% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/formattable.R
\name{format_table}
\alias{format_table}
\title{Format a data frame with formatter functions}
\usage{
format_table(
  x,
  formatters = list(),
  format = c("html", "markdown", "pandoc"),
  align = "r",
  ...,
  digits = getOption("digits"),
  table.attr = "class=\\"table table-condensed\\""
)
}
\arguments{
\item{x}{a \code{data.frame}.}

\item{formatters}{a list of formatter functions or formulas.
The existing columns of \code{x} will be applied the formatter
function in \code{formatters} if it exists.

If a formatter is specified by formula, then the formula will be
interpreted as a lambda expression with its left-hand side being
a symbol and right-hand side being the expression using the symbol
to represent the column values. The formula expression will be evaluated
in the environment of the formula.

If a formatter is \code{FALSE}, then the corresponding column will be hidden.

Area formatter is specified in the form of
\code{area(row, col) ~ formatter} without specifying the column name.}

\item{format}{The output format: html, markdown or pandoc?}

\item{align}{The alignment of columns: a character vector consisting
of \code{'l'} (left), \code{'c'} (center), and/or \code{'r'} (right).
By default, all columns are right-aligned.}

\item{...}{additional parameters to be passed to \code{knitr::kable}.}

\item{digits}{The number of significant digits to be used for numeric
and complex values.}

\item{table.attr}{The HTML class of \code{<table>} created when
\code{format = "html"}}
}
\value{
a \code{knitr_kable} object whose \code{print} method generates a
string-representation of \code{data} formatted by \code{formatter} in
specific \code{format}.
}
\description{
This is an table generator that specializes in creating
formatted table presented in HTML by default.
To generate a formatted table, columns or areas of the
input data frame can be transformed by formatter functions.
}
\examples{
# mtcars (mpg in red)
format_table(mtcars,
   list(mpg = formatter("span", style = "color:red")))

# mtcars (mpg in red if greater than median)
format_table(mtcars, list(mpg = formatter("span",
   style = function(x) ifelse(x > median(x), "color:red", NA))))

# mtcars (mpg in red if greater than median, using formula)
format_table(mtcars, list(mpg = formatter("span",
   style = x ~ ifelse(x > median(x), "color:red", NA))))

# mtcars (mpg in gradient: the higher, the redder)
format_table(mtcars, list(mpg = formatter("span",
   style = x ~ style(color = rgb(x/max(x), 0, 0)))))

# mtcars (mpg background in gradient: the higher, the redder)
format_table(mtcars, list(mpg = formatter("span",
   style = x ~ style(display = "block",
   "border-radius" = "4px",
   "padding-right" = "4px",
   color = "white",
   "background-color" = rgb(x/max(x), 0, 0)))))

# mtcars (mpg in red if vs == 1 and am == 1)
format_table(mtcars, list(mpg = formatter("span",
    style = ~ style(color = ifelse(vs == 1 & am == 1, "red", NA)))))

# hide columns
format_table(mtcars, list(mpg = FALSE, cyl = FALSE))

# area formatting
format_table(mtcars, list(area(col = vs:carb) ~ formatter("span",
  style = x ~ style(color = ifelse(x > 0, "red", NA)))))

df <- data.frame(a = rnorm(10), b = rnorm(10), c = rnorm(10))
format_table(df, list(area() ~ color_tile("transparent", "lightgray")))
format_table(df, list(area(1:5) ~ color_tile("transparent", "lightgray")))
format_table(df, list(area(1:5) ~ color_tile("transparent", "lightgray"),
  area(6:10) ~ color_tile("transparent", "lightpink")))
}
\seealso{
\link{formattable}, \link{area}
}
