% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spec-result-get-query.R
\docType{data}
\name{spec_result_get_query}
\alias{spec_result_get_query}
\title{spec_result_get_query}
\value{
\code{dbGetQuery()} always returns a \link{data.frame}
with as many rows as records were fetched and as many
columns as fields in the result set,
even if the result is a single value
or has one
or zero rows.
An error is raised when issuing a query over a closed
or invalid connection,
if the syntax of the query is invalid,
or if the query is not a non-\code{NA} string.
If the \code{n} argument is not an atomic whole number
greater or equal to -1 or Inf, an error is raised,
but a subsequent call to \code{dbGetQuery()} with proper \code{n} argument succeeds.
}
\description{
spec_result_get_query
}
\section{Additional arguments}{

The following arguments are not part of the \code{dbGetQuery()} generic
(to improve compatibility across backends)
but are part of the DBI specification:
\itemize{
\item \code{n} (default: -1)
\item \code{params} (TBD)
}

They must be provided as named arguments.
See the "Specification" and "Value" sections for details on their usage.
}

\section{Specification}{

Fetching multi-row queries with one
or more columns be default returns the entire result.
A value of \link{Inf} for the \code{n} argument is supported
and also returns the full result.
If more rows than available are fetched, the result is returned in full
without warning.
If zero rows are fetched, the columns of the data frame are still fully
typed.
Fetching fewer rows than available is permitted,
no warning is issued.

A column named \code{row_names} is treated like any other column.
}

