% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/progress-server.R
\name{cli_progress_builtin_handlers}
\alias{cli_progress_builtin_handlers}
\title{cli progress handlers}
\usage{
cli_progress_builtin_handlers()
}
\value{
\code{cli_progress_builtin_handlers()} returns the names of the
currently supported progress handlers.
}
\description{
The progress handler(s) to use can be selected with global options.
}
\details{
There are three options that specify which handlers will be selected,
but most of the time you only need to use one of them. You can set these
options to a character vector, the names of the built-in cli handlers you
want to use:
\itemize{
\item If \code{cli.progress_handlers_only} is set, then these handlers are used,
without considering others and without checking if they are able to
handle a progress bar. This option is mainly intended for testing
purposes.
\item The handlers named in \code{cli.progress_handlers} are checked if they are
able to handle the progress bar, and from the ones that are, the first
one is selected. This is usually the option that the end use would want
to set.
\item The handlers named in \code{cli.progress_handlers_force} are always appended
to the ones selected via \code{cli.progress_handlers}. This option is useful
to add an additional handler, e.g. a logger that writes to a file.
}
}
\section{The built-in progress handlers}{
\subsection{\code{cli}}{

Use cli's internal status bar, the last line of the screen, to show the
progress bar. This handler is always able to handle all progress bars.
}

\subsection{\code{logger}}{

Log progress updates to the screen, with one line for each update and with
time stamps. This handler is always able to handle all progress bars.
}

\subsection{\code{progressr}}{

Use the progressr package to create
progress bars. This handler is always able to handle all progress bars.
(The progressr package needs to be installed.)
}

\subsection{\code{rstudio}}{

Use \href{https://www.rstudio.com/blog/rstudio-1-2-jobs/}{RStudio's job panel}
to show the progress bars. This handler is available at the RStudio console,
in recent versions of RStudio.
}

\subsection{\code{say}}{

Use the macOS \code{say} command to announce progress events in speech (type
\verb{man say} on a terminal for more info). Set the \code{cli.progress_say_frequency}
option to set the minimum delay between \code{say} invocations, the default is
three seconds. This handler is available on macOS, if the \code{say} command is
on the path.

The external command and its arguments can be configured with options:
\itemize{
\item \code{cli_progress_say_args}: command line arguments, e.g. you can use this
to select a voice on macOS,
\item \code{cli_progress_say_command}: external command to run,
\item \code{cli_progress_say_frequency}: wait at least this many seconds between
calling the external command.
}
}

\subsection{\code{shiny}}{

Use \link[shiny:Progress]{shiny's progress bars}. This handler is available if a
shiny app is running.
}
}

