% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ansiex.R
\name{ansi_columns}
\alias{ansi_columns}
\title{Format a character vector in multiple columns}
\usage{
ansi_columns(
  text,
  width = console_width(),
  sep = " ",
  fill = c("rows", "cols"),
  max_cols = 4,
  align = c("left", "center", "right"),
  type = "width",
  ellipsis = symbol$ellipsis
)
}
\arguments{
\item{text}{Character vector to format. Each element will formatted
as a cell of a table.}

\item{width}{Width of the screen.}

\item{sep}{Separator between the columns. It may have ANSI styles.}

\item{fill}{Whether to fill the columns row-wise or column-wise.}

\item{max_cols}{Maximum number of columns to use. Will not use more,
even if there is space for it.}

\item{align}{Alignment within the columns.}

\item{type}{Passed to \code{\link[=ansi_nchar]{ansi_nchar()}} and \code{\link[=ansi_align]{ansi_align()}}. Most probably
you want the default, \code{"width"}.}

\item{ellipsis}{The string to append to truncated strings. Supply an
empty string if you don't want a marker.}
}
\value{
ANSI string vector.
}
\description{
This function helps with multi-column output of ANSI styles strings.
It works well together with \code{\link[=boxx]{boxx()}}, see the example below.
}
\details{
If a string does not fit into the specified \code{width}, it will be
truncated using \code{\link[=ansi_strtrim]{ansi_strtrim()}}.\if{html}{\out{<div class="sourceCode r">}}\preformatted{fmt <- ansi_columns(
  paste(col_red("foo"), 1:10),
  width = 50,
  fill = "rows",
  max_cols=10,
  align = "center",
  sep = "   "
)
boxx(fmt, padding = c(0,1,0,1), header = col_cyan("Columns"))
}\if{html}{\out{</div>}}

\if{html}{\figure{ansi-column.svg}}
}
\seealso{
Other ANSI string operations: 
\code{\link{ansi_align}()},
\code{\link{ansi_nchar}()},
\code{\link{ansi_strsplit}()},
\code{\link{ansi_strtrim}()},
\code{\link{ansi_strwrap}()},
\code{\link{ansi_substring}()},
\code{\link{ansi_substr}()},
\code{\link{ansi_toupper}()},
\code{\link{ansi_trimws}()}
}
\concept{ANSI string operations}
