% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stats-htest-tidiers.R
\name{tidy.htest}
\alias{tidy.htest}
\alias{htest_tidiers}
\alias{glance.htest}
\title{Tidy/glance a(n) htest object}
\usage{
\method{tidy}{htest}(x, ...)

\method{glance}{htest}(x, ...)
}
\arguments{
\item{x}{An \code{htest} objected, such as those created by \code{\link[stats:cor.test]{stats::cor.test()}},
\code{\link[stats:t.test]{stats::t.test()}}, \code{\link[stats:wilcox.test]{stats::wilcox.test()}}, \code{\link[stats:chisq.test]{stats::chisq.test()}}, etc.}

\item{...}{Additional arguments. Not used. Needed to match generic
signature only. \strong{Cautionary note:} Misspelled arguments will be
absorbed in \code{...}, where they will be ignored. If the misspelled
argument has a default value, the default value will be used.
For example, if you pass \code{conf.lvel = 0.9}, all computation will
proceed using \code{conf.level = 0.95}. Two exceptions here are:
\itemize{
\item \code{tidy()} methods will warn when supplied an \code{exponentiate} argument if
it will be ignored.
\item \code{augment()} methods will warn when supplied a \code{newdata} argument if it
will be ignored.
}}
}
\description{
For models that have only a single component, the \code{\link[=tidy]{tidy()}} and
\code{\link[=glance]{glance()}} methods are identical. Please see the documentation for both
of those methods.
}
\examples{

tt <- t.test(rnorm(10))

tidy(tt)

# the glance output will be the same for each of the below tests
glance(tt)

tt <- t.test(mpg ~ am, data = mtcars)

tidy(tt)

wt <- wilcox.test(mpg ~ am, data = mtcars, conf.int = TRUE, exact = FALSE)

tidy(wt)

ct <- cor.test(mtcars$wt, mtcars$mpg)

tidy(ct)

chit <- chisq.test(xtabs(Freq ~ Sex + Class, data = as.data.frame(Titanic)))

tidy(chit)
augment(chit)

}
\seealso{
\code{\link[=tidy]{tidy()}}, \code{\link[stats:cor.test]{stats::cor.test()}}, \code{\link[stats:t.test]{stats::t.test()}},
\code{\link[stats:wilcox.test]{stats::wilcox.test()}}, \code{\link[stats:chisq.test]{stats::chisq.test()}}

Other htest tidiers: 
\code{\link{augment.htest}()},
\code{\link{tidy.pairwise.htest}()},
\code{\link{tidy.power.htest}()}
}
\concept{htest tidiers}
\value{
A \code{\link[tibble:tibble]{tibble::tibble()}} with columns:
  \item{alternative}{Alternative hypothesis (character).}
  \item{conf.high}{Upper bound on the confidence interval for the estimate.}
  \item{conf.low}{Lower bound on the confidence interval for the estimate.}
  \item{estimate}{The estimated value of the regression term.}
  \item{estimate1}{Sometimes two estimates are computed, such as in a two-sample t-test.}
  \item{estimate2}{Sometimes two estimates are computed, such as in a two-sample t-test.}
  \item{method}{Method used.}
  \item{p.value}{The two-sided p-value associated with the observed statistic.}
  \item{parameter}{The parameter being modeled.}
  \item{statistic}{The value of a T-statistic to use in a hypothesis that the regression term is non-zero.}

}
