import unittest

from scrapy.http import Request
from scrapy.contrib.downloadermiddleware.httpauth import HttpAuthMiddleware
from scrapy.spider import BaseSpider

class TestSpider(BaseSpider):
    http_user = 'foo'
    http_pass = 'bar'

class HttpAuthMiddlewareTest(unittest.TestCase):

    def setUp(self):
        self.mw = HttpAuthMiddleware()
        self.spider = TestSpider('foo')

    def tearDown(self):
        del self.mw

    def test_auth(self):
        req = Request('http://scrapytest.org/')
        assert self.mw.process_request(req, self.spider) is None
        self.assertEquals(req.headers['Authorization'], 'Basic Zm9vOmJhcg==')

    def test_auth_already_set(self):
        req = Request('http://scrapytest.org/', headers=dict(Authorization='Digest 123'))
        assert self.mw.process_request(req, self.spider) is None
        self.assertEquals(req.headers['Authorization'], 'Digest 123')


if __name__ == '__main__':
    unittest.main()
