# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from azure.identity import DefaultAzureCredential
from azure.mgmt.eventhub import EventHubManagementClient

"""
# PREREQUISITES
    pip install azure-identity
    pip install azure-mgmt-eventhub
# USAGE
    python eh_network_rule_set_create.py

    Before run the sample, please set the values of the client ID, tenant ID and client secret
    of the AAD application as environment variables: AZURE_CLIENT_ID, AZURE_TENANT_ID,
    AZURE_CLIENT_SECRET. For more info about how to get the value, please see:
    https://docs.microsoft.com/azure/active-directory/develop/howto-create-service-principal-portal
"""


def main():
    client = EventHubManagementClient(
        credential=DefaultAzureCredential(),
        subscription_id="Subscription",
    )

    response = client.namespaces.create_or_update_network_rule_set(
        resource_group_name="ResourceGroup",
        namespace_name="sdk-Namespace-6019",
        parameters={
            "properties": {
                "defaultAction": "Deny",
                "ipRules": [
                    {"action": "Allow", "ipMask": "1.1.1.1"},
                    {"action": "Allow", "ipMask": "1.1.1.2"},
                    {"action": "Allow", "ipMask": "1.1.1.3"},
                    {"action": "Allow", "ipMask": "1.1.1.4"},
                    {"action": "Allow", "ipMask": "1.1.1.5"},
                ],
                "virtualNetworkRules": [
                    {
                        "ignoreMissingVnetServiceEndpoint": True,
                        "subnet": {
                            "id": "/subscriptions/subscriptionid/resourcegroups/resourcegroupid/providers/Microsoft.Network/virtualNetworks/myvn/subnets/subnet2"
                        },
                    },
                    {
                        "ignoreMissingVnetServiceEndpoint": False,
                        "subnet": {
                            "id": "/subscriptions/subscriptionid/resourcegroups/resourcegroupid/providers/Microsoft.Network/virtualNetworks/myvn/subnets/subnet3"
                        },
                    },
                    {
                        "ignoreMissingVnetServiceEndpoint": False,
                        "subnet": {
                            "id": "/subscriptions/subscriptionid/resourcegroups/resourcegroupid/providers/Microsoft.Network/virtualNetworks/myvn/subnets/subnet6"
                        },
                    },
                ],
            }
        },
    )
    print(response)


# x-ms-original-file: specification/eventhub/resource-manager/Microsoft.EventHub/stable/2021-11-01/examples/NameSpaces/VirtualNetworkRule/EHNetworkRuleSetCreate.json
if __name__ == "__main__":
    main()
