% PRAAT-OPEN-FILES(1) | User Commands
%
% April 22, 2013

# NAME

praat-open-files - Open sound files with Praat

# SYNOPSIS

**praat-open-files** \[--new] \[--wait=_secs_] _file_ \[_file_ ...]

# DESCRIPTION

The **praat-open-files** command allows one to open of sound files with
**praat** from the command line. Any file type recognized by Praat
(WAV, FLAC, MP3, etc) can be given as arguments.

# OPTIONS

\--new
:  Launch a new instance of **praat** for viewing and editing the sound
   files. By default, **praat-open-files** try to open the files in an
   running **praat** program, and fails if there is none.

\--wait=secs
:  By default, when the --new option is used, **praat-open-files** waits
   for 3 seconds before sending commands to the newly launched
   instance of **praat**. If **praat** takes longer to be launched on
   your system, specify another value with the --wait option.

# EXAMPLES

    praat-open-files file.wav relative/path/file.flac /absolute/path/file.mp3
    
Open the three specified files with individual View & Edit windows for
each one on a running instance of *praat*.
    
    praat-open-files --new file.wav

Open file.wav in a new instance of **praat**.
    
    praat-open-files --new --wait=5 file.wav

Open file.wav in a new instance of **praat**, waiting 5 seconds before
sending the request to open the file.
    
# AUTHOR

Rafael Laboissière <rafael@laboissiere.net>

# SEE ALSO

For further information, see the Praat website <http://www.praat.org>.
