/*
 * Decompiled with CFR 0.152.
 */
package com.sixlegs.png;

import com.sixlegs.png.BasicPixelProcessor;
import com.sixlegs.png.Destination;

final class GammaPixelProcessor
extends BasicPixelProcessor {
    private final short[] gammaTable;
    private final int shift;
    private final int samplesNoAlpha;
    private final boolean hasAlpha;
    private final boolean shiftAlpha;

    public GammaPixelProcessor(Destination dst, short[] gammaTable, int shift) {
        super(dst, dst.getRaster().getNumBands());
        this.gammaTable = gammaTable;
        this.shift = shift;
        this.hasAlpha = this.samples % 2 == 0;
        this.samplesNoAlpha = this.hasAlpha ? this.samples - 1 : this.samples;
        this.shiftAlpha = this.hasAlpha && shift > 0;
    }

    public boolean process(int[] row, int xOffset, int xStep, int yStep, int y, int width) {
        int total = this.samples * width;
        for (int i = 0; i < this.samplesNoAlpha; ++i) {
            for (int index = i; index < total; index += this.samples) {
                row[index] = 0xFFFF & this.gammaTable[row[index] >> this.shift];
            }
        }
        if (this.shiftAlpha) {
            for (int index = this.samplesNoAlpha; index < total; index += this.samples) {
                int n = index;
                row[n] = row[n] >> this.shift;
            }
        }
        return super.process(row, xOffset, xStep, yStep, y, width);
    }
}

