/*
  Bear Engine

  Copyright (C) 20052011 Julien Jorge, Sebastien Angibaud

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the
  Free Software Foundation; either version 2 of the License, or (at your
  option) any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

  contact: plee-the-bear@gamned.org

  Please add the tag [Bear] in the subject of your mails.
*/
/**
 * \file static_crossfade_sequence.hpp
 * \brief A decorative sprite.
 * \author Sebastien Angibaud
 */
#ifndef __BEAR_CROSSFADE_SEQUENCE_HPP__
#define __BEAR_CROSSFADE_SEQUENCE_HPP__

#include "engine/base_item.hpp"
#include "engine/item_brick/with_rendering_attributes.hpp"
#include "generic_items/class_export.hpp"
#include "universe/derived_item_handle.hpp"
#include "engine/scene_visual.hpp"
#include "engine/export.hpp"

#include <vector>

namespace bear
{
  /**
   * \brief A rectangle in which we render a sequence of sprite with fade.
   * \author Sebastien Angibaud
   */
  class GENERIC_ITEMS_EXPORT crossfade_sequence:
    public engine::base_item
  {
    DECLARE_BASE_ITEM(crossfade_sequence);

  public:
    /** \brief The type of the parent class. */
    typedef engine::base_item super;

  private:
    /** \brief The type of the list of the handles on the items. */
    typedef std::vector
      < bear::universe::derived_item_handle
        < bear::engine::with_rendering_attributes >
      > item_list_type;

  public:
    crossfade_sequence();

    virtual void progress( universe::time_type elapsed_time );
    void build();

    virtual bool set_bool_field( const std::string& name, bool value );
    virtual bool set_real_field( const std::string& name, double value );
    virtual bool set_real_list_field
    ( const std::string& name, const std::vector<double>& value );
    virtual bool set_item_list_field
    ( const std::string& name, const std::vector<base_item*>& value );

    virtual bool is_valid() const;

  private:
    /** \brief The duration sequence. */
    std::vector<double> m_duration_sequence;

    /** \brief The list of items to reveal. */
    item_list_type m_items_sequence;

    /** \brief The duration since the beginning of the current sprite. */
    double m_last_sprite;

    /** \brief The index of the current sprite. */
    unsigned int m_index;

    /** \brief The duration of fade. */
    double m_fadeout_duration;

    /** \brief Indicates if there is a fadein for the first sprite. */
    bool m_fadein_for_first_sprite;

    /** \brief Indicates if there is a fadeout for the last sprite. */
    bool m_fadeout_for_last_sprite;

  }; // class crossfade_sequence
} // namespace bear

#endif // __BEAR_CROSSFADE_SEQUENCE_HPP__
