
# Arduino: framework for [PlatformIO](https://platformio.org)

Arduino Wiring-based Framework allows writing cross-platform software to control devices attached to a wide range of Arduino boards to create all kinds of creative coding, interactive objects, spaces or physical experiences.

* [Home](https://platformio.org/frameworks/arduino) (home page in PlatformIO Registry)
* [Documentation](https://docs.platformio.org/page/frameworks/arduino.html)

# Examples

- [Atmel AVR](https://github.com/platformio/platform-atmelavr)
  * [arduino-blink](https://github.com/platformio/platform-atmelavr/tree/master/examples/arduino-blink)
  * [arduino-external-libs](https://github.com/platformio/platform-atmelavr/tree/master/examples/arduino-external-libs)
  * [arduino-internal-libs](https://github.com/platformio/platform-atmelavr/tree/master/examples/arduino-internal-libs)
  * [arduino-own-src_dir](https://github.com/platformio/platform-atmelavr/tree/master/examples/arduino-own-src_dir)
  * [digitstump-mouse](https://github.com/platformio/platform-atmelavr/tree/master/examples/digitstump-mouse)
  * [engduino-magnetometer](https://github.com/platformio/platform-atmelavr/tree/master/examples/engduino-magnetometer)
  * [native-blink](https://github.com/platformio/platform-atmelavr/tree/master/examples/native-blink)
  * [simba-blink](https://github.com/platformio/platform-atmelavr/tree/master/examples/simba-blink)

- [Atmel megaAVR](https://github.com/platformio/platform-atmelmegaavr)
  * [arduino-blink](https://github.com/platformio/platform-atmelmegaavr/tree/master/examples/arduino-blink)
  * [arduino-external-libs](https://github.com/platformio/platform-atmelmegaavr/tree/master/examples/arduino-external-libs)
  * [arduino-internal-libs](https://github.com/platformio/platform-atmelmegaavr/tree/master/examples/arduino-internal-libs)
  * [native-blink](https://github.com/platformio/platform-atmelmegaavr/tree/master/examples/native-blink)

- [Atmel SAM](https://github.com/platformio/platform-atmelsam)
  * [arduino-blink](https://github.com/platformio/platform-atmelsam/tree/master/examples/arduino-blink)
  * [arduino-briki-internal-libs](https://github.com/platformio/platform-atmelsam/tree/master/examples/arduino-briki-internal-libs)
  * [arduino-external-libs](https://github.com/platformio/platform-atmelsam/tree/master/examples/arduino-external-libs)
  * [arduino-internal-libs](https://github.com/platformio/platform-atmelsam/tree/master/examples/arduino-internal-libs)
  * [arduino-web-thing-led](https://github.com/platformio/platform-atmelsam/tree/master/examples/arduino-web-thing-led)
  * [mbed-blink](https://github.com/platformio/platform-atmelsam/tree/master/examples/mbed-blink)
  * [mbed-dsp](https://github.com/platformio/platform-atmelsam/tree/master/examples/mbed-dsp)
  * [mbed-events](https://github.com/platformio/platform-atmelsam/tree/master/examples/mbed-events)
  * [mbed-serial](https://github.com/platformio/platform-atmelsam/tree/master/examples/mbed-serial)
  * [simba-blink](https://github.com/platformio/platform-atmelsam/tree/master/examples/simba-blink)
  * [zephyr-blink](https://github.com/platformio/platform-atmelsam/tree/master/examples/zephyr-blink)
  * [zephyr-drivers-i2c-scanner](https://github.com/platformio/platform-atmelsam/tree/master/examples/zephyr-drivers-i2c-scanner)
  * [zephyr-subsys-logger](https://github.com/platformio/platform-atmelsam/tree/master/examples/zephyr-subsys-logger)

- [Espressif 32](https://github.com/platformio/platform-espressif32)
  * [arduino-blink](https://github.com/platformio/platform-espressif32/tree/master/examples/arduino-blink)
  * [arduino-briki-internal-libs](https://github.com/platformio/platform-espressif32/tree/master/examples/arduino-briki-internal-libs)
  * [arduino-wifiscan](https://github.com/platformio/platform-espressif32/tree/master/examples/arduino-wifiscan)
  * [espidf-arduino-blink](https://github.com/platformio/platform-espressif32/tree/master/examples/espidf-arduino-blink)
  * [espidf-arduino-wifiscan](https://github.com/platformio/platform-espressif32/tree/master/examples/espidf-arduino-wifiscan)
  * [espidf-aws-iot](https://github.com/platformio/platform-espressif32/tree/master/examples/espidf-aws-iot)
  * [espidf-ble-eddystone](https://github.com/platformio/platform-espressif32/tree/master/examples/espidf-ble-eddystone)
  * [espidf-blink](https://github.com/platformio/platform-espressif32/tree/master/examples/espidf-blink)
  * [espidf-coap-server](https://github.com/platformio/platform-espressif32/tree/master/examples/espidf-coap-server)
  * [espidf-exceptions](https://github.com/platformio/platform-espressif32/tree/master/examples/espidf-exceptions)
  * [espidf-hello-world](https://github.com/platformio/platform-espressif32/tree/master/examples/espidf-hello-world)
  * [espidf-http-request](https://github.com/platformio/platform-espressif32/tree/master/examples/espidf-http-request)
  * [espidf-peripherals-uart](https://github.com/platformio/platform-espressif32/tree/master/examples/espidf-peripherals-uart)
  * [espidf-storage-sdcard](https://github.com/platformio/platform-espressif32/tree/master/examples/espidf-storage-sdcard)
  * [espidf-ulp-adc](https://github.com/platformio/platform-espressif32/tree/master/examples/espidf-ulp-adc)
  * [espidf-ulp-pulse](https://github.com/platformio/platform-espressif32/tree/master/examples/espidf-ulp-pulse)
  * [pumbaa-blink](https://github.com/platformio/platform-espressif32/tree/master/examples/pumbaa-blink)
  * [simba-blink](https://github.com/platformio/platform-espressif32/tree/master/examples/simba-blink)

- [Espressif 8266](https://github.com/platformio/platform-espressif8266)
  * [arduino-asyncudp](https://github.com/platformio/platform-espressif8266/tree/master/examples/arduino-asyncudp)
  * [arduino-blink](https://github.com/platformio/platform-espressif8266/tree/master/examples/arduino-blink)
  * [arduino-webserver](https://github.com/platformio/platform-espressif8266/tree/master/examples/arduino-webserver)
  * [arduino-wifiscan](https://github.com/platformio/platform-espressif8266/tree/master/examples/arduino-wifiscan)
  * [esp8266-nonos-sdk-blink](https://github.com/platformio/platform-espressif8266/tree/master/examples/esp8266-nonos-sdk-blink)
  * [esp8266-rtos-sdk-blink](https://github.com/platformio/platform-espressif8266/tree/master/examples/esp8266-rtos-sdk-blink)
  * [simba-blink](https://github.com/platformio/platform-espressif8266/tree/master/examples/simba-blink)

- [GigaDevice GD32V](https://github.com/sipeed/platform-gd32v)
  * [arduino-blink](https://github.com/sipeed/platform-gd32v/tree/master/examples/arduino-blink)
  * [eval-blink](https://github.com/sipeed/platform-gd32v/tree/master/examples/eval-blink)
  * [longan-nano-blink](https://github.com/sipeed/platform-gd32v/tree/master/examples/longan-nano-blink)

- [Infineon XMC](https://github.com/Infineon/platformio-infineonxmc)
  * [arduino-blink](https://github.com/Infineon/platformio-infineonxmc/tree/master/examples/arduino-blink)
  * [arduino-wire](https://github.com/Infineon/platformio-infineonxmc/tree/master/examples/arduino-wire)
  * [device-control](https://github.com/Infineon/platformio-infineonxmc/tree/master/examples/device-control)
  * [ifx9201](https://github.com/Infineon/platformio-infineonxmc/tree/master/examples/ifx9201)
  * [radar](https://github.com/Infineon/platformio-infineonxmc/tree/master/examples/radar)
  * [rtc](https://github.com/Infineon/platformio-infineonxmc/tree/master/examples/rtc)
  * [spi](https://github.com/Infineon/platformio-infineonxmc/tree/master/examples/spi)
  * [ultrasonic](https://github.com/Infineon/platformio-infineonxmc/tree/master/examples/ultrasonic)

- [Intel ARC32](https://github.com/platformio/platform-intel_arc32)
  * [arduino-blink](https://github.com/platformio/platform-intel_arc32/tree/master/examples/arduino-blink)
  * [arduino-curie-imu](https://github.com/platformio/platform-intel_arc32/tree/master/examples/arduino-curie-imu)
  * [arduino-internal-libs](https://github.com/platformio/platform-intel_arc32/tree/master/examples/arduino-internal-libs)

- [Kendryte K210](https://github.com/sipeed/platform-kendryte210)
  * [arduino-blink](https://github.com/sipeed/platform-kendryte210/tree/master/examples/arduino-blink)
  * [kendryte-freertos-sdk_hello](https://github.com/sipeed/platform-kendryte210/tree/master/examples/kendryte-freertos-sdk_hello)
  * [kendryte-standalone-sdk_hello](https://github.com/sipeed/platform-kendryte210/tree/master/examples/kendryte-standalone-sdk_hello)

- [Microchip PIC32](https://github.com/platformio/platform-microchippic32)
  * [arduino-blink](https://github.com/platformio/platform-microchippic32/tree/master/examples/arduino-blink)
  * [arduino-internal-libs](https://github.com/platformio/platform-microchippic32/tree/master/examples/arduino-internal-libs)

- [Nordic nRF51](https://github.com/platformio/platform-nordicnrf51)
  * [arduino-ble-led](https://github.com/platformio/platform-nordicnrf51/tree/master/examples/arduino-ble-led)
  * [arduino-blink](https://github.com/platformio/platform-nordicnrf51/tree/master/examples/arduino-blink)
  * [arduino-internal-libs](https://github.com/platformio/platform-nordicnrf51/tree/master/examples/arduino-internal-libs)
  * [mbed-ble-thermometer](https://github.com/platformio/platform-nordicnrf51/tree/master/examples/mbed-ble-thermometer)
  * [mbed-blink](https://github.com/platformio/platform-nordicnrf51/tree/master/examples/mbed-blink)
  * [mbed-events](https://github.com/platformio/platform-nordicnrf51/tree/master/examples/mbed-events)
  * [mbed-serial](https://github.com/platformio/platform-nordicnrf51/tree/master/examples/mbed-serial)
  * [zephyr-ble-eddystone](https://github.com/platformio/platform-nordicnrf51/tree/master/examples/zephyr-ble-eddystone)
  * [zephyr-blink](https://github.com/platformio/platform-nordicnrf51/tree/master/examples/zephyr-blink)
  * [zephyr-drivers-entropy](https://github.com/platformio/platform-nordicnrf51/tree/master/examples/zephyr-drivers-entropy)

- [Nordic nRF52](https://github.com/platformio/platform-nordicnrf52)
  * [arduino-ble-led](https://github.com/platformio/platform-nordicnrf52/tree/master/examples/arduino-ble-led)
  * [arduino-blink](https://github.com/platformio/platform-nordicnrf52/tree/master/examples/arduino-blink)
  * [arduino-bluefruit-bleuart](https://github.com/platformio/platform-nordicnrf52/tree/master/examples/arduino-bluefruit-bleuart)
  * [arduino-nina-b1-generic-example](https://github.com/platformio/platform-nordicnrf52/tree/master/examples/arduino-nina-b1-generic-example)
  * [arduino-serial-plotter](https://github.com/platformio/platform-nordicnrf52/tree/master/examples/arduino-serial-plotter)
  * [mbed-ble-thermometer](https://github.com/platformio/platform-nordicnrf52/tree/master/examples/mbed-ble-thermometer)
  * [mbed-blink](https://github.com/platformio/platform-nordicnrf52/tree/master/examples/mbed-blink)
  * [mbed-dsp](https://github.com/platformio/platform-nordicnrf52/tree/master/examples/mbed-dsp)
  * [mbed-events](https://github.com/platformio/platform-nordicnrf52/tree/master/examples/mbed-events)
  * [mbed-nfc](https://github.com/platformio/platform-nordicnrf52/tree/master/examples/mbed-nfc)
  * [mbed-rtos](https://github.com/platformio/platform-nordicnrf52/tree/master/examples/mbed-rtos)
  * [mbed-serial](https://github.com/platformio/platform-nordicnrf52/tree/master/examples/mbed-serial)
  * [zephyr-ble-beacon](https://github.com/platformio/platform-nordicnrf52/tree/master/examples/zephyr-ble-beacon)
  * [zephyr-blink](https://github.com/platformio/platform-nordicnrf52/tree/master/examples/zephyr-blink)
  * [zephyr-net-echo-client](https://github.com/platformio/platform-nordicnrf52/tree/master/examples/zephyr-net-echo-client)
  * [zephyr-subsys-nvs](https://github.com/platformio/platform-nordicnrf52/tree/master/examples/zephyr-subsys-nvs)

- [ST STM32](https://github.com/platformio/platform-ststm32)
  * [arduino-blink](https://github.com/platformio/platform-ststm32/tree/master/examples/arduino-blink)
  * [arduino-external-libs](https://github.com/platformio/platform-ststm32/tree/master/examples/arduino-external-libs)
  * [arduino-internal-libs](https://github.com/platformio/platform-ststm32/tree/master/examples/arduino-internal-libs)
  * [arduino-mxchip-azureiot](https://github.com/platformio/platform-ststm32/tree/master/examples/arduino-mxchip-azureiot)
  * [arduino-mxchip-filesystem](https://github.com/platformio/platform-ststm32/tree/master/examples/arduino-mxchip-filesystem)
  * [arduino-mxchip-sensors](https://github.com/platformio/platform-ststm32/tree/master/examples/arduino-mxchip-sensors)
  * [arduino-mxchip-wifiscan](https://github.com/platformio/platform-ststm32/tree/master/examples/arduino-mxchip-wifiscan)
  * [cmsis-blink](https://github.com/platformio/platform-ststm32/tree/master/examples/cmsis-blink)
  * [libopencm3-1bitsy](https://github.com/platformio/platform-ststm32/tree/master/examples/libopencm3-1bitsy)
  * [libopencm3-blink](https://github.com/platformio/platform-ststm32/tree/master/examples/libopencm3-blink)
  * [mbed-blink](https://github.com/platformio/platform-ststm32/tree/master/examples/mbed-blink)
  * [mbed-custom-target](https://github.com/platformio/platform-ststm32/tree/master/examples/mbed-custom-target)
  * [mbed-dsp](https://github.com/platformio/platform-ststm32/tree/master/examples/mbed-dsp)
  * [mbed-events](https://github.com/platformio/platform-ststm32/tree/master/examples/mbed-events)
  * [mbed-filesystem](https://github.com/platformio/platform-ststm32/tree/master/examples/mbed-filesystem)
  * [mbed-rtos](https://github.com/platformio/platform-ststm32/tree/master/examples/mbed-rtos)
  * [mbed-rtos-ethernet](https://github.com/platformio/platform-ststm32/tree/master/examples/mbed-rtos-ethernet)
  * [mbed-rtos-ethernet-tls](https://github.com/platformio/platform-ststm32/tree/master/examples/mbed-rtos-ethernet-tls)
  * [mbed-rtos-mesh-minimal](https://github.com/platformio/platform-ststm32/tree/master/examples/mbed-rtos-mesh-minimal)
  * [mbed-rtos-semaphore](https://github.com/platformio/platform-ststm32/tree/master/examples/mbed-rtos-semaphore)
  * [mbed-serial](https://github.com/platformio/platform-ststm32/tree/master/examples/mbed-serial)
  * [spl-blink](https://github.com/platformio/platform-ststm32/tree/master/examples/spl-blink)
  * [stm32cube-hal-blink](https://github.com/platformio/platform-ststm32/tree/master/examples/stm32cube-hal-blink)
  * [stm32cube-ll-blink](https://github.com/platformio/platform-ststm32/tree/master/examples/stm32cube-ll-blink)
  * [zephyr-blink](https://github.com/platformio/platform-ststm32/tree/master/examples/zephyr-blink)
  * [zephyr-cpp-synchronization](https://github.com/platformio/platform-ststm32/tree/master/examples/zephyr-cpp-synchronization)
  * [zephyr-drivers-can](https://github.com/platformio/platform-ststm32/tree/master/examples/zephyr-drivers-can)
  * [zephyr-net-https-client](https://github.com/platformio/platform-ststm32/tree/master/examples/zephyr-net-https-client)
  * [zephyr-subsys-usb-hid-mouse](https://github.com/platformio/platform-ststm32/tree/master/examples/zephyr-subsys-usb-hid-mouse)

- [ST STM8](https://github.com/platformio/platform-ststm8)
  * [arduino-fade-all-pins](https://github.com/platformio/platform-ststm8/tree/master/examples/arduino-fade-all-pins)
  * [arduino-internal-lib](https://github.com/platformio/platform-ststm8/tree/master/examples/arduino-internal-lib)
  * [arduino-ping-hc04](https://github.com/platformio/platform-ststm8/tree/master/examples/arduino-ping-hc04)
  * [spl-blink](https://github.com/platformio/platform-ststm8/tree/master/examples/spl-blink)
  * [spl-flash](https://github.com/platformio/platform-ststm8/tree/master/examples/spl-flash)
  * [spl-uart](https://github.com/platformio/platform-ststm8/tree/master/examples/spl-uart)

- [Teensy](https://github.com/platformio/platform-teensy)
  * [arduino-blink](https://github.com/platformio/platform-teensy/tree/master/examples/arduino-blink)
  * [arduino-hid-usb-mouse](https://github.com/platformio/platform-teensy/tree/master/examples/arduino-hid-usb-mouse)
  * [arduino-internal-libs](https://github.com/platformio/platform-teensy/tree/master/examples/arduino-internal-libs)
  * [mbed-blink](https://github.com/platformio/platform-teensy/tree/master/examples/mbed-blink)
  * [mbed-dsp](https://github.com/platformio/platform-teensy/tree/master/examples/mbed-dsp)
  * [mbed-events](https://github.com/platformio/platform-teensy/tree/master/examples/mbed-events)
  * [mbed-serial](https://github.com/platformio/platform-teensy/tree/master/examples/mbed-serial)

- [TI MSP430](https://github.com/platformio/platform-timsp430)
  * [arduino-blink](https://github.com/platformio/platform-timsp430/tree/master/examples/arduino-blink)
  * [arduino-internal-libs](https://github.com/platformio/platform-timsp430/tree/master/examples/arduino-internal-libs)
  * [native-blink](https://github.com/platformio/platform-timsp430/tree/master/examples/native-blink)

- [TI TIVA](https://github.com/platformio/platform-titiva)
  * [arduino-blink](https://github.com/platformio/platform-titiva/tree/master/examples/arduino-blink)
  * [arduino-internal-libs](https://github.com/platformio/platform-titiva/tree/master/examples/arduino-internal-libs)
  * [libopencm3-blink](https://github.com/platformio/platform-titiva/tree/master/examples/libopencm3-blink)
  * [native-blink](https://github.com/platformio/platform-titiva/tree/master/examples/native-blink)

