/*
 * Picviz - Parallel coordinates ploter
 * Copyright (C) 2008 Sebastien Tricaud <toady@gscore.org>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation version 3.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * $Id: line.h 252 2008-10-20 05:17:44Z toady $
 */

#ifndef _LINE_H_
#define _LINE_H_

#include <picviz.h>

#include "linuxlist.h"

#ifdef __cplusplus
 extern "C" {
#endif

void picviz_line_free(PicvizLine *line);
struct line_t *picviz_line_init(void);
struct line_t *picviz_line_new(void);
struct line_t *picviz_line_get(PicvizAxis *axis, PcvID id);
void picviz_lines_axisplot_append(PicvizLine *line, PicvizAxisPlot *axisplot);
PcvHeight picviz_line_max_get(pcimage_t *image, struct llist_head *line, PcvID axis_id);
PcvHeight picviz_line_max_pertype_get(PicvizImage *image, PicvizDataType type);
void picviz_line_axisplot_append(PicvizLine *line, PicvizAxisPlot *axisplot);
int picviz_line_draw(PicvizImage *image, PicvizLine *line, void (*draw_line_func)(PicvizImage *image, PcvID axis_id, PicvizLine *line, PicvizAxisPlot *axisplot1, PicvizAxisPlot *axisplot2, PcvWidth x1, PcvHeight y1, PcvWidth x2, PcvHeight y2));
PicvizLine *picviz_line_id_get(PicvizImage *image, PcvID line_id);
void picviz_line_debug(PicvizLine *line);

#ifdef __cplusplus
 }
#endif

#endif /* _LINE_H_ */

