<?php
/**
*
* This file is part of the Norwegian (bokmål) Language Pack
* for the phpBB Forum Software.
*
* @copyright (c) phpBB Limited <https://www.phpbb.com>
* @copyright (c) Lars Christian Schreiner
* @license GNU General Public License, version 2 (GPL-2.0)
*
* For full copyright and license information, please see
* the docs/CREDITS.txt file.
*
*/

/**
* DO NOT CHANGE
*/
if (!defined('IN_PHPBB'))
{
	exit;
}

if (empty($lang) || !is_array($lang))
{
	$lang = array();
}

// DEVELOPERS PLEASE NOTE
//
// All language files should use UTF-8 as their encoding and the files must not contain a BOM.
//
// Placeholders can now contain order information, e.g. instead of
// 'Page %s of %s' you can (and should) write 'Page %1$s of %2$s', this allows
// translators to re-order the output of data while ensuring it remains correct
//
// You do not need this where single placeholders are used, e.g. 'Message %d' is fine
// equally where a string contains only two placeholders which are used to wrap text
// in a url you again do not need to specify an order e.g., 'Click %sHERE%s' is fine

$lang = array_merge($lang, array(
	'ACTION'				=> 'Handling',
	'ACTION_NOTE'			=> 'Handling/notat',
	'ADD_FEEDBACK'			=> 'Legg til tilbakemelding',
	'ADD_FEEDBACK_EXPLAIN'	=> 'Hvis du vil legge til en rapport om dette, fyller du ut følgende skjema. Bruk bare ren tekst – HTML, BBCode osv. tillates ikke.',
	'ADD_WARNING'			=> 'Legg til advarsel',
	'ADD_WARNING_EXPLAIN'	=> 'Hvis du vil sende en advarsel til denne brukeren, fyller du ut følgende skjema. Bruk bare ren tekst – HTML, BBCode osv. tillates ikke.',
	'ALL_ENTRIES'			=> 'Alle oppføringer',
	'ALL_NOTES_DELETED'		=> 'Alle brukernotater fjernet.',
	'ALL_REPORTS'			=> 'Alle rapporter',
	'ALREADY_REPORTED'		=> 'Dette innlegget er allerede rapportert.',
	'ALREADY_REPORTED_PM'	=> 'Denne private meldingen er allerede rapportert.',
	'ALREADY_WARNED'		=> 'Det er utstedt en advarsel for dette innlegget.',
	'APPROVE'				=> 'Godkjenn',
	'APPROVE_POST'			=> 'Godkjenn innlegg',
	'APPROVE_POST_CONFIRM'	=> 'Er du sikker på at du vil godkjenne dette innlegget?',
	'APPROVE_POSTS'			=> 'Godkjenn innlegg',
	'APPROVE_POSTS_CONFIRM'	=> 'Er du sikker på at du vil godkjenne de valgte innleggene?',
	'APPROVE_TOPIC'			=> 'Godkjenn emne',
	'APPROVE_TOPIC_CONFIRM'	=> 'Er du sikker påa t du vil godkjenne dette emnet?',
	'APPROVE_TOPICS'		=> 'Godkjenn emner',
	'APPROVE_TOPICS_CONFIRM'=> 'Er du sikker på at du vil godkjenne de valgte emnene?',

	'CANNOT_MOVE_SAME_FORUM'=> 'Du kan ikke flytte et emne til det samme forumet.',
	'CANNOT_WARN_ANONYMOUS'	=> 'Du kan ikke advare uregistrerte gjestebrukere.',
	'CANNOT_WARN_SELF'		=> 'Du kan ikke advare deg selv.',
	'CAN_LEAVE_BLANK'		=> 'Dette kan stå tomt.',
	'CHANGE_POSTER'			=> 'Endre forfatter',
	'CLOSE_PM_REPORT'		=> 'Lukk PM-rapport',
	'CLOSE_PM_REPORT_CONFIRM'	=> 'Er du sikker på at du vil lukke den valgte PM-rapporten?',
	'CLOSE_PM_REPORTS'		=> 'Lukk PM-rapporter',
	'CLOSE_PM_REPORTS_CONFIRM'	=> 'Er du sikker på at du vil lukke de valgte PM-rapportene?',
	'CLOSE_REPORT'			=> 'Lukk rapport',
	'CLOSE_REPORT_CONFIRM'	=> 'Er du sikker på at du vil lukke den valgte rapporten?',
	'CLOSE_REPORTS'			=> 'Lukk rapporter',
	'CLOSE_REPORTS_CONFIRM'	=> 'Er du sikker på at du vil lukke de valgte rapportene?',

	'DELETE_PM_REPORT'			=> 'Slett PM-rapport',
	'DELETE_PM_REPORT_CONFIRM'	=> 'Er du sikker på at du vil slette den valgte PM-rapporten?',
	'DELETE_PM_REPORTS'			=> 'Slett PM-rapporter',
	'DELETE_PM_REPORTS_CONFIRM'	=> 'Er du sikker på at du vil slette de valgte PM-rapportene?',
	'DELETE_POSTS'				=> 'Slett innlegg',
	'DELETE_REPORT'				=> 'Slett rapport',
	'DELETE_REPORT_CONFIRM'		=> 'Er du sikker på at du vil slette den valgte rapporten?',
	'DELETE_REPORTS'			=> 'Slett rapporter',
	'DELETE_REPORTS_CONFIRM'	=> 'Er du sikker på at du vil slette de valgte rapportene?',
	'DELETE_SHADOW_TOPIC'		=> 'Slett skyggeemne',
	'DELETE_TOPICS'				=> 'Slett valgte emner',
	'DISAPPROVE'				=> 'Avslå',
	'DISAPPROVE_REASON'			=> 'Begrunnelse for avslag',
	'DISAPPROVE_POST'			=> 'Avslå innlegg',
	'DISAPPROVE_POST_CONFIRM'	=> 'Er du sikker på at du vil avslå dette innlegget?',
	'DISAPPROVE_POSTS'			=> 'Avslå innlegg',
	'DISAPPROVE_POSTS_CONFIRM'	=> 'Er du sikker på at du vil avslå de valgte innleggene?',
	'DISPLAY_LOG'				=> 'Vis oppføringer fra forrige',
	'DISPLAY_OPTIONS'			=> 'Vis alternativer',

	'EMPTY_REPORT'					=> 'Du må angi en beskrivelse når du velger denne begrunnelsen.',
	'EMPTY_TOPICS_REMOVED_WARNING'	=> 'Merk at ett eller flere emner er fjernet fra databasen fordi de ble tomme.',

	'FEEDBACK'				=> 'Tilbakemelding',
	'FORK'					=> 'Kopier',
	'FORK_TOPIC'			=> 'Kkopier emne',
	'FORK_TOPIC_CONFIRM'	=> 'Er du sikker på at du vil kopiere dette emnet?',
	'FORK_TOPICS'			=> 'Kopier vlagte emner',
	'FORK_TOPICS_CONFIRM'	=> 'Er du sikker på at du vil kopiere de valgte emnene?',
	'FORUM_DESC'			=> 'Beskrivelse',
	'FORUM_NAME'			=> 'Forumnavn',
	'FORUM_NOT_EXIST'		=> 'Forumet du valgte, finnes ikke.',
	'FORUM_NOT_POSTABLE'	=> 'Det går ikke an å lage innlegg i forumet du valgte.',
	'FORUM_STATUS'			=> 'Forumstatus',
	'FORUM_STYLE'			=> 'Forumstil',

	'GLOBAL_ANNOUNCEMENT'	=> 'Global kunngjøring',

	'IP_INFO'				=> 'Informasjon om IP-adresse',
	'IPS_POSTED_FROM'		=> 'IP-adressene denne brukeren har skrevet innlegg fra',

	'LATEST_LOGS'				=> 'De 5 siste handlingene som er logget',
	'LATEST_REPORTED'			=> 'De 5 siste rapportene',
	'LATEST_REPORTED_PMS'		=> 'De 5 siste PM-rapportene',
	'LATEST_UNAPPROVED'			=> 'De 5 siste innleggene som venter på godkjenning',
	'LATEST_WARNING_TIME'		=> 'Den siste advarselen som ble utstedt',
	'LATEST_WARNINGS'			=> 'De 5 siste advarslene',
	'LEAVE_SHADOW'				=> 'La skyggeemne være',
	'LIST_REPORTS'				=> array(
		1	=> '%d rapport',
		2	=> '%d rapporter',
	),
	'LOCK'						=> 'Lås',
	'LOCK_POST_POST'			=> 'Lås innlegg',
	'LOCK_POST_POST_CONFIRM'	=> 'Er du sikker på at du vil forhindre redigering av dette innlegget?',
	'LOCK_POST_POSTS'			=> 'Lås valgte innlegg',
	'LOCK_POST_POSTS_CONFIRM'	=> 'Er du sikker på at du vil forhindre redigering av de valgte innleggene?',
	'LOCK_TOPIC_CONFIRM'		=> 'Er du sikker på at du vil låse dette emnet?',
	'LOCK_TOPICS'				=> 'Lås valgte emner',
	'LOCK_TOPICS_CONFIRM'		=> 'Er du sikker på at du vil låse alle valgte emner?',
	'LOGS_CURRENT_TOPIC'		=> 'Viser nå loggene for:',
	'LOGIN_EXPLAIN_MCP'			=> 'Du må logge inn for å moderere dette forumet.',
	'LOGVIEW_VIEWTOPIC'			=> 'Vis emne',
	'LOGVIEW_VIEWLOGS'			=> 'Vis emnelogg',
	'LOGVIEW_VIEWFORUM'			=> 'Vis forum',
	'LOOKUP_ALL'				=> 'Slå opp alle IP-er',
	'LOOKUP_IP'					=> 'Slå opp IP',

	'MARKED_NOTES_DELETED'		=> 'Alle merkede brukernotater er fjernet.',

	'MCP_ADD'						=> 'Legg til en advarsel',

	'MCP_BAN'					=> 'Utestengelse',
	'MCP_BAN_EMAILS'			=> 'Steng ute e-post',
	'MCP_BAN_IPS'				=> 'Steng ute IP-er',
	'MCP_BAN_USERNAMES'			=> 'Steng ute brukernavn',

	'MCP_LOGS'						=> 'Moderatorlogger',
	'MCP_LOGS_FRONT'				=> 'Forside',
	'MCP_LOGS_FORUM_VIEW'			=> 'Forumlogger',
	'MCP_LOGS_TOPIC_VIEW'			=> 'Emnelogger',

	'MCP_MAIN'						=> 'Hoved',
	'MCP_MAIN_FORUM_VIEW'			=> 'Vis forum',
	'MCP_MAIN_FRONT'				=> 'Forside',
	'MCP_MAIN_POST_DETAILS'			=> 'Innleggsdetaljer',
	'MCP_MAIN_TOPIC_VIEW'			=> 'Vis emne',
	'MCP_MAKE_ANNOUNCEMENT'			=> 'Endre til «Kunngjøring»',
	'MCP_MAKE_ANNOUNCEMENT_CONFIRM'	=> 'Er du sikker på at du vil endre dette emnet til en «Kunngjøring»?',
	'MCP_MAKE_ANNOUNCEMENTS'		=> 'Endre til «Kunngjøringer»',
	'MCP_MAKE_ANNOUNCEMENTS_CONFIRM'=> 'Er du sikker på at du vil endre de valgte emnene til «Kunngjøringer»?',
	'MCP_MAKE_GLOBAL'				=> 'Endre til «Global kunngjøring»',
	'MCP_MAKE_GLOBAL_CONFIRM'		=> 'Er du sikker på at du vil endre dette emnet til en «Global kunngjøring»?',
	'MCP_MAKE_GLOBALS'				=> 'Endre til «Globale kunngjøringer»',
	'MCP_MAKE_GLOBALS_CONFIRM'		=> 'Er du sikker på at du vil endre de valgte emnene til «Globale kunngjøringer»?',
	'MCP_MAKE_STICKY'				=> 'Endre til «Festet»',
	'MCP_MAKE_STICKY_CONFIRM'		=> 'Er du sikker på at du vil endre dette emnet til «Festet»?',
	'MCP_MAKE_STICKIES'				=> 'Endre til «Festet',
	'MCP_MAKE_STICKIES_CONFIRM'		=> 'Er du sikker på at du vil endre de valgte emnene til «Festet»?',
	'MCP_MAKE_NORMAL'				=> 'Endre til «Standardemne»',
	'MCP_MAKE_NORMAL_CONFIRM'		=> 'Er du sikker på at du vil endre dette emnet til et «Standardemne»?',
	'MCP_MAKE_NORMALS'				=> 'Endre til «Standardemner»',
	'MCP_MAKE_NORMALS_CONFIRM'		=> 'Er du sikker på at du vil endre de valgte emnene til «Standardemner»?',

	'MCP_NOTES'						=> 'Brukernotater',
	'MCP_NOTES_FRONT'				=> 'Forside',
	'MCP_NOTES_USER'				=> 'Brukerdetaljer',

	'MCP_POST_REPORTS'				=> 'Rapporter som er utstedt for dette innlegget',

	'MCP_PM_REPORTS'				=> 'Rapporterte PM-er',
	'MCP_PM_REPORT_DETAILS'			=> 'PM-rapportdetaljer',
	'MCP_PM_REPORTS_CLOSED'			=> 'Lukkede PM-rapporter',
	'MCP_PM_REPORTS_CLOSED_EXPLAIN'	=> 'Dette er en liste over alle rapporter om private meldinger som tidligere har blitt behandlet.',
	'MCP_PM_REPORTS_OPEN'			=> 'Åpne PM-rapporter',
	'MCP_PM_REPORTS_OPEN_EXPLAIN'	=> 'Dette er en liste over alle rapporter om private meldinger som fortsatt ikke er behandlet.',

	'MCP_REPORTS'					=> 'Rapporterte meldinger',
	'MCP_REPORT_DETAILS'			=> 'Rapportdetaljer',
	'MCP_REPORTS_CLOSED'			=> 'Lukkede rapporter',
	'MCP_REPORTS_CLOSED_EXPLAIN'	=> 'Dette er en liste over alle rapporter om innlegg som tidligere har blitt behandlet.',
	'MCP_REPORTS_OPEN'				=> 'Åpne rapporter',
	'MCP_REPORTS_OPEN_EXPLAIN'		=> 'Dette er en liste over alle rapporter om innlegg som fortsatt ikke er behandlet.',

	'MCP_QUEUE'								=> 'Modereringskø',
	'MCP_QUEUE_APPROVE_DETAILS'				=> 'Godkjenningsdetaljer',
	'MCP_QUEUE_UNAPPROVED_POSTS'			=> 'Innlegg som avventer godkjenning',
	'MCP_QUEUE_UNAPPROVED_POSTS_EXPLAIN'	=> 'Dette er en liste over alle innlegg som krever godkjenning før de blir synlige for brukere.',
	'MCP_QUEUE_UNAPPROVED_TOPICS'			=> 'Emner som avventer godkjenning',
	'MCP_QUEUE_UNAPPROVED_TOPICS_EXPLAIN'	=> 'Dette er en liste over alle emner som krever godkjenning før de blir synlige for brukere.',
	'MCP_QUEUE_DELETED_POSTS'				=> 'Slettede innlegg',
	'MCP_QUEUE_DELETED_POSTS_EXPLAIN'		=> 'Dette er en liste over alle innlegg som er påbegynt slettet. Fra denne skjermen kan du gjenopprette dem eller slette dem permanent.',
	'MCP_QUEUE_DELETED_TOPICS'				=> 'Slettede emner',
	'MCP_QUEUE_DELETED_TOPICS_EXPLAIN'		=> 'Dette er en liste over alle emner som er påbegynt slettet. Fra denne skjermen kan du gjenopprette dem eller slette dem permanent.',

	'MCP_VIEW_USER'			=> 'Vis advarsler for en bestemt bruker',

	'MCP_WARN'				=> 'Advarsler',
	'MCP_WARN_FRONT'		=> 'Forside',
	'MCP_WARN_LIST'			=> 'List opp advarsler',
	'MCP_WARN_POST'			=> 'Advar for spesifikt innlegg',
	'MCP_WARN_USER'			=> 'Advar bruker',

	'MERGE_POSTS_CONFIRM'	=> 'Er du sikker på at du vil flytte de valgte innleggene?',
	'MERGE_TOPIC_EXPLAIN'	=> 'Ved hjelp av skjemaet nedenfor kan du flytte valgte innlegg inn i et annet emne. Innleggene vil bli splittet fra dette emnet og slått sammen med det andre emnet. Disse innleggene vil ikke bli separert, og vil vises som om brukerne la dem inn i det nye emnet.<br />Angi emne-ID for målet eller klikk «Velg emne» for å søke etter den.',
	'MERGE_TOPIC_ID'		=> 'Emne-ID-nummer for mål',
	'MERGE_TOPICS'			=> 'Slå sammen emner',
	'MERGE_TOPICS_CONFIRM'	=> 'Er du sikker på at du vil slå sammen de valgte emnene?',
	'MODERATE_FORUM'		=> 'Moderer forum',
	'MODERATE_TOPIC'		=> 'Moderer emne',
	'MODERATE_POST'			=> 'Moderer innlegg',
	'MOD_OPTIONS'			=> 'Moderatoralternativer',
	'MORE_INFO'				=> 'Ytterligere informasjon',
	'MOST_WARNINGS'			=> 'Brukerne med flest advarsler',
	'MOVE_TOPIC_CONFIRM'	=> 'Er du sikker på at du vil flytte emnet til et nytt forum?',
	'MOVE_TOPICS'			=> 'Flytt valgte emner',
	'MOVE_TOPICS_CONFIRM'	=> 'Er du sikker på at du vil flytte de valgte emnene til et nytt forum?',

	'NOTIFY_POSTER_APPROVAL'		=> 'Vil du varsle innleggsforfatteren om godkjenningen?',
	'NOTIFY_POSTER_DISAPPROVAL'		=> 'Vil du varsle innleggsforfatteren om avslaget?',
	'NOTIFY_USER_WARN'				=> 'Vil du varsle brukeren om advarselen?',
	'NOT_MODERATOR'					=> 'Du er ikke moderator i dette forumet.',
	'NO_DESTINATION_FORUM'			=> 'Velg et målforum.',
	'NO_DESTINATION_FORUM_FOUND'	=> 'Intet målforum er tilgjengelig.',
	'NO_ENTRIES'					=> 'Ingen loggoppføringer.',
	'NO_FEEDBACK'					=> 'Ingen tilbakemeldinger finnes for denne brukeren.',
	'NO_FINAL_TOPIC_SELECTED'		=> 'Du må velge et målemne for sammenslåing av innlegg.',
	'NO_MATCHES_FOUND'				=> 'Finner ingen treff.',
	'NO_POST'						=> 'Du må velge et innlegg for å kunne advare brukeren om et innlegg.',
	'NO_POST_REPORT'				=> 'Dette innlegget var ikke rapportert.',
	'NO_POST_SELECTED'				=> 'Du må velge minst ett innlegg for å utføre denne handlingen.',
	'NO_POSTS_DELETED'				=> 'Det finnes ingen slettede innlegg.',
	'NO_POSTS_QUEUE'				=> 'Det er ingen innlegg som venter på godkjenning.',
	'NO_REASON_DISAPPROVAL'			=> 'Gi en passende begrunnelse for avslaget.',
	'NO_REPORT'						=> 'Ingen rapport funnet',
	'NO_REPORTS'					=> 'Ingen rapporter funnet',
	'NO_REPORT_SELECTED'			=> 'Du må velge minst én rapport for å utføre denne handlingen.',
	'NO_TOPIC_ICON'					=> 'Ingen',
	'NO_TOPIC_SELECTED'				=> 'Du må velge minst ett emne for å utføre denne handlingen.',
	'NO_TOPICS_DELETED'				=> 'Det er ingen slettede emner.',
	'NO_TOPICS_QUEUE'				=> 'Det er ingen emner som avventer godkjenning.',

	'ONLY_TOPIC'			=> 'Bare emnet «%s»',
	'OTHER_USERS'			=> 'Andre brukere som skriver innlegg fra denne IP-en',

	'QUICKMOD_ACTION_NOT_ALLOWED' => "%s tillates ikke som hurtigmoderering",

	'PM_REPORT_CLOSED_SUCCESS'	=> 'Den valgte PM-rapporten er lukket.',
	'PM_REPORT_DELETED_SUCCESS'	=> 'Den valgte PM-rapporten er slettet.',
	'PM_REPORTED_SUCCESS'		=> 'Den private meldingen er rapportert.',
	'PM_REPORTS_CLOSED_SUCCESS'	=> 'De valgte PM-rapportene er lukket.',
	'PM_REPORTS_DELETED_SUCCESS'=> 'De valgte PM-rapportene er slettet.',
	'PM_REPORTS_TOTAL'			=> array(
		0	=> 'Det er ingen PM-rapporter å se gjennom.',
		1	=> 'Totalt er det <strong>1</strong> PM-rapport å se gjennom.',
		2	=> 'Totalt er det <strong>%d</strong> PM-rapporter å se gjennom.',
	),
	'PM_REPORT_DETAILS'			=> 'Detaljer for rapport om privat melding',
	'POSTER'					=> 'Innleggsforfatter',
	'POSTS_APPROVED_SUCCESS'	=> 'De valgte innleggene er godkjent.',
	'POSTS_DELETED_SUCCESS'		=> 'De valgte innleggene er fjernet fra databasen.',
	'POSTS_DISAPPROVED_SUCCESS'	=> 'De valgte innleggene er avslått.',
	'POSTS_LOCKED_SUCCESS'		=> 'De valgte innleggene er låst.',
	'POSTS_MERGED_SUCCESS'		=> 'De valgte innleggene er slått sammen.',
	'POSTS_PER_PAGE'			=> 'Innlegg per side',
	'POSTS_PER_PAGE_EXPLAIN'	=> '(Angi 0 for å vise alle innlegg.)',
	'POSTS_RESTORED_SUCCESS'	=> 'De valgte innleggene er gjenopprettet.',
	'POSTS_UNLOCKED_SUCCESS'	=> 'De valgte innleggene er låst opp.',
	'POST_APPROVED_SUCCESS'		=> 'Det valgte innlegget er godkjent.',
	'POST_DELETED_SUCCESS'		=> 'Det valgte innlegget er fjernet fra databasen.',
	'POST_DISAPPROVED_SUCCESS'	=> 'Det valgte innlegget er avslått.',
	'POST_LOCKED_SUCCESS'		=> 'Innlegget er låst.',
	'POST_NOT_EXIST'			=> 'Innlegget du forespurte, finnes ikke.',
	'POST_REPORTED_SUCCESS'		=> 'Dette innlegget er nå rapportert.',
	'POST_RESTORED_SUCCESS'		=> 'Dette innlegget er nå gjenopprettet.',
	'POST_UNLOCKED_SUCCESS'		=> 'Innlegget er nå låst opp.',

	'READ_USERNOTES'			=> 'Brukernotater',
	'READ_WARNINGS'				=> 'Brukeradvarsler',
	'REPORTER'					=> 'Rapportør',
	'REPORTED'					=> 'Rapporterte',
	'REPORTED_BY'				=> 'Rapportert av',
	'REPORTED_ON_DATE'			=> 'den',
	'REPORTS_CLOSED_SUCCESS'	=> 'De valgte rapportene er nå lukket.',
	'REPORTS_DELETED_SUCCESS'	=> 'De valgte rapportene er nå slettet.',
	'REPORTS_TOTAL'				=> array(
		0	=> 'Det er ingen rapporter å se gjennom.',
		1	=> 'Totalt er det <strong>1</strong> rapport å se gjennom.',
		2	=> 'Totalt er det <strong>%d</strong> rapporter å se gjennom.',
	),
	'REPORT_CLOSED'				=> 'Denne rapporten er allerede lukket.',
	'REPORT_CLOSED_SUCCESS'		=> 'Den valgte rapporten er nå lukket.',
	'REPORT_DELETED_SUCCESS'	=> 'Den valgte rapporten er nå slettet.',
	'REPORT_DETAILS'			=> 'Rapportdetaljer',
	'REPORT_MESSAGE'			=> 'Rapporter denne meldingen',
	'REPORT_MESSAGE_EXPLAIN'	=> 'Bruk dette skjemaet til å rapportere den valgte private meldingen. Rapportering bør normalt bare brukes hvis meldingen bryter med forumreglene. <strong>Når en privat melding rapporteres, blir innholdet i den synlig for alle moderatorer.</strong>',
	'REPORT_NOTIFY'				=> 'Varsle meg',
	'REPORT_NOTIFY_EXPLAIN'		=> 'Informerer deg når rapporten er behandlet.',
	'REPORT_POST_EXPLAIN'		=> 'Bruk dette skjemaet til å rapportere det valgte innlegget til forummoderatorene og systemadministratorene. Rapportering bør normalt bare brukes hvis innlegget bryter med forumreglene.',
	'REPORT_REASON'				=> 'Rapportbegrunnelse',
	'REPORT_TIME'				=> 'Rapportklokkeslett',
	'RESTORE'					=> 'Gjenopprett',
	'RESTORE_POST'				=> 'Gjenopprett innlegg',
	'RESTORE_POST_CONFIRM'		=> 'Er du sikker på at du vil gjenopprette dette innlegget?',
	'RESTORE_POSTS'				=> 'Gjenopprett innlegg',
	'RESTORE_POSTS_CONFIRM'		=> 'Er du sikker på at du vil gjenopprette de valgte innleggene?',
	'RESTORE_TOPIC'				=> 'Gjenopprett emne',
	'RESTORE_TOPIC_CONFIRM'		=> 'Er du sikker påa t du vil gjenopprette dette emnet?',
	'RESTORE_TOPICS'			=> 'Gjenopprett emner',
	'RESTORE_TOPICS_CONFIRM'	=> 'Er du sikker på at du vil gjenopprette de valgte emnene?',
	'RESYNC'					=> 'Resynkroniser',
	'RETURN_MESSAGE'			=> '%sGå tilbake til meldingen%s',
	'RETURN_NEW_FORUM'			=> '%sGå til det nye forumet%s',
	'RETURN_NEW_TOPIC'			=> '%sGå til det nye emnet%s',
	'RETURN_PM'					=> '%sGå tilbake til den private meldingen%s',
	'RETURN_POST'				=> '%sGå tilbake til innlegget%s',
	'RETURN_QUEUE'				=> '%sGå tilbake til køen%s',
	'RETURN_REPORTS'			=> '%sGå tilbake til rapportene%s',
	'RETURN_TOPIC_SIMPLE'		=> '%sGå tilbake til emnet%s',

	'SEARCH_POSTS_BY_USER'				=> 'Søk etter innlegg av',
	'SELECT_ACTION'						=> 'Velg ønsket handling',
	'SELECT_FORUM_GLOBAL_ANNOUNCEMENT'	=> 'Velg forumet du vil at denne globale kunngjøringen skal vises i.',
	'SELECT_FORUM_GLOBAL_ANNOUNCEMENTS'	=> 'Ett eller flere av de valgte emnene er globale kunngjøringer. Velg forumet du vil at disse skal vises i.',
	'SELECT_MERGE'						=> 'Velg for sammenslåing',
	'SELECT_TOPICS_FROM'				=> 'Velg emner fra',
	'SELECT_TOPIC'						=> 'Velg emne',
	'SELECT_USER'						=> 'Velg bruker',
	'SORT_ACTION'						=> 'Logghandling',
	'SORT_DATE'							=> 'Dato',
	'SORT_IP'							=> 'IP-adresse',
	'SORT_WARNINGS'						=> 'Advarsler',
	'SPLIT_AFTER'						=> 'Splitt emnet fra valgte innlegg og utover',
	'SPLIT_FORUM'						=> 'Forum for det nye emnet',
	'SPLIT_POSTS'						=> 'Splitt valgte innlegg',
	'SPLIT_SUBJECT'						=> 'Tittel på nytt emne',
	'SPLIT_TOPIC_ALL'					=> 'Splitt emnet fra valgte innlegg',
	'SPLIT_TOPIC_ALL_CONFIRM'			=> 'Er du sikker på at du vil splitte dette emnet?',
	'SPLIT_TOPIC_BEYOND'				=> 'Splitt emnet på valgte innlegg',
	'SPLIT_TOPIC_BEYOND_CONFIRM'		=> 'Er du sikker på at du vil splitte dette emnet på det valgte innlegget?',
	'SPLIT_TOPIC_EXPLAIN'				=> 'Ved hjelp av skjemaet nedenfor kan du splitte et emne i to, enten ved å velge innleggene enkeltvis eller ved å splitt på et valgt innlegg.',

	'THIS_PM_IP'				=> 'IP for denne private meldingen',
	'THIS_POST_IP'				=> 'IP for dette innlegget',
	'TOPICS_APPROVED_SUCCESS'	=> 'De valgte emnene er godkjent.',
	'TOPICS_DELETED_SUCCESS'	=> 'De valgte emnene er fjernet fra databasen.',
	'TOPICS_DISAPPROVED_SUCCESS'=> 'De valgte emnene er avslått.',
	'TOPICS_FORKED_SUCCESS'		=> 'De valgte emnene er kopiert.',
	'TOPICS_LOCKED_SUCCESS'		=> 'De valgte emnene er låst.',
	'TOPICS_MOVED_SUCCESS'		=> 'De valgte emnene er flyttet.',
	'TOPICS_RESTORED_SUCCESS'	=> 'De valgte emnene er gjenopprettet.',
	'TOPICS_RESYNC_SUCCESS'		=> 'De valgte emnene er resynkronisert.',
	'TOPICS_TYPE_CHANGED'		=> 'Emnetype er nå endret.',
	'TOPICS_UNLOCKED_SUCCESS'	=> 'De valgte emnene er låst opp.',
	'TOPIC_APPROVED_SUCCESS'	=> 'Det valgte emnet er godkjent.',
	'TOPIC_DELETED_SUCCESS'		=> 'Det valgte emnet er fjernet fra databasen.',
	'TOPIC_DISAPPROVED_SUCCESS'	=> 'Det valgte emnet er avslått.',
	'TOPIC_FORKED_SUCCESS'		=> 'Det valgte emnet er kopiert.',
	'TOPIC_LOCKED_SUCCESS'		=> 'Det valgte emnet er låst.',
	'TOPIC_MOVED_SUCCESS'		=> 'Det valgte emnet er flyttet.',
	'TOPIC_NOT_EXIST'			=> 'Emnet du valgte, finnes ikke.',
	'TOPIC_RESTORED_SUCCESS'	=> 'Det valgte emnet er gjenopprettet.',
	'TOPIC_RESYNC_SUCCESS'		=> 'Det valgte emnet er resynkronisert.',
	'TOPIC_SPLIT_SUCCESS'		=> 'Det valgte emnet er splittet.',
	'TOPIC_TIME'				=> 'Emneklokkeslett',
	'TOPIC_TYPE_CHANGED'		=> 'Emnetype er nå endret.',
	'TOPIC_UNLOCKED_SUCCESS'	=> 'Det valgte emnet er nå låst opp.',
	'TOTAL_WARNINGS'			=> 'Advarsler totalt',

	'UNAPPROVED_POSTS_TOTAL'		=> array(
		0	=> 'Det er ingen innlegg som avventer godkjenning.',
		1	=> 'Totalt er det <strong>1</strong> innlegg som avventer godkjenning.',
		2	=> 'Totalt er det <strong>%d</strong> innlegg som avventer godkjenning.',
	),
	'UNLOCK'						=> 'Lås opp',
	'UNLOCK_POST'					=> 'Lås opp innlegg',
	'UNLOCK_POST_EXPLAIN'			=> 'Tillat redigering',
	'UNLOCK_POST_POST'				=> 'Lås opp innlegg',
	'UNLOCK_POST_POST_CONFIRM'		=> 'Er du sikker på at du vil tillate redigering av dette innlegget?',
	'UNLOCK_POST_POSTS'				=> 'Lås opp valgte innlegg',
	'UNLOCK_POST_POSTS_CONFIRM'		=> 'Er du sikker på at du vil tillate redigering av de valgte innleggene?',
	'UNLOCK_TOPIC'					=> 'Lås opp emne',
	'UNLOCK_TOPIC_CONFIRM'			=> 'Er du sikker på at du vil låse opp dette emnet?',
	'UNLOCK_TOPICS'					=> 'Lås opp valgte emner',
	'UNLOCK_TOPICS_CONFIRM'			=> 'Er du sikker på at du vil låse opp alle valgte emner?',
	'USER_CANNOT_POST'				=> 'Du kan ikke skrive innlegg i dette forumet.',
	'USER_CANNOT_REPORT'			=> 'Du kan ikke rapportere innlegg i dette forumet.',
	'USER_FEEDBACK_ADDED'			=> 'Brukertilbakemelding er lagt til.',
	'USER_WARNING_ADDED'			=> 'Brukeren er advart.',

	'VIEW_DETAILS'			=> 'Vis detaljer',
	'VIEW_PM'				=> 'Vis privat melding',
	'VIEW_POST'				=> 'Vis innlegg',

	'WARNED_USERS'			=> 'Advarte brukere',
	'WARNED_USERS_EXPLAIN'	=> 'Dette er en liste over brukere med ikke-utløpte advarsler.',
	'WARNING_PM_BODY'		=> 'Følgende er en advarsel som en administrator eller moderator på dette systemet har utstedt til deg.[quote]%s[/quote]',
	'WARNING_PM_SUBJECT'	=> 'Systemadvarsel utstedt',
	'WARNING_POST_DEFAULT'	=> 'Dette er en advarsel om følgende innlegg av deg: %s .',
	'NO_WARNINGS'	=> 'Det finnes ingen advarsler.',

	'YOU_SELECTED_TOPIC'	=> 'Du valgte emne nummer %d: %s.',

	'report_reasons'		=> array(
		'TITLE'	=> array(
			'WAREZ'		=> 'Warez',
			'SPAM'		=> 'Spam',
			'OFF_TOPIC'	=> 'Avsporing',
			'OTHER'		=> 'Annet',
		),
		'DESCRIPTION' => array(
			'WAREZ'		=> 'Meldingen inneholder lenker til ulovlig eller piratkopiert programvare.',
			'SPAM'		=> 'Den rapporterte meldingen har som eneste hensikt å annonsere for et nettsted eller et produkt.',
			'OFF_TOPIC'	=> 'Den rapporterte meldingen holder seg ikke til emnet.',
			'OTHER'		=> 'Den rapporterte meldingen passer ikke inn i noen av de andre kategoriene, bruk feltet for ytterligere informasjon.',
		),
	),
));
