##############################################################################
#
#  MySQL Empty Bit-String Literal Denial of Service Vulnerability 
#
#  Copyright: SecPod
#
#  Date Written: 2008/09/18
#
#  Revision: 1.1
#
#  Log: veerendragg
#  Issue #0241
#  ------------------------------------------------------------------------
#  This program was written by SecPod and is licensed under the GNU GPL 
#  license. Please refer to the below link for details,
#  http://www.gnu.org/licenses/gpl.html
#  This header contains information regarding licensing terms under the GPL, 
#  and information regarding obtaining source code from the Author. 
#  Consequently, pursuant to section 3(c) of the GPL, you must accompany the 
#  information found in this header with any distribution you make of this 
#  Program.
#  ------------------------------------------------------------------------
##############################################################################


if(description)
{
 script_id(900221);
 script_bugtraq_id(31081);
 script_cve_id("CVE-2008-3963");
 script_copyright("Copyright (C) 2008 SecPod");
 script_version("Revision: 1.1 ");
 script_tag(name:"cvss_base", value:"7.1");
 script_tag(name:"risk_factor", value:"High");
 script_category(ACT_GATHER_INFO);
 script_family("Denial of Service");
 script_name("MySQL Empty Bit-String Literal Denial of Service Vulnerability");
 script_summary("Check for version of MySQL");
 desc = "
 Overview : This host is running MySQL, which is prone to Denial of Service
 Vulnerability.

 Vulnerability Insight :

        Issue is due to error while processing an empty bit string literal via
        a specially crafted SQL statement.

        Impact : Successful exploitation by remote attackers could cause denying
        access to legitimate users.

 Impact Level : Application

 Affected Software/OS : 
        MySQL versions prior to 5.0.x - 5.0.66,
                                5.1.x - 5.1.26, and
                                6.0.x - 6.0.5 on all running platform.

 Fix : Update to version 5.0.66 or 5.1.26 or 6.0.6 or later.
 http://dev.mysql.com/downloads/

 References : 
 http://secunia.com/advisories/31769/
 http://bugs.mysql.com/bug.php?id=35658
 http://dev.mysql.com/doc/refman/5.1/en/news-5-1-26.html
 
 CVSS Score :
        CVSS Base Score     : 7.1 (AV:N/AC:M/Au:NR/C:N/I:N/A:C)
        CVSS Temporal Score : 5.6
 Risk factor : High";

 script_description(desc);
 script_dependencies("mysql_version.nasl");
 script_require_ports("Services/mysql", 3306);
 exit(0);
}


 include("misc_func.inc");

 sqlPort = get_kb_item("Services/mysql");
 if(!sqlPort){
        sqlPort = 3306;
 }

 if(!get_port_state(sqlPort)){
        exit(0);
 }

 mysqlVer = get_mysql_version(port:sqlPort);
 if(mysqlVer)
 {
       # grep for version < 5.0.66, 5.1.26, and 6.0.6
       if(ereg(pattern:"^(5\.0(\.[0-5]?[0-9]|\.6[0-5])?|5\.1(\.[01]?[0-9]|" +
                       "\.2[0-5])?|6\.0(\.[0-5])?)[^.0-9]", string:mysqlVer)){
                security_hole(sqlPort);
       }
 }
