# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1740-1 (yaws)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(63605);
 script_cve_id("CVE-2009-0751");
 script_version ("$");
 script_tag(name:"cvss_base", value:"5.0");
 script_tag(name:"risk_factor", value:"Medium");
 name = "Debian Security Advisory DSA 1740-1 (yaws)";
 script_name(name);

 desc = "The remote host is missing an update to yaws
announced via advisory DSA 1740-1.


It was discovered that yaws, a high performance HTTP 1.1 webserver, is
prone to a denial of service attack via a request with a large HTTP
header.

For the stable distribution (lenny), this problem has been fixed in
version 1.77-3+lenny1.

For the oldstable distribution (etch), this problem has been fixed in
version 1.65-4etch1.

For the testing distribution (squeeze) and the unstable distribution
(sid), this problem has been fixed in version 1.80-1.

We recommend that you upgrade your yaws package.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201740-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 1740-1 (yaws)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"yaws", ver:"1.65-4etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"yaws-wiki", ver:"1.77-3+lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"yaws-chat", ver:"1.77-3+lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"yaws-mail", ver:"1.77-3+lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"yaws-yapp", ver:"1.77-3+lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"yaws", ver:"1.77-3+lenny1", rls:"DEB5.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
