'use strict';

var redis = require('redis');
var client = redis.createClient();
var set_size = 20;

client.sadd('bigset', 'a member');
client.sadd('bigset', 'another member');

while (set_size > 0) {
    client.sadd('bigset', 'member ' + set_size);
    set_size -= 1;
}

// multi chain with an individual callback
client.multi()
    .scard('bigset')
    .smembers('bigset')
    .keys('*', function (err, replies) {
        client.mget(replies, redis.print);
    })
    .dbsize()
    .exec(function (err, replies) {
        console.log('MULTI got ' + replies.length + ' replies');
        replies.forEach(function (reply, index) {
            console.log('Reply ' + index + ': ' + reply.toString());
        });
    });

client.mset('incr thing', 100, 'incr other thing', 1, redis.print);

// start a separate multi command queue
var multi = client.multi();
multi.incr('incr thing', redis.print);
multi.incr('incr other thing', redis.print);

// runs immediately
client.get('incr thing', redis.print); // 100

// drains multi queue and runs atomically
multi.exec(function (err, replies) {
    console.log(replies); // 101, 2
});

// you can re-run the same transaction if you like
multi.exec(function (err, replies) {
    console.log(replies); // 102, 3
    client.quit();
});
