<!--startmeta
custom_edit_url: "https://github.com/netdata/netdata/edit/master/collectors/proc.plugin/integrations/amd_gpu.md"
meta_yaml: "https://github.com/netdata/netdata/edit/master/collectors/proc.plugin/metadata.yaml"
sidebar_label: "AMD GPU"
learn_status: "Published"
learn_rel_path: "Data Collection/Hardware Devices and Sensors"
message: "DO NOT EDIT THIS FILE DIRECTLY, IT IS GENERATED BY THE COLLECTOR'S metadata.yaml FILE"
endmeta-->

# AMD GPU


<img src="https://netdata.cloud/img/amd.svg" width="150"/>


Plugin: proc.plugin
Module: /sys/class/drm

<img src="https://img.shields.io/badge/maintained%20by-Netdata-%2300ab44" />

## Overview

This integration monitors AMD GPU metrics, such as utilization, clock frequency and memory usage.

It reads `/sys/class/drm` to collect metrics for every AMD GPU card instance it encounters.

This collector is only supported on the following platforms:

- Linux

This collector supports collecting metrics from multiple instances of this integration, including remote instances.


### Default Behavior

#### Auto-Detection

This integration doesn't support auto-detection.

#### Limits

The default configuration for this integration does not impose any limits on data collection.

#### Performance Impact

The default configuration for this integration is not expected to impose a significant performance impact on the system.


## Metrics

Metrics grouped by *scope*.

The scope defines the instance that the metric belongs to. An instance is uniquely identified by a set of labels.



### Per gpu

These metrics refer to the GPU.

Labels:

| Label      | Description     |
|:-----------|:----------------|
| product_name | GPU product name (e.g. AMD RX 6600) |

Metrics:

| Metric | Dimensions | Unit |
|:------|:----------|:----|
| amdgpu.gpu_utilization | utilization | percentage |
| amdgpu.gpu_mem_utilization | utilization | percentage |
| amdgpu.gpu_clk_frequency | frequency | MHz |
| amdgpu.gpu_mem_clk_frequency | frequency | MHz |
| amdgpu.gpu_mem_vram_usage_perc | usage | percentage |
| amdgpu.gpu_mem_vram_usage | free, used | bytes |
| amdgpu.gpu_mem_vis_vram_usage_perc | usage | percentage |
| amdgpu.gpu_mem_vis_vram_usage | free, used | bytes |
| amdgpu.gpu_mem_gtt_usage_perc | usage | percentage |
| amdgpu.gpu_mem_gtt_usage | free, used | bytes |



## Alerts

There are no alerts configured by default for this integration.


## Setup

### Prerequisites

No action required.

### Configuration

#### File

There is no configuration file.
#### Options



There are no configuration options.

#### Examples
There are no configuration examples.


