type amount = int * string
type default_units_amount = int

let create sum str = (sum, str)
let to_string (amount, str) =
  if str <> "" then (Misc.format_money amount) ^ " (" ^ str ^ ")"
  else Misc.format_money amount

let zero = (0, "0.00")
let zero_default = 0
let is_negative (sum, _) = sum < 0
let add (sum, str) sum' = sum + sum'
let negate (sum, str) =
  if str = "" then (-sum, str)
  else
  begin
    if sum < 0 then
      (-sum, String.sub str 1 (String.length str - 1))
    else
      (-sum, "-" ^ str)
  end
let to_string_default = Misc.format_money
let non_negative_default sum = (not (sum <= -1))
let very_negative_default sum = sum < -5000
let negate_default sum = -sum
let scale_default numerator denominator sum =
  truncate (numerator /. denominator *. (float sum))
let abs_default a = abs a
let add_default a b = a + b
let subtract_default a b = a - b
let default_to_normal sum = (sum, "")
let is_zero (sum, _) = (sum = 0)

