/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#ifndef SYMBOLSP_H
#define SYMBOLSP_H

#include <Xm/XmP.h>
#include <Xm/PrimitiveP.h>

/* Symbols class : no new fileds */

typedef struct _SymbolsClassPart{
    int ignore;
} SymbolsClassPart;

typedef struct _SymbolsClassRec{
    CoreClassPart    core_class;
    XmPrimitiveClassPart  primitive_class;
    SymbolsClassPart  symbols_class;
} SymbolsClassRec;

extern SymbolsClassRec symbolsClassRec;

typedef struct _SymbolsPart {
	int             count;
	int             max;
	unsigned int     width;
	unsigned int     height;
	unsigned int    *widths;
	unsigned int    *heights;
	Pixmap          *pixmaps;
	XtCallbackList  activate;
	XmFontList      fontlist;
	char           *no_colours;
	GC              fontGC;
} SymbolsPart;

typedef struct _SymbolsRec {
    CorePart          core;
    XmPrimitivePart  primitive;
    SymbolsPart        symbols;
} SymbolsRec;

#endif
