/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#ifndef OutputDrawer_H
#include "OutputDrawer.h"
#endif

#ifndef EditorDrawerFactory_H
#include "EditorDrawerFactory.h"
#endif

#ifndef MacroEditor_H
#include "MacroEditor.h"
#endif

#ifndef XMText_H
#include "XMText.h"
#endif


OutputDrawer::OutputDrawer(MacroEditor& e):
	XEditorDrawer<UIOutputDrawer_c>(e),
	editor_(e)
{
	e.output(text_);	
}

OutputDrawer::~OutputDrawer()
{
}

void OutputDrawer::clickCB(Widget,XtPointer data)
{
	XmTextVerifyCallbackStruct *cb = (XmTextVerifyCallbackStruct*)data;
	XMText text(text_);
	string p = text.get();
	
	long len = p.length();
	long n = cb->newInsert;

	const char* pc = p.c_str();  //-- HP C++ string crashes on p[n]
	                             //-- thus use C string pc  :-(

	while(n > 0 && pc[n-1] != '\n') 
		n--;

	if(pc[n-1] == '\n') 
		n++;

	string s;
	while(n < len && pc[n-1] != 'L' && pc[n-1] != '\n')
	   n++;
	while(n < len && pc[n-1] != '\n')
	   s += pc[n++];

	editor_.line(s);
}

static EditorDrawerMaker<OutputDrawer,MacroEditor> maker(10);
