/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#ifndef FolderViewer_H
#include "FolderViewer.h"
#endif

#ifndef IconSelection_H
#include "IconSelection.h"
#endif

#ifndef ConfigLoader_H
#include "ConfigLoader.h"
#endif

#ifndef IconObject_H
#include "IconObject.h"
#endif
#ifndef IconClass_H
#include "IconClass.h"
#endif

#ifndef IconFactory_H
#include "IconFactory.h"
#endif

#ifndef IconInfo_H
#include "IconInfo.h"
#endif

#ifndef Dropping_H
#include "Dropping.h"
#endif

#ifndef FileSelection_H
#include "FileSelection.h"
#endif

#ifndef XPalette_H
#include "XPalette.h"
#endif


FolderViewer::FolderViewer(Folder* f):
	folder_(f),
	count_(0)
{
}

FolderViewer::~FolderViewer()
{
	folder_->removeObserver(this);		
}

void FolderViewer::install(Widget w)
{
	DragWindow::install(w);
	redraw();
}

void FolderViewer::redraw()
{
	removeAllIcons();

	folder_->removeObserver(this);
	folder_->addObserver(this);		

	int n = 0;
	while(count_ == 0 && fill(n++))
		;
}


void FolderViewer::arrived(IconObject* o)
{     
	if(accept(o)) 
	{
		int x = 0; int y = 0;
		where(o,x,y);

		addIcon(o,x,y);

		count_++;
	}
}

void FolderViewer::where(IconObject*,int&,int&)
{
}

void FolderViewer::opened(IconObject* o)
{     
	openIcon(o);
}

void FolderViewer::closed(IconObject* o)
{     
	closeIcon(o);
}

void FolderViewer::gone(IconObject* o)
{	    
	removeIcon(o);
	count_--;

	int n = 0;
	while(count_ == 0 && fill(n++))
		;
}

void FolderViewer::position(IconObject* o,int x,int y)
{
    Icon i = DragFindIconByData(widget_,o);
	if(i != 0) DragSetPositionIcon(widget_,i,x,y);
}

void FolderViewer::renamed(IconObject* o)
{	      
	refreshIcon(o);
}

bool FolderViewer::clone()
{
	return true;
}

void FolderViewer::drop(Dropping& drop)
{
    IconObject *o = drop.object(*this);
	if(!accept(o)) return;

	if(clone()) // Drop copies icon
	{
		o = o->clone(folder_);
		position(o,drop.x(),drop.y());
		return;
	}


	// NOTE x,y are not the mouse x,y, but the top corber of the icon
	IconObject *x = objectAt(drop.x()+16,drop.y()+16);

	if(drop.copy())
	{
		o = o->clone(folder_);
		position(o,drop.x(),drop.y());
	}
	else if(folder_->adopt(o))
		position(o,drop.x(),drop.y());

	if(x) x->drop(o);

}

bool FolderViewer::accept(IconObject* o)
{
	return o->visible();
}

void FolderViewer::doubleClick(IconObject* o)
{
	o->edit();
}

void FolderViewer::rename(IconObject* o,const string& new_name)
{
	o->rename(new_name);
}

bool FolderViewer::fill(int)
{
	return false;
}

IconObject* FolderViewer::newIcon()
{
	return IconSelection::make(folder_,menu_x_,menu_y_);
}

IconObject* FolderViewer::newLink()
{
	if(FileSelection::ask("Select a file of a directory:"))
	{
		Path result = FileSelection::file();
		string name = folder_->uniqueName(result.name());
		Path path   = folder_->path().add(name);

		path.symlink(result);		
		
		//The dot file for a link should not be created in the 
		//link target's folder. By commenting out the line below we can prevent it!
		//path.dot().symlink(result.dot());		

		folder_->scan();

		return folder_->find(name);

	}
	return 0;
}

void FolderViewer::waiting(IconObject* o)
{
	color(o,"orange");
}

void FolderViewer::error(IconObject* o)
{
	color(o,"red");
}

void FolderViewer::modified(IconObject* o)
{
	color(o,"black");
}

void FolderViewer::ready(IconObject* o)
{
	color(o,"green3");
}

void FolderViewer::color(IconObject* o, const char* name)
{
	Icon i = DragFindIconByData(widget_,o);
	if(i != 0) DragSetIconColor(widget_,i,XPalette::pixel(name));
}

void FolderViewer::highlight(IconObject* o)
{
	Icon i = DragFindIconByData(widget_,o);
	if(i != 0) DragBlinkIcon(widget_,i);
}
