/* ddsC.c
   Generated by gSOAP 2.7.9 from DigiDocService.h
   Copyright(C) 2000-2006, Robert van Engelen, Genivia Inc. All Rights Reserved.
   This part of the software is released under one of the following licenses:
   GPL, the gSOAP public license, or Genivia's license for commercial use.
*/

#include "ddsH.h"
#ifdef __cplusplus
extern "C" {
#endif

SOAP_SOURCE_STAMP("@(#) ddsC.c ver 2.7.9 2007-03-12 16:55:20 GMT")


#ifndef WITH_NOGLOBAL

SOAP_FMAC3 void SOAP_FMAC4 soap_serializeheader(struct soap *soap)
{
	if (soap->header)
		soap_serialize_SOAP_ENV__Header(soap, soap->header);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_putheader(struct soap *soap)
{
	if (soap->header)
	{	soap->part = SOAP_IN_HEADER;
		soap_out_SOAP_ENV__Header(soap, "SOAP-ENV:Header", 0, soap->header, NULL);
		soap->part = SOAP_END_HEADER;
	}
	return SOAP_OK;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_getheader(struct soap *soap)
{
	soap->part = SOAP_IN_HEADER;
	soap->header = soap_in_SOAP_ENV__Header(soap, "SOAP-ENV:Header", NULL, NULL);
	soap->part = SOAP_END_HEADER;
	return soap->header == NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_fault(struct soap *soap)
{
	if (!soap->fault)
	{	soap->fault = (struct SOAP_ENV__Fault*)soap_malloc(soap, sizeof(struct SOAP_ENV__Fault));
		soap_default_SOAP_ENV__Fault(soap, soap->fault);
	}
	if (soap->version == 2 && !soap->fault->SOAP_ENV__Code)
	{	soap->fault->SOAP_ENV__Code = (struct SOAP_ENV__Code*)soap_malloc(soap, sizeof(struct SOAP_ENV__Code));
		soap_default_SOAP_ENV__Code(soap, soap->fault->SOAP_ENV__Code);
	}
	if (soap->version == 2 && !soap->fault->SOAP_ENV__Reason)
	{	soap->fault->SOAP_ENV__Reason = (struct SOAP_ENV__Reason*)soap_malloc(soap, sizeof(struct SOAP_ENV__Reason));
		soap_default_SOAP_ENV__Reason(soap, soap->fault->SOAP_ENV__Reason);
	}
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serializefault(struct soap *soap)
{
	if (soap->fault)
		soap_serialize_SOAP_ENV__Fault(soap, soap->fault);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_putfault(struct soap *soap)
{
	if (soap->fault)
		return soap_put_SOAP_ENV__Fault(soap, soap->fault, "SOAP-ENV:Fault", NULL);
	return SOAP_OK;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_getfault(struct soap *soap)
{
	return (soap->fault = soap_get_SOAP_ENV__Fault(soap, NULL, "SOAP-ENV:Fault", NULL)) == NULL;
}

SOAP_FMAC3 const char ** SOAP_FMAC4 soap_faultcode(struct soap *soap)
{
	soap_fault(soap);
	if (soap->version == 2)
		return (const char**)&soap->fault->SOAP_ENV__Code->SOAP_ENV__Value;
	return (const char**)&soap->fault->faultcode;
}

SOAP_FMAC3 const char ** SOAP_FMAC4 soap_faultsubcode(struct soap *soap)
{
	soap_fault(soap);
	if (soap->version == 2)
	{	if (!soap->fault->SOAP_ENV__Code->SOAP_ENV__Subcode)
		{	soap->fault->SOAP_ENV__Code->SOAP_ENV__Subcode = (struct SOAP_ENV__Code*)soap_malloc(soap, sizeof(struct SOAP_ENV__Code));
			soap_default_SOAP_ENV__Code(soap, soap->fault->SOAP_ENV__Code->SOAP_ENV__Subcode);
		}
		return (const char**)&soap->fault->SOAP_ENV__Code->SOAP_ENV__Subcode->SOAP_ENV__Value;
	}
	return (const char**)&soap->fault->faultcode;
}

SOAP_FMAC3 const char ** SOAP_FMAC4 soap_faultstring(struct soap *soap)
{
	soap_fault(soap);
	if (soap->version == 2)
		return (const char**)&soap->fault->SOAP_ENV__Reason->SOAP_ENV__Text;
	return (const char**)&soap->fault->faultstring;
}

SOAP_FMAC3 const char ** SOAP_FMAC4 soap_faultdetail(struct soap *soap)
{
	soap_fault(soap);
	if (soap->version == 1)
	{	if (!soap->fault->detail)
		{	soap->fault->detail = (struct SOAP_ENV__Detail*)soap_malloc(soap, sizeof(struct SOAP_ENV__Detail));
			soap_default_SOAP_ENV__Detail(soap, soap->fault->detail);
		}
		return (const char**)&soap->fault->detail->__any;
	}
	if (!soap->fault->SOAP_ENV__Detail)
	{	soap->fault->SOAP_ENV__Detail = (struct SOAP_ENV__Detail*)soap_malloc(soap, sizeof(struct SOAP_ENV__Detail));
		soap_default_SOAP_ENV__Detail(soap, soap->fault->SOAP_ENV__Detail);
	}
	return (const char**)&soap->fault->SOAP_ENV__Detail->__any;
}

#endif

#ifndef WITH_NOIDREF
SOAP_FMAC3 int SOAP_FMAC4 soap_getindependent(struct soap *soap)
{
	int t;
	for (;;)
		if (!soap_getelement(soap, &t))
			if (soap->error || soap_ignore_element(soap))
				break;
	if (soap->error == SOAP_NO_TAG || soap->error == SOAP_EOF)
		soap->error = SOAP_OK;
	return soap->error;
}
#endif

#ifndef WITH_NOIDREF
SOAP_FMAC3 void * SOAP_FMAC4 soap_getelement(struct soap *soap, int *type)
{
	if (soap_peek_element(soap))
		return NULL;
	if (!*soap->id || !(*type = soap_lookup_type(soap, soap->id)))
		*type = soap_lookup_type(soap, soap->href);
	switch (*type)
	{
	case SOAP_TYPE_byte:
		return soap_in_byte(soap, NULL, NULL, "xsd:byte");
	case SOAP_TYPE_int:
		return soap_in_int(soap, NULL, NULL, "xsd:int");
	case SOAP_TYPE_xsd__int:
		return soap_in_xsd__int(soap, NULL, NULL, "xsd:int");
	case SOAP_TYPE_long:
		return soap_in_long(soap, NULL, NULL, "xsd:long");
	case SOAP_TYPE_LONG64:
		return soap_in_LONG64(soap, NULL, NULL, "xsd:long");
	case SOAP_TYPE_xsd__float:
		return soap_in_xsd__float(soap, NULL, NULL, "xsd:float");
	case SOAP_TYPE_float:
		return soap_in_float(soap, NULL, NULL, "xsd:float");
	case SOAP_TYPE_unsignedByte:
		return soap_in_unsignedByte(soap, NULL, NULL, "xsd:unsignedByte");
	case SOAP_TYPE_unsignedInt:
		return soap_in_unsignedInt(soap, NULL, NULL, "xsd:unsignedInt");
	case SOAP_TYPE_xsd__positiveInteger:
		return soap_in_xsd__positiveInteger(soap, NULL, NULL, "xsd:positiveInteger");
	case SOAP_TYPE_unsignedLONG64:
		return soap_in_unsignedLONG64(soap, NULL, NULL, "xsd:unsignedLong");
	case SOAP_TYPE_xsd__boolean:
		return soap_in_xsd__boolean(soap, NULL, NULL, "xsd:boolean");
	case SOAP_TYPE_bool:
		return soap_in_bool(soap, NULL, NULL, "xsd:boolean");
	case SOAP_TYPE_mss__MSS_USCORESignatureDummy:
		return soap_in_mss__MSS_USCORESignatureDummy(soap, NULL, NULL, "mss:MSS_SignatureDummy");
	case SOAP_TYPE_mss_DummyResp:
		return soap_in_mss_DummyResp(soap, NULL, NULL, "mss-DummyResp");
	case SOAP_TYPE_d__GetMobileCreateSignatureStatus:
		return soap_in_d__GetMobileCreateSignatureStatus(soap, NULL, NULL, "d:GetMobileCreateSignatureStatus");
	case SOAP_TYPE_d__GetMobileCreateSignatureStatusResponse:
		return soap_in_d__GetMobileCreateSignatureStatusResponse(soap, NULL, NULL, "d:GetMobileCreateSignatureStatusResponse");
	case SOAP_TYPE_d__MobileCreateSignature:
		return soap_in_d__MobileCreateSignature(soap, NULL, NULL, "d:MobileCreateSignature");
	case SOAP_TYPE_d__MobileCreateSignatureResponse:
		return soap_in_d__MobileCreateSignatureResponse(soap, NULL, NULL, "d:MobileCreateSignatureResponse");
	case SOAP_TYPE_d__DataFileDigestList:
		return soap_in_d__DataFileDigestList(soap, NULL, NULL, "d:DataFileDigestList");
	case SOAP_TYPE_d__DataFileDigest:
		return soap_in_d__DataFileDigest(soap, NULL, NULL, "d:DataFileDigest");
	case SOAP_TYPE_d__GetMobileAuthenticateStatus:
		return soap_in_d__GetMobileAuthenticateStatus(soap, NULL, NULL, "d:GetMobileAuthenticateStatus");
	case SOAP_TYPE_d__GetMobileAuthenticateStatusResponse:
		return soap_in_d__GetMobileAuthenticateStatusResponse(soap, NULL, NULL, "d:GetMobileAuthenticateStatusResponse");
	case SOAP_TYPE_d__MobileAuthenticate:
		return soap_in_d__MobileAuthenticate(soap, NULL, NULL, "d:MobileAuthenticate");
	case SOAP_TYPE_d__MobileAuthenticateResponse:
		return soap_in_d__MobileAuthenticateResponse(soap, NULL, NULL, "d:MobileAuthenticateResponse");
	case SOAP_TYPE_d__GetStatusInfo:
		return soap_in_d__GetStatusInfo(soap, NULL, NULL, "d:GetStatusInfo");
	case SOAP_TYPE_d__GetStatusInfoResponse:
		return soap_in_d__GetStatusInfoResponse(soap, NULL, NULL, "d:GetStatusInfoResponse");
	case SOAP_TYPE_d__MobileSign:
		return soap_in_d__MobileSign(soap, NULL, NULL, "d:MobileSign");
	case SOAP_TYPE_d__MobileSignResponse:
		return soap_in_d__MobileSignResponse(soap, NULL, NULL, "d:MobileSignResponse");
	case SOAP_TYPE_d__GetVersion:
		return soap_in_d__GetVersion(soap, NULL, NULL, "d:GetVersion");
	case SOAP_TYPE_d__GetVersionResponse:
		return soap_in_d__GetVersionResponse(soap, NULL, NULL, "d:GetVersionResponse");
	case SOAP_TYPE_d__RemoveSignature:
		return soap_in_d__RemoveSignature(soap, NULL, NULL, "d:RemoveSignature");
	case SOAP_TYPE_d__RemoveSignatureResponse:
		return soap_in_d__RemoveSignatureResponse(soap, NULL, NULL, "d:RemoveSignatureResponse");
	case SOAP_TYPE_d__FinalizeSignature:
		return soap_in_d__FinalizeSignature(soap, NULL, NULL, "d:FinalizeSignature");
	case SOAP_TYPE_d__FinalizeSignatureResponse:
		return soap_in_d__FinalizeSignatureResponse(soap, NULL, NULL, "d:FinalizeSignatureResponse");
	case SOAP_TYPE_d__PrepareSignature:
		return soap_in_d__PrepareSignature(soap, NULL, NULL, "d:PrepareSignature");
	case SOAP_TYPE_d__PrepareSignatureResponse:
		return soap_in_d__PrepareSignatureResponse(soap, NULL, NULL, "d:PrepareSignatureResponse");
	case SOAP_TYPE_d__GetSignatureModules:
		return soap_in_d__GetSignatureModules(soap, NULL, NULL, "d:GetSignatureModules");
	case SOAP_TYPE_d__GetSignatureModulesResponse:
		return soap_in_d__GetSignatureModulesResponse(soap, NULL, NULL, "d:GetSignatureModulesResponse");
	case SOAP_TYPE_d__SignatureModulesArray:
		return soap_in_d__SignatureModulesArray(soap, NULL, NULL, "d:SignatureModulesArray");
	case SOAP_TYPE_d__SignatureModule:
		return soap_in_d__SignatureModule(soap, NULL, NULL, "d:SignatureModule");
	case SOAP_TYPE_d__GetCRL:
		return soap_in_d__GetCRL(soap, NULL, NULL, "d:GetCRL");
	case SOAP_TYPE_d__GetCRLResponse:
		return soap_in_d__GetCRLResponse(soap, NULL, NULL, "d:GetCRLResponse");
	case SOAP_TYPE_d__GetTimestamp:
		return soap_in_d__GetTimestamp(soap, NULL, NULL, "d:GetTimestamp");
	case SOAP_TYPE_d__GetTimestampResponse:
		return soap_in_d__GetTimestampResponse(soap, NULL, NULL, "d:GetTimestampResponse");
	case SOAP_TYPE_d__GetTSACertificate:
		return soap_in_d__GetTSACertificate(soap, NULL, NULL, "d:GetTSACertificate");
	case SOAP_TYPE_d__GetTSACertificateResponse:
		return soap_in_d__GetTSACertificateResponse(soap, NULL, NULL, "d:GetTSACertificateResponse");
	case SOAP_TYPE_d__GetNotary:
		return soap_in_d__GetNotary(soap, NULL, NULL, "d:GetNotary");
	case SOAP_TYPE_d__GetNotaryResponse:
		return soap_in_d__GetNotaryResponse(soap, NULL, NULL, "d:GetNotaryResponse");
	case SOAP_TYPE_d__GetNotarysCertificate:
		return soap_in_d__GetNotarysCertificate(soap, NULL, NULL, "d:GetNotarysCertificate");
	case SOAP_TYPE_d__GetNotarysCertificateResponse:
		return soap_in_d__GetNotarysCertificateResponse(soap, NULL, NULL, "d:GetNotarysCertificateResponse");
	case SOAP_TYPE_d__GetSignersCertificate:
		return soap_in_d__GetSignersCertificate(soap, NULL, NULL, "d:GetSignersCertificate");
	case SOAP_TYPE_d__GetSignersCertificateResponse:
		return soap_in_d__GetSignersCertificateResponse(soap, NULL, NULL, "d:GetSignersCertificateResponse");
	case SOAP_TYPE_d__GetDataFile:
		return soap_in_d__GetDataFile(soap, NULL, NULL, "d:GetDataFile");
	case SOAP_TYPE_d__GetDataFileResponse:
		return soap_in_d__GetDataFileResponse(soap, NULL, NULL, "d:GetDataFileResponse");
	case SOAP_TYPE_d__GetSignedDocInfo:
		return soap_in_d__GetSignedDocInfo(soap, NULL, NULL, "d:GetSignedDocInfo");
	case SOAP_TYPE_d__GetSignedDocInfoResponse:
		return soap_in_d__GetSignedDocInfoResponse(soap, NULL, NULL, "d:GetSignedDocInfoResponse");
	case SOAP_TYPE_d__GetSignedDoc:
		return soap_in_d__GetSignedDoc(soap, NULL, NULL, "d:GetSignedDoc");
	case SOAP_TYPE_d__GetSignedDocResponse:
		return soap_in_d__GetSignedDocResponse(soap, NULL, NULL, "d:GetSignedDocResponse");
	case SOAP_TYPE_d__RemoveDataFile:
		return soap_in_d__RemoveDataFile(soap, NULL, NULL, "d:RemoveDataFile");
	case SOAP_TYPE_d__RemoveDataFileResponse:
		return soap_in_d__RemoveDataFileResponse(soap, NULL, NULL, "d:RemoveDataFileResponse");
	case SOAP_TYPE_d__AddDataFile:
		return soap_in_d__AddDataFile(soap, NULL, NULL, "d:AddDataFile");
	case SOAP_TYPE_d__AddDataFileResponse:
		return soap_in_d__AddDataFileResponse(soap, NULL, NULL, "d:AddDataFileResponse");
	case SOAP_TYPE_d__CreateSignedDoc:
		return soap_in_d__CreateSignedDoc(soap, NULL, NULL, "d:CreateSignedDoc");
	case SOAP_TYPE_d__CreateSignedDocResponse:
		return soap_in_d__CreateSignedDocResponse(soap, NULL, NULL, "d:CreateSignedDocResponse");
	case SOAP_TYPE_d__CloseSession:
		return soap_in_d__CloseSession(soap, NULL, NULL, "d:CloseSession");
	case SOAP_TYPE_d__CloseSessionResponse:
		return soap_in_d__CloseSessionResponse(soap, NULL, NULL, "d:CloseSessionResponse");
	case SOAP_TYPE_d__StartSession:
		return soap_in_d__StartSession(soap, NULL, NULL, "d:StartSession");
	case SOAP_TYPE_d__StartSessionResponse:
		return soap_in_d__StartSessionResponse(soap, NULL, NULL, "d:StartSessionResponse");
	case SOAP_TYPE_d__DataFileData:
		return soap_in_d__DataFileData(soap, NULL, NULL, "d:DataFileData");
	case SOAP_TYPE_d__SignedDocInfo:
		return soap_in_d__SignedDocInfo(soap, NULL, NULL, "d:SignedDocInfo");
	case SOAP_TYPE_d__SignatureInfo:
		return soap_in_d__SignatureInfo(soap, NULL, NULL, "d:SignatureInfo");
	case SOAP_TYPE_d__Error:
		return soap_in_d__Error(soap, NULL, NULL, "d:Error");
	case SOAP_TYPE_d__CRLInfo:
		return soap_in_d__CRLInfo(soap, NULL, NULL, "d:CRLInfo");
	case SOAP_TYPE_d__RevokedInfo:
		return soap_in_d__RevokedInfo(soap, NULL, NULL, "d:RevokedInfo");
	case SOAP_TYPE_d__TstInfo:
		return soap_in_d__TstInfo(soap, NULL, NULL, "d:TstInfo");
	case SOAP_TYPE_d__ConfirmationInfo:
		return soap_in_d__ConfirmationInfo(soap, NULL, NULL, "d:ConfirmationInfo");
	case SOAP_TYPE_d__SignerInfo:
		return soap_in_d__SignerInfo(soap, NULL, NULL, "d:SignerInfo");
	case SOAP_TYPE_d__CertificateInfo:
		return soap_in_d__CertificateInfo(soap, NULL, NULL, "d:CertificateInfo");
	case SOAP_TYPE_d__CertificatePolicy:
		return soap_in_d__CertificatePolicy(soap, NULL, NULL, "d:CertificatePolicy");
	case SOAP_TYPE_d__SignatureProductionPlace:
		return soap_in_d__SignatureProductionPlace(soap, NULL, NULL, "d:SignatureProductionPlace");
	case SOAP_TYPE_d__SignerRole:
		return soap_in_d__SignerRole(soap, NULL, NULL, "d:SignerRole");
	case SOAP_TYPE_d__DataFileInfo:
		return soap_in_d__DataFileInfo(soap, NULL, NULL, "d:DataFileInfo");
	case SOAP_TYPE_d__DataFileAttribute:
		return soap_in_d__DataFileAttribute(soap, NULL, NULL, "d:DataFileAttribute");
	case SOAP_TYPE_xsd__hexBinary:
		return soap_in_xsd__hexBinary(soap, NULL, NULL, "xsd:hexBinary");
	case SOAP_TYPE_PointerTomss_DummyResp:
		return soap_in_PointerTomss_DummyResp(soap, NULL, NULL, "mss-DummyResp");
	case SOAP_TYPE_PointerTod__GetMobileCreateSignatureStatusResponse:
		return soap_in_PointerTod__GetMobileCreateSignatureStatusResponse(soap, NULL, NULL, "d:GetMobileCreateSignatureStatusResponse");
	case SOAP_TYPE_PointerTod__MobileCreateSignatureResponse:
		return soap_in_PointerTod__MobileCreateSignatureResponse(soap, NULL, NULL, "d:MobileCreateSignatureResponse");
	case SOAP_TYPE_PointerTod__DataFileDigestList:
		return soap_in_PointerTod__DataFileDigestList(soap, NULL, NULL, "d:DataFileDigestList");
	case SOAP_TYPE_PointerTod__DataFileDigest:
		return soap_in_PointerTod__DataFileDigest(soap, NULL, NULL, "d:DataFileDigest");
	case SOAP_TYPE_PointerTod__GetMobileAuthenticateStatusResponse:
		return soap_in_PointerTod__GetMobileAuthenticateStatusResponse(soap, NULL, NULL, "d:GetMobileAuthenticateStatusResponse");
	case SOAP_TYPE_PointerTod__MobileAuthenticateResponse:
		return soap_in_PointerTod__MobileAuthenticateResponse(soap, NULL, NULL, "d:MobileAuthenticateResponse");
	case SOAP_TYPE_PointerTod__GetStatusInfoResponse:
		return soap_in_PointerTod__GetStatusInfoResponse(soap, NULL, NULL, "d:GetStatusInfoResponse");
	case SOAP_TYPE_PointerTod__MobileSignResponse:
		return soap_in_PointerTod__MobileSignResponse(soap, NULL, NULL, "d:MobileSignResponse");
	case SOAP_TYPE_PointerTod__GetVersionResponse:
		return soap_in_PointerTod__GetVersionResponse(soap, NULL, NULL, "d:GetVersionResponse");
	case SOAP_TYPE_PointerTod__RemoveSignatureResponse:
		return soap_in_PointerTod__RemoveSignatureResponse(soap, NULL, NULL, "d:RemoveSignatureResponse");
	case SOAP_TYPE_PointerTod__FinalizeSignatureResponse:
		return soap_in_PointerTod__FinalizeSignatureResponse(soap, NULL, NULL, "d:FinalizeSignatureResponse");
	case SOAP_TYPE_PointerTod__PrepareSignatureResponse:
		return soap_in_PointerTod__PrepareSignatureResponse(soap, NULL, NULL, "d:PrepareSignatureResponse");
	case SOAP_TYPE_PointerTod__GetSignatureModulesResponse:
		return soap_in_PointerTod__GetSignatureModulesResponse(soap, NULL, NULL, "d:GetSignatureModulesResponse");
	case SOAP_TYPE_PointerTod__SignatureModulesArray:
		return soap_in_PointerTod__SignatureModulesArray(soap, NULL, NULL, "d:SignatureModulesArray");
	case SOAP_TYPE_PointerTod__SignatureModule:
		return soap_in_PointerTod__SignatureModule(soap, NULL, NULL, "d:SignatureModule");
	case SOAP_TYPE_PointerTod__GetCRLResponse:
		return soap_in_PointerTod__GetCRLResponse(soap, NULL, NULL, "d:GetCRLResponse");
	case SOAP_TYPE_PointerTod__GetTimestampResponse:
		return soap_in_PointerTod__GetTimestampResponse(soap, NULL, NULL, "d:GetTimestampResponse");
	case SOAP_TYPE_PointerTod__GetTSACertificateResponse:
		return soap_in_PointerTod__GetTSACertificateResponse(soap, NULL, NULL, "d:GetTSACertificateResponse");
	case SOAP_TYPE_PointerTod__GetNotaryResponse:
		return soap_in_PointerTod__GetNotaryResponse(soap, NULL, NULL, "d:GetNotaryResponse");
	case SOAP_TYPE_PointerTod__GetNotarysCertificateResponse:
		return soap_in_PointerTod__GetNotarysCertificateResponse(soap, NULL, NULL, "d:GetNotarysCertificateResponse");
	case SOAP_TYPE_PointerTod__GetSignersCertificateResponse:
		return soap_in_PointerTod__GetSignersCertificateResponse(soap, NULL, NULL, "d:GetSignersCertificateResponse");
	case SOAP_TYPE_PointerTod__GetDataFileResponse:
		return soap_in_PointerTod__GetDataFileResponse(soap, NULL, NULL, "d:GetDataFileResponse");
	case SOAP_TYPE_PointerTod__GetSignedDocInfoResponse:
		return soap_in_PointerTod__GetSignedDocInfoResponse(soap, NULL, NULL, "d:GetSignedDocInfoResponse");
	case SOAP_TYPE_PointerTod__GetSignedDocResponse:
		return soap_in_PointerTod__GetSignedDocResponse(soap, NULL, NULL, "d:GetSignedDocResponse");
	case SOAP_TYPE_PointerTod__RemoveDataFileResponse:
		return soap_in_PointerTod__RemoveDataFileResponse(soap, NULL, NULL, "d:RemoveDataFileResponse");
	case SOAP_TYPE_PointerTod__AddDataFileResponse:
		return soap_in_PointerTod__AddDataFileResponse(soap, NULL, NULL, "d:AddDataFileResponse");
	case SOAP_TYPE_PointerTod__CreateSignedDocResponse:
		return soap_in_PointerTod__CreateSignedDocResponse(soap, NULL, NULL, "d:CreateSignedDocResponse");
	case SOAP_TYPE_PointerTod__CloseSessionResponse:
		return soap_in_PointerTod__CloseSessionResponse(soap, NULL, NULL, "d:CloseSessionResponse");
	case SOAP_TYPE_PointerTod__StartSessionResponse:
		return soap_in_PointerTod__StartSessionResponse(soap, NULL, NULL, "d:StartSessionResponse");
	case SOAP_TYPE_PointerTod__DataFileData:
		return soap_in_PointerTod__DataFileData(soap, NULL, NULL, "d:DataFileData");
	case SOAP_TYPE_PointerTod__SignedDocInfo:
		return soap_in_PointerTod__SignedDocInfo(soap, NULL, NULL, "d:SignedDocInfo");
	case SOAP_TYPE_PointerTod__SignatureInfo:
		return soap_in_PointerTod__SignatureInfo(soap, NULL, NULL, "d:SignatureInfo");
	case SOAP_TYPE_PointerTod__DataFileInfo:
		return soap_in_PointerTod__DataFileInfo(soap, NULL, NULL, "d:DataFileInfo");
	case SOAP_TYPE_PointerTod__CRLInfo:
		return soap_in_PointerTod__CRLInfo(soap, NULL, NULL, "d:CRLInfo");
	case SOAP_TYPE_PointerTod__TstInfo:
		return soap_in_PointerTod__TstInfo(soap, NULL, NULL, "d:TstInfo");
	case SOAP_TYPE_PointerTod__ConfirmationInfo:
		return soap_in_PointerTod__ConfirmationInfo(soap, NULL, NULL, "d:ConfirmationInfo");
	case SOAP_TYPE_PointerTod__SignerInfo:
		return soap_in_PointerTod__SignerInfo(soap, NULL, NULL, "d:SignerInfo");
	case SOAP_TYPE_PointerTod__SignatureProductionPlace:
		return soap_in_PointerTod__SignatureProductionPlace(soap, NULL, NULL, "d:SignatureProductionPlace");
	case SOAP_TYPE_PointerTod__SignerRole:
		return soap_in_PointerTod__SignerRole(soap, NULL, NULL, "d:SignerRole");
	case SOAP_TYPE_PointerTod__Error:
		return soap_in_PointerTod__Error(soap, NULL, NULL, "d:Error");
	case SOAP_TYPE_PointerTod__RevokedInfo:
		return soap_in_PointerTod__RevokedInfo(soap, NULL, NULL, "d:RevokedInfo");
	case SOAP_TYPE_PointerTod__CertificateInfo:
		return soap_in_PointerTod__CertificateInfo(soap, NULL, NULL, "d:CertificateInfo");
	case SOAP_TYPE_PointerTod__CertificatePolicy:
		return soap_in_PointerTod__CertificatePolicy(soap, NULL, NULL, "d:CertificatePolicy");
	case SOAP_TYPE_PointerTod__DataFileAttribute:
		return soap_in_PointerTod__DataFileAttribute(soap, NULL, NULL, "d:DataFileAttribute");
	case SOAP_TYPE_PointerTounsignedByte:
		return soap_in_PointerTounsignedByte(soap, NULL, NULL, "xsd:unsignedByte");
	case SOAP_TYPE_xsd__dateTime:
	{	char **s;
		s = soap_in_xsd__dateTime(soap, NULL, NULL, "xsd:dateTime");
		return s ? *s : NULL;
	}
	case SOAP_TYPE_xsd__anyURI:
	{	char **s;
		s = soap_in_xsd__anyURI(soap, NULL, NULL, "xsd:anyURI");
		return s ? *s : NULL;
	}
	case SOAP_TYPE_xsd__string:
	{	char **s;
		s = soap_in_xsd__string(soap, NULL, NULL, "xsd:string");
		return s ? *s : NULL;
	}
	case SOAP_TYPE_string:
	{	char **s;
		s = soap_in_string(soap, NULL, NULL, "xsd:string");
		return s ? *s : NULL;
	}
	default:
	{	const char *t = soap->type;
		if (!*t)
			t = soap->tag;
		if (!soap_match_tag(soap, t, "xsd:byte"))
		{	*type = SOAP_TYPE_byte;
			return soap_in_byte(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "xsd:int"))
		{	*type = SOAP_TYPE_int;
			return soap_in_int(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "xsd:int"))
		{	*type = SOAP_TYPE_xsd__int;
			return soap_in_xsd__int(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "xsd:long"))
		{	*type = SOAP_TYPE_long;
			return soap_in_long(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "xsd:long"))
		{	*type = SOAP_TYPE_LONG64;
			return soap_in_LONG64(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "xsd:float"))
		{	*type = SOAP_TYPE_xsd__float;
			return soap_in_xsd__float(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "xsd:float"))
		{	*type = SOAP_TYPE_float;
			return soap_in_float(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "xsd:unsignedByte"))
		{	*type = SOAP_TYPE_unsignedByte;
			return soap_in_unsignedByte(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "xsd:unsignedInt"))
		{	*type = SOAP_TYPE_unsignedInt;
			return soap_in_unsignedInt(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "xsd:positiveInteger"))
		{	*type = SOAP_TYPE_xsd__positiveInteger;
			return soap_in_xsd__positiveInteger(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "xsd:unsignedLong"))
		{	*type = SOAP_TYPE_unsignedLONG64;
			return soap_in_unsignedLONG64(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "xsd:boolean"))
		{	*type = SOAP_TYPE_xsd__boolean;
			return soap_in_xsd__boolean(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "xsd:boolean"))
		{	*type = SOAP_TYPE_bool;
			return soap_in_bool(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "mss:MSS_SignatureDummy"))
		{	*type = SOAP_TYPE_mss__MSS_USCORESignatureDummy;
			return soap_in_mss__MSS_USCORESignatureDummy(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "mss-DummyResp"))
		{	*type = SOAP_TYPE_mss_DummyResp;
			return soap_in_mss_DummyResp(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "d:GetMobileCreateSignatureStatus"))
		{	*type = SOAP_TYPE_d__GetMobileCreateSignatureStatus;
			return soap_in_d__GetMobileCreateSignatureStatus(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "d:GetMobileCreateSignatureStatusResponse"))
		{	*type = SOAP_TYPE_d__GetMobileCreateSignatureStatusResponse;
			return soap_in_d__GetMobileCreateSignatureStatusResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "d:MobileCreateSignature"))
		{	*type = SOAP_TYPE_d__MobileCreateSignature;
			return soap_in_d__MobileCreateSignature(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "d:MobileCreateSignatureResponse"))
		{	*type = SOAP_TYPE_d__MobileCreateSignatureResponse;
			return soap_in_d__MobileCreateSignatureResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "d:DataFileDigestList"))
		{	*type = SOAP_TYPE_d__DataFileDigestList;
			return soap_in_d__DataFileDigestList(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "d:DataFileDigest"))
		{	*type = SOAP_TYPE_d__DataFileDigest;
			return soap_in_d__DataFileDigest(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "d:GetMobileAuthenticateStatus"))
		{	*type = SOAP_TYPE_d__GetMobileAuthenticateStatus;
			return soap_in_d__GetMobileAuthenticateStatus(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "d:GetMobileAuthenticateStatusResponse"))
		{	*type = SOAP_TYPE_d__GetMobileAuthenticateStatusResponse;
			return soap_in_d__GetMobileAuthenticateStatusResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "d:MobileAuthenticate"))
		{	*type = SOAP_TYPE_d__MobileAuthenticate;
			return soap_in_d__MobileAuthenticate(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "d:MobileAuthenticateResponse"))
		{	*type = SOAP_TYPE_d__MobileAuthenticateResponse;
			return soap_in_d__MobileAuthenticateResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "d:GetStatusInfo"))
		{	*type = SOAP_TYPE_d__GetStatusInfo;
			return soap_in_d__GetStatusInfo(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "d:GetStatusInfoResponse"))
		{	*type = SOAP_TYPE_d__GetStatusInfoResponse;
			return soap_in_d__GetStatusInfoResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "d:MobileSign"))
		{	*type = SOAP_TYPE_d__MobileSign;
			return soap_in_d__MobileSign(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "d:MobileSignResponse"))
		{	*type = SOAP_TYPE_d__MobileSignResponse;
			return soap_in_d__MobileSignResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "d:GetVersion"))
		{	*type = SOAP_TYPE_d__GetVersion;
			return soap_in_d__GetVersion(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "d:GetVersionResponse"))
		{	*type = SOAP_TYPE_d__GetVersionResponse;
			return soap_in_d__GetVersionResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "d:RemoveSignature"))
		{	*type = SOAP_TYPE_d__RemoveSignature;
			return soap_in_d__RemoveSignature(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "d:RemoveSignatureResponse"))
		{	*type = SOAP_TYPE_d__RemoveSignatureResponse;
			return soap_in_d__RemoveSignatureResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "d:FinalizeSignature"))
		{	*type = SOAP_TYPE_d__FinalizeSignature;
			return soap_in_d__FinalizeSignature(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "d:FinalizeSignatureResponse"))
		{	*type = SOAP_TYPE_d__FinalizeSignatureResponse;
			return soap_in_d__FinalizeSignatureResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "d:PrepareSignature"))
		{	*type = SOAP_TYPE_d__PrepareSignature;
			return soap_in_d__PrepareSignature(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "d:PrepareSignatureResponse"))
		{	*type = SOAP_TYPE_d__PrepareSignatureResponse;
			return soap_in_d__PrepareSignatureResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "d:GetSignatureModules"))
		{	*type = SOAP_TYPE_d__GetSignatureModules;
			return soap_in_d__GetSignatureModules(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "d:GetSignatureModulesResponse"))
		{	*type = SOAP_TYPE_d__GetSignatureModulesResponse;
			return soap_in_d__GetSignatureModulesResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "d:SignatureModulesArray"))
		{	*type = SOAP_TYPE_d__SignatureModulesArray;
			return soap_in_d__SignatureModulesArray(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "d:SignatureModule"))
		{	*type = SOAP_TYPE_d__SignatureModule;
			return soap_in_d__SignatureModule(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "d:GetCRL"))
		{	*type = SOAP_TYPE_d__GetCRL;
			return soap_in_d__GetCRL(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "d:GetCRLResponse"))
		{	*type = SOAP_TYPE_d__GetCRLResponse;
			return soap_in_d__GetCRLResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "d:GetTimestamp"))
		{	*type = SOAP_TYPE_d__GetTimestamp;
			return soap_in_d__GetTimestamp(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "d:GetTimestampResponse"))
		{	*type = SOAP_TYPE_d__GetTimestampResponse;
			return soap_in_d__GetTimestampResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "d:GetTSACertificate"))
		{	*type = SOAP_TYPE_d__GetTSACertificate;
			return soap_in_d__GetTSACertificate(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "d:GetTSACertificateResponse"))
		{	*type = SOAP_TYPE_d__GetTSACertificateResponse;
			return soap_in_d__GetTSACertificateResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "d:GetNotary"))
		{	*type = SOAP_TYPE_d__GetNotary;
			return soap_in_d__GetNotary(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "d:GetNotaryResponse"))
		{	*type = SOAP_TYPE_d__GetNotaryResponse;
			return soap_in_d__GetNotaryResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "d:GetNotarysCertificate"))
		{	*type = SOAP_TYPE_d__GetNotarysCertificate;
			return soap_in_d__GetNotarysCertificate(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "d:GetNotarysCertificateResponse"))
		{	*type = SOAP_TYPE_d__GetNotarysCertificateResponse;
			return soap_in_d__GetNotarysCertificateResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "d:GetSignersCertificate"))
		{	*type = SOAP_TYPE_d__GetSignersCertificate;
			return soap_in_d__GetSignersCertificate(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "d:GetSignersCertificateResponse"))
		{	*type = SOAP_TYPE_d__GetSignersCertificateResponse;
			return soap_in_d__GetSignersCertificateResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "d:GetDataFile"))
		{	*type = SOAP_TYPE_d__GetDataFile;
			return soap_in_d__GetDataFile(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "d:GetDataFileResponse"))
		{	*type = SOAP_TYPE_d__GetDataFileResponse;
			return soap_in_d__GetDataFileResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "d:GetSignedDocInfo"))
		{	*type = SOAP_TYPE_d__GetSignedDocInfo;
			return soap_in_d__GetSignedDocInfo(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "d:GetSignedDocInfoResponse"))
		{	*type = SOAP_TYPE_d__GetSignedDocInfoResponse;
			return soap_in_d__GetSignedDocInfoResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "d:GetSignedDoc"))
		{	*type = SOAP_TYPE_d__GetSignedDoc;
			return soap_in_d__GetSignedDoc(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "d:GetSignedDocResponse"))
		{	*type = SOAP_TYPE_d__GetSignedDocResponse;
			return soap_in_d__GetSignedDocResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "d:RemoveDataFile"))
		{	*type = SOAP_TYPE_d__RemoveDataFile;
			return soap_in_d__RemoveDataFile(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "d:RemoveDataFileResponse"))
		{	*type = SOAP_TYPE_d__RemoveDataFileResponse;
			return soap_in_d__RemoveDataFileResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "d:AddDataFile"))
		{	*type = SOAP_TYPE_d__AddDataFile;
			return soap_in_d__AddDataFile(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "d:AddDataFileResponse"))
		{	*type = SOAP_TYPE_d__AddDataFileResponse;
			return soap_in_d__AddDataFileResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "d:CreateSignedDoc"))
		{	*type = SOAP_TYPE_d__CreateSignedDoc;
			return soap_in_d__CreateSignedDoc(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "d:CreateSignedDocResponse"))
		{	*type = SOAP_TYPE_d__CreateSignedDocResponse;
			return soap_in_d__CreateSignedDocResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "d:CloseSession"))
		{	*type = SOAP_TYPE_d__CloseSession;
			return soap_in_d__CloseSession(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "d:CloseSessionResponse"))
		{	*type = SOAP_TYPE_d__CloseSessionResponse;
			return soap_in_d__CloseSessionResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "d:StartSession"))
		{	*type = SOAP_TYPE_d__StartSession;
			return soap_in_d__StartSession(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "d:StartSessionResponse"))
		{	*type = SOAP_TYPE_d__StartSessionResponse;
			return soap_in_d__StartSessionResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "d:DataFileData"))
		{	*type = SOAP_TYPE_d__DataFileData;
			return soap_in_d__DataFileData(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "d:SignedDocInfo"))
		{	*type = SOAP_TYPE_d__SignedDocInfo;
			return soap_in_d__SignedDocInfo(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "d:SignatureInfo"))
		{	*type = SOAP_TYPE_d__SignatureInfo;
			return soap_in_d__SignatureInfo(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "d:Error"))
		{	*type = SOAP_TYPE_d__Error;
			return soap_in_d__Error(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "d:CRLInfo"))
		{	*type = SOAP_TYPE_d__CRLInfo;
			return soap_in_d__CRLInfo(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "d:RevokedInfo"))
		{	*type = SOAP_TYPE_d__RevokedInfo;
			return soap_in_d__RevokedInfo(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "d:TstInfo"))
		{	*type = SOAP_TYPE_d__TstInfo;
			return soap_in_d__TstInfo(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "d:ConfirmationInfo"))
		{	*type = SOAP_TYPE_d__ConfirmationInfo;
			return soap_in_d__ConfirmationInfo(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "d:SignerInfo"))
		{	*type = SOAP_TYPE_d__SignerInfo;
			return soap_in_d__SignerInfo(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "d:CertificateInfo"))
		{	*type = SOAP_TYPE_d__CertificateInfo;
			return soap_in_d__CertificateInfo(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "d:CertificatePolicy"))
		{	*type = SOAP_TYPE_d__CertificatePolicy;
			return soap_in_d__CertificatePolicy(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "d:SignatureProductionPlace"))
		{	*type = SOAP_TYPE_d__SignatureProductionPlace;
			return soap_in_d__SignatureProductionPlace(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "d:SignerRole"))
		{	*type = SOAP_TYPE_d__SignerRole;
			return soap_in_d__SignerRole(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "d:DataFileInfo"))
		{	*type = SOAP_TYPE_d__DataFileInfo;
			return soap_in_d__DataFileInfo(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "d:DataFileAttribute"))
		{	*type = SOAP_TYPE_d__DataFileAttribute;
			return soap_in_d__DataFileAttribute(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "xsd:hexBinary"))
		{	*type = SOAP_TYPE_xsd__hexBinary;
			return soap_in_xsd__hexBinary(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "xsd:dateTime"))
		{	char **s;
			*type = SOAP_TYPE_xsd__dateTime;
			s = soap_in_xsd__dateTime(soap, NULL, NULL, NULL);
			return s ? *s : NULL;
		}
		if (!soap_match_tag(soap, t, "xsd:anyURI"))
		{	char **s;
			*type = SOAP_TYPE_xsd__anyURI;
			s = soap_in_xsd__anyURI(soap, NULL, NULL, NULL);
			return s ? *s : NULL;
		}
		if (!soap_match_tag(soap, t, "xsd:string"))
		{	char **s;
			*type = SOAP_TYPE_xsd__string;
			s = soap_in_xsd__string(soap, NULL, NULL, NULL);
			return s ? *s : NULL;
		}
		if (!soap_match_tag(soap, t, "xsd:string"))
		{	char **s;
			*type = SOAP_TYPE_string;
			s = soap_in_string(soap, NULL, NULL, NULL);
			return s ? *s : NULL;
		}
		t = soap->tag;
		if (!soap_match_tag(soap, t, "xsd:QName"))
		{	char **s;
			*type = SOAP_TYPE__QName;
			s = soap_in__QName(soap, NULL, NULL, NULL);
			return s ? *s : NULL;
		}
	}
	}
	soap->error = SOAP_TAG_MISMATCH;
	return NULL;
}
#endif

SOAP_FMAC3 int SOAP_FMAC4 soap_ignore_element(struct soap *soap)
{
	if (!soap_peek_element(soap))
	{	int t;
		if (soap->mustUnderstand && !soap->other)
			return soap->error = SOAP_MUSTUNDERSTAND;
		if (((soap->mode & SOAP_XML_STRICT) && soap->part != SOAP_IN_HEADER) || !soap_match_tag(soap, soap->tag, "SOAP-ENV:"))
		{	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "REJECTING element '%s'\n", soap->tag));
			return soap->error = SOAP_TAG_MISMATCH;
		}
		if (!*soap->id || !soap_getelement(soap, &t))
		{	soap->peeked = 0;
			DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Unknown element '%s' (level=%u, %d)\n", soap->tag, soap->level, soap->body));
			if (soap->fignore)
				soap->error = soap->fignore(soap, soap->tag);
			else
				soap->error = SOAP_OK;
			DBGLOG(TEST, if (!soap->error) SOAP_MESSAGE(fdebug, "IGNORING element '%s'\n", soap->tag));
			if (!soap->error && soap->body)
			{	soap->level++;
				while (!soap_ignore_element(soap))
					;
				if (soap->error == SOAP_NO_TAG)
					soap->error = soap_element_end_in(soap, NULL);
			}
		}
	}
	return soap->error;
}

#ifndef WITH_NOIDREF
SOAP_FMAC3 int SOAP_FMAC4 soap_putindependent(struct soap *soap)
{
	int i;
	struct soap_plist *pp;
	if (soap->version == 1 && soap->encodingStyle && !(soap->mode & (SOAP_XML_TREE | SOAP_XML_GRAPH)))
		for (i = 0; i < SOAP_PTRHASH; i++)
			for (pp = soap->pht[i]; pp; pp = pp->next)
				if (pp->mark1 == 2 || pp->mark2 == 2)
					if (soap_putelement(soap, pp->ptr, "id", pp->id, pp->type))
						return soap->error;
	return SOAP_OK;
}
#endif

#ifndef WITH_NOIDREF
SOAP_FMAC3 int SOAP_FMAC4 soap_putelement(struct soap *soap, const void *ptr, const char *tag, int id, int type)
{
	switch (type)
	{
	case SOAP_TYPE_byte:
		return soap_out_byte(soap, tag, id, (const char *)ptr, "xsd:byte");
	case SOAP_TYPE_int:
		return soap_out_int(soap, tag, id, (const int *)ptr, "xsd:int");
	case SOAP_TYPE_xsd__int:
		return soap_out_xsd__int(soap, tag, id, (const long *)ptr, "xsd:int");
	case SOAP_TYPE_long:
		return soap_out_long(soap, tag, id, (const long *)ptr, "xsd:long");
	case SOAP_TYPE_LONG64:
		return soap_out_LONG64(soap, tag, id, (const LONG64 *)ptr, "xsd:long");
	case SOAP_TYPE_xsd__float:
		return soap_out_xsd__float(soap, tag, id, (const float *)ptr, "xsd:float");
	case SOAP_TYPE_float:
		return soap_out_float(soap, tag, id, (const float *)ptr, "xsd:float");
	case SOAP_TYPE_unsignedByte:
		return soap_out_unsignedByte(soap, tag, id, (const unsigned char *)ptr, "xsd:unsignedByte");
	case SOAP_TYPE_unsignedInt:
		return soap_out_unsignedInt(soap, tag, id, (const unsigned int *)ptr, "xsd:unsignedInt");
	case SOAP_TYPE_xsd__positiveInteger:
		return soap_out_xsd__positiveInteger(soap, tag, id, (const ULONG64 *)ptr, "xsd:positiveInteger");
	case SOAP_TYPE_unsignedLONG64:
		return soap_out_unsignedLONG64(soap, tag, id, (const ULONG64 *)ptr, "xsd:unsignedLong");
	case SOAP_TYPE_xsd__boolean:
		return soap_out_xsd__boolean(soap, tag, id, (const bool *)ptr, "xsd:boolean");
	case SOAP_TYPE_bool:
		return soap_out_bool(soap, tag, id, (const bool *)ptr, "xsd:boolean");
	case SOAP_TYPE_mss__MSS_USCORESignatureDummy:
		return soap_out_mss__MSS_USCORESignatureDummy(soap, tag, id, (const struct mss__MSS_USCORESignatureDummy *)ptr, "mss:MSS_SignatureDummy");
	case SOAP_TYPE_mss_DummyResp:
		return soap_out_mss_DummyResp(soap, tag, id, (const struct mss_DummyResp *)ptr, "mss-DummyResp");
	case SOAP_TYPE_d__GetMobileCreateSignatureStatus:
		return soap_out_d__GetMobileCreateSignatureStatus(soap, tag, id, (const struct d__GetMobileCreateSignatureStatus *)ptr, "d:GetMobileCreateSignatureStatus");
	case SOAP_TYPE_d__GetMobileCreateSignatureStatusResponse:
		return soap_out_d__GetMobileCreateSignatureStatusResponse(soap, tag, id, (const struct d__GetMobileCreateSignatureStatusResponse *)ptr, "d:GetMobileCreateSignatureStatusResponse");
	case SOAP_TYPE_d__MobileCreateSignature:
		return soap_out_d__MobileCreateSignature(soap, tag, id, (const struct d__MobileCreateSignature *)ptr, "d:MobileCreateSignature");
	case SOAP_TYPE_d__MobileCreateSignatureResponse:
		return soap_out_d__MobileCreateSignatureResponse(soap, tag, id, (const struct d__MobileCreateSignatureResponse *)ptr, "d:MobileCreateSignatureResponse");
	case SOAP_TYPE_d__DataFileDigestList:
		return soap_out_d__DataFileDigestList(soap, tag, id, (const struct d__DataFileDigestList *)ptr, "d:DataFileDigestList");
	case SOAP_TYPE_d__DataFileDigest:
		return soap_out_d__DataFileDigest(soap, tag, id, (const struct d__DataFileDigest *)ptr, "d:DataFileDigest");
	case SOAP_TYPE_d__GetMobileAuthenticateStatus:
		return soap_out_d__GetMobileAuthenticateStatus(soap, tag, id, (const struct d__GetMobileAuthenticateStatus *)ptr, "d:GetMobileAuthenticateStatus");
	case SOAP_TYPE_d__GetMobileAuthenticateStatusResponse:
		return soap_out_d__GetMobileAuthenticateStatusResponse(soap, tag, id, (const struct d__GetMobileAuthenticateStatusResponse *)ptr, "d:GetMobileAuthenticateStatusResponse");
	case SOAP_TYPE_d__MobileAuthenticate:
		return soap_out_d__MobileAuthenticate(soap, tag, id, (const struct d__MobileAuthenticate *)ptr, "d:MobileAuthenticate");
	case SOAP_TYPE_d__MobileAuthenticateResponse:
		return soap_out_d__MobileAuthenticateResponse(soap, tag, id, (const struct d__MobileAuthenticateResponse *)ptr, "d:MobileAuthenticateResponse");
	case SOAP_TYPE_d__GetStatusInfo:
		return soap_out_d__GetStatusInfo(soap, tag, id, (const struct d__GetStatusInfo *)ptr, "d:GetStatusInfo");
	case SOAP_TYPE_d__GetStatusInfoResponse:
		return soap_out_d__GetStatusInfoResponse(soap, tag, id, (const struct d__GetStatusInfoResponse *)ptr, "d:GetStatusInfoResponse");
	case SOAP_TYPE_d__MobileSign:
		return soap_out_d__MobileSign(soap, tag, id, (const struct d__MobileSign *)ptr, "d:MobileSign");
	case SOAP_TYPE_d__MobileSignResponse:
		return soap_out_d__MobileSignResponse(soap, tag, id, (const struct d__MobileSignResponse *)ptr, "d:MobileSignResponse");
	case SOAP_TYPE_d__GetVersion:
		return soap_out_d__GetVersion(soap, tag, id, (const struct d__GetVersion *)ptr, "d:GetVersion");
	case SOAP_TYPE_d__GetVersionResponse:
		return soap_out_d__GetVersionResponse(soap, tag, id, (const struct d__GetVersionResponse *)ptr, "d:GetVersionResponse");
	case SOAP_TYPE_d__RemoveSignature:
		return soap_out_d__RemoveSignature(soap, tag, id, (const struct d__RemoveSignature *)ptr, "d:RemoveSignature");
	case SOAP_TYPE_d__RemoveSignatureResponse:
		return soap_out_d__RemoveSignatureResponse(soap, tag, id, (const struct d__RemoveSignatureResponse *)ptr, "d:RemoveSignatureResponse");
	case SOAP_TYPE_d__FinalizeSignature:
		return soap_out_d__FinalizeSignature(soap, tag, id, (const struct d__FinalizeSignature *)ptr, "d:FinalizeSignature");
	case SOAP_TYPE_d__FinalizeSignatureResponse:
		return soap_out_d__FinalizeSignatureResponse(soap, tag, id, (const struct d__FinalizeSignatureResponse *)ptr, "d:FinalizeSignatureResponse");
	case SOAP_TYPE_d__PrepareSignature:
		return soap_out_d__PrepareSignature(soap, tag, id, (const struct d__PrepareSignature *)ptr, "d:PrepareSignature");
	case SOAP_TYPE_d__PrepareSignatureResponse:
		return soap_out_d__PrepareSignatureResponse(soap, tag, id, (const struct d__PrepareSignatureResponse *)ptr, "d:PrepareSignatureResponse");
	case SOAP_TYPE_d__GetSignatureModules:
		return soap_out_d__GetSignatureModules(soap, tag, id, (const struct d__GetSignatureModules *)ptr, "d:GetSignatureModules");
	case SOAP_TYPE_d__GetSignatureModulesResponse:
		return soap_out_d__GetSignatureModulesResponse(soap, tag, id, (const struct d__GetSignatureModulesResponse *)ptr, "d:GetSignatureModulesResponse");
	case SOAP_TYPE_d__SignatureModulesArray:
		return soap_out_d__SignatureModulesArray(soap, tag, id, (const struct d__SignatureModulesArray *)ptr, "d:SignatureModulesArray");
	case SOAP_TYPE_d__SignatureModule:
		return soap_out_d__SignatureModule(soap, tag, id, (const struct d__SignatureModule *)ptr, "d:SignatureModule");
	case SOAP_TYPE_d__GetCRL:
		return soap_out_d__GetCRL(soap, tag, id, (const struct d__GetCRL *)ptr, "d:GetCRL");
	case SOAP_TYPE_d__GetCRLResponse:
		return soap_out_d__GetCRLResponse(soap, tag, id, (const struct d__GetCRLResponse *)ptr, "d:GetCRLResponse");
	case SOAP_TYPE_d__GetTimestamp:
		return soap_out_d__GetTimestamp(soap, tag, id, (const struct d__GetTimestamp *)ptr, "d:GetTimestamp");
	case SOAP_TYPE_d__GetTimestampResponse:
		return soap_out_d__GetTimestampResponse(soap, tag, id, (const struct d__GetTimestampResponse *)ptr, "d:GetTimestampResponse");
	case SOAP_TYPE_d__GetTSACertificate:
		return soap_out_d__GetTSACertificate(soap, tag, id, (const struct d__GetTSACertificate *)ptr, "d:GetTSACertificate");
	case SOAP_TYPE_d__GetTSACertificateResponse:
		return soap_out_d__GetTSACertificateResponse(soap, tag, id, (const struct d__GetTSACertificateResponse *)ptr, "d:GetTSACertificateResponse");
	case SOAP_TYPE_d__GetNotary:
		return soap_out_d__GetNotary(soap, tag, id, (const struct d__GetNotary *)ptr, "d:GetNotary");
	case SOAP_TYPE_d__GetNotaryResponse:
		return soap_out_d__GetNotaryResponse(soap, tag, id, (const struct d__GetNotaryResponse *)ptr, "d:GetNotaryResponse");
	case SOAP_TYPE_d__GetNotarysCertificate:
		return soap_out_d__GetNotarysCertificate(soap, tag, id, (const struct d__GetNotarysCertificate *)ptr, "d:GetNotarysCertificate");
	case SOAP_TYPE_d__GetNotarysCertificateResponse:
		return soap_out_d__GetNotarysCertificateResponse(soap, tag, id, (const struct d__GetNotarysCertificateResponse *)ptr, "d:GetNotarysCertificateResponse");
	case SOAP_TYPE_d__GetSignersCertificate:
		return soap_out_d__GetSignersCertificate(soap, tag, id, (const struct d__GetSignersCertificate *)ptr, "d:GetSignersCertificate");
	case SOAP_TYPE_d__GetSignersCertificateResponse:
		return soap_out_d__GetSignersCertificateResponse(soap, tag, id, (const struct d__GetSignersCertificateResponse *)ptr, "d:GetSignersCertificateResponse");
	case SOAP_TYPE_d__GetDataFile:
		return soap_out_d__GetDataFile(soap, tag, id, (const struct d__GetDataFile *)ptr, "d:GetDataFile");
	case SOAP_TYPE_d__GetDataFileResponse:
		return soap_out_d__GetDataFileResponse(soap, tag, id, (const struct d__GetDataFileResponse *)ptr, "d:GetDataFileResponse");
	case SOAP_TYPE_d__GetSignedDocInfo:
		return soap_out_d__GetSignedDocInfo(soap, tag, id, (const struct d__GetSignedDocInfo *)ptr, "d:GetSignedDocInfo");
	case SOAP_TYPE_d__GetSignedDocInfoResponse:
		return soap_out_d__GetSignedDocInfoResponse(soap, tag, id, (const struct d__GetSignedDocInfoResponse *)ptr, "d:GetSignedDocInfoResponse");
	case SOAP_TYPE_d__GetSignedDoc:
		return soap_out_d__GetSignedDoc(soap, tag, id, (const struct d__GetSignedDoc *)ptr, "d:GetSignedDoc");
	case SOAP_TYPE_d__GetSignedDocResponse:
		return soap_out_d__GetSignedDocResponse(soap, tag, id, (const struct d__GetSignedDocResponse *)ptr, "d:GetSignedDocResponse");
	case SOAP_TYPE_d__RemoveDataFile:
		return soap_out_d__RemoveDataFile(soap, tag, id, (const struct d__RemoveDataFile *)ptr, "d:RemoveDataFile");
	case SOAP_TYPE_d__RemoveDataFileResponse:
		return soap_out_d__RemoveDataFileResponse(soap, tag, id, (const struct d__RemoveDataFileResponse *)ptr, "d:RemoveDataFileResponse");
	case SOAP_TYPE_d__AddDataFile:
		return soap_out_d__AddDataFile(soap, tag, id, (const struct d__AddDataFile *)ptr, "d:AddDataFile");
	case SOAP_TYPE_d__AddDataFileResponse:
		return soap_out_d__AddDataFileResponse(soap, tag, id, (const struct d__AddDataFileResponse *)ptr, "d:AddDataFileResponse");
	case SOAP_TYPE_d__CreateSignedDoc:
		return soap_out_d__CreateSignedDoc(soap, tag, id, (const struct d__CreateSignedDoc *)ptr, "d:CreateSignedDoc");
	case SOAP_TYPE_d__CreateSignedDocResponse:
		return soap_out_d__CreateSignedDocResponse(soap, tag, id, (const struct d__CreateSignedDocResponse *)ptr, "d:CreateSignedDocResponse");
	case SOAP_TYPE_d__CloseSession:
		return soap_out_d__CloseSession(soap, tag, id, (const struct d__CloseSession *)ptr, "d:CloseSession");
	case SOAP_TYPE_d__CloseSessionResponse:
		return soap_out_d__CloseSessionResponse(soap, tag, id, (const struct d__CloseSessionResponse *)ptr, "d:CloseSessionResponse");
	case SOAP_TYPE_d__StartSession:
		return soap_out_d__StartSession(soap, tag, id, (const struct d__StartSession *)ptr, "d:StartSession");
	case SOAP_TYPE_d__StartSessionResponse:
		return soap_out_d__StartSessionResponse(soap, tag, id, (const struct d__StartSessionResponse *)ptr, "d:StartSessionResponse");
	case SOAP_TYPE_d__DataFileData:
		return soap_out_d__DataFileData(soap, tag, id, (const struct d__DataFileData *)ptr, "d:DataFileData");
	case SOAP_TYPE_d__SignedDocInfo:
		return soap_out_d__SignedDocInfo(soap, tag, id, (const struct d__SignedDocInfo *)ptr, "d:SignedDocInfo");
	case SOAP_TYPE_d__SignatureInfo:
		return soap_out_d__SignatureInfo(soap, tag, id, (const struct d__SignatureInfo *)ptr, "d:SignatureInfo");
	case SOAP_TYPE_d__Error:
		return soap_out_d__Error(soap, tag, id, (const struct d__Error *)ptr, "d:Error");
	case SOAP_TYPE_d__CRLInfo:
		return soap_out_d__CRLInfo(soap, tag, id, (const struct d__CRLInfo *)ptr, "d:CRLInfo");
	case SOAP_TYPE_d__RevokedInfo:
		return soap_out_d__RevokedInfo(soap, tag, id, (const struct d__RevokedInfo *)ptr, "d:RevokedInfo");
	case SOAP_TYPE_d__TstInfo:
		return soap_out_d__TstInfo(soap, tag, id, (const struct d__TstInfo *)ptr, "d:TstInfo");
	case SOAP_TYPE_d__ConfirmationInfo:
		return soap_out_d__ConfirmationInfo(soap, tag, id, (const struct d__ConfirmationInfo *)ptr, "d:ConfirmationInfo");
	case SOAP_TYPE_d__SignerInfo:
		return soap_out_d__SignerInfo(soap, tag, id, (const struct d__SignerInfo *)ptr, "d:SignerInfo");
	case SOAP_TYPE_d__CertificateInfo:
		return soap_out_d__CertificateInfo(soap, tag, id, (const struct d__CertificateInfo *)ptr, "d:CertificateInfo");
	case SOAP_TYPE_d__CertificatePolicy:
		return soap_out_d__CertificatePolicy(soap, tag, id, (const struct d__CertificatePolicy *)ptr, "d:CertificatePolicy");
	case SOAP_TYPE_d__SignatureProductionPlace:
		return soap_out_d__SignatureProductionPlace(soap, tag, id, (const struct d__SignatureProductionPlace *)ptr, "d:SignatureProductionPlace");
	case SOAP_TYPE_d__SignerRole:
		return soap_out_d__SignerRole(soap, tag, id, (const struct d__SignerRole *)ptr, "d:SignerRole");
	case SOAP_TYPE_d__DataFileInfo:
		return soap_out_d__DataFileInfo(soap, tag, id, (const struct d__DataFileInfo *)ptr, "d:DataFileInfo");
	case SOAP_TYPE_d__DataFileAttribute:
		return soap_out_d__DataFileAttribute(soap, tag, id, (const struct d__DataFileAttribute *)ptr, "d:DataFileAttribute");
	case SOAP_TYPE_xsd__hexBinary:
		return soap_out_xsd__hexBinary(soap, tag, id, (const struct xsd__hexBinary *)ptr, "xsd:hexBinary");
	case SOAP_TYPE_PointerTomss_DummyResp:
		return soap_out_PointerTomss_DummyResp(soap, tag, id, (struct mss_DummyResp *const*)ptr, "mss-DummyResp");
	case SOAP_TYPE_PointerTod__GetMobileCreateSignatureStatusResponse:
		return soap_out_PointerTod__GetMobileCreateSignatureStatusResponse(soap, tag, id, (struct d__GetMobileCreateSignatureStatusResponse *const*)ptr, "d:GetMobileCreateSignatureStatusResponse");
	case SOAP_TYPE_PointerTod__MobileCreateSignatureResponse:
		return soap_out_PointerTod__MobileCreateSignatureResponse(soap, tag, id, (struct d__MobileCreateSignatureResponse *const*)ptr, "d:MobileCreateSignatureResponse");
	case SOAP_TYPE_PointerTod__DataFileDigestList:
		return soap_out_PointerTod__DataFileDigestList(soap, tag, id, (struct d__DataFileDigestList *const*)ptr, "d:DataFileDigestList");
	case SOAP_TYPE_PointerTod__DataFileDigest:
		return soap_out_PointerTod__DataFileDigest(soap, tag, id, (struct d__DataFileDigest *const*)ptr, "d:DataFileDigest");
	case SOAP_TYPE_PointerTod__GetMobileAuthenticateStatusResponse:
		return soap_out_PointerTod__GetMobileAuthenticateStatusResponse(soap, tag, id, (struct d__GetMobileAuthenticateStatusResponse *const*)ptr, "d:GetMobileAuthenticateStatusResponse");
	case SOAP_TYPE_PointerTod__MobileAuthenticateResponse:
		return soap_out_PointerTod__MobileAuthenticateResponse(soap, tag, id, (struct d__MobileAuthenticateResponse *const*)ptr, "d:MobileAuthenticateResponse");
	case SOAP_TYPE_PointerTod__GetStatusInfoResponse:
		return soap_out_PointerTod__GetStatusInfoResponse(soap, tag, id, (struct d__GetStatusInfoResponse *const*)ptr, "d:GetStatusInfoResponse");
	case SOAP_TYPE_PointerTod__MobileSignResponse:
		return soap_out_PointerTod__MobileSignResponse(soap, tag, id, (struct d__MobileSignResponse *const*)ptr, "d:MobileSignResponse");
	case SOAP_TYPE_PointerTod__GetVersionResponse:
		return soap_out_PointerTod__GetVersionResponse(soap, tag, id, (struct d__GetVersionResponse *const*)ptr, "d:GetVersionResponse");
	case SOAP_TYPE_PointerTod__RemoveSignatureResponse:
		return soap_out_PointerTod__RemoveSignatureResponse(soap, tag, id, (struct d__RemoveSignatureResponse *const*)ptr, "d:RemoveSignatureResponse");
	case SOAP_TYPE_PointerTod__FinalizeSignatureResponse:
		return soap_out_PointerTod__FinalizeSignatureResponse(soap, tag, id, (struct d__FinalizeSignatureResponse *const*)ptr, "d:FinalizeSignatureResponse");
	case SOAP_TYPE_PointerTod__PrepareSignatureResponse:
		return soap_out_PointerTod__PrepareSignatureResponse(soap, tag, id, (struct d__PrepareSignatureResponse *const*)ptr, "d:PrepareSignatureResponse");
	case SOAP_TYPE_PointerTod__GetSignatureModulesResponse:
		return soap_out_PointerTod__GetSignatureModulesResponse(soap, tag, id, (struct d__GetSignatureModulesResponse *const*)ptr, "d:GetSignatureModulesResponse");
	case SOAP_TYPE_PointerTod__SignatureModulesArray:
		return soap_out_PointerTod__SignatureModulesArray(soap, tag, id, (struct d__SignatureModulesArray *const*)ptr, "d:SignatureModulesArray");
	case SOAP_TYPE_PointerTod__SignatureModule:
		return soap_out_PointerTod__SignatureModule(soap, tag, id, (struct d__SignatureModule *const*)ptr, "d:SignatureModule");
	case SOAP_TYPE_PointerTod__GetCRLResponse:
		return soap_out_PointerTod__GetCRLResponse(soap, tag, id, (struct d__GetCRLResponse *const*)ptr, "d:GetCRLResponse");
	case SOAP_TYPE_PointerTod__GetTimestampResponse:
		return soap_out_PointerTod__GetTimestampResponse(soap, tag, id, (struct d__GetTimestampResponse *const*)ptr, "d:GetTimestampResponse");
	case SOAP_TYPE_PointerTod__GetTSACertificateResponse:
		return soap_out_PointerTod__GetTSACertificateResponse(soap, tag, id, (struct d__GetTSACertificateResponse *const*)ptr, "d:GetTSACertificateResponse");
	case SOAP_TYPE_PointerTod__GetNotaryResponse:
		return soap_out_PointerTod__GetNotaryResponse(soap, tag, id, (struct d__GetNotaryResponse *const*)ptr, "d:GetNotaryResponse");
	case SOAP_TYPE_PointerTod__GetNotarysCertificateResponse:
		return soap_out_PointerTod__GetNotarysCertificateResponse(soap, tag, id, (struct d__GetNotarysCertificateResponse *const*)ptr, "d:GetNotarysCertificateResponse");
	case SOAP_TYPE_PointerTod__GetSignersCertificateResponse:
		return soap_out_PointerTod__GetSignersCertificateResponse(soap, tag, id, (struct d__GetSignersCertificateResponse *const*)ptr, "d:GetSignersCertificateResponse");
	case SOAP_TYPE_PointerTod__GetDataFileResponse:
		return soap_out_PointerTod__GetDataFileResponse(soap, tag, id, (struct d__GetDataFileResponse *const*)ptr, "d:GetDataFileResponse");
	case SOAP_TYPE_PointerTod__GetSignedDocInfoResponse:
		return soap_out_PointerTod__GetSignedDocInfoResponse(soap, tag, id, (struct d__GetSignedDocInfoResponse *const*)ptr, "d:GetSignedDocInfoResponse");
	case SOAP_TYPE_PointerTod__GetSignedDocResponse:
		return soap_out_PointerTod__GetSignedDocResponse(soap, tag, id, (struct d__GetSignedDocResponse *const*)ptr, "d:GetSignedDocResponse");
	case SOAP_TYPE_PointerTod__RemoveDataFileResponse:
		return soap_out_PointerTod__RemoveDataFileResponse(soap, tag, id, (struct d__RemoveDataFileResponse *const*)ptr, "d:RemoveDataFileResponse");
	case SOAP_TYPE_PointerTod__AddDataFileResponse:
		return soap_out_PointerTod__AddDataFileResponse(soap, tag, id, (struct d__AddDataFileResponse *const*)ptr, "d:AddDataFileResponse");
	case SOAP_TYPE_PointerTod__CreateSignedDocResponse:
		return soap_out_PointerTod__CreateSignedDocResponse(soap, tag, id, (struct d__CreateSignedDocResponse *const*)ptr, "d:CreateSignedDocResponse");
	case SOAP_TYPE_PointerTod__CloseSessionResponse:
		return soap_out_PointerTod__CloseSessionResponse(soap, tag, id, (struct d__CloseSessionResponse *const*)ptr, "d:CloseSessionResponse");
	case SOAP_TYPE_PointerTod__StartSessionResponse:
		return soap_out_PointerTod__StartSessionResponse(soap, tag, id, (struct d__StartSessionResponse *const*)ptr, "d:StartSessionResponse");
	case SOAP_TYPE_PointerTod__DataFileData:
		return soap_out_PointerTod__DataFileData(soap, tag, id, (struct d__DataFileData *const*)ptr, "d:DataFileData");
	case SOAP_TYPE_PointerTod__SignedDocInfo:
		return soap_out_PointerTod__SignedDocInfo(soap, tag, id, (struct d__SignedDocInfo *const*)ptr, "d:SignedDocInfo");
	case SOAP_TYPE_PointerTod__SignatureInfo:
		return soap_out_PointerTod__SignatureInfo(soap, tag, id, (struct d__SignatureInfo *const*)ptr, "d:SignatureInfo");
	case SOAP_TYPE_PointerTod__DataFileInfo:
		return soap_out_PointerTod__DataFileInfo(soap, tag, id, (struct d__DataFileInfo *const*)ptr, "d:DataFileInfo");
	case SOAP_TYPE_PointerTod__CRLInfo:
		return soap_out_PointerTod__CRLInfo(soap, tag, id, (struct d__CRLInfo *const*)ptr, "d:CRLInfo");
	case SOAP_TYPE_PointerTod__TstInfo:
		return soap_out_PointerTod__TstInfo(soap, tag, id, (struct d__TstInfo *const*)ptr, "d:TstInfo");
	case SOAP_TYPE_PointerTod__ConfirmationInfo:
		return soap_out_PointerTod__ConfirmationInfo(soap, tag, id, (struct d__ConfirmationInfo *const*)ptr, "d:ConfirmationInfo");
	case SOAP_TYPE_PointerTod__SignerInfo:
		return soap_out_PointerTod__SignerInfo(soap, tag, id, (struct d__SignerInfo *const*)ptr, "d:SignerInfo");
	case SOAP_TYPE_PointerTod__SignatureProductionPlace:
		return soap_out_PointerTod__SignatureProductionPlace(soap, tag, id, (struct d__SignatureProductionPlace *const*)ptr, "d:SignatureProductionPlace");
	case SOAP_TYPE_PointerTod__SignerRole:
		return soap_out_PointerTod__SignerRole(soap, tag, id, (struct d__SignerRole *const*)ptr, "d:SignerRole");
	case SOAP_TYPE_PointerTod__Error:
		return soap_out_PointerTod__Error(soap, tag, id, (struct d__Error *const*)ptr, "d:Error");
	case SOAP_TYPE_PointerTod__RevokedInfo:
		return soap_out_PointerTod__RevokedInfo(soap, tag, id, (struct d__RevokedInfo *const*)ptr, "d:RevokedInfo");
	case SOAP_TYPE_PointerTod__CertificateInfo:
		return soap_out_PointerTod__CertificateInfo(soap, tag, id, (struct d__CertificateInfo *const*)ptr, "d:CertificateInfo");
	case SOAP_TYPE_PointerTod__CertificatePolicy:
		return soap_out_PointerTod__CertificatePolicy(soap, tag, id, (struct d__CertificatePolicy *const*)ptr, "d:CertificatePolicy");
	case SOAP_TYPE_PointerTod__DataFileAttribute:
		return soap_out_PointerTod__DataFileAttribute(soap, tag, id, (struct d__DataFileAttribute *const*)ptr, "d:DataFileAttribute");
	case SOAP_TYPE_PointerTounsignedByte:
		return soap_out_PointerTounsignedByte(soap, tag, id, (unsigned char *const*)ptr, "xsd:unsignedByte");
	case SOAP_TYPE_xsd__dateTime:
		return soap_out_string(soap, tag, id, (char**)&ptr, "xsd:dateTime");
	case SOAP_TYPE_xsd__anyURI:
		return soap_out_string(soap, tag, id, (char**)&ptr, "xsd:anyURI");
	case SOAP_TYPE_xsd__string:
		return soap_out_string(soap, tag, id, (char**)&ptr, "xsd:string");
	case SOAP_TYPE__QName:
		return soap_out_string(soap, "xsd:QName", id, (char**)&ptr, NULL);
	case SOAP_TYPE_string:
		return soap_out_string(soap, tag, id, (char**)&ptr, "xsd:string");
	}
	return SOAP_OK;
}
#endif

#ifndef WITH_NOIDREF
SOAP_FMAC3 void SOAP_FMAC4 soap_markelement(struct soap *soap, const void *ptr, int type)
{
	(void)soap; (void)ptr; (void)type; /* appease -Wall -Werror */
	switch (type)
	{
	case SOAP_TYPE_mss__MSS_USCORESignatureDummy:
		soap_serialize_mss__MSS_USCORESignatureDummy(soap, (const struct mss__MSS_USCORESignatureDummy *)ptr);
		break;
	case SOAP_TYPE_mss_DummyResp:
		soap_serialize_mss_DummyResp(soap, (const struct mss_DummyResp *)ptr);
		break;
	case SOAP_TYPE_d__GetMobileCreateSignatureStatus:
		soap_serialize_d__GetMobileCreateSignatureStatus(soap, (const struct d__GetMobileCreateSignatureStatus *)ptr);
		break;
	case SOAP_TYPE_d__GetMobileCreateSignatureStatusResponse:
		soap_serialize_d__GetMobileCreateSignatureStatusResponse(soap, (const struct d__GetMobileCreateSignatureStatusResponse *)ptr);
		break;
	case SOAP_TYPE_d__MobileCreateSignature:
		soap_serialize_d__MobileCreateSignature(soap, (const struct d__MobileCreateSignature *)ptr);
		break;
	case SOAP_TYPE_d__MobileCreateSignatureResponse:
		soap_serialize_d__MobileCreateSignatureResponse(soap, (const struct d__MobileCreateSignatureResponse *)ptr);
		break;
	case SOAP_TYPE_d__DataFileDigestList:
		soap_serialize_d__DataFileDigestList(soap, (const struct d__DataFileDigestList *)ptr);
		break;
	case SOAP_TYPE_d__DataFileDigest:
		soap_serialize_d__DataFileDigest(soap, (const struct d__DataFileDigest *)ptr);
		break;
	case SOAP_TYPE_d__GetMobileAuthenticateStatus:
		soap_serialize_d__GetMobileAuthenticateStatus(soap, (const struct d__GetMobileAuthenticateStatus *)ptr);
		break;
	case SOAP_TYPE_d__GetMobileAuthenticateStatusResponse:
		soap_serialize_d__GetMobileAuthenticateStatusResponse(soap, (const struct d__GetMobileAuthenticateStatusResponse *)ptr);
		break;
	case SOAP_TYPE_d__MobileAuthenticate:
		soap_serialize_d__MobileAuthenticate(soap, (const struct d__MobileAuthenticate *)ptr);
		break;
	case SOAP_TYPE_d__MobileAuthenticateResponse:
		soap_serialize_d__MobileAuthenticateResponse(soap, (const struct d__MobileAuthenticateResponse *)ptr);
		break;
	case SOAP_TYPE_d__GetStatusInfo:
		soap_serialize_d__GetStatusInfo(soap, (const struct d__GetStatusInfo *)ptr);
		break;
	case SOAP_TYPE_d__GetStatusInfoResponse:
		soap_serialize_d__GetStatusInfoResponse(soap, (const struct d__GetStatusInfoResponse *)ptr);
		break;
	case SOAP_TYPE_d__MobileSign:
		soap_serialize_d__MobileSign(soap, (const struct d__MobileSign *)ptr);
		break;
	case SOAP_TYPE_d__MobileSignResponse:
		soap_serialize_d__MobileSignResponse(soap, (const struct d__MobileSignResponse *)ptr);
		break;
	case SOAP_TYPE_d__GetVersion:
		soap_serialize_d__GetVersion(soap, (const struct d__GetVersion *)ptr);
		break;
	case SOAP_TYPE_d__GetVersionResponse:
		soap_serialize_d__GetVersionResponse(soap, (const struct d__GetVersionResponse *)ptr);
		break;
	case SOAP_TYPE_d__RemoveSignature:
		soap_serialize_d__RemoveSignature(soap, (const struct d__RemoveSignature *)ptr);
		break;
	case SOAP_TYPE_d__RemoveSignatureResponse:
		soap_serialize_d__RemoveSignatureResponse(soap, (const struct d__RemoveSignatureResponse *)ptr);
		break;
	case SOAP_TYPE_d__FinalizeSignature:
		soap_serialize_d__FinalizeSignature(soap, (const struct d__FinalizeSignature *)ptr);
		break;
	case SOAP_TYPE_d__FinalizeSignatureResponse:
		soap_serialize_d__FinalizeSignatureResponse(soap, (const struct d__FinalizeSignatureResponse *)ptr);
		break;
	case SOAP_TYPE_d__PrepareSignature:
		soap_serialize_d__PrepareSignature(soap, (const struct d__PrepareSignature *)ptr);
		break;
	case SOAP_TYPE_d__PrepareSignatureResponse:
		soap_serialize_d__PrepareSignatureResponse(soap, (const struct d__PrepareSignatureResponse *)ptr);
		break;
	case SOAP_TYPE_d__GetSignatureModules:
		soap_serialize_d__GetSignatureModules(soap, (const struct d__GetSignatureModules *)ptr);
		break;
	case SOAP_TYPE_d__GetSignatureModulesResponse:
		soap_serialize_d__GetSignatureModulesResponse(soap, (const struct d__GetSignatureModulesResponse *)ptr);
		break;
	case SOAP_TYPE_d__SignatureModulesArray:
		soap_serialize_d__SignatureModulesArray(soap, (const struct d__SignatureModulesArray *)ptr);
		break;
	case SOAP_TYPE_d__SignatureModule:
		soap_serialize_d__SignatureModule(soap, (const struct d__SignatureModule *)ptr);
		break;
	case SOAP_TYPE_d__GetCRL:
		soap_serialize_d__GetCRL(soap, (const struct d__GetCRL *)ptr);
		break;
	case SOAP_TYPE_d__GetCRLResponse:
		soap_serialize_d__GetCRLResponse(soap, (const struct d__GetCRLResponse *)ptr);
		break;
	case SOAP_TYPE_d__GetTimestamp:
		soap_serialize_d__GetTimestamp(soap, (const struct d__GetTimestamp *)ptr);
		break;
	case SOAP_TYPE_d__GetTimestampResponse:
		soap_serialize_d__GetTimestampResponse(soap, (const struct d__GetTimestampResponse *)ptr);
		break;
	case SOAP_TYPE_d__GetTSACertificate:
		soap_serialize_d__GetTSACertificate(soap, (const struct d__GetTSACertificate *)ptr);
		break;
	case SOAP_TYPE_d__GetTSACertificateResponse:
		soap_serialize_d__GetTSACertificateResponse(soap, (const struct d__GetTSACertificateResponse *)ptr);
		break;
	case SOAP_TYPE_d__GetNotary:
		soap_serialize_d__GetNotary(soap, (const struct d__GetNotary *)ptr);
		break;
	case SOAP_TYPE_d__GetNotaryResponse:
		soap_serialize_d__GetNotaryResponse(soap, (const struct d__GetNotaryResponse *)ptr);
		break;
	case SOAP_TYPE_d__GetNotarysCertificate:
		soap_serialize_d__GetNotarysCertificate(soap, (const struct d__GetNotarysCertificate *)ptr);
		break;
	case SOAP_TYPE_d__GetNotarysCertificateResponse:
		soap_serialize_d__GetNotarysCertificateResponse(soap, (const struct d__GetNotarysCertificateResponse *)ptr);
		break;
	case SOAP_TYPE_d__GetSignersCertificate:
		soap_serialize_d__GetSignersCertificate(soap, (const struct d__GetSignersCertificate *)ptr);
		break;
	case SOAP_TYPE_d__GetSignersCertificateResponse:
		soap_serialize_d__GetSignersCertificateResponse(soap, (const struct d__GetSignersCertificateResponse *)ptr);
		break;
	case SOAP_TYPE_d__GetDataFile:
		soap_serialize_d__GetDataFile(soap, (const struct d__GetDataFile *)ptr);
		break;
	case SOAP_TYPE_d__GetDataFileResponse:
		soap_serialize_d__GetDataFileResponse(soap, (const struct d__GetDataFileResponse *)ptr);
		break;
	case SOAP_TYPE_d__GetSignedDocInfo:
		soap_serialize_d__GetSignedDocInfo(soap, (const struct d__GetSignedDocInfo *)ptr);
		break;
	case SOAP_TYPE_d__GetSignedDocInfoResponse:
		soap_serialize_d__GetSignedDocInfoResponse(soap, (const struct d__GetSignedDocInfoResponse *)ptr);
		break;
	case SOAP_TYPE_d__GetSignedDoc:
		soap_serialize_d__GetSignedDoc(soap, (const struct d__GetSignedDoc *)ptr);
		break;
	case SOAP_TYPE_d__GetSignedDocResponse:
		soap_serialize_d__GetSignedDocResponse(soap, (const struct d__GetSignedDocResponse *)ptr);
		break;
	case SOAP_TYPE_d__RemoveDataFile:
		soap_serialize_d__RemoveDataFile(soap, (const struct d__RemoveDataFile *)ptr);
		break;
	case SOAP_TYPE_d__RemoveDataFileResponse:
		soap_serialize_d__RemoveDataFileResponse(soap, (const struct d__RemoveDataFileResponse *)ptr);
		break;
	case SOAP_TYPE_d__AddDataFile:
		soap_serialize_d__AddDataFile(soap, (const struct d__AddDataFile *)ptr);
		break;
	case SOAP_TYPE_d__AddDataFileResponse:
		soap_serialize_d__AddDataFileResponse(soap, (const struct d__AddDataFileResponse *)ptr);
		break;
	case SOAP_TYPE_d__CreateSignedDoc:
		soap_serialize_d__CreateSignedDoc(soap, (const struct d__CreateSignedDoc *)ptr);
		break;
	case SOAP_TYPE_d__CreateSignedDocResponse:
		soap_serialize_d__CreateSignedDocResponse(soap, (const struct d__CreateSignedDocResponse *)ptr);
		break;
	case SOAP_TYPE_d__CloseSession:
		soap_serialize_d__CloseSession(soap, (const struct d__CloseSession *)ptr);
		break;
	case SOAP_TYPE_d__CloseSessionResponse:
		soap_serialize_d__CloseSessionResponse(soap, (const struct d__CloseSessionResponse *)ptr);
		break;
	case SOAP_TYPE_d__StartSession:
		soap_serialize_d__StartSession(soap, (const struct d__StartSession *)ptr);
		break;
	case SOAP_TYPE_d__StartSessionResponse:
		soap_serialize_d__StartSessionResponse(soap, (const struct d__StartSessionResponse *)ptr);
		break;
	case SOAP_TYPE_d__DataFileData:
		soap_serialize_d__DataFileData(soap, (const struct d__DataFileData *)ptr);
		break;
	case SOAP_TYPE_d__SignedDocInfo:
		soap_serialize_d__SignedDocInfo(soap, (const struct d__SignedDocInfo *)ptr);
		break;
	case SOAP_TYPE_d__SignatureInfo:
		soap_serialize_d__SignatureInfo(soap, (const struct d__SignatureInfo *)ptr);
		break;
	case SOAP_TYPE_d__Error:
		soap_serialize_d__Error(soap, (const struct d__Error *)ptr);
		break;
	case SOAP_TYPE_d__CRLInfo:
		soap_serialize_d__CRLInfo(soap, (const struct d__CRLInfo *)ptr);
		break;
	case SOAP_TYPE_d__RevokedInfo:
		soap_serialize_d__RevokedInfo(soap, (const struct d__RevokedInfo *)ptr);
		break;
	case SOAP_TYPE_d__TstInfo:
		soap_serialize_d__TstInfo(soap, (const struct d__TstInfo *)ptr);
		break;
	case SOAP_TYPE_d__ConfirmationInfo:
		soap_serialize_d__ConfirmationInfo(soap, (const struct d__ConfirmationInfo *)ptr);
		break;
	case SOAP_TYPE_d__SignerInfo:
		soap_serialize_d__SignerInfo(soap, (const struct d__SignerInfo *)ptr);
		break;
	case SOAP_TYPE_d__CertificateInfo:
		soap_serialize_d__CertificateInfo(soap, (const struct d__CertificateInfo *)ptr);
		break;
	case SOAP_TYPE_d__CertificatePolicy:
		soap_serialize_d__CertificatePolicy(soap, (const struct d__CertificatePolicy *)ptr);
		break;
	case SOAP_TYPE_d__SignatureProductionPlace:
		soap_serialize_d__SignatureProductionPlace(soap, (const struct d__SignatureProductionPlace *)ptr);
		break;
	case SOAP_TYPE_d__SignerRole:
		soap_serialize_d__SignerRole(soap, (const struct d__SignerRole *)ptr);
		break;
	case SOAP_TYPE_d__DataFileInfo:
		soap_serialize_d__DataFileInfo(soap, (const struct d__DataFileInfo *)ptr);
		break;
	case SOAP_TYPE_d__DataFileAttribute:
		soap_serialize_d__DataFileAttribute(soap, (const struct d__DataFileAttribute *)ptr);
		break;
	case SOAP_TYPE_xsd__hexBinary:
		soap_serialize_xsd__hexBinary(soap, (const struct xsd__hexBinary *)ptr);
		break;
	case SOAP_TYPE_PointerTomss_DummyResp:
		soap_serialize_PointerTomss_DummyResp(soap, (struct mss_DummyResp *const*)ptr);
		break;
	case SOAP_TYPE_PointerTod__GetMobileCreateSignatureStatusResponse:
		soap_serialize_PointerTod__GetMobileCreateSignatureStatusResponse(soap, (struct d__GetMobileCreateSignatureStatusResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTod__MobileCreateSignatureResponse:
		soap_serialize_PointerTod__MobileCreateSignatureResponse(soap, (struct d__MobileCreateSignatureResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTod__DataFileDigestList:
		soap_serialize_PointerTod__DataFileDigestList(soap, (struct d__DataFileDigestList *const*)ptr);
		break;
	case SOAP_TYPE_PointerTod__DataFileDigest:
		soap_serialize_PointerTod__DataFileDigest(soap, (struct d__DataFileDigest *const*)ptr);
		break;
	case SOAP_TYPE_PointerTod__GetMobileAuthenticateStatusResponse:
		soap_serialize_PointerTod__GetMobileAuthenticateStatusResponse(soap, (struct d__GetMobileAuthenticateStatusResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTod__MobileAuthenticateResponse:
		soap_serialize_PointerTod__MobileAuthenticateResponse(soap, (struct d__MobileAuthenticateResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTod__GetStatusInfoResponse:
		soap_serialize_PointerTod__GetStatusInfoResponse(soap, (struct d__GetStatusInfoResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTod__MobileSignResponse:
		soap_serialize_PointerTod__MobileSignResponse(soap, (struct d__MobileSignResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTod__GetVersionResponse:
		soap_serialize_PointerTod__GetVersionResponse(soap, (struct d__GetVersionResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTod__RemoveSignatureResponse:
		soap_serialize_PointerTod__RemoveSignatureResponse(soap, (struct d__RemoveSignatureResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTod__FinalizeSignatureResponse:
		soap_serialize_PointerTod__FinalizeSignatureResponse(soap, (struct d__FinalizeSignatureResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTod__PrepareSignatureResponse:
		soap_serialize_PointerTod__PrepareSignatureResponse(soap, (struct d__PrepareSignatureResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTod__GetSignatureModulesResponse:
		soap_serialize_PointerTod__GetSignatureModulesResponse(soap, (struct d__GetSignatureModulesResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTod__SignatureModulesArray:
		soap_serialize_PointerTod__SignatureModulesArray(soap, (struct d__SignatureModulesArray *const*)ptr);
		break;
	case SOAP_TYPE_PointerTod__SignatureModule:
		soap_serialize_PointerTod__SignatureModule(soap, (struct d__SignatureModule *const*)ptr);
		break;
	case SOAP_TYPE_PointerTod__GetCRLResponse:
		soap_serialize_PointerTod__GetCRLResponse(soap, (struct d__GetCRLResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTod__GetTimestampResponse:
		soap_serialize_PointerTod__GetTimestampResponse(soap, (struct d__GetTimestampResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTod__GetTSACertificateResponse:
		soap_serialize_PointerTod__GetTSACertificateResponse(soap, (struct d__GetTSACertificateResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTod__GetNotaryResponse:
		soap_serialize_PointerTod__GetNotaryResponse(soap, (struct d__GetNotaryResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTod__GetNotarysCertificateResponse:
		soap_serialize_PointerTod__GetNotarysCertificateResponse(soap, (struct d__GetNotarysCertificateResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTod__GetSignersCertificateResponse:
		soap_serialize_PointerTod__GetSignersCertificateResponse(soap, (struct d__GetSignersCertificateResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTod__GetDataFileResponse:
		soap_serialize_PointerTod__GetDataFileResponse(soap, (struct d__GetDataFileResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTod__GetSignedDocInfoResponse:
		soap_serialize_PointerTod__GetSignedDocInfoResponse(soap, (struct d__GetSignedDocInfoResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTod__GetSignedDocResponse:
		soap_serialize_PointerTod__GetSignedDocResponse(soap, (struct d__GetSignedDocResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTod__RemoveDataFileResponse:
		soap_serialize_PointerTod__RemoveDataFileResponse(soap, (struct d__RemoveDataFileResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTod__AddDataFileResponse:
		soap_serialize_PointerTod__AddDataFileResponse(soap, (struct d__AddDataFileResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTod__CreateSignedDocResponse:
		soap_serialize_PointerTod__CreateSignedDocResponse(soap, (struct d__CreateSignedDocResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTod__CloseSessionResponse:
		soap_serialize_PointerTod__CloseSessionResponse(soap, (struct d__CloseSessionResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTod__StartSessionResponse:
		soap_serialize_PointerTod__StartSessionResponse(soap, (struct d__StartSessionResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTod__DataFileData:
		soap_serialize_PointerTod__DataFileData(soap, (struct d__DataFileData *const*)ptr);
		break;
	case SOAP_TYPE_PointerTod__SignedDocInfo:
		soap_serialize_PointerTod__SignedDocInfo(soap, (struct d__SignedDocInfo *const*)ptr);
		break;
	case SOAP_TYPE_PointerTod__SignatureInfo:
		soap_serialize_PointerTod__SignatureInfo(soap, (struct d__SignatureInfo *const*)ptr);
		break;
	case SOAP_TYPE_PointerTod__DataFileInfo:
		soap_serialize_PointerTod__DataFileInfo(soap, (struct d__DataFileInfo *const*)ptr);
		break;
	case SOAP_TYPE_PointerTod__CRLInfo:
		soap_serialize_PointerTod__CRLInfo(soap, (struct d__CRLInfo *const*)ptr);
		break;
	case SOAP_TYPE_PointerTod__TstInfo:
		soap_serialize_PointerTod__TstInfo(soap, (struct d__TstInfo *const*)ptr);
		break;
	case SOAP_TYPE_PointerTod__ConfirmationInfo:
		soap_serialize_PointerTod__ConfirmationInfo(soap, (struct d__ConfirmationInfo *const*)ptr);
		break;
	case SOAP_TYPE_PointerTod__SignerInfo:
		soap_serialize_PointerTod__SignerInfo(soap, (struct d__SignerInfo *const*)ptr);
		break;
	case SOAP_TYPE_PointerTod__SignatureProductionPlace:
		soap_serialize_PointerTod__SignatureProductionPlace(soap, (struct d__SignatureProductionPlace *const*)ptr);
		break;
	case SOAP_TYPE_PointerTod__SignerRole:
		soap_serialize_PointerTod__SignerRole(soap, (struct d__SignerRole *const*)ptr);
		break;
	case SOAP_TYPE_PointerTod__Error:
		soap_serialize_PointerTod__Error(soap, (struct d__Error *const*)ptr);
		break;
	case SOAP_TYPE_PointerTod__RevokedInfo:
		soap_serialize_PointerTod__RevokedInfo(soap, (struct d__RevokedInfo *const*)ptr);
		break;
	case SOAP_TYPE_PointerTod__CertificateInfo:
		soap_serialize_PointerTod__CertificateInfo(soap, (struct d__CertificateInfo *const*)ptr);
		break;
	case SOAP_TYPE_PointerTod__CertificatePolicy:
		soap_serialize_PointerTod__CertificatePolicy(soap, (struct d__CertificatePolicy *const*)ptr);
		break;
	case SOAP_TYPE_PointerTod__DataFileAttribute:
		soap_serialize_PointerTod__DataFileAttribute(soap, (struct d__DataFileAttribute *const*)ptr);
		break;
	case SOAP_TYPE_PointerTounsignedByte:
		soap_serialize_PointerTounsignedByte(soap, (unsigned char *const*)ptr);
		break;
	case SOAP_TYPE_xsd__dateTime:
		soap_serialize_string(soap, (char**)&ptr);
		break;
	case SOAP_TYPE_xsd__anyURI:
		soap_serialize_string(soap, (char**)&ptr);
		break;
	case SOAP_TYPE_xsd__string:
		soap_serialize_string(soap, (char**)&ptr);
		break;
	case SOAP_TYPE__QName:
		soap_serialize_string(soap, (char**)&ptr);
		break;
	case SOAP_TYPE_string:
		soap_serialize_string(soap, (char**)&ptr);
		break;
	}
}
#endif

SOAP_FMAC3 void SOAP_FMAC4 soap_default_byte(struct soap *soap, char *a)
{	(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_byte
	*a = SOAP_DEFAULT_byte;
#else
	*a = (char)0;
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_byte(struct soap *soap, const char *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_byte);
	if (soap_out_byte(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_byte(struct soap *soap, const char *tag, int id, const char *a, const char *type)
{
	return soap_outbyte(soap, tag, id, a, type, SOAP_TYPE_byte);
}

SOAP_FMAC3 char * SOAP_FMAC4 soap_get_byte(struct soap *soap, char *p, const char *tag, const char *type)
{
	if ((p = soap_in_byte(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 char * SOAP_FMAC4 soap_in_byte(struct soap *soap, const char *tag, char *a, const char *type)
{
	return soap_inbyte(soap, tag, a, type, SOAP_TYPE_byte);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_int(struct soap *soap, int *a)
{	(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_int
	*a = SOAP_DEFAULT_int;
#else
	*a = (int)0;
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_int(struct soap *soap, const int *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_int);
	if (soap_out_int(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_int(struct soap *soap, const char *tag, int id, const int *a, const char *type)
{
	return soap_outint(soap, tag, id, a, type, SOAP_TYPE_int);
}

SOAP_FMAC3 int * SOAP_FMAC4 soap_get_int(struct soap *soap, int *p, const char *tag, const char *type)
{
	if ((p = soap_in_int(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 int * SOAP_FMAC4 soap_in_int(struct soap *soap, const char *tag, int *a, const char *type)
{
	return soap_inint(soap, tag, a, type, SOAP_TYPE_int);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_xsd__int(struct soap *soap, long *a)
{	soap_default_long(soap, a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_xsd__int(struct soap *soap, const long *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_xsd__int);
	if (soap_out_xsd__int(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_xsd__int(struct soap *soap, const char *tag, int id, const long *a, const char *type)
{
	return soap_outlong(soap, tag, id, a, type, SOAP_TYPE_xsd__int);
}

SOAP_FMAC3 long * SOAP_FMAC4 soap_get_xsd__int(struct soap *soap, long *p, const char *tag, const char *type)
{
	if ((p = soap_in_xsd__int(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 long * SOAP_FMAC4 soap_in_xsd__int(struct soap *soap, const char *tag, long *a, const char *type)
{
	return soap_inlong(soap, tag, a, type, SOAP_TYPE_xsd__int);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_long(struct soap *soap, long *a)
{	(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_long
	*a = SOAP_DEFAULT_long;
#else
	*a = (long)0;
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_long(struct soap *soap, const long *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_long);
	if (soap_out_long(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_long(struct soap *soap, const char *tag, int id, const long *a, const char *type)
{
	return soap_outlong(soap, tag, id, a, type, SOAP_TYPE_long);
}

SOAP_FMAC3 long * SOAP_FMAC4 soap_get_long(struct soap *soap, long *p, const char *tag, const char *type)
{
	if ((p = soap_in_long(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 long * SOAP_FMAC4 soap_in_long(struct soap *soap, const char *tag, long *a, const char *type)
{
	return soap_inlong(soap, tag, a, type, SOAP_TYPE_long);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_LONG64(struct soap *soap, LONG64 *a)
{	(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_LONG64
	*a = SOAP_DEFAULT_LONG64;
#else
	*a = (LONG64)0;
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_LONG64(struct soap *soap, const LONG64 *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_LONG64);
	if (soap_out_LONG64(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_LONG64(struct soap *soap, const char *tag, int id, const LONG64 *a, const char *type)
{
	return soap_outLONG64(soap, tag, id, a, type, SOAP_TYPE_LONG64);
}

SOAP_FMAC3 LONG64 * SOAP_FMAC4 soap_get_LONG64(struct soap *soap, LONG64 *p, const char *tag, const char *type)
{
	if ((p = soap_in_LONG64(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 LONG64 * SOAP_FMAC4 soap_in_LONG64(struct soap *soap, const char *tag, LONG64 *a, const char *type)
{
	return soap_inLONG64(soap, tag, a, type, SOAP_TYPE_LONG64);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_xsd__float(struct soap *soap, float *a)
{	soap_default_float(soap, a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_xsd__float(struct soap *soap, const float *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_xsd__float);
	if (soap_out_xsd__float(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_xsd__float(struct soap *soap, const char *tag, int id, const float *a, const char *type)
{
	return soap_outfloat(soap, tag, id, a, type, SOAP_TYPE_xsd__float);
}

SOAP_FMAC3 float * SOAP_FMAC4 soap_get_xsd__float(struct soap *soap, float *p, const char *tag, const char *type)
{
	if ((p = soap_in_xsd__float(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 float * SOAP_FMAC4 soap_in_xsd__float(struct soap *soap, const char *tag, float *a, const char *type)
{
	return soap_infloat(soap, tag, a, type, SOAP_TYPE_xsd__float);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_float(struct soap *soap, float *a)
{	(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_float
	*a = SOAP_DEFAULT_float;
#else
	*a = (float)0;
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_float(struct soap *soap, const float *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_float);
	if (soap_out_float(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_float(struct soap *soap, const char *tag, int id, const float *a, const char *type)
{
	return soap_outfloat(soap, tag, id, a, type, SOAP_TYPE_float);
}

SOAP_FMAC3 float * SOAP_FMAC4 soap_get_float(struct soap *soap, float *p, const char *tag, const char *type)
{
	if ((p = soap_in_float(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 float * SOAP_FMAC4 soap_in_float(struct soap *soap, const char *tag, float *a, const char *type)
{
	return soap_infloat(soap, tag, a, type, SOAP_TYPE_float);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_unsignedByte(struct soap *soap, unsigned char *a)
{	(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_unsignedByte
	*a = SOAP_DEFAULT_unsignedByte;
#else
	*a = (unsigned char)0;
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_unsignedByte(struct soap *soap, const unsigned char *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_unsignedByte);
	if (soap_out_unsignedByte(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_unsignedByte(struct soap *soap, const char *tag, int id, const unsigned char *a, const char *type)
{
	return soap_outunsignedByte(soap, tag, id, a, type, SOAP_TYPE_unsignedByte);
}

SOAP_FMAC3 unsigned char * SOAP_FMAC4 soap_get_unsignedByte(struct soap *soap, unsigned char *p, const char *tag, const char *type)
{
	if ((p = soap_in_unsignedByte(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 unsigned char * SOAP_FMAC4 soap_in_unsignedByte(struct soap *soap, const char *tag, unsigned char *a, const char *type)
{
	return soap_inunsignedByte(soap, tag, a, type, SOAP_TYPE_unsignedByte);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_unsignedInt(struct soap *soap, unsigned int *a)
{	(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_unsignedInt
	*a = SOAP_DEFAULT_unsignedInt;
#else
	*a = (unsigned int)0;
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_unsignedInt(struct soap *soap, const unsigned int *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_unsignedInt);
	if (soap_out_unsignedInt(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_unsignedInt(struct soap *soap, const char *tag, int id, const unsigned int *a, const char *type)
{
	return soap_outunsignedInt(soap, tag, id, a, type, SOAP_TYPE_unsignedInt);
}

SOAP_FMAC3 unsigned int * SOAP_FMAC4 soap_get_unsignedInt(struct soap *soap, unsigned int *p, const char *tag, const char *type)
{
	if ((p = soap_in_unsignedInt(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 unsigned int * SOAP_FMAC4 soap_in_unsignedInt(struct soap *soap, const char *tag, unsigned int *a, const char *type)
{
	return soap_inunsignedInt(soap, tag, a, type, SOAP_TYPE_unsignedInt);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_xsd__positiveInteger(struct soap *soap, ULONG64 *a)
{	soap_default_unsignedLONG64(soap, a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_xsd__positiveInteger(struct soap *soap, const ULONG64 *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_xsd__positiveInteger);
	if (soap_out_xsd__positiveInteger(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_xsd__positiveInteger(struct soap *soap, const char *tag, int id, const ULONG64 *a, const char *type)
{
	return soap_outULONG64(soap, tag, id, a, type, SOAP_TYPE_xsd__positiveInteger);
}

SOAP_FMAC3 ULONG64 * SOAP_FMAC4 soap_get_xsd__positiveInteger(struct soap *soap, ULONG64 *p, const char *tag, const char *type)
{
	if ((p = soap_in_xsd__positiveInteger(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 ULONG64 * SOAP_FMAC4 soap_in_xsd__positiveInteger(struct soap *soap, const char *tag, ULONG64 *a, const char *type)
{
	return soap_inULONG64(soap, tag, a, type, SOAP_TYPE_xsd__positiveInteger);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_unsignedLONG64(struct soap *soap, ULONG64 *a)
{	(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_unsignedLONG64
	*a = SOAP_DEFAULT_unsignedLONG64;
#else
	*a = (ULONG64)0;
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_unsignedLONG64(struct soap *soap, const ULONG64 *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_unsignedLONG64);
	if (soap_out_unsignedLONG64(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_unsignedLONG64(struct soap *soap, const char *tag, int id, const ULONG64 *a, const char *type)
{
	return soap_outULONG64(soap, tag, id, a, type, SOAP_TYPE_unsignedLONG64);
}

SOAP_FMAC3 ULONG64 * SOAP_FMAC4 soap_get_unsignedLONG64(struct soap *soap, ULONG64 *p, const char *tag, const char *type)
{
	if ((p = soap_in_unsignedLONG64(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 ULONG64 * SOAP_FMAC4 soap_in_unsignedLONG64(struct soap *soap, const char *tag, ULONG64 *a, const char *type)
{
	return soap_inULONG64(soap, tag, a, type, SOAP_TYPE_unsignedLONG64);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_xsd__boolean(struct soap *soap, bool *a)
{	soap_default_bool(soap, a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_xsd__boolean(struct soap *soap, const bool *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_xsd__boolean);
	if (soap_out_xsd__boolean(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3S const char* SOAP_FMAC4S soap_xsd__boolean2s(struct soap *soap, bool n)
{	return soap_bool2s(soap, n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_xsd__boolean(struct soap *soap, const char *tag, int id, const bool *a, const char *type)
{	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_xsd__boolean), type);
	soap_send(soap, soap_xsd__boolean2s(soap, *a));
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 bool * SOAP_FMAC4 soap_get_xsd__boolean(struct soap *soap, bool *p, const char *tag, const char *type)
{
	if ((p = soap_in_xsd__boolean(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2xsd__boolean(struct soap *soap, const char *s, bool *a)
{
	return soap_s2bool(soap, s, a);
}

SOAP_FMAC3 bool * SOAP_FMAC4 soap_in_xsd__boolean(struct soap *soap, const char *tag, bool *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, NULL))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type) && soap_match_tag(soap, soap->type, ":boolean"))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (bool *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_xsd__boolean, sizeof(bool), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (soap->body && !*soap->href)
	{	if (!a || soap_s2xsd__boolean(soap, soap_value(soap), a) || soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (bool *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_xsd__boolean, 0, sizeof(bool), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_bool(struct soap *soap, bool *a)
{	(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_bool
	*a = SOAP_DEFAULT_bool;
#else
	*a = (bool)0;
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_bool(struct soap *soap, const bool *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_bool);
	if (soap_out_bool(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

static const struct soap_code_map soap_codes_bool[] =
{	{ (long)false, "false" },
	{ (long)true, "true" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_bool2s(struct soap *soap, bool n)
{	return soap_code_str(soap_codes_bool, n!=0);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_bool(struct soap *soap, const char *tag, int id, const bool *a, const char *type)
{	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_bool), type);
	soap_send(soap, soap_bool2s(soap, *a));
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 bool * SOAP_FMAC4 soap_get_bool(struct soap *soap, bool *p, const char *tag, const char *type)
{
	if ((p = soap_in_bool(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2bool(struct soap *soap, const char *s, bool *a)
{
	const struct soap_code_map *map;
	if (!s)
		return SOAP_OK;
	map = soap_code(soap_codes_bool, s);
	if (map)
		*a = (bool)(map->code != 0);
	else
	{	long n;
		if (soap_s2long(soap, s, &n) || n < 0 || n > 1)
			return soap->error = SOAP_TYPE;
		*a = (bool)(n != 0);
	}
	return SOAP_OK;
}

SOAP_FMAC3 bool * SOAP_FMAC4 soap_in_bool(struct soap *soap, const char *tag, bool *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, NULL))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type) && soap_match_tag(soap, soap->type, ":boolean"))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (bool *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_bool, sizeof(bool), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (soap->body && !*soap->href)
	{	if (!a || soap_s2bool(soap, soap_value(soap), a) || soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (bool *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_bool, 0, sizeof(bool), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

#ifndef WITH_NOGLOBAL

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_SOAP_ENV__Fault(struct soap *soap, const struct SOAP_ENV__Fault *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize__QName(soap, &a->faultcode);
	soap_serialize_string(soap, &a->faultstring);
	soap_serialize_string(soap, &a->faultactor);
	soap_serialize_PointerToSOAP_ENV__Detail(soap, &a->detail);
	soap_serialize_PointerToSOAP_ENV__Code(soap, &a->SOAP_ENV__Code);
	soap_serialize_PointerToSOAP_ENV__Reason(soap, &a->SOAP_ENV__Reason);
	soap_serialize_string(soap, &a->SOAP_ENV__Node);
	soap_serialize_string(soap, &a->SOAP_ENV__Role);
	soap_serialize_PointerToSOAP_ENV__Detail(soap, &a->SOAP_ENV__Detail);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_SOAP_ENV__Fault(struct soap *soap, struct SOAP_ENV__Fault *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default__QName(soap, &a->faultcode);
	soap_default_string(soap, &a->faultstring);
	soap_default_string(soap, &a->faultactor);
	a->detail = NULL;
	a->SOAP_ENV__Code = NULL;
	a->SOAP_ENV__Reason = NULL;
	soap_default_string(soap, &a->SOAP_ENV__Node);
	soap_default_string(soap, &a->SOAP_ENV__Role);
	a->SOAP_ENV__Detail = NULL;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_SOAP_ENV__Fault(struct soap *soap, const struct SOAP_ENV__Fault *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_SOAP_ENV__Fault);
	if (soap_out_SOAP_ENV__Fault(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SOAP_ENV__Fault(struct soap *soap, const char *tag, int id, const struct SOAP_ENV__Fault *a, const char *type)
{
	const char *soap_tmp_faultcode = soap_QName2s(soap, a->faultcode);
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SOAP_ENV__Fault), type);
	soap_out__QName(soap, "faultcode", -1, (char*const*)&soap_tmp_faultcode, "");
	soap_out_string(soap, "faultstring", -1, &a->faultstring, "");
	soap_out_string(soap, "faultactor", -1, &a->faultactor, "");
	soap_out_PointerToSOAP_ENV__Detail(soap, "detail", -1, &a->detail, "");
	soap_out_PointerToSOAP_ENV__Code(soap, "SOAP-ENV:Code", -1, &a->SOAP_ENV__Code, "");
	soap_out_PointerToSOAP_ENV__Reason(soap, "SOAP-ENV:Reason", -1, &a->SOAP_ENV__Reason, "");
	soap_out_string(soap, "SOAP-ENV:Node", -1, &a->SOAP_ENV__Node, "");
	soap_out_string(soap, "SOAP-ENV:Role", -1, &a->SOAP_ENV__Role, "");
	soap_out_PointerToSOAP_ENV__Detail(soap, "SOAP-ENV:Detail", -1, &a->SOAP_ENV__Detail, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct SOAP_ENV__Fault * SOAP_FMAC4 soap_get_SOAP_ENV__Fault(struct soap *soap, struct SOAP_ENV__Fault *p, const char *tag, const char *type)
{
	if ((p = soap_in_SOAP_ENV__Fault(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct SOAP_ENV__Fault * SOAP_FMAC4 soap_in_SOAP_ENV__Fault(struct soap *soap, const char *tag, struct SOAP_ENV__Fault *a, const char *type)
{
	short soap_flag_faultcode = 1, soap_flag_faultstring = 1, soap_flag_faultactor = 1, soap_flag_detail = 1, soap_flag_SOAP_ENV__Code = 1, soap_flag_SOAP_ENV__Reason = 1, soap_flag_SOAP_ENV__Node = 1, soap_flag_SOAP_ENV__Role = 1, soap_flag_SOAP_ENV__Detail = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct SOAP_ENV__Fault *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_SOAP_ENV__Fault, sizeof(struct SOAP_ENV__Fault), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_SOAP_ENV__Fault(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_faultcode && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in__QName(soap, "faultcode", &a->faultcode, ""))
				{	soap_flag_faultcode--;
					continue;
				}
			if (soap_flag_faultstring && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "faultstring", &a->faultstring, "xsd:string"))
				{	soap_flag_faultstring--;
					continue;
				}
			if (soap_flag_faultactor && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "faultactor", &a->faultactor, "xsd:string"))
				{	soap_flag_faultactor--;
					continue;
				}
			if (soap_flag_detail && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSOAP_ENV__Detail(soap, "detail", &a->detail, ""))
				{	soap_flag_detail--;
					continue;
				}
			if (soap_flag_SOAP_ENV__Code && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSOAP_ENV__Code(soap, "SOAP-ENV:Code", &a->SOAP_ENV__Code, ""))
				{	soap_flag_SOAP_ENV__Code--;
					continue;
				}
			if (soap_flag_SOAP_ENV__Reason && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSOAP_ENV__Reason(soap, "SOAP-ENV:Reason", &a->SOAP_ENV__Reason, ""))
				{	soap_flag_SOAP_ENV__Reason--;
					continue;
				}
			if (soap_flag_SOAP_ENV__Node && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "SOAP-ENV:Node", &a->SOAP_ENV__Node, "xsd:string"))
				{	soap_flag_SOAP_ENV__Node--;
					continue;
				}
			if (soap_flag_SOAP_ENV__Role && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "SOAP-ENV:Role", &a->SOAP_ENV__Role, "xsd:string"))
				{	soap_flag_SOAP_ENV__Role--;
					continue;
				}
			if (soap_flag_SOAP_ENV__Detail && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSOAP_ENV__Detail(soap, "SOAP-ENV:Detail", &a->SOAP_ENV__Detail, ""))
				{	soap_flag_SOAP_ENV__Detail--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct SOAP_ENV__Fault *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_SOAP_ENV__Fault, 0, sizeof(struct SOAP_ENV__Fault), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

#endif

#ifndef WITH_NOGLOBAL

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_SOAP_ENV__Reason(struct soap *soap, const struct SOAP_ENV__Reason *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->SOAP_ENV__Text);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_SOAP_ENV__Reason(struct soap *soap, struct SOAP_ENV__Reason *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->SOAP_ENV__Text);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_SOAP_ENV__Reason(struct soap *soap, const struct SOAP_ENV__Reason *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_SOAP_ENV__Reason);
	if (soap_out_SOAP_ENV__Reason(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SOAP_ENV__Reason(struct soap *soap, const char *tag, int id, const struct SOAP_ENV__Reason *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SOAP_ENV__Reason), type);
	soap_out_string(soap, "SOAP-ENV:Text", -1, &a->SOAP_ENV__Text, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct SOAP_ENV__Reason * SOAP_FMAC4 soap_get_SOAP_ENV__Reason(struct soap *soap, struct SOAP_ENV__Reason *p, const char *tag, const char *type)
{
	if ((p = soap_in_SOAP_ENV__Reason(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct SOAP_ENV__Reason * SOAP_FMAC4 soap_in_SOAP_ENV__Reason(struct soap *soap, const char *tag, struct SOAP_ENV__Reason *a, const char *type)
{
	short soap_flag_SOAP_ENV__Text = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct SOAP_ENV__Reason *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_SOAP_ENV__Reason, sizeof(struct SOAP_ENV__Reason), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_SOAP_ENV__Reason(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_SOAP_ENV__Text && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "SOAP-ENV:Text", &a->SOAP_ENV__Text, "xsd:string"))
				{	soap_flag_SOAP_ENV__Text--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct SOAP_ENV__Reason *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_SOAP_ENV__Reason, 0, sizeof(struct SOAP_ENV__Reason), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

#endif

#ifndef WITH_NOGLOBAL

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_SOAP_ENV__Detail(struct soap *soap, const struct SOAP_ENV__Detail *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_markelement(soap, a->fault, a->__type);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_SOAP_ENV__Detail(struct soap *soap, struct SOAP_ENV__Detail *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->__type = 0;
	a->fault = NULL;
	a->__any = NULL;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_SOAP_ENV__Detail(struct soap *soap, const struct SOAP_ENV__Detail *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_SOAP_ENV__Detail);
	if (soap_out_SOAP_ENV__Detail(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SOAP_ENV__Detail(struct soap *soap, const char *tag, int id, const struct SOAP_ENV__Detail *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SOAP_ENV__Detail), type);
	soap_putelement(soap, a->fault, "fault", -1, a->__type);
	soap_outliteral(soap, "-any", &a->__any, NULL);
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct SOAP_ENV__Detail * SOAP_FMAC4 soap_get_SOAP_ENV__Detail(struct soap *soap, struct SOAP_ENV__Detail *p, const char *tag, const char *type)
{
	if ((p = soap_in_SOAP_ENV__Detail(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct SOAP_ENV__Detail * SOAP_FMAC4 soap_in_SOAP_ENV__Detail(struct soap *soap, const char *tag, struct SOAP_ENV__Detail *a, const char *type)
{
	short soap_flag_fault = 1, soap_flag___any = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct SOAP_ENV__Detail *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_SOAP_ENV__Detail, sizeof(struct SOAP_ENV__Detail), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_SOAP_ENV__Detail(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_fault && soap->error == SOAP_TAG_MISMATCH)
				if ((a->fault = soap_getelement(soap, &a->__type)))
				{	soap_flag_fault = 0;
					continue;
				}
			if (soap_flag___any && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_inliteral(soap, "-any", &a->__any))
				{	soap_flag___any--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct SOAP_ENV__Detail *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_SOAP_ENV__Detail, 0, sizeof(struct SOAP_ENV__Detail), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

#endif

#ifndef WITH_NOGLOBAL

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_SOAP_ENV__Code(struct soap *soap, const struct SOAP_ENV__Code *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize__QName(soap, &a->SOAP_ENV__Value);
	soap_serialize_PointerToSOAP_ENV__Code(soap, &a->SOAP_ENV__Subcode);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_SOAP_ENV__Code(struct soap *soap, struct SOAP_ENV__Code *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default__QName(soap, &a->SOAP_ENV__Value);
	a->SOAP_ENV__Subcode = NULL;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_SOAP_ENV__Code(struct soap *soap, const struct SOAP_ENV__Code *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_SOAP_ENV__Code);
	if (soap_out_SOAP_ENV__Code(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SOAP_ENV__Code(struct soap *soap, const char *tag, int id, const struct SOAP_ENV__Code *a, const char *type)
{
	const char *soap_tmp_SOAP_ENV__Value = soap_QName2s(soap, a->SOAP_ENV__Value);
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SOAP_ENV__Code), type);
	soap_out__QName(soap, "SOAP-ENV:Value", -1, (char*const*)&soap_tmp_SOAP_ENV__Value, "");
	soap_out_PointerToSOAP_ENV__Code(soap, "SOAP-ENV:Subcode", -1, &a->SOAP_ENV__Subcode, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct SOAP_ENV__Code * SOAP_FMAC4 soap_get_SOAP_ENV__Code(struct soap *soap, struct SOAP_ENV__Code *p, const char *tag, const char *type)
{
	if ((p = soap_in_SOAP_ENV__Code(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct SOAP_ENV__Code * SOAP_FMAC4 soap_in_SOAP_ENV__Code(struct soap *soap, const char *tag, struct SOAP_ENV__Code *a, const char *type)
{
	short soap_flag_SOAP_ENV__Value = 1, soap_flag_SOAP_ENV__Subcode = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct SOAP_ENV__Code *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_SOAP_ENV__Code, sizeof(struct SOAP_ENV__Code), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_SOAP_ENV__Code(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_SOAP_ENV__Value && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in__QName(soap, "SOAP-ENV:Value", &a->SOAP_ENV__Value, ""))
				{	soap_flag_SOAP_ENV__Value--;
					continue;
				}
			if (soap_flag_SOAP_ENV__Subcode && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSOAP_ENV__Code(soap, "SOAP-ENV:Subcode", &a->SOAP_ENV__Subcode, ""))
				{	soap_flag_SOAP_ENV__Subcode--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct SOAP_ENV__Code *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_SOAP_ENV__Code, 0, sizeof(struct SOAP_ENV__Code), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

#endif

#ifndef WITH_NOGLOBAL

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_SOAP_ENV__Header(struct soap *soap, const struct SOAP_ENV__Header *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	/* transient dummy skipped */
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_SOAP_ENV__Header(struct soap *soap, struct SOAP_ENV__Header *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	/* transient dummy skipped */
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_SOAP_ENV__Header(struct soap *soap, const struct SOAP_ENV__Header *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_SOAP_ENV__Header);
	if (soap_out_SOAP_ENV__Header(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SOAP_ENV__Header(struct soap *soap, const char *tag, int id, const struct SOAP_ENV__Header *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SOAP_ENV__Header), type);
	/* transient dummy skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct SOAP_ENV__Header * SOAP_FMAC4 soap_get_SOAP_ENV__Header(struct soap *soap, struct SOAP_ENV__Header *p, const char *tag, const char *type)
{
	if ((p = soap_in_SOAP_ENV__Header(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct SOAP_ENV__Header * SOAP_FMAC4 soap_in_SOAP_ENV__Header(struct soap *soap, const char *tag, struct SOAP_ENV__Header *a, const char *type)
{;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct SOAP_ENV__Header *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_SOAP_ENV__Header, sizeof(struct SOAP_ENV__Header), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_SOAP_ENV__Header(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
		/* transient dummy skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct SOAP_ENV__Header *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_SOAP_ENV__Header, 0, sizeof(struct SOAP_ENV__Header), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

#endif

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_mss__MSS_USCORESignatureDummy(struct soap *soap, const struct mss__MSS_USCORESignatureDummy *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_mss__MSS_USCORESignatureDummy(struct soap *soap, struct mss__MSS_USCORESignatureDummy *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_mss__MSS_USCORESignatureDummy(struct soap *soap, const struct mss__MSS_USCORESignatureDummy *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_mss__MSS_USCORESignatureDummy);
	if (soap_out_mss__MSS_USCORESignatureDummy(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_mss__MSS_USCORESignatureDummy(struct soap *soap, const char *tag, int id, const struct mss__MSS_USCORESignatureDummy *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_mss__MSS_USCORESignatureDummy), type);
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct mss__MSS_USCORESignatureDummy * SOAP_FMAC4 soap_get_mss__MSS_USCORESignatureDummy(struct soap *soap, struct mss__MSS_USCORESignatureDummy *p, const char *tag, const char *type)
{
	if ((p = soap_in_mss__MSS_USCORESignatureDummy(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct mss__MSS_USCORESignatureDummy * SOAP_FMAC4 soap_in_mss__MSS_USCORESignatureDummy(struct soap *soap, const char *tag, struct mss__MSS_USCORESignatureDummy *a, const char *type)
{;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct mss__MSS_USCORESignatureDummy *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_mss__MSS_USCORESignatureDummy, sizeof(struct mss__MSS_USCORESignatureDummy), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_mss__MSS_USCORESignatureDummy(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct mss__MSS_USCORESignatureDummy *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_mss__MSS_USCORESignatureDummy, 0, sizeof(struct mss__MSS_USCORESignatureDummy), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_mss_DummyResp(struct soap *soap, const struct mss_DummyResp *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_xsd__string(soap, &a->str);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_mss_DummyResp(struct soap *soap, struct mss_DummyResp *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_xsd__string(soap, &a->str);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_mss_DummyResp(struct soap *soap, const struct mss_DummyResp *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_mss_DummyResp);
	if (soap_out_mss_DummyResp(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_mss_DummyResp(struct soap *soap, const char *tag, int id, const struct mss_DummyResp *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_mss_DummyResp), type);
	if (a->str)
		soap_element_result(soap, "str");
	soap_out_xsd__string(soap, "str", -1, &a->str, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct mss_DummyResp * SOAP_FMAC4 soap_get_mss_DummyResp(struct soap *soap, struct mss_DummyResp *p, const char *tag, const char *type)
{
	if ((p = soap_in_mss_DummyResp(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct mss_DummyResp * SOAP_FMAC4 soap_in_mss_DummyResp(struct soap *soap, const char *tag, struct mss_DummyResp *a, const char *type)
{
	short soap_flag_str = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct mss_DummyResp *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_mss_DummyResp, sizeof(struct mss_DummyResp), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_mss_DummyResp(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_str && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "str", &a->str, "xsd:string"))
				{	soap_flag_str--;
					continue;
				}
			soap_check_result(soap, "str");
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct mss_DummyResp *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_mss_DummyResp, 0, sizeof(struct mss_DummyResp), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_d__GetMobileCreateSignatureStatus(struct soap *soap, const struct d__GetMobileCreateSignatureStatus *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_d__GetMobileCreateSignatureStatus(struct soap *soap, struct d__GetMobileCreateSignatureStatus *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_xsd__int(soap, &a->Sesscode);
	soap_default_xsd__boolean(soap, &a->WaitSignature);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_d__GetMobileCreateSignatureStatus(struct soap *soap, const struct d__GetMobileCreateSignatureStatus *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_d__GetMobileCreateSignatureStatus);
	if (soap_out_d__GetMobileCreateSignatureStatus(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_d__GetMobileCreateSignatureStatus(struct soap *soap, const char *tag, int id, const struct d__GetMobileCreateSignatureStatus *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_d__GetMobileCreateSignatureStatus), type);
	soap_out_xsd__int(soap, "Sesscode", -1, &a->Sesscode, "");
	soap_out_xsd__boolean(soap, "WaitSignature", -1, &a->WaitSignature, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct d__GetMobileCreateSignatureStatus * SOAP_FMAC4 soap_get_d__GetMobileCreateSignatureStatus(struct soap *soap, struct d__GetMobileCreateSignatureStatus *p, const char *tag, const char *type)
{
	if ((p = soap_in_d__GetMobileCreateSignatureStatus(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct d__GetMobileCreateSignatureStatus * SOAP_FMAC4 soap_in_d__GetMobileCreateSignatureStatus(struct soap *soap, const char *tag, struct d__GetMobileCreateSignatureStatus *a, const char *type)
{
	short soap_flag_Sesscode = 1, soap_flag_WaitSignature = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct d__GetMobileCreateSignatureStatus *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_d__GetMobileCreateSignatureStatus, sizeof(struct d__GetMobileCreateSignatureStatus), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_d__GetMobileCreateSignatureStatus(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_Sesscode && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_xsd__int(soap, "Sesscode", &a->Sesscode, "xsd:int"))
				{	soap_flag_Sesscode--;
					continue;
				}
			if (soap_flag_WaitSignature && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_xsd__boolean(soap, "WaitSignature", &a->WaitSignature, "xsd:boolean"))
				{	soap_flag_WaitSignature--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_Sesscode > 0 || soap_flag_WaitSignature > 0))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct d__GetMobileCreateSignatureStatus *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_d__GetMobileCreateSignatureStatus, 0, sizeof(struct d__GetMobileCreateSignatureStatus), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_d__GetMobileCreateSignatureStatusResponse(struct soap *soap, const struct d__GetMobileCreateSignatureStatusResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_xsd__string(soap, &a->Status);
	soap_serialize_xsd__string(soap, &a->Signature);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_d__GetMobileCreateSignatureStatusResponse(struct soap *soap, struct d__GetMobileCreateSignatureStatusResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_xsd__int(soap, &a->Sesscode);
	soap_default_xsd__string(soap, &a->Status);
	soap_default_xsd__string(soap, &a->Signature);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_d__GetMobileCreateSignatureStatusResponse(struct soap *soap, const struct d__GetMobileCreateSignatureStatusResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_d__GetMobileCreateSignatureStatusResponse);
	if (soap_out_d__GetMobileCreateSignatureStatusResponse(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_d__GetMobileCreateSignatureStatusResponse(struct soap *soap, const char *tag, int id, const struct d__GetMobileCreateSignatureStatusResponse *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_d__GetMobileCreateSignatureStatusResponse), type);
	soap_element_result(soap, "Sesscode");
	soap_out_xsd__int(soap, "Sesscode", -1, &a->Sesscode, "");
	soap_out_xsd__string(soap, "Status", -1, &a->Status, "");
	soap_out_xsd__string(soap, "Signature", -1, &a->Signature, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct d__GetMobileCreateSignatureStatusResponse * SOAP_FMAC4 soap_get_d__GetMobileCreateSignatureStatusResponse(struct soap *soap, struct d__GetMobileCreateSignatureStatusResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_d__GetMobileCreateSignatureStatusResponse(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct d__GetMobileCreateSignatureStatusResponse * SOAP_FMAC4 soap_in_d__GetMobileCreateSignatureStatusResponse(struct soap *soap, const char *tag, struct d__GetMobileCreateSignatureStatusResponse *a, const char *type)
{
	short soap_flag_Sesscode = 1, soap_flag_Status = 1, soap_flag_Signature = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct d__GetMobileCreateSignatureStatusResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_d__GetMobileCreateSignatureStatusResponse, sizeof(struct d__GetMobileCreateSignatureStatusResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_d__GetMobileCreateSignatureStatusResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_Sesscode && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_xsd__int(soap, "Sesscode", &a->Sesscode, "xsd:int"))
				{	soap_flag_Sesscode--;
					continue;
				}
			if (soap_flag_Status && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "Status", &a->Status, "xsd:string"))
				{	soap_flag_Status--;
					continue;
				}
			if (soap_flag_Signature && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "Signature", &a->Signature, "xsd:string"))
				{	soap_flag_Signature--;
					continue;
				}
			soap_check_result(soap, "Sesscode");
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_Sesscode > 0))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct d__GetMobileCreateSignatureStatusResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_d__GetMobileCreateSignatureStatusResponse, 0, sizeof(struct d__GetMobileCreateSignatureStatusResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_d__MobileCreateSignature(struct soap *soap, const struct d__MobileCreateSignature *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_xsd__string(soap, &a->IDCode);
	soap_serialize_xsd__string(soap, &a->SignersCountry);
	soap_serialize_xsd__string(soap, &a->PhoneNo);
	soap_serialize_xsd__string(soap, &a->Language);
	soap_serialize_xsd__string(soap, &a->ServiceName);
	soap_serialize_xsd__string(soap, &a->MessageToDisplay);
	soap_serialize_xsd__string(soap, &a->Role);
	soap_serialize_xsd__string(soap, &a->City);
	soap_serialize_xsd__string(soap, &a->StateOrProvince);
	soap_serialize_xsd__string(soap, &a->PostalCode);
	soap_serialize_xsd__string(soap, &a->CountryName);
	soap_serialize_xsd__string(soap, &a->SigningProfile);
	soap_serialize_PointerTod__DataFileDigestList(soap, &a->DataFiles);
	soap_serialize_xsd__string(soap, &a->Format);
	soap_serialize_xsd__string(soap, &a->Version);
	soap_serialize_xsd__string(soap, &a->SignatureID);
	soap_serialize_xsd__string(soap, &a->MessagingMode);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_d__MobileCreateSignature(struct soap *soap, struct d__MobileCreateSignature *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_xsd__string(soap, &a->IDCode);
	soap_default_xsd__string(soap, &a->SignersCountry);
	soap_default_xsd__string(soap, &a->PhoneNo);
	soap_default_xsd__string(soap, &a->Language);
	soap_default_xsd__string(soap, &a->ServiceName);
	soap_default_xsd__string(soap, &a->MessageToDisplay);
	soap_default_xsd__string(soap, &a->Role);
	soap_default_xsd__string(soap, &a->City);
	soap_default_xsd__string(soap, &a->StateOrProvince);
	soap_default_xsd__string(soap, &a->PostalCode);
	soap_default_xsd__string(soap, &a->CountryName);
	soap_default_xsd__string(soap, &a->SigningProfile);
	a->DataFiles = NULL;
	soap_default_xsd__string(soap, &a->Format);
	soap_default_xsd__string(soap, &a->Version);
	soap_default_xsd__string(soap, &a->SignatureID);
	soap_default_xsd__string(soap, &a->MessagingMode);
	soap_default_xsd__int(soap, &a->AsyncConfiguration);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_d__MobileCreateSignature(struct soap *soap, const struct d__MobileCreateSignature *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_d__MobileCreateSignature);
	if (soap_out_d__MobileCreateSignature(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_d__MobileCreateSignature(struct soap *soap, const char *tag, int id, const struct d__MobileCreateSignature *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_d__MobileCreateSignature), type);
	soap_out_xsd__string(soap, "IDCode", -1, &a->IDCode, "");
	soap_out_xsd__string(soap, "SignersCountry", -1, &a->SignersCountry, "");
	soap_out_xsd__string(soap, "PhoneNo", -1, &a->PhoneNo, "");
	soap_out_xsd__string(soap, "Language", -1, &a->Language, "");
	soap_out_xsd__string(soap, "ServiceName", -1, &a->ServiceName, "");
	soap_out_xsd__string(soap, "MessageToDisplay", -1, &a->MessageToDisplay, "");
	soap_out_xsd__string(soap, "Role", -1, &a->Role, "");
	soap_out_xsd__string(soap, "City", -1, &a->City, "");
	soap_out_xsd__string(soap, "StateOrProvince", -1, &a->StateOrProvince, "");
	soap_out_xsd__string(soap, "PostalCode", -1, &a->PostalCode, "");
	soap_out_xsd__string(soap, "CountryName", -1, &a->CountryName, "");
	soap_out_xsd__string(soap, "SigningProfile", -1, &a->SigningProfile, "");
	soap_out_PointerTod__DataFileDigestList(soap, "DataFiles", -1, &a->DataFiles, "");
	soap_out_xsd__string(soap, "Format", -1, &a->Format, "");
	soap_out_xsd__string(soap, "Version", -1, &a->Version, "");
	soap_out_xsd__string(soap, "SignatureID", -1, &a->SignatureID, "");
	soap_out_xsd__string(soap, "MessagingMode", -1, &a->MessagingMode, "");
	soap_out_xsd__int(soap, "AsyncConfiguration", -1, &a->AsyncConfiguration, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct d__MobileCreateSignature * SOAP_FMAC4 soap_get_d__MobileCreateSignature(struct soap *soap, struct d__MobileCreateSignature *p, const char *tag, const char *type)
{
	if ((p = soap_in_d__MobileCreateSignature(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct d__MobileCreateSignature * SOAP_FMAC4 soap_in_d__MobileCreateSignature(struct soap *soap, const char *tag, struct d__MobileCreateSignature *a, const char *type)
{
	short soap_flag_IDCode = 1, soap_flag_SignersCountry = 1, soap_flag_PhoneNo = 1, soap_flag_Language = 1, soap_flag_ServiceName = 1, soap_flag_MessageToDisplay = 1, soap_flag_Role = 1, soap_flag_City = 1, soap_flag_StateOrProvince = 1, soap_flag_PostalCode = 1, soap_flag_CountryName = 1, soap_flag_SigningProfile = 1, soap_flag_DataFiles = 1, soap_flag_Format = 1, soap_flag_Version = 1, soap_flag_SignatureID = 1, soap_flag_MessagingMode = 1, soap_flag_AsyncConfiguration = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct d__MobileCreateSignature *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_d__MobileCreateSignature, sizeof(struct d__MobileCreateSignature), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_d__MobileCreateSignature(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_IDCode && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "IDCode", &a->IDCode, "xsd:string"))
				{	soap_flag_IDCode--;
					continue;
				}
			if (soap_flag_SignersCountry && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "SignersCountry", &a->SignersCountry, "xsd:string"))
				{	soap_flag_SignersCountry--;
					continue;
				}
			if (soap_flag_PhoneNo && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "PhoneNo", &a->PhoneNo, "xsd:string"))
				{	soap_flag_PhoneNo--;
					continue;
				}
			if (soap_flag_Language && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "Language", &a->Language, "xsd:string"))
				{	soap_flag_Language--;
					continue;
				}
			if (soap_flag_ServiceName && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "ServiceName", &a->ServiceName, "xsd:string"))
				{	soap_flag_ServiceName--;
					continue;
				}
			if (soap_flag_MessageToDisplay && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "MessageToDisplay", &a->MessageToDisplay, "xsd:string"))
				{	soap_flag_MessageToDisplay--;
					continue;
				}
			if (soap_flag_Role && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "Role", &a->Role, "xsd:string"))
				{	soap_flag_Role--;
					continue;
				}
			if (soap_flag_City && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "City", &a->City, "xsd:string"))
				{	soap_flag_City--;
					continue;
				}
			if (soap_flag_StateOrProvince && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "StateOrProvince", &a->StateOrProvince, "xsd:string"))
				{	soap_flag_StateOrProvince--;
					continue;
				}
			if (soap_flag_PostalCode && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "PostalCode", &a->PostalCode, "xsd:string"))
				{	soap_flag_PostalCode--;
					continue;
				}
			if (soap_flag_CountryName && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "CountryName", &a->CountryName, "xsd:string"))
				{	soap_flag_CountryName--;
					continue;
				}
			if (soap_flag_SigningProfile && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "SigningProfile", &a->SigningProfile, "xsd:string"))
				{	soap_flag_SigningProfile--;
					continue;
				}
			if (soap_flag_DataFiles && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTod__DataFileDigestList(soap, "DataFiles", &a->DataFiles, "d:DataFileDigestList"))
				{	soap_flag_DataFiles--;
					continue;
				}
			if (soap_flag_Format && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "Format", &a->Format, "xsd:string"))
				{	soap_flag_Format--;
					continue;
				}
			if (soap_flag_Version && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "Version", &a->Version, "xsd:string"))
				{	soap_flag_Version--;
					continue;
				}
			if (soap_flag_SignatureID && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "SignatureID", &a->SignatureID, "xsd:string"))
				{	soap_flag_SignatureID--;
					continue;
				}
			if (soap_flag_MessagingMode && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "MessagingMode", &a->MessagingMode, "xsd:string"))
				{	soap_flag_MessagingMode--;
					continue;
				}
			if (soap_flag_AsyncConfiguration && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_xsd__int(soap, "AsyncConfiguration", &a->AsyncConfiguration, "xsd:int"))
				{	soap_flag_AsyncConfiguration--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_AsyncConfiguration > 0))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct d__MobileCreateSignature *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_d__MobileCreateSignature, 0, sizeof(struct d__MobileCreateSignature), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_d__MobileCreateSignatureResponse(struct soap *soap, const struct d__MobileCreateSignatureResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_xsd__string(soap, &a->ChallengeID);
	soap_serialize_xsd__string(soap, &a->Status);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_d__MobileCreateSignatureResponse(struct soap *soap, struct d__MobileCreateSignatureResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_xsd__int(soap, &a->Sesscode);
	soap_default_xsd__string(soap, &a->ChallengeID);
	soap_default_xsd__string(soap, &a->Status);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_d__MobileCreateSignatureResponse(struct soap *soap, const struct d__MobileCreateSignatureResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_d__MobileCreateSignatureResponse);
	if (soap_out_d__MobileCreateSignatureResponse(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_d__MobileCreateSignatureResponse(struct soap *soap, const char *tag, int id, const struct d__MobileCreateSignatureResponse *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_d__MobileCreateSignatureResponse), type);
	soap_element_result(soap, "Sesscode");
	soap_out_xsd__int(soap, "Sesscode", -1, &a->Sesscode, "");
	soap_out_xsd__string(soap, "ChallengeID", -1, &a->ChallengeID, "");
	soap_out_xsd__string(soap, "Status", -1, &a->Status, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct d__MobileCreateSignatureResponse * SOAP_FMAC4 soap_get_d__MobileCreateSignatureResponse(struct soap *soap, struct d__MobileCreateSignatureResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_d__MobileCreateSignatureResponse(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct d__MobileCreateSignatureResponse * SOAP_FMAC4 soap_in_d__MobileCreateSignatureResponse(struct soap *soap, const char *tag, struct d__MobileCreateSignatureResponse *a, const char *type)
{
	short soap_flag_Sesscode = 1, soap_flag_ChallengeID = 1, soap_flag_Status = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct d__MobileCreateSignatureResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_d__MobileCreateSignatureResponse, sizeof(struct d__MobileCreateSignatureResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_d__MobileCreateSignatureResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_Sesscode && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_xsd__int(soap, "Sesscode", &a->Sesscode, "xsd:int"))
				{	soap_flag_Sesscode--;
					continue;
				}
			if (soap_flag_ChallengeID && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "ChallengeID", &a->ChallengeID, "xsd:string"))
				{	soap_flag_ChallengeID--;
					continue;
				}
			if (soap_flag_Status && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "Status", &a->Status, "xsd:string"))
				{	soap_flag_Status--;
					continue;
				}
			soap_check_result(soap, "Sesscode");
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_Sesscode > 0))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct d__MobileCreateSignatureResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_d__MobileCreateSignatureResponse, 0, sizeof(struct d__MobileCreateSignatureResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_d__DataFileDigestList(struct soap *soap, const struct d__DataFileDigestList *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	if (a->__ptrDataFileDigest)
	{	int i;
		for (i = 0; i < a->__sizeOfDataFileDigests; i++)
		{
			soap_embedded(soap, a->__ptrDataFileDigest + i, SOAP_TYPE_d__DataFileDigest);
			soap_serialize_d__DataFileDigest(soap, a->__ptrDataFileDigest + i);
		}
	}
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_d__DataFileDigestList(struct soap *soap, struct d__DataFileDigestList *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->__sizeOfDataFileDigests = 0;
	a->__ptrDataFileDigest = NULL;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_d__DataFileDigestList(struct soap *soap, const struct d__DataFileDigestList *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_d__DataFileDigestList);
	if (soap_out_d__DataFileDigestList(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_d__DataFileDigestList(struct soap *soap, const char *tag, int id, const struct d__DataFileDigestList *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_d__DataFileDigestList), type);
	if (a->__ptrDataFileDigest)
	{	int i;
		for (i = 0; i < a->__sizeOfDataFileDigests; i++)
			soap_out_d__DataFileDigest(soap, "DataFileDigest", -1, a->__ptrDataFileDigest + i, "");
	}
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct d__DataFileDigestList * SOAP_FMAC4 soap_get_d__DataFileDigestList(struct soap *soap, struct d__DataFileDigestList *p, const char *tag, const char *type)
{
	if ((p = soap_in_d__DataFileDigestList(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct d__DataFileDigestList * SOAP_FMAC4 soap_in_d__DataFileDigestList(struct soap *soap, const char *tag, struct d__DataFileDigestList *a, const char *type)
{
	short soap_flag___ptrDataFileDigest = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct d__DataFileDigestList *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_d__DataFileDigestList, sizeof(struct d__DataFileDigestList), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_d__DataFileDigestList(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag___ptrDataFileDigest && soap->error == SOAP_TAG_MISMATCH)
			{	struct d__DataFileDigest *p;
				soap_new_block(soap);
				for (a->__sizeOfDataFileDigests = 0; !soap_element_begin_in(soap, "DataFileDigest", 1, NULL); a->__sizeOfDataFileDigests++)
				{	p = (struct d__DataFileDigest *)soap_push_block(soap, sizeof(struct d__DataFileDigest));
					soap_default_d__DataFileDigest(soap, p);
					soap_revert(soap);
					if (!soap_in_d__DataFileDigest(soap, "DataFileDigest", p, "d:DataFileDigest"))
						break;
					soap_flag___ptrDataFileDigest = 0;
				}
				a->__ptrDataFileDigest = (struct d__DataFileDigest *)soap_save_block(soap, NULL, 1);
				if (!soap_flag___ptrDataFileDigest && soap->error == SOAP_TAG_MISMATCH)
					continue;
			}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct d__DataFileDigestList *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_d__DataFileDigestList, 0, sizeof(struct d__DataFileDigestList), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_d__DataFileDigest(struct soap *soap, const struct d__DataFileDigest *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_xsd__string(soap, &a->Id);
	soap_serialize_xsd__string(soap, &a->DigestType);
	soap_serialize_xsd__string(soap, &a->DigestValue);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_d__DataFileDigest(struct soap *soap, struct d__DataFileDigest *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_xsd__string(soap, &a->Id);
	soap_default_xsd__string(soap, &a->DigestType);
	soap_default_xsd__string(soap, &a->DigestValue);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_d__DataFileDigest(struct soap *soap, const struct d__DataFileDigest *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_d__DataFileDigest);
	if (soap_out_d__DataFileDigest(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_d__DataFileDigest(struct soap *soap, const char *tag, int id, const struct d__DataFileDigest *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_d__DataFileDigest), type);
	soap_out_xsd__string(soap, "Id", -1, &a->Id, "");
	soap_out_xsd__string(soap, "DigestType", -1, &a->DigestType, "");
	soap_out_xsd__string(soap, "DigestValue", -1, &a->DigestValue, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct d__DataFileDigest * SOAP_FMAC4 soap_get_d__DataFileDigest(struct soap *soap, struct d__DataFileDigest *p, const char *tag, const char *type)
{
	if ((p = soap_in_d__DataFileDigest(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct d__DataFileDigest * SOAP_FMAC4 soap_in_d__DataFileDigest(struct soap *soap, const char *tag, struct d__DataFileDigest *a, const char *type)
{
	short soap_flag_Id = 1, soap_flag_DigestType = 1, soap_flag_DigestValue = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct d__DataFileDigest *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_d__DataFileDigest, sizeof(struct d__DataFileDigest), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_d__DataFileDigest(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_Id && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "Id", &a->Id, "xsd:string"))
				{	soap_flag_Id--;
					continue;
				}
			if (soap_flag_DigestType && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "DigestType", &a->DigestType, "xsd:string"))
				{	soap_flag_DigestType--;
					continue;
				}
			if (soap_flag_DigestValue && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "DigestValue", &a->DigestValue, "xsd:string"))
				{	soap_flag_DigestValue--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct d__DataFileDigest *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_d__DataFileDigest, 0, sizeof(struct d__DataFileDigest), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_d__GetMobileAuthenticateStatus(struct soap *soap, const struct d__GetMobileAuthenticateStatus *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_d__GetMobileAuthenticateStatus(struct soap *soap, struct d__GetMobileAuthenticateStatus *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_xsd__int(soap, &a->Sesscode);
	soap_default_xsd__boolean(soap, &a->WaitSignature);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_d__GetMobileAuthenticateStatus(struct soap *soap, const struct d__GetMobileAuthenticateStatus *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_d__GetMobileAuthenticateStatus);
	if (soap_out_d__GetMobileAuthenticateStatus(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_d__GetMobileAuthenticateStatus(struct soap *soap, const char *tag, int id, const struct d__GetMobileAuthenticateStatus *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_d__GetMobileAuthenticateStatus), type);
	soap_out_xsd__int(soap, "Sesscode", -1, &a->Sesscode, "");
	soap_out_xsd__boolean(soap, "WaitSignature", -1, &a->WaitSignature, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct d__GetMobileAuthenticateStatus * SOAP_FMAC4 soap_get_d__GetMobileAuthenticateStatus(struct soap *soap, struct d__GetMobileAuthenticateStatus *p, const char *tag, const char *type)
{
	if ((p = soap_in_d__GetMobileAuthenticateStatus(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct d__GetMobileAuthenticateStatus * SOAP_FMAC4 soap_in_d__GetMobileAuthenticateStatus(struct soap *soap, const char *tag, struct d__GetMobileAuthenticateStatus *a, const char *type)
{
	short soap_flag_Sesscode = 1, soap_flag_WaitSignature = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct d__GetMobileAuthenticateStatus *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_d__GetMobileAuthenticateStatus, sizeof(struct d__GetMobileAuthenticateStatus), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_d__GetMobileAuthenticateStatus(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_Sesscode && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_xsd__int(soap, "Sesscode", &a->Sesscode, "xsd:int"))
				{	soap_flag_Sesscode--;
					continue;
				}
			if (soap_flag_WaitSignature && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_xsd__boolean(soap, "WaitSignature", &a->WaitSignature, "xsd:boolean"))
				{	soap_flag_WaitSignature--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_Sesscode > 0 || soap_flag_WaitSignature > 0))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct d__GetMobileAuthenticateStatus *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_d__GetMobileAuthenticateStatus, 0, sizeof(struct d__GetMobileAuthenticateStatus), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_d__GetMobileAuthenticateStatusResponse(struct soap *soap, const struct d__GetMobileAuthenticateStatusResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_xsd__string(soap, &a->Status);
	soap_serialize_xsd__string(soap, &a->Signature);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_d__GetMobileAuthenticateStatusResponse(struct soap *soap, struct d__GetMobileAuthenticateStatusResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_xsd__string(soap, &a->Status);
	soap_default_xsd__string(soap, &a->Signature);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_d__GetMobileAuthenticateStatusResponse(struct soap *soap, const struct d__GetMobileAuthenticateStatusResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_d__GetMobileAuthenticateStatusResponse);
	if (soap_out_d__GetMobileAuthenticateStatusResponse(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_d__GetMobileAuthenticateStatusResponse(struct soap *soap, const char *tag, int id, const struct d__GetMobileAuthenticateStatusResponse *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_d__GetMobileAuthenticateStatusResponse), type);
	if (a->Status)
		soap_element_result(soap, "Status");
	soap_out_xsd__string(soap, "Status", -1, &a->Status, "");
	soap_out_xsd__string(soap, "Signature", -1, &a->Signature, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct d__GetMobileAuthenticateStatusResponse * SOAP_FMAC4 soap_get_d__GetMobileAuthenticateStatusResponse(struct soap *soap, struct d__GetMobileAuthenticateStatusResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_d__GetMobileAuthenticateStatusResponse(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct d__GetMobileAuthenticateStatusResponse * SOAP_FMAC4 soap_in_d__GetMobileAuthenticateStatusResponse(struct soap *soap, const char *tag, struct d__GetMobileAuthenticateStatusResponse *a, const char *type)
{
	short soap_flag_Status = 1, soap_flag_Signature = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct d__GetMobileAuthenticateStatusResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_d__GetMobileAuthenticateStatusResponse, sizeof(struct d__GetMobileAuthenticateStatusResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_d__GetMobileAuthenticateStatusResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_Status && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "Status", &a->Status, "xsd:string"))
				{	soap_flag_Status--;
					continue;
				}
			if (soap_flag_Signature && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "Signature", &a->Signature, "xsd:string"))
				{	soap_flag_Signature--;
					continue;
				}
			soap_check_result(soap, "Status");
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct d__GetMobileAuthenticateStatusResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_d__GetMobileAuthenticateStatusResponse, 0, sizeof(struct d__GetMobileAuthenticateStatusResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_d__MobileAuthenticate(struct soap *soap, const struct d__MobileAuthenticate *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_xsd__string(soap, &a->IDCode);
	soap_serialize_xsd__string(soap, &a->CountryCode);
	soap_serialize_xsd__string(soap, &a->PhoneNo);
	soap_serialize_xsd__string(soap, &a->Language);
	soap_serialize_xsd__string(soap, &a->ServiceName);
	soap_serialize_xsd__string(soap, &a->MessageToDisplay);
	soap_serialize_xsd__string(soap, &a->SPChallenge);
	soap_serialize_xsd__string(soap, &a->MessagingMode);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_d__MobileAuthenticate(struct soap *soap, struct d__MobileAuthenticate *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_xsd__string(soap, &a->IDCode);
	soap_default_xsd__string(soap, &a->CountryCode);
	soap_default_xsd__string(soap, &a->PhoneNo);
	soap_default_xsd__string(soap, &a->Language);
	soap_default_xsd__string(soap, &a->ServiceName);
	soap_default_xsd__string(soap, &a->MessageToDisplay);
	soap_default_xsd__string(soap, &a->SPChallenge);
	soap_default_xsd__string(soap, &a->MessagingMode);
	soap_default_xsd__int(soap, &a->AsyncConfiguration);
	soap_default_xsd__boolean(soap, &a->ReturnCertData);
	soap_default_xsd__boolean(soap, &a->ReturnRevocationData);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_d__MobileAuthenticate(struct soap *soap, const struct d__MobileAuthenticate *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_d__MobileAuthenticate);
	if (soap_out_d__MobileAuthenticate(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_d__MobileAuthenticate(struct soap *soap, const char *tag, int id, const struct d__MobileAuthenticate *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_d__MobileAuthenticate), type);
	soap_out_xsd__string(soap, "IDCode", -1, &a->IDCode, "");
	soap_out_xsd__string(soap, "CountryCode", -1, &a->CountryCode, "");
	soap_out_xsd__string(soap, "PhoneNo", -1, &a->PhoneNo, "");
	soap_out_xsd__string(soap, "Language", -1, &a->Language, "");
	soap_out_xsd__string(soap, "ServiceName", -1, &a->ServiceName, "");
	soap_out_xsd__string(soap, "MessageToDisplay", -1, &a->MessageToDisplay, "");
	soap_out_xsd__string(soap, "SPChallenge", -1, &a->SPChallenge, "");
	soap_out_xsd__string(soap, "MessagingMode", -1, &a->MessagingMode, "");
	soap_out_xsd__int(soap, "AsyncConfiguration", -1, &a->AsyncConfiguration, "");
	soap_out_xsd__boolean(soap, "ReturnCertData", -1, &a->ReturnCertData, "");
	soap_out_xsd__boolean(soap, "ReturnRevocationData", -1, &a->ReturnRevocationData, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct d__MobileAuthenticate * SOAP_FMAC4 soap_get_d__MobileAuthenticate(struct soap *soap, struct d__MobileAuthenticate *p, const char *tag, const char *type)
{
	if ((p = soap_in_d__MobileAuthenticate(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct d__MobileAuthenticate * SOAP_FMAC4 soap_in_d__MobileAuthenticate(struct soap *soap, const char *tag, struct d__MobileAuthenticate *a, const char *type)
{
	short soap_flag_IDCode = 1, soap_flag_CountryCode = 1, soap_flag_PhoneNo = 1, soap_flag_Language = 1, soap_flag_ServiceName = 1, soap_flag_MessageToDisplay = 1, soap_flag_SPChallenge = 1, soap_flag_MessagingMode = 1, soap_flag_AsyncConfiguration = 1, soap_flag_ReturnCertData = 1, soap_flag_ReturnRevocationData = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct d__MobileAuthenticate *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_d__MobileAuthenticate, sizeof(struct d__MobileAuthenticate), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_d__MobileAuthenticate(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_IDCode && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "IDCode", &a->IDCode, "xsd:string"))
				{	soap_flag_IDCode--;
					continue;
				}
			if (soap_flag_CountryCode && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "CountryCode", &a->CountryCode, "xsd:string"))
				{	soap_flag_CountryCode--;
					continue;
				}
			if (soap_flag_PhoneNo && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "PhoneNo", &a->PhoneNo, "xsd:string"))
				{	soap_flag_PhoneNo--;
					continue;
				}
			if (soap_flag_Language && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "Language", &a->Language, "xsd:string"))
				{	soap_flag_Language--;
					continue;
				}
			if (soap_flag_ServiceName && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "ServiceName", &a->ServiceName, "xsd:string"))
				{	soap_flag_ServiceName--;
					continue;
				}
			if (soap_flag_MessageToDisplay && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "MessageToDisplay", &a->MessageToDisplay, "xsd:string"))
				{	soap_flag_MessageToDisplay--;
					continue;
				}
			if (soap_flag_SPChallenge && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "SPChallenge", &a->SPChallenge, "xsd:string"))
				{	soap_flag_SPChallenge--;
					continue;
				}
			if (soap_flag_MessagingMode && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "MessagingMode", &a->MessagingMode, "xsd:string"))
				{	soap_flag_MessagingMode--;
					continue;
				}
			if (soap_flag_AsyncConfiguration && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_xsd__int(soap, "AsyncConfiguration", &a->AsyncConfiguration, "xsd:int"))
				{	soap_flag_AsyncConfiguration--;
					continue;
				}
			if (soap_flag_ReturnCertData && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_xsd__boolean(soap, "ReturnCertData", &a->ReturnCertData, "xsd:boolean"))
				{	soap_flag_ReturnCertData--;
					continue;
				}
			if (soap_flag_ReturnRevocationData && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_xsd__boolean(soap, "ReturnRevocationData", &a->ReturnRevocationData, "xsd:boolean"))
				{	soap_flag_ReturnRevocationData--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_AsyncConfiguration > 0 || soap_flag_ReturnCertData > 0 || soap_flag_ReturnRevocationData > 0))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct d__MobileAuthenticate *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_d__MobileAuthenticate, 0, sizeof(struct d__MobileAuthenticate), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_d__MobileAuthenticateResponse(struct soap *soap, const struct d__MobileAuthenticateResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_xsd__string(soap, &a->Status);
	soap_serialize_xsd__string(soap, &a->UserIDCode);
	soap_serialize_xsd__string(soap, &a->UserGivenname);
	soap_serialize_xsd__string(soap, &a->UserSurname);
	soap_serialize_xsd__string(soap, &a->UserCountry);
	soap_serialize_xsd__string(soap, &a->UserCN);
	soap_serialize_xsd__string(soap, &a->CertificateData);
	soap_serialize_xsd__string(soap, &a->ChallengeID);
	soap_serialize_xsd__string(soap, &a->Challenge);
	soap_serialize_xsd__string(soap, &a->RevocationData);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_d__MobileAuthenticateResponse(struct soap *soap, struct d__MobileAuthenticateResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_xsd__int(soap, &a->Sesscode);
	soap_default_xsd__string(soap, &a->Status);
	soap_default_xsd__string(soap, &a->UserIDCode);
	soap_default_xsd__string(soap, &a->UserGivenname);
	soap_default_xsd__string(soap, &a->UserSurname);
	soap_default_xsd__string(soap, &a->UserCountry);
	soap_default_xsd__string(soap, &a->UserCN);
	soap_default_xsd__string(soap, &a->CertificateData);
	soap_default_xsd__string(soap, &a->ChallengeID);
	soap_default_xsd__string(soap, &a->Challenge);
	soap_default_xsd__string(soap, &a->RevocationData);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_d__MobileAuthenticateResponse(struct soap *soap, const struct d__MobileAuthenticateResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_d__MobileAuthenticateResponse);
	if (soap_out_d__MobileAuthenticateResponse(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_d__MobileAuthenticateResponse(struct soap *soap, const char *tag, int id, const struct d__MobileAuthenticateResponse *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_d__MobileAuthenticateResponse), type);
	soap_element_result(soap, "Sesscode");
	soap_out_xsd__int(soap, "Sesscode", -1, &a->Sesscode, "");
	soap_out_xsd__string(soap, "Status", -1, &a->Status, "");
	soap_out_xsd__string(soap, "UserIDCode", -1, &a->UserIDCode, "");
	soap_out_xsd__string(soap, "UserGivenname", -1, &a->UserGivenname, "");
	soap_out_xsd__string(soap, "UserSurname", -1, &a->UserSurname, "");
	soap_out_xsd__string(soap, "UserCountry", -1, &a->UserCountry, "");
	soap_out_xsd__string(soap, "UserCN", -1, &a->UserCN, "");
	soap_out_xsd__string(soap, "CertificateData", -1, &a->CertificateData, "");
	soap_out_xsd__string(soap, "ChallengeID", -1, &a->ChallengeID, "");
	soap_out_xsd__string(soap, "Challenge", -1, &a->Challenge, "");
	soap_out_xsd__string(soap, "RevocationData", -1, &a->RevocationData, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct d__MobileAuthenticateResponse * SOAP_FMAC4 soap_get_d__MobileAuthenticateResponse(struct soap *soap, struct d__MobileAuthenticateResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_d__MobileAuthenticateResponse(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct d__MobileAuthenticateResponse * SOAP_FMAC4 soap_in_d__MobileAuthenticateResponse(struct soap *soap, const char *tag, struct d__MobileAuthenticateResponse *a, const char *type)
{
	short soap_flag_Sesscode = 1, soap_flag_Status = 1, soap_flag_UserIDCode = 1, soap_flag_UserGivenname = 1, soap_flag_UserSurname = 1, soap_flag_UserCountry = 1, soap_flag_UserCN = 1, soap_flag_CertificateData = 1, soap_flag_ChallengeID = 1, soap_flag_Challenge = 1, soap_flag_RevocationData = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct d__MobileAuthenticateResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_d__MobileAuthenticateResponse, sizeof(struct d__MobileAuthenticateResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_d__MobileAuthenticateResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_Sesscode && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_xsd__int(soap, "Sesscode", &a->Sesscode, "xsd:int"))
				{	soap_flag_Sesscode--;
					continue;
				}
			if (soap_flag_Status && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "Status", &a->Status, "xsd:string"))
				{	soap_flag_Status--;
					continue;
				}
			if (soap_flag_UserIDCode && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "UserIDCode", &a->UserIDCode, "xsd:string"))
				{	soap_flag_UserIDCode--;
					continue;
				}
			if (soap_flag_UserGivenname && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "UserGivenname", &a->UserGivenname, "xsd:string"))
				{	soap_flag_UserGivenname--;
					continue;
				}
			if (soap_flag_UserSurname && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "UserSurname", &a->UserSurname, "xsd:string"))
				{	soap_flag_UserSurname--;
					continue;
				}
			if (soap_flag_UserCountry && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "UserCountry", &a->UserCountry, "xsd:string"))
				{	soap_flag_UserCountry--;
					continue;
				}
			if (soap_flag_UserCN && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "UserCN", &a->UserCN, "xsd:string"))
				{	soap_flag_UserCN--;
					continue;
				}
			if (soap_flag_CertificateData && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "CertificateData", &a->CertificateData, "xsd:string"))
				{	soap_flag_CertificateData--;
					continue;
				}
			if (soap_flag_ChallengeID && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "ChallengeID", &a->ChallengeID, "xsd:string"))
				{	soap_flag_ChallengeID--;
					continue;
				}
			if (soap_flag_Challenge && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "Challenge", &a->Challenge, "xsd:string"))
				{	soap_flag_Challenge--;
					continue;
				}
			if (soap_flag_RevocationData && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "RevocationData", &a->RevocationData, "xsd:string"))
				{	soap_flag_RevocationData--;
					continue;
				}
			soap_check_result(soap, "Sesscode");
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_Sesscode > 0))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct d__MobileAuthenticateResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_d__MobileAuthenticateResponse, 0, sizeof(struct d__MobileAuthenticateResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_d__GetStatusInfo(struct soap *soap, const struct d__GetStatusInfo *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_d__GetStatusInfo(struct soap *soap, struct d__GetStatusInfo *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_xsd__int(soap, &a->Sesscode);
	soap_default_xsd__boolean(soap, &a->ReturnDocInfo);
	soap_default_xsd__boolean(soap, &a->WaitSignature);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_d__GetStatusInfo(struct soap *soap, const struct d__GetStatusInfo *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_d__GetStatusInfo);
	if (soap_out_d__GetStatusInfo(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_d__GetStatusInfo(struct soap *soap, const char *tag, int id, const struct d__GetStatusInfo *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_d__GetStatusInfo), type);
	soap_out_xsd__int(soap, "Sesscode", -1, &a->Sesscode, "");
	soap_out_xsd__boolean(soap, "ReturnDocInfo", -1, &a->ReturnDocInfo, "");
	soap_out_xsd__boolean(soap, "WaitSignature", -1, &a->WaitSignature, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct d__GetStatusInfo * SOAP_FMAC4 soap_get_d__GetStatusInfo(struct soap *soap, struct d__GetStatusInfo *p, const char *tag, const char *type)
{
	if ((p = soap_in_d__GetStatusInfo(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct d__GetStatusInfo * SOAP_FMAC4 soap_in_d__GetStatusInfo(struct soap *soap, const char *tag, struct d__GetStatusInfo *a, const char *type)
{
	short soap_flag_Sesscode = 1, soap_flag_ReturnDocInfo = 1, soap_flag_WaitSignature = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct d__GetStatusInfo *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_d__GetStatusInfo, sizeof(struct d__GetStatusInfo), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_d__GetStatusInfo(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_Sesscode && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_xsd__int(soap, "Sesscode", &a->Sesscode, "xsd:int"))
				{	soap_flag_Sesscode--;
					continue;
				}
			if (soap_flag_ReturnDocInfo && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_xsd__boolean(soap, "ReturnDocInfo", &a->ReturnDocInfo, "xsd:boolean"))
				{	soap_flag_ReturnDocInfo--;
					continue;
				}
			if (soap_flag_WaitSignature && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_xsd__boolean(soap, "WaitSignature", &a->WaitSignature, "xsd:boolean"))
				{	soap_flag_WaitSignature--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_Sesscode > 0 || soap_flag_ReturnDocInfo > 0 || soap_flag_WaitSignature > 0))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct d__GetStatusInfo *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_d__GetStatusInfo, 0, sizeof(struct d__GetStatusInfo), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_d__GetStatusInfoResponse(struct soap *soap, const struct d__GetStatusInfoResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_xsd__string(soap, &a->Status);
	soap_serialize_xsd__string(soap, &a->StatusCode);
	soap_serialize_PointerTod__SignedDocInfo(soap, &a->SignedDocInfo);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_d__GetStatusInfoResponse(struct soap *soap, struct d__GetStatusInfoResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_xsd__string(soap, &a->Status);
	soap_default_xsd__string(soap, &a->StatusCode);
	a->SignedDocInfo = NULL;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_d__GetStatusInfoResponse(struct soap *soap, const struct d__GetStatusInfoResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_d__GetStatusInfoResponse);
	if (soap_out_d__GetStatusInfoResponse(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_d__GetStatusInfoResponse(struct soap *soap, const char *tag, int id, const struct d__GetStatusInfoResponse *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_d__GetStatusInfoResponse), type);
	if (a->Status)
		soap_element_result(soap, "Status");
	soap_out_xsd__string(soap, "Status", -1, &a->Status, "");
	soap_out_xsd__string(soap, "StatusCode", -1, &a->StatusCode, "");
	soap_out_PointerTod__SignedDocInfo(soap, "SignedDocInfo", -1, &a->SignedDocInfo, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct d__GetStatusInfoResponse * SOAP_FMAC4 soap_get_d__GetStatusInfoResponse(struct soap *soap, struct d__GetStatusInfoResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_d__GetStatusInfoResponse(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct d__GetStatusInfoResponse * SOAP_FMAC4 soap_in_d__GetStatusInfoResponse(struct soap *soap, const char *tag, struct d__GetStatusInfoResponse *a, const char *type)
{
	short soap_flag_Status = 1, soap_flag_StatusCode = 1, soap_flag_SignedDocInfo = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct d__GetStatusInfoResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_d__GetStatusInfoResponse, sizeof(struct d__GetStatusInfoResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_d__GetStatusInfoResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_Status && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "Status", &a->Status, "xsd:string"))
				{	soap_flag_Status--;
					continue;
				}
			if (soap_flag_StatusCode && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "StatusCode", &a->StatusCode, "xsd:string"))
				{	soap_flag_StatusCode--;
					continue;
				}
			if (soap_flag_SignedDocInfo && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTod__SignedDocInfo(soap, "SignedDocInfo", &a->SignedDocInfo, "d:SignedDocInfo"))
				{	soap_flag_SignedDocInfo--;
					continue;
				}
			soap_check_result(soap, "Status");
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct d__GetStatusInfoResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_d__GetStatusInfoResponse, 0, sizeof(struct d__GetStatusInfoResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_d__MobileSign(struct soap *soap, const struct d__MobileSign *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_xsd__string(soap, &a->SignerIDCode);
	soap_serialize_xsd__string(soap, &a->SignersCountry);
	soap_serialize_xsd__string(soap, &a->SignerPhoneNo);
	soap_serialize_xsd__string(soap, &a->ServiceName);
	soap_serialize_xsd__string(soap, &a->AdditionalDataToBeDisplayed);
	soap_serialize_xsd__string(soap, &a->Language);
	soap_serialize_xsd__string(soap, &a->Role);
	soap_serialize_xsd__string(soap, &a->City);
	soap_serialize_xsd__string(soap, &a->StateOrProvince);
	soap_serialize_xsd__string(soap, &a->PostalCode);
	soap_serialize_xsd__string(soap, &a->CountryName);
	soap_serialize_xsd__string(soap, &a->SigningProfile);
	soap_serialize_xsd__string(soap, &a->MessagingMode);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_d__MobileSign(struct soap *soap, struct d__MobileSign *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_xsd__int(soap, &a->Sesscode);
	soap_default_xsd__string(soap, &a->SignerIDCode);
	soap_default_xsd__string(soap, &a->SignersCountry);
	soap_default_xsd__string(soap, &a->SignerPhoneNo);
	soap_default_xsd__string(soap, &a->ServiceName);
	soap_default_xsd__string(soap, &a->AdditionalDataToBeDisplayed);
	soap_default_xsd__string(soap, &a->Language);
	soap_default_xsd__string(soap, &a->Role);
	soap_default_xsd__string(soap, &a->City);
	soap_default_xsd__string(soap, &a->StateOrProvince);
	soap_default_xsd__string(soap, &a->PostalCode);
	soap_default_xsd__string(soap, &a->CountryName);
	soap_default_xsd__string(soap, &a->SigningProfile);
	soap_default_xsd__string(soap, &a->MessagingMode);
	soap_default_xsd__int(soap, &a->AsyncConfiguration);
	soap_default_xsd__boolean(soap, &a->ReturnDocInfo);
	soap_default_xsd__boolean(soap, &a->ReturnDocData);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_d__MobileSign(struct soap *soap, const struct d__MobileSign *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_d__MobileSign);
	if (soap_out_d__MobileSign(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_d__MobileSign(struct soap *soap, const char *tag, int id, const struct d__MobileSign *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_d__MobileSign), type);
	soap_out_xsd__int(soap, "Sesscode", -1, &a->Sesscode, "");
	soap_out_xsd__string(soap, "SignerIDCode", -1, &a->SignerIDCode, "");
	soap_out_xsd__string(soap, "SignersCountry", -1, &a->SignersCountry, "");
	soap_out_xsd__string(soap, "SignerPhoneNo", -1, &a->SignerPhoneNo, "");
	soap_out_xsd__string(soap, "ServiceName", -1, &a->ServiceName, "");
	soap_out_xsd__string(soap, "AdditionalDataToBeDisplayed", -1, &a->AdditionalDataToBeDisplayed, "");
	soap_out_xsd__string(soap, "Language", -1, &a->Language, "");
	soap_out_xsd__string(soap, "Role", -1, &a->Role, "");
	soap_out_xsd__string(soap, "City", -1, &a->City, "");
	soap_out_xsd__string(soap, "StateOrProvince", -1, &a->StateOrProvince, "");
	soap_out_xsd__string(soap, "PostalCode", -1, &a->PostalCode, "");
	soap_out_xsd__string(soap, "CountryName", -1, &a->CountryName, "");
	soap_out_xsd__string(soap, "SigningProfile", -1, &a->SigningProfile, "");
	soap_out_xsd__string(soap, "MessagingMode", -1, &a->MessagingMode, "");
	soap_out_xsd__int(soap, "AsyncConfiguration", -1, &a->AsyncConfiguration, "");
	soap_out_xsd__boolean(soap, "ReturnDocInfo", -1, &a->ReturnDocInfo, "");
	soap_out_xsd__boolean(soap, "ReturnDocData", -1, &a->ReturnDocData, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct d__MobileSign * SOAP_FMAC4 soap_get_d__MobileSign(struct soap *soap, struct d__MobileSign *p, const char *tag, const char *type)
{
	if ((p = soap_in_d__MobileSign(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct d__MobileSign * SOAP_FMAC4 soap_in_d__MobileSign(struct soap *soap, const char *tag, struct d__MobileSign *a, const char *type)
{
	short soap_flag_Sesscode = 1, soap_flag_SignerIDCode = 1, soap_flag_SignersCountry = 1, soap_flag_SignerPhoneNo = 1, soap_flag_ServiceName = 1, soap_flag_AdditionalDataToBeDisplayed = 1, soap_flag_Language = 1, soap_flag_Role = 1, soap_flag_City = 1, soap_flag_StateOrProvince = 1, soap_flag_PostalCode = 1, soap_flag_CountryName = 1, soap_flag_SigningProfile = 1, soap_flag_MessagingMode = 1, soap_flag_AsyncConfiguration = 1, soap_flag_ReturnDocInfo = 1, soap_flag_ReturnDocData = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct d__MobileSign *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_d__MobileSign, sizeof(struct d__MobileSign), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_d__MobileSign(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_Sesscode && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_xsd__int(soap, "Sesscode", &a->Sesscode, "xsd:int"))
				{	soap_flag_Sesscode--;
					continue;
				}
			if (soap_flag_SignerIDCode && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "SignerIDCode", &a->SignerIDCode, "xsd:string"))
				{	soap_flag_SignerIDCode--;
					continue;
				}
			if (soap_flag_SignersCountry && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "SignersCountry", &a->SignersCountry, "xsd:string"))
				{	soap_flag_SignersCountry--;
					continue;
				}
			if (soap_flag_SignerPhoneNo && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "SignerPhoneNo", &a->SignerPhoneNo, "xsd:string"))
				{	soap_flag_SignerPhoneNo--;
					continue;
				}
			if (soap_flag_ServiceName && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "ServiceName", &a->ServiceName, "xsd:string"))
				{	soap_flag_ServiceName--;
					continue;
				}
			if (soap_flag_AdditionalDataToBeDisplayed && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "AdditionalDataToBeDisplayed", &a->AdditionalDataToBeDisplayed, "xsd:string"))
				{	soap_flag_AdditionalDataToBeDisplayed--;
					continue;
				}
			if (soap_flag_Language && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "Language", &a->Language, "xsd:string"))
				{	soap_flag_Language--;
					continue;
				}
			if (soap_flag_Role && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "Role", &a->Role, "xsd:string"))
				{	soap_flag_Role--;
					continue;
				}
			if (soap_flag_City && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "City", &a->City, "xsd:string"))
				{	soap_flag_City--;
					continue;
				}
			if (soap_flag_StateOrProvince && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "StateOrProvince", &a->StateOrProvince, "xsd:string"))
				{	soap_flag_StateOrProvince--;
					continue;
				}
			if (soap_flag_PostalCode && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "PostalCode", &a->PostalCode, "xsd:string"))
				{	soap_flag_PostalCode--;
					continue;
				}
			if (soap_flag_CountryName && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "CountryName", &a->CountryName, "xsd:string"))
				{	soap_flag_CountryName--;
					continue;
				}
			if (soap_flag_SigningProfile && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "SigningProfile", &a->SigningProfile, "xsd:string"))
				{	soap_flag_SigningProfile--;
					continue;
				}
			if (soap_flag_MessagingMode && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "MessagingMode", &a->MessagingMode, "xsd:string"))
				{	soap_flag_MessagingMode--;
					continue;
				}
			if (soap_flag_AsyncConfiguration && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_xsd__int(soap, "AsyncConfiguration", &a->AsyncConfiguration, "xsd:int"))
				{	soap_flag_AsyncConfiguration--;
					continue;
				}
			if (soap_flag_ReturnDocInfo && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_xsd__boolean(soap, "ReturnDocInfo", &a->ReturnDocInfo, "xsd:boolean"))
				{	soap_flag_ReturnDocInfo--;
					continue;
				}
			if (soap_flag_ReturnDocData && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_xsd__boolean(soap, "ReturnDocData", &a->ReturnDocData, "xsd:boolean"))
				{	soap_flag_ReturnDocData--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_Sesscode > 0 || soap_flag_AsyncConfiguration > 0 || soap_flag_ReturnDocInfo > 0 || soap_flag_ReturnDocData > 0))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct d__MobileSign *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_d__MobileSign, 0, sizeof(struct d__MobileSign), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_d__MobileSignResponse(struct soap *soap, const struct d__MobileSignResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_xsd__string(soap, &a->Status);
	soap_serialize_xsd__string(soap, &a->StatusCode);
	soap_serialize_xsd__string(soap, &a->ChallengeID);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_d__MobileSignResponse(struct soap *soap, struct d__MobileSignResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_xsd__string(soap, &a->Status);
	soap_default_xsd__string(soap, &a->StatusCode);
	soap_default_xsd__string(soap, &a->ChallengeID);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_d__MobileSignResponse(struct soap *soap, const struct d__MobileSignResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_d__MobileSignResponse);
	if (soap_out_d__MobileSignResponse(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_d__MobileSignResponse(struct soap *soap, const char *tag, int id, const struct d__MobileSignResponse *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_d__MobileSignResponse), type);
	if (a->Status)
		soap_element_result(soap, "Status");
	soap_out_xsd__string(soap, "Status", -1, &a->Status, "");
	soap_out_xsd__string(soap, "StatusCode", -1, &a->StatusCode, "");
	soap_out_xsd__string(soap, "ChallengeID", -1, &a->ChallengeID, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct d__MobileSignResponse * SOAP_FMAC4 soap_get_d__MobileSignResponse(struct soap *soap, struct d__MobileSignResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_d__MobileSignResponse(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct d__MobileSignResponse * SOAP_FMAC4 soap_in_d__MobileSignResponse(struct soap *soap, const char *tag, struct d__MobileSignResponse *a, const char *type)
{
	short soap_flag_Status = 1, soap_flag_StatusCode = 1, soap_flag_ChallengeID = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct d__MobileSignResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_d__MobileSignResponse, sizeof(struct d__MobileSignResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_d__MobileSignResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_Status && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "Status", &a->Status, "xsd:string"))
				{	soap_flag_Status--;
					continue;
				}
			if (soap_flag_StatusCode && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "StatusCode", &a->StatusCode, "xsd:string"))
				{	soap_flag_StatusCode--;
					continue;
				}
			if (soap_flag_ChallengeID && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "ChallengeID", &a->ChallengeID, "xsd:string"))
				{	soap_flag_ChallengeID--;
					continue;
				}
			soap_check_result(soap, "Status");
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct d__MobileSignResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_d__MobileSignResponse, 0, sizeof(struct d__MobileSignResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_d__GetVersion(struct soap *soap, const struct d__GetVersion *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_d__GetVersion(struct soap *soap, struct d__GetVersion *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_d__GetVersion(struct soap *soap, const struct d__GetVersion *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_d__GetVersion);
	if (soap_out_d__GetVersion(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_d__GetVersion(struct soap *soap, const char *tag, int id, const struct d__GetVersion *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_d__GetVersion), type);
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct d__GetVersion * SOAP_FMAC4 soap_get_d__GetVersion(struct soap *soap, struct d__GetVersion *p, const char *tag, const char *type)
{
	if ((p = soap_in_d__GetVersion(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct d__GetVersion * SOAP_FMAC4 soap_in_d__GetVersion(struct soap *soap, const char *tag, struct d__GetVersion *a, const char *type)
{;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct d__GetVersion *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_d__GetVersion, sizeof(struct d__GetVersion), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_d__GetVersion(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct d__GetVersion *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_d__GetVersion, 0, sizeof(struct d__GetVersion), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_d__GetVersionResponse(struct soap *soap, const struct d__GetVersionResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_xsd__string(soap, &a->Name);
	soap_serialize_xsd__string(soap, &a->Version);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_d__GetVersionResponse(struct soap *soap, struct d__GetVersionResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_xsd__string(soap, &a->Name);
	soap_default_xsd__string(soap, &a->Version);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_d__GetVersionResponse(struct soap *soap, const struct d__GetVersionResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_d__GetVersionResponse);
	if (soap_out_d__GetVersionResponse(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_d__GetVersionResponse(struct soap *soap, const char *tag, int id, const struct d__GetVersionResponse *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_d__GetVersionResponse), type);
	if (a->Name)
		soap_element_result(soap, "Name");
	soap_out_xsd__string(soap, "Name", -1, &a->Name, "");
	soap_out_xsd__string(soap, "Version", -1, &a->Version, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct d__GetVersionResponse * SOAP_FMAC4 soap_get_d__GetVersionResponse(struct soap *soap, struct d__GetVersionResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_d__GetVersionResponse(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct d__GetVersionResponse * SOAP_FMAC4 soap_in_d__GetVersionResponse(struct soap *soap, const char *tag, struct d__GetVersionResponse *a, const char *type)
{
	short soap_flag_Name = 1, soap_flag_Version = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct d__GetVersionResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_d__GetVersionResponse, sizeof(struct d__GetVersionResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_d__GetVersionResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_Name && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "Name", &a->Name, "xsd:string"))
				{	soap_flag_Name--;
					continue;
				}
			if (soap_flag_Version && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "Version", &a->Version, "xsd:string"))
				{	soap_flag_Version--;
					continue;
				}
			soap_check_result(soap, "Name");
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct d__GetVersionResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_d__GetVersionResponse, 0, sizeof(struct d__GetVersionResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_d__RemoveSignature(struct soap *soap, const struct d__RemoveSignature *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_xsd__string(soap, &a->SignatureId);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_d__RemoveSignature(struct soap *soap, struct d__RemoveSignature *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_xsd__int(soap, &a->Sesscode);
	soap_default_xsd__string(soap, &a->SignatureId);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_d__RemoveSignature(struct soap *soap, const struct d__RemoveSignature *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_d__RemoveSignature);
	if (soap_out_d__RemoveSignature(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_d__RemoveSignature(struct soap *soap, const char *tag, int id, const struct d__RemoveSignature *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_d__RemoveSignature), type);
	soap_out_xsd__int(soap, "Sesscode", -1, &a->Sesscode, "");
	soap_out_xsd__string(soap, "SignatureId", -1, &a->SignatureId, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct d__RemoveSignature * SOAP_FMAC4 soap_get_d__RemoveSignature(struct soap *soap, struct d__RemoveSignature *p, const char *tag, const char *type)
{
	if ((p = soap_in_d__RemoveSignature(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct d__RemoveSignature * SOAP_FMAC4 soap_in_d__RemoveSignature(struct soap *soap, const char *tag, struct d__RemoveSignature *a, const char *type)
{
	short soap_flag_Sesscode = 1, soap_flag_SignatureId = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct d__RemoveSignature *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_d__RemoveSignature, sizeof(struct d__RemoveSignature), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_d__RemoveSignature(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_Sesscode && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_xsd__int(soap, "Sesscode", &a->Sesscode, "xsd:int"))
				{	soap_flag_Sesscode--;
					continue;
				}
			if (soap_flag_SignatureId && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "SignatureId", &a->SignatureId, "xsd:string"))
				{	soap_flag_SignatureId--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_Sesscode > 0))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct d__RemoveSignature *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_d__RemoveSignature, 0, sizeof(struct d__RemoveSignature), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_d__RemoveSignatureResponse(struct soap *soap, const struct d__RemoveSignatureResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_xsd__string(soap, &a->Status);
	soap_serialize_PointerTod__SignedDocInfo(soap, &a->SignedDocInfo);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_d__RemoveSignatureResponse(struct soap *soap, struct d__RemoveSignatureResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_xsd__string(soap, &a->Status);
	a->SignedDocInfo = NULL;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_d__RemoveSignatureResponse(struct soap *soap, const struct d__RemoveSignatureResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_d__RemoveSignatureResponse);
	if (soap_out_d__RemoveSignatureResponse(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_d__RemoveSignatureResponse(struct soap *soap, const char *tag, int id, const struct d__RemoveSignatureResponse *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_d__RemoveSignatureResponse), type);
	if (a->Status)
		soap_element_result(soap, "Status");
	soap_out_xsd__string(soap, "Status", -1, &a->Status, "");
	soap_out_PointerTod__SignedDocInfo(soap, "SignedDocInfo", -1, &a->SignedDocInfo, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct d__RemoveSignatureResponse * SOAP_FMAC4 soap_get_d__RemoveSignatureResponse(struct soap *soap, struct d__RemoveSignatureResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_d__RemoveSignatureResponse(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct d__RemoveSignatureResponse * SOAP_FMAC4 soap_in_d__RemoveSignatureResponse(struct soap *soap, const char *tag, struct d__RemoveSignatureResponse *a, const char *type)
{
	short soap_flag_Status = 1, soap_flag_SignedDocInfo = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct d__RemoveSignatureResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_d__RemoveSignatureResponse, sizeof(struct d__RemoveSignatureResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_d__RemoveSignatureResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_Status && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "Status", &a->Status, "xsd:string"))
				{	soap_flag_Status--;
					continue;
				}
			if (soap_flag_SignedDocInfo && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTod__SignedDocInfo(soap, "SignedDocInfo", &a->SignedDocInfo, "d:SignedDocInfo"))
				{	soap_flag_SignedDocInfo--;
					continue;
				}
			soap_check_result(soap, "Status");
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct d__RemoveSignatureResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_d__RemoveSignatureResponse, 0, sizeof(struct d__RemoveSignatureResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_d__FinalizeSignature(struct soap *soap, const struct d__FinalizeSignature *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_xsd__string(soap, &a->SignatureId);
	soap_serialize_xsd__string(soap, &a->SignatureValue);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_d__FinalizeSignature(struct soap *soap, struct d__FinalizeSignature *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_xsd__int(soap, &a->Sesscode);
	soap_default_xsd__string(soap, &a->SignatureId);
	soap_default_xsd__string(soap, &a->SignatureValue);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_d__FinalizeSignature(struct soap *soap, const struct d__FinalizeSignature *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_d__FinalizeSignature);
	if (soap_out_d__FinalizeSignature(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_d__FinalizeSignature(struct soap *soap, const char *tag, int id, const struct d__FinalizeSignature *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_d__FinalizeSignature), type);
	soap_out_xsd__int(soap, "Sesscode", -1, &a->Sesscode, "");
	soap_out_xsd__string(soap, "SignatureId", -1, &a->SignatureId, "");
	soap_out_xsd__string(soap, "SignatureValue", -1, &a->SignatureValue, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct d__FinalizeSignature * SOAP_FMAC4 soap_get_d__FinalizeSignature(struct soap *soap, struct d__FinalizeSignature *p, const char *tag, const char *type)
{
	if ((p = soap_in_d__FinalizeSignature(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct d__FinalizeSignature * SOAP_FMAC4 soap_in_d__FinalizeSignature(struct soap *soap, const char *tag, struct d__FinalizeSignature *a, const char *type)
{
	short soap_flag_Sesscode = 1, soap_flag_SignatureId = 1, soap_flag_SignatureValue = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct d__FinalizeSignature *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_d__FinalizeSignature, sizeof(struct d__FinalizeSignature), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_d__FinalizeSignature(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_Sesscode && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_xsd__int(soap, "Sesscode", &a->Sesscode, "xsd:int"))
				{	soap_flag_Sesscode--;
					continue;
				}
			if (soap_flag_SignatureId && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "SignatureId", &a->SignatureId, "xsd:string"))
				{	soap_flag_SignatureId--;
					continue;
				}
			if (soap_flag_SignatureValue && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "SignatureValue", &a->SignatureValue, "xsd:string"))
				{	soap_flag_SignatureValue--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_Sesscode > 0))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct d__FinalizeSignature *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_d__FinalizeSignature, 0, sizeof(struct d__FinalizeSignature), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_d__FinalizeSignatureResponse(struct soap *soap, const struct d__FinalizeSignatureResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_xsd__string(soap, &a->Status);
	soap_serialize_PointerTod__SignedDocInfo(soap, &a->SignedDocInfo);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_d__FinalizeSignatureResponse(struct soap *soap, struct d__FinalizeSignatureResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_xsd__string(soap, &a->Status);
	a->SignedDocInfo = NULL;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_d__FinalizeSignatureResponse(struct soap *soap, const struct d__FinalizeSignatureResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_d__FinalizeSignatureResponse);
	if (soap_out_d__FinalizeSignatureResponse(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_d__FinalizeSignatureResponse(struct soap *soap, const char *tag, int id, const struct d__FinalizeSignatureResponse *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_d__FinalizeSignatureResponse), type);
	if (a->Status)
		soap_element_result(soap, "Status");
	soap_out_xsd__string(soap, "Status", -1, &a->Status, "");
	soap_out_PointerTod__SignedDocInfo(soap, "SignedDocInfo", -1, &a->SignedDocInfo, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct d__FinalizeSignatureResponse * SOAP_FMAC4 soap_get_d__FinalizeSignatureResponse(struct soap *soap, struct d__FinalizeSignatureResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_d__FinalizeSignatureResponse(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct d__FinalizeSignatureResponse * SOAP_FMAC4 soap_in_d__FinalizeSignatureResponse(struct soap *soap, const char *tag, struct d__FinalizeSignatureResponse *a, const char *type)
{
	short soap_flag_Status = 1, soap_flag_SignedDocInfo = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct d__FinalizeSignatureResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_d__FinalizeSignatureResponse, sizeof(struct d__FinalizeSignatureResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_d__FinalizeSignatureResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_Status && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "Status", &a->Status, "xsd:string"))
				{	soap_flag_Status--;
					continue;
				}
			if (soap_flag_SignedDocInfo && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTod__SignedDocInfo(soap, "SignedDocInfo", &a->SignedDocInfo, "d:SignedDocInfo"))
				{	soap_flag_SignedDocInfo--;
					continue;
				}
			soap_check_result(soap, "Status");
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct d__FinalizeSignatureResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_d__FinalizeSignatureResponse, 0, sizeof(struct d__FinalizeSignatureResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_d__PrepareSignature(struct soap *soap, const struct d__PrepareSignature *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_xsd__string(soap, &a->SignersCertificate);
	soap_serialize_xsd__string(soap, &a->SignersTokenId);
	soap_serialize_xsd__string(soap, &a->Role);
	soap_serialize_xsd__string(soap, &a->City);
	soap_serialize_xsd__string(soap, &a->State);
	soap_serialize_xsd__string(soap, &a->PostalCode);
	soap_serialize_xsd__string(soap, &a->Country);
	soap_serialize_xsd__string(soap, &a->SigningProfile);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_d__PrepareSignature(struct soap *soap, struct d__PrepareSignature *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_xsd__int(soap, &a->Sesscode);
	soap_default_xsd__string(soap, &a->SignersCertificate);
	soap_default_xsd__string(soap, &a->SignersTokenId);
	soap_default_xsd__string(soap, &a->Role);
	soap_default_xsd__string(soap, &a->City);
	soap_default_xsd__string(soap, &a->State);
	soap_default_xsd__string(soap, &a->PostalCode);
	soap_default_xsd__string(soap, &a->Country);
	soap_default_xsd__string(soap, &a->SigningProfile);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_d__PrepareSignature(struct soap *soap, const struct d__PrepareSignature *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_d__PrepareSignature);
	if (soap_out_d__PrepareSignature(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_d__PrepareSignature(struct soap *soap, const char *tag, int id, const struct d__PrepareSignature *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_d__PrepareSignature), type);
	soap_out_xsd__int(soap, "Sesscode", -1, &a->Sesscode, "");
	soap_out_xsd__string(soap, "SignersCertificate", -1, &a->SignersCertificate, "");
	soap_out_xsd__string(soap, "SignersTokenId", -1, &a->SignersTokenId, "");
	soap_out_xsd__string(soap, "Role", -1, &a->Role, "");
	soap_out_xsd__string(soap, "City", -1, &a->City, "");
	soap_out_xsd__string(soap, "State", -1, &a->State, "");
	soap_out_xsd__string(soap, "PostalCode", -1, &a->PostalCode, "");
	soap_out_xsd__string(soap, "Country", -1, &a->Country, "");
	soap_out_xsd__string(soap, "SigningProfile", -1, &a->SigningProfile, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct d__PrepareSignature * SOAP_FMAC4 soap_get_d__PrepareSignature(struct soap *soap, struct d__PrepareSignature *p, const char *tag, const char *type)
{
	if ((p = soap_in_d__PrepareSignature(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct d__PrepareSignature * SOAP_FMAC4 soap_in_d__PrepareSignature(struct soap *soap, const char *tag, struct d__PrepareSignature *a, const char *type)
{
	short soap_flag_Sesscode = 1, soap_flag_SignersCertificate = 1, soap_flag_SignersTokenId = 1, soap_flag_Role = 1, soap_flag_City = 1, soap_flag_State = 1, soap_flag_PostalCode = 1, soap_flag_Country = 1, soap_flag_SigningProfile = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct d__PrepareSignature *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_d__PrepareSignature, sizeof(struct d__PrepareSignature), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_d__PrepareSignature(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_Sesscode && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_xsd__int(soap, "Sesscode", &a->Sesscode, "xsd:int"))
				{	soap_flag_Sesscode--;
					continue;
				}
			if (soap_flag_SignersCertificate && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "SignersCertificate", &a->SignersCertificate, "xsd:string"))
				{	soap_flag_SignersCertificate--;
					continue;
				}
			if (soap_flag_SignersTokenId && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "SignersTokenId", &a->SignersTokenId, "xsd:string"))
				{	soap_flag_SignersTokenId--;
					continue;
				}
			if (soap_flag_Role && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "Role", &a->Role, "xsd:string"))
				{	soap_flag_Role--;
					continue;
				}
			if (soap_flag_City && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "City", &a->City, "xsd:string"))
				{	soap_flag_City--;
					continue;
				}
			if (soap_flag_State && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "State", &a->State, "xsd:string"))
				{	soap_flag_State--;
					continue;
				}
			if (soap_flag_PostalCode && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "PostalCode", &a->PostalCode, "xsd:string"))
				{	soap_flag_PostalCode--;
					continue;
				}
			if (soap_flag_Country && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "Country", &a->Country, "xsd:string"))
				{	soap_flag_Country--;
					continue;
				}
			if (soap_flag_SigningProfile && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "SigningProfile", &a->SigningProfile, "xsd:string"))
				{	soap_flag_SigningProfile--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_Sesscode > 0))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct d__PrepareSignature *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_d__PrepareSignature, 0, sizeof(struct d__PrepareSignature), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_d__PrepareSignatureResponse(struct soap *soap, const struct d__PrepareSignatureResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_xsd__string(soap, &a->Status);
	soap_serialize_xsd__string(soap, &a->SignatureId);
	soap_serialize_xsd__string(soap, &a->SignedInfoDigest);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_d__PrepareSignatureResponse(struct soap *soap, struct d__PrepareSignatureResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_xsd__string(soap, &a->Status);
	soap_default_xsd__string(soap, &a->SignatureId);
	soap_default_xsd__string(soap, &a->SignedInfoDigest);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_d__PrepareSignatureResponse(struct soap *soap, const struct d__PrepareSignatureResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_d__PrepareSignatureResponse);
	if (soap_out_d__PrepareSignatureResponse(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_d__PrepareSignatureResponse(struct soap *soap, const char *tag, int id, const struct d__PrepareSignatureResponse *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_d__PrepareSignatureResponse), type);
	if (a->Status)
		soap_element_result(soap, "Status");
	soap_out_xsd__string(soap, "Status", -1, &a->Status, "");
	soap_out_xsd__string(soap, "SignatureId", -1, &a->SignatureId, "");
	soap_out_xsd__string(soap, "SignedInfoDigest", -1, &a->SignedInfoDigest, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct d__PrepareSignatureResponse * SOAP_FMAC4 soap_get_d__PrepareSignatureResponse(struct soap *soap, struct d__PrepareSignatureResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_d__PrepareSignatureResponse(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct d__PrepareSignatureResponse * SOAP_FMAC4 soap_in_d__PrepareSignatureResponse(struct soap *soap, const char *tag, struct d__PrepareSignatureResponse *a, const char *type)
{
	short soap_flag_Status = 1, soap_flag_SignatureId = 1, soap_flag_SignedInfoDigest = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct d__PrepareSignatureResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_d__PrepareSignatureResponse, sizeof(struct d__PrepareSignatureResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_d__PrepareSignatureResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_Status && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "Status", &a->Status, "xsd:string"))
				{	soap_flag_Status--;
					continue;
				}
			if (soap_flag_SignatureId && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "SignatureId", &a->SignatureId, "xsd:string"))
				{	soap_flag_SignatureId--;
					continue;
				}
			if (soap_flag_SignedInfoDigest && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "SignedInfoDigest", &a->SignedInfoDigest, "xsd:string"))
				{	soap_flag_SignedInfoDigest--;
					continue;
				}
			soap_check_result(soap, "Status");
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct d__PrepareSignatureResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_d__PrepareSignatureResponse, 0, sizeof(struct d__PrepareSignatureResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_d__GetSignatureModules(struct soap *soap, const struct d__GetSignatureModules *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_xsd__string(soap, &a->Platform);
	soap_serialize_xsd__string(soap, &a->Phase);
	soap_serialize_xsd__string(soap, &a->Type);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_d__GetSignatureModules(struct soap *soap, struct d__GetSignatureModules *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_xsd__int(soap, &a->Sesscode);
	soap_default_xsd__string(soap, &a->Platform);
	soap_default_xsd__string(soap, &a->Phase);
	soap_default_xsd__string(soap, &a->Type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_d__GetSignatureModules(struct soap *soap, const struct d__GetSignatureModules *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_d__GetSignatureModules);
	if (soap_out_d__GetSignatureModules(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_d__GetSignatureModules(struct soap *soap, const char *tag, int id, const struct d__GetSignatureModules *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_d__GetSignatureModules), type);
	soap_out_xsd__int(soap, "Sesscode", -1, &a->Sesscode, "");
	soap_out_xsd__string(soap, "Platform", -1, &a->Platform, "");
	soap_out_xsd__string(soap, "Phase", -1, &a->Phase, "");
	soap_out_xsd__string(soap, "Type", -1, &a->Type, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct d__GetSignatureModules * SOAP_FMAC4 soap_get_d__GetSignatureModules(struct soap *soap, struct d__GetSignatureModules *p, const char *tag, const char *type)
{
	if ((p = soap_in_d__GetSignatureModules(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct d__GetSignatureModules * SOAP_FMAC4 soap_in_d__GetSignatureModules(struct soap *soap, const char *tag, struct d__GetSignatureModules *a, const char *type)
{
	short soap_flag_Sesscode = 1, soap_flag_Platform = 1, soap_flag_Phase = 1, soap_flag_Type = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct d__GetSignatureModules *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_d__GetSignatureModules, sizeof(struct d__GetSignatureModules), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_d__GetSignatureModules(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_Sesscode && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_xsd__int(soap, "Sesscode", &a->Sesscode, "xsd:int"))
				{	soap_flag_Sesscode--;
					continue;
				}
			if (soap_flag_Platform && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "Platform", &a->Platform, "xsd:string"))
				{	soap_flag_Platform--;
					continue;
				}
			if (soap_flag_Phase && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "Phase", &a->Phase, "xsd:string"))
				{	soap_flag_Phase--;
					continue;
				}
			if (soap_flag_Type && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "Type", &a->Type, "xsd:string"))
				{	soap_flag_Type--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_Sesscode > 0))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct d__GetSignatureModules *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_d__GetSignatureModules, 0, sizeof(struct d__GetSignatureModules), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_d__GetSignatureModulesResponse(struct soap *soap, const struct d__GetSignatureModulesResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_xsd__string(soap, &a->Status);
	soap_serialize_PointerTod__SignatureModulesArray(soap, &a->Modules);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_d__GetSignatureModulesResponse(struct soap *soap, struct d__GetSignatureModulesResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_xsd__string(soap, &a->Status);
	a->Modules = NULL;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_d__GetSignatureModulesResponse(struct soap *soap, const struct d__GetSignatureModulesResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_d__GetSignatureModulesResponse);
	if (soap_out_d__GetSignatureModulesResponse(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_d__GetSignatureModulesResponse(struct soap *soap, const char *tag, int id, const struct d__GetSignatureModulesResponse *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_d__GetSignatureModulesResponse), type);
	if (a->Status)
		soap_element_result(soap, "Status");
	soap_out_xsd__string(soap, "Status", -1, &a->Status, "");
	soap_out_PointerTod__SignatureModulesArray(soap, "Modules", -1, &a->Modules, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct d__GetSignatureModulesResponse * SOAP_FMAC4 soap_get_d__GetSignatureModulesResponse(struct soap *soap, struct d__GetSignatureModulesResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_d__GetSignatureModulesResponse(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct d__GetSignatureModulesResponse * SOAP_FMAC4 soap_in_d__GetSignatureModulesResponse(struct soap *soap, const char *tag, struct d__GetSignatureModulesResponse *a, const char *type)
{
	short soap_flag_Status = 1, soap_flag_Modules = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct d__GetSignatureModulesResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_d__GetSignatureModulesResponse, sizeof(struct d__GetSignatureModulesResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_d__GetSignatureModulesResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_Status && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "Status", &a->Status, "xsd:string"))
				{	soap_flag_Status--;
					continue;
				}
			if (soap_flag_Modules && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTod__SignatureModulesArray(soap, "Modules", &a->Modules, "d:SignatureModulesArray"))
				{	soap_flag_Modules--;
					continue;
				}
			soap_check_result(soap, "Status");
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct d__GetSignatureModulesResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_d__GetSignatureModulesResponse, 0, sizeof(struct d__GetSignatureModulesResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_d__SignatureModulesArray(struct soap *soap, const struct d__SignatureModulesArray *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	if (a->__ptrModules)
	{	int i;
		for (i = 0; i < a->__sizeOfModules; i++)
		{
			soap_embedded(soap, a->__ptrModules + i, SOAP_TYPE_d__SignatureModule);
			soap_serialize_d__SignatureModule(soap, a->__ptrModules + i);
		}
	}
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_d__SignatureModulesArray(struct soap *soap, struct d__SignatureModulesArray *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->__sizeOfModules = 0;
	a->__ptrModules = NULL;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_d__SignatureModulesArray(struct soap *soap, const struct d__SignatureModulesArray *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_d__SignatureModulesArray);
	if (soap_out_d__SignatureModulesArray(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_d__SignatureModulesArray(struct soap *soap, const char *tag, int id, const struct d__SignatureModulesArray *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_d__SignatureModulesArray), type);
	if (a->__ptrModules)
	{	int i;
		for (i = 0; i < a->__sizeOfModules; i++)
			soap_out_d__SignatureModule(soap, "Modules", -1, a->__ptrModules + i, "");
	}
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct d__SignatureModulesArray * SOAP_FMAC4 soap_get_d__SignatureModulesArray(struct soap *soap, struct d__SignatureModulesArray *p, const char *tag, const char *type)
{
	if ((p = soap_in_d__SignatureModulesArray(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct d__SignatureModulesArray * SOAP_FMAC4 soap_in_d__SignatureModulesArray(struct soap *soap, const char *tag, struct d__SignatureModulesArray *a, const char *type)
{
	short soap_flag___ptrModules = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct d__SignatureModulesArray *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_d__SignatureModulesArray, sizeof(struct d__SignatureModulesArray), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_d__SignatureModulesArray(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag___ptrModules && soap->error == SOAP_TAG_MISMATCH)
			{	struct d__SignatureModule *p;
				soap_new_block(soap);
				for (a->__sizeOfModules = 0; !soap_element_begin_in(soap, "Modules", 1, NULL); a->__sizeOfModules++)
				{	p = (struct d__SignatureModule *)soap_push_block(soap, sizeof(struct d__SignatureModule));
					soap_default_d__SignatureModule(soap, p);
					soap_revert(soap);
					if (!soap_in_d__SignatureModule(soap, "Modules", p, "d:SignatureModule"))
						break;
					soap_flag___ptrModules = 0;
				}
				a->__ptrModules = (struct d__SignatureModule *)soap_save_block(soap, NULL, 1);
				if (!soap_flag___ptrModules && soap->error == SOAP_TAG_MISMATCH)
					continue;
			}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct d__SignatureModulesArray *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_d__SignatureModulesArray, 0, sizeof(struct d__SignatureModulesArray), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_d__SignatureModule(struct soap *soap, const struct d__SignatureModule *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_xsd__string(soap, &a->Name);
	soap_serialize_xsd__string(soap, &a->Type);
	soap_serialize_xsd__string(soap, &a->Location);
	soap_serialize_xsd__string(soap, &a->ContentType);
	soap_serialize_xsd__string(soap, &a->Content);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_d__SignatureModule(struct soap *soap, struct d__SignatureModule *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_xsd__string(soap, &a->Name);
	soap_default_xsd__string(soap, &a->Type);
	soap_default_xsd__string(soap, &a->Location);
	soap_default_xsd__string(soap, &a->ContentType);
	soap_default_xsd__string(soap, &a->Content);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_d__SignatureModule(struct soap *soap, const struct d__SignatureModule *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_d__SignatureModule);
	if (soap_out_d__SignatureModule(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_d__SignatureModule(struct soap *soap, const char *tag, int id, const struct d__SignatureModule *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_d__SignatureModule), type);
	soap_out_xsd__string(soap, "Name", -1, &a->Name, "");
	soap_out_xsd__string(soap, "Type", -1, &a->Type, "");
	soap_out_xsd__string(soap, "Location", -1, &a->Location, "");
	soap_out_xsd__string(soap, "ContentType", -1, &a->ContentType, "");
	soap_out_xsd__string(soap, "Content", -1, &a->Content, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct d__SignatureModule * SOAP_FMAC4 soap_get_d__SignatureModule(struct soap *soap, struct d__SignatureModule *p, const char *tag, const char *type)
{
	if ((p = soap_in_d__SignatureModule(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct d__SignatureModule * SOAP_FMAC4 soap_in_d__SignatureModule(struct soap *soap, const char *tag, struct d__SignatureModule *a, const char *type)
{
	short soap_flag_Name = 1, soap_flag_Type = 1, soap_flag_Location = 1, soap_flag_ContentType = 1, soap_flag_Content = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct d__SignatureModule *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_d__SignatureModule, sizeof(struct d__SignatureModule), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_d__SignatureModule(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_Name && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "Name", &a->Name, "xsd:string"))
				{	soap_flag_Name--;
					continue;
				}
			if (soap_flag_Type && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "Type", &a->Type, "xsd:string"))
				{	soap_flag_Type--;
					continue;
				}
			if (soap_flag_Location && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "Location", &a->Location, "xsd:string"))
				{	soap_flag_Location--;
					continue;
				}
			if (soap_flag_ContentType && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "ContentType", &a->ContentType, "xsd:string"))
				{	soap_flag_ContentType--;
					continue;
				}
			if (soap_flag_Content && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "Content", &a->Content, "xsd:string"))
				{	soap_flag_Content--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct d__SignatureModule *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_d__SignatureModule, 0, sizeof(struct d__SignatureModule), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_d__GetCRL(struct soap *soap, const struct d__GetCRL *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_xsd__string(soap, &a->SignatureId);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_d__GetCRL(struct soap *soap, struct d__GetCRL *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_xsd__int(soap, &a->Sesscode);
	soap_default_xsd__string(soap, &a->SignatureId);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_d__GetCRL(struct soap *soap, const struct d__GetCRL *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_d__GetCRL);
	if (soap_out_d__GetCRL(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_d__GetCRL(struct soap *soap, const char *tag, int id, const struct d__GetCRL *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_d__GetCRL), type);
	soap_out_xsd__int(soap, "Sesscode", -1, &a->Sesscode, "");
	soap_out_xsd__string(soap, "SignatureId", -1, &a->SignatureId, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct d__GetCRL * SOAP_FMAC4 soap_get_d__GetCRL(struct soap *soap, struct d__GetCRL *p, const char *tag, const char *type)
{
	if ((p = soap_in_d__GetCRL(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct d__GetCRL * SOAP_FMAC4 soap_in_d__GetCRL(struct soap *soap, const char *tag, struct d__GetCRL *a, const char *type)
{
	short soap_flag_Sesscode = 1, soap_flag_SignatureId = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct d__GetCRL *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_d__GetCRL, sizeof(struct d__GetCRL), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_d__GetCRL(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_Sesscode && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_xsd__int(soap, "Sesscode", &a->Sesscode, "xsd:int"))
				{	soap_flag_Sesscode--;
					continue;
				}
			if (soap_flag_SignatureId && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "SignatureId", &a->SignatureId, "xsd:string"))
				{	soap_flag_SignatureId--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_Sesscode > 0))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct d__GetCRL *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_d__GetCRL, 0, sizeof(struct d__GetCRL), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_d__GetCRLResponse(struct soap *soap, const struct d__GetCRLResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_xsd__string(soap, &a->Status);
	soap_serialize_xsd__string(soap, &a->CRLData);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_d__GetCRLResponse(struct soap *soap, struct d__GetCRLResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_xsd__string(soap, &a->Status);
	soap_default_xsd__string(soap, &a->CRLData);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_d__GetCRLResponse(struct soap *soap, const struct d__GetCRLResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_d__GetCRLResponse);
	if (soap_out_d__GetCRLResponse(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_d__GetCRLResponse(struct soap *soap, const char *tag, int id, const struct d__GetCRLResponse *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_d__GetCRLResponse), type);
	if (a->Status)
		soap_element_result(soap, "Status");
	soap_out_xsd__string(soap, "Status", -1, &a->Status, "");
	soap_out_xsd__string(soap, "CRLData", -1, &a->CRLData, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct d__GetCRLResponse * SOAP_FMAC4 soap_get_d__GetCRLResponse(struct soap *soap, struct d__GetCRLResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_d__GetCRLResponse(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct d__GetCRLResponse * SOAP_FMAC4 soap_in_d__GetCRLResponse(struct soap *soap, const char *tag, struct d__GetCRLResponse *a, const char *type)
{
	short soap_flag_Status = 1, soap_flag_CRLData = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct d__GetCRLResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_d__GetCRLResponse, sizeof(struct d__GetCRLResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_d__GetCRLResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_Status && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "Status", &a->Status, "xsd:string"))
				{	soap_flag_Status--;
					continue;
				}
			if (soap_flag_CRLData && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "CRLData", &a->CRLData, "xsd:string"))
				{	soap_flag_CRLData--;
					continue;
				}
			soap_check_result(soap, "Status");
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct d__GetCRLResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_d__GetCRLResponse, 0, sizeof(struct d__GetCRLResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_d__GetTimestamp(struct soap *soap, const struct d__GetTimestamp *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_xsd__string(soap, &a->TimestampId);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_d__GetTimestamp(struct soap *soap, struct d__GetTimestamp *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_xsd__int(soap, &a->Sesscode);
	soap_default_xsd__string(soap, &a->TimestampId);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_d__GetTimestamp(struct soap *soap, const struct d__GetTimestamp *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_d__GetTimestamp);
	if (soap_out_d__GetTimestamp(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_d__GetTimestamp(struct soap *soap, const char *tag, int id, const struct d__GetTimestamp *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_d__GetTimestamp), type);
	soap_out_xsd__int(soap, "Sesscode", -1, &a->Sesscode, "");
	soap_out_xsd__string(soap, "TimestampId", -1, &a->TimestampId, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct d__GetTimestamp * SOAP_FMAC4 soap_get_d__GetTimestamp(struct soap *soap, struct d__GetTimestamp *p, const char *tag, const char *type)
{
	if ((p = soap_in_d__GetTimestamp(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct d__GetTimestamp * SOAP_FMAC4 soap_in_d__GetTimestamp(struct soap *soap, const char *tag, struct d__GetTimestamp *a, const char *type)
{
	short soap_flag_Sesscode = 1, soap_flag_TimestampId = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct d__GetTimestamp *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_d__GetTimestamp, sizeof(struct d__GetTimestamp), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_d__GetTimestamp(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_Sesscode && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_xsd__int(soap, "Sesscode", &a->Sesscode, "xsd:int"))
				{	soap_flag_Sesscode--;
					continue;
				}
			if (soap_flag_TimestampId && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "TimestampId", &a->TimestampId, "xsd:string"))
				{	soap_flag_TimestampId--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_Sesscode > 0))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct d__GetTimestamp *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_d__GetTimestamp, 0, sizeof(struct d__GetTimestamp), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_d__GetTimestampResponse(struct soap *soap, const struct d__GetTimestampResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_xsd__string(soap, &a->Status);
	soap_serialize_xsd__string(soap, &a->TimestampData);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_d__GetTimestampResponse(struct soap *soap, struct d__GetTimestampResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_xsd__string(soap, &a->Status);
	soap_default_xsd__string(soap, &a->TimestampData);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_d__GetTimestampResponse(struct soap *soap, const struct d__GetTimestampResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_d__GetTimestampResponse);
	if (soap_out_d__GetTimestampResponse(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_d__GetTimestampResponse(struct soap *soap, const char *tag, int id, const struct d__GetTimestampResponse *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_d__GetTimestampResponse), type);
	if (a->Status)
		soap_element_result(soap, "Status");
	soap_out_xsd__string(soap, "Status", -1, &a->Status, "");
	soap_out_xsd__string(soap, "TimestampData", -1, &a->TimestampData, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct d__GetTimestampResponse * SOAP_FMAC4 soap_get_d__GetTimestampResponse(struct soap *soap, struct d__GetTimestampResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_d__GetTimestampResponse(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct d__GetTimestampResponse * SOAP_FMAC4 soap_in_d__GetTimestampResponse(struct soap *soap, const char *tag, struct d__GetTimestampResponse *a, const char *type)
{
	short soap_flag_Status = 1, soap_flag_TimestampData = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct d__GetTimestampResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_d__GetTimestampResponse, sizeof(struct d__GetTimestampResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_d__GetTimestampResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_Status && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "Status", &a->Status, "xsd:string"))
				{	soap_flag_Status--;
					continue;
				}
			if (soap_flag_TimestampData && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "TimestampData", &a->TimestampData, "xsd:string"))
				{	soap_flag_TimestampData--;
					continue;
				}
			soap_check_result(soap, "Status");
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct d__GetTimestampResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_d__GetTimestampResponse, 0, sizeof(struct d__GetTimestampResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_d__GetTSACertificate(struct soap *soap, const struct d__GetTSACertificate *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_xsd__string(soap, &a->TimestampId);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_d__GetTSACertificate(struct soap *soap, struct d__GetTSACertificate *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_xsd__int(soap, &a->Sesscode);
	soap_default_xsd__string(soap, &a->TimestampId);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_d__GetTSACertificate(struct soap *soap, const struct d__GetTSACertificate *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_d__GetTSACertificate);
	if (soap_out_d__GetTSACertificate(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_d__GetTSACertificate(struct soap *soap, const char *tag, int id, const struct d__GetTSACertificate *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_d__GetTSACertificate), type);
	soap_out_xsd__int(soap, "Sesscode", -1, &a->Sesscode, "");
	soap_out_xsd__string(soap, "TimestampId", -1, &a->TimestampId, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct d__GetTSACertificate * SOAP_FMAC4 soap_get_d__GetTSACertificate(struct soap *soap, struct d__GetTSACertificate *p, const char *tag, const char *type)
{
	if ((p = soap_in_d__GetTSACertificate(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct d__GetTSACertificate * SOAP_FMAC4 soap_in_d__GetTSACertificate(struct soap *soap, const char *tag, struct d__GetTSACertificate *a, const char *type)
{
	short soap_flag_Sesscode = 1, soap_flag_TimestampId = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct d__GetTSACertificate *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_d__GetTSACertificate, sizeof(struct d__GetTSACertificate), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_d__GetTSACertificate(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_Sesscode && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_xsd__int(soap, "Sesscode", &a->Sesscode, "xsd:int"))
				{	soap_flag_Sesscode--;
					continue;
				}
			if (soap_flag_TimestampId && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "TimestampId", &a->TimestampId, "xsd:string"))
				{	soap_flag_TimestampId--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_Sesscode > 0))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct d__GetTSACertificate *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_d__GetTSACertificate, 0, sizeof(struct d__GetTSACertificate), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_d__GetTSACertificateResponse(struct soap *soap, const struct d__GetTSACertificateResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_xsd__string(soap, &a->Status);
	soap_serialize_xsd__string(soap, &a->CertificateData);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_d__GetTSACertificateResponse(struct soap *soap, struct d__GetTSACertificateResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_xsd__string(soap, &a->Status);
	soap_default_xsd__string(soap, &a->CertificateData);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_d__GetTSACertificateResponse(struct soap *soap, const struct d__GetTSACertificateResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_d__GetTSACertificateResponse);
	if (soap_out_d__GetTSACertificateResponse(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_d__GetTSACertificateResponse(struct soap *soap, const char *tag, int id, const struct d__GetTSACertificateResponse *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_d__GetTSACertificateResponse), type);
	if (a->Status)
		soap_element_result(soap, "Status");
	soap_out_xsd__string(soap, "Status", -1, &a->Status, "");
	soap_out_xsd__string(soap, "CertificateData", -1, &a->CertificateData, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct d__GetTSACertificateResponse * SOAP_FMAC4 soap_get_d__GetTSACertificateResponse(struct soap *soap, struct d__GetTSACertificateResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_d__GetTSACertificateResponse(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct d__GetTSACertificateResponse * SOAP_FMAC4 soap_in_d__GetTSACertificateResponse(struct soap *soap, const char *tag, struct d__GetTSACertificateResponse *a, const char *type)
{
	short soap_flag_Status = 1, soap_flag_CertificateData = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct d__GetTSACertificateResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_d__GetTSACertificateResponse, sizeof(struct d__GetTSACertificateResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_d__GetTSACertificateResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_Status && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "Status", &a->Status, "xsd:string"))
				{	soap_flag_Status--;
					continue;
				}
			if (soap_flag_CertificateData && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "CertificateData", &a->CertificateData, "xsd:string"))
				{	soap_flag_CertificateData--;
					continue;
				}
			soap_check_result(soap, "Status");
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct d__GetTSACertificateResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_d__GetTSACertificateResponse, 0, sizeof(struct d__GetTSACertificateResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_d__GetNotary(struct soap *soap, const struct d__GetNotary *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_xsd__string(soap, &a->SignatureId);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_d__GetNotary(struct soap *soap, struct d__GetNotary *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_xsd__int(soap, &a->Sesscode);
	soap_default_xsd__string(soap, &a->SignatureId);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_d__GetNotary(struct soap *soap, const struct d__GetNotary *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_d__GetNotary);
	if (soap_out_d__GetNotary(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_d__GetNotary(struct soap *soap, const char *tag, int id, const struct d__GetNotary *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_d__GetNotary), type);
	soap_out_xsd__int(soap, "Sesscode", -1, &a->Sesscode, "");
	soap_out_xsd__string(soap, "SignatureId", -1, &a->SignatureId, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct d__GetNotary * SOAP_FMAC4 soap_get_d__GetNotary(struct soap *soap, struct d__GetNotary *p, const char *tag, const char *type)
{
	if ((p = soap_in_d__GetNotary(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct d__GetNotary * SOAP_FMAC4 soap_in_d__GetNotary(struct soap *soap, const char *tag, struct d__GetNotary *a, const char *type)
{
	short soap_flag_Sesscode = 1, soap_flag_SignatureId = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct d__GetNotary *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_d__GetNotary, sizeof(struct d__GetNotary), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_d__GetNotary(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_Sesscode && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_xsd__int(soap, "Sesscode", &a->Sesscode, "xsd:int"))
				{	soap_flag_Sesscode--;
					continue;
				}
			if (soap_flag_SignatureId && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "SignatureId", &a->SignatureId, "xsd:string"))
				{	soap_flag_SignatureId--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_Sesscode > 0))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct d__GetNotary *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_d__GetNotary, 0, sizeof(struct d__GetNotary), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_d__GetNotaryResponse(struct soap *soap, const struct d__GetNotaryResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_xsd__string(soap, &a->Status);
	soap_serialize_xsd__string(soap, &a->OcspData);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_d__GetNotaryResponse(struct soap *soap, struct d__GetNotaryResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_xsd__string(soap, &a->Status);
	soap_default_xsd__string(soap, &a->OcspData);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_d__GetNotaryResponse(struct soap *soap, const struct d__GetNotaryResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_d__GetNotaryResponse);
	if (soap_out_d__GetNotaryResponse(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_d__GetNotaryResponse(struct soap *soap, const char *tag, int id, const struct d__GetNotaryResponse *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_d__GetNotaryResponse), type);
	if (a->Status)
		soap_element_result(soap, "Status");
	soap_out_xsd__string(soap, "Status", -1, &a->Status, "");
	soap_out_xsd__string(soap, "OcspData", -1, &a->OcspData, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct d__GetNotaryResponse * SOAP_FMAC4 soap_get_d__GetNotaryResponse(struct soap *soap, struct d__GetNotaryResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_d__GetNotaryResponse(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct d__GetNotaryResponse * SOAP_FMAC4 soap_in_d__GetNotaryResponse(struct soap *soap, const char *tag, struct d__GetNotaryResponse *a, const char *type)
{
	short soap_flag_Status = 1, soap_flag_OcspData = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct d__GetNotaryResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_d__GetNotaryResponse, sizeof(struct d__GetNotaryResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_d__GetNotaryResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_Status && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "Status", &a->Status, "xsd:string"))
				{	soap_flag_Status--;
					continue;
				}
			if (soap_flag_OcspData && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "OcspData", &a->OcspData, "xsd:string"))
				{	soap_flag_OcspData--;
					continue;
				}
			soap_check_result(soap, "Status");
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct d__GetNotaryResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_d__GetNotaryResponse, 0, sizeof(struct d__GetNotaryResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_d__GetNotarysCertificate(struct soap *soap, const struct d__GetNotarysCertificate *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_xsd__string(soap, &a->SignatureId);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_d__GetNotarysCertificate(struct soap *soap, struct d__GetNotarysCertificate *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_xsd__int(soap, &a->Sesscode);
	soap_default_xsd__string(soap, &a->SignatureId);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_d__GetNotarysCertificate(struct soap *soap, const struct d__GetNotarysCertificate *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_d__GetNotarysCertificate);
	if (soap_out_d__GetNotarysCertificate(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_d__GetNotarysCertificate(struct soap *soap, const char *tag, int id, const struct d__GetNotarysCertificate *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_d__GetNotarysCertificate), type);
	soap_out_xsd__int(soap, "Sesscode", -1, &a->Sesscode, "");
	soap_out_xsd__string(soap, "SignatureId", -1, &a->SignatureId, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct d__GetNotarysCertificate * SOAP_FMAC4 soap_get_d__GetNotarysCertificate(struct soap *soap, struct d__GetNotarysCertificate *p, const char *tag, const char *type)
{
	if ((p = soap_in_d__GetNotarysCertificate(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct d__GetNotarysCertificate * SOAP_FMAC4 soap_in_d__GetNotarysCertificate(struct soap *soap, const char *tag, struct d__GetNotarysCertificate *a, const char *type)
{
	short soap_flag_Sesscode = 1, soap_flag_SignatureId = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct d__GetNotarysCertificate *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_d__GetNotarysCertificate, sizeof(struct d__GetNotarysCertificate), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_d__GetNotarysCertificate(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_Sesscode && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_xsd__int(soap, "Sesscode", &a->Sesscode, "xsd:int"))
				{	soap_flag_Sesscode--;
					continue;
				}
			if (soap_flag_SignatureId && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "SignatureId", &a->SignatureId, "xsd:string"))
				{	soap_flag_SignatureId--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_Sesscode > 0))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct d__GetNotarysCertificate *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_d__GetNotarysCertificate, 0, sizeof(struct d__GetNotarysCertificate), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_d__GetNotarysCertificateResponse(struct soap *soap, const struct d__GetNotarysCertificateResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_xsd__string(soap, &a->Status);
	soap_serialize_xsd__string(soap, &a->CertificateData);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_d__GetNotarysCertificateResponse(struct soap *soap, struct d__GetNotarysCertificateResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_xsd__string(soap, &a->Status);
	soap_default_xsd__string(soap, &a->CertificateData);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_d__GetNotarysCertificateResponse(struct soap *soap, const struct d__GetNotarysCertificateResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_d__GetNotarysCertificateResponse);
	if (soap_out_d__GetNotarysCertificateResponse(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_d__GetNotarysCertificateResponse(struct soap *soap, const char *tag, int id, const struct d__GetNotarysCertificateResponse *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_d__GetNotarysCertificateResponse), type);
	if (a->Status)
		soap_element_result(soap, "Status");
	soap_out_xsd__string(soap, "Status", -1, &a->Status, "");
	soap_out_xsd__string(soap, "CertificateData", -1, &a->CertificateData, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct d__GetNotarysCertificateResponse * SOAP_FMAC4 soap_get_d__GetNotarysCertificateResponse(struct soap *soap, struct d__GetNotarysCertificateResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_d__GetNotarysCertificateResponse(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct d__GetNotarysCertificateResponse * SOAP_FMAC4 soap_in_d__GetNotarysCertificateResponse(struct soap *soap, const char *tag, struct d__GetNotarysCertificateResponse *a, const char *type)
{
	short soap_flag_Status = 1, soap_flag_CertificateData = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct d__GetNotarysCertificateResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_d__GetNotarysCertificateResponse, sizeof(struct d__GetNotarysCertificateResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_d__GetNotarysCertificateResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_Status && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "Status", &a->Status, "xsd:string"))
				{	soap_flag_Status--;
					continue;
				}
			if (soap_flag_CertificateData && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "CertificateData", &a->CertificateData, "xsd:string"))
				{	soap_flag_CertificateData--;
					continue;
				}
			soap_check_result(soap, "Status");
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct d__GetNotarysCertificateResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_d__GetNotarysCertificateResponse, 0, sizeof(struct d__GetNotarysCertificateResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_d__GetSignersCertificate(struct soap *soap, const struct d__GetSignersCertificate *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_xsd__string(soap, &a->SignatureId);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_d__GetSignersCertificate(struct soap *soap, struct d__GetSignersCertificate *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_xsd__int(soap, &a->Sesscode);
	soap_default_xsd__string(soap, &a->SignatureId);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_d__GetSignersCertificate(struct soap *soap, const struct d__GetSignersCertificate *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_d__GetSignersCertificate);
	if (soap_out_d__GetSignersCertificate(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_d__GetSignersCertificate(struct soap *soap, const char *tag, int id, const struct d__GetSignersCertificate *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_d__GetSignersCertificate), type);
	soap_out_xsd__int(soap, "Sesscode", -1, &a->Sesscode, "");
	soap_out_xsd__string(soap, "SignatureId", -1, &a->SignatureId, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct d__GetSignersCertificate * SOAP_FMAC4 soap_get_d__GetSignersCertificate(struct soap *soap, struct d__GetSignersCertificate *p, const char *tag, const char *type)
{
	if ((p = soap_in_d__GetSignersCertificate(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct d__GetSignersCertificate * SOAP_FMAC4 soap_in_d__GetSignersCertificate(struct soap *soap, const char *tag, struct d__GetSignersCertificate *a, const char *type)
{
	short soap_flag_Sesscode = 1, soap_flag_SignatureId = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct d__GetSignersCertificate *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_d__GetSignersCertificate, sizeof(struct d__GetSignersCertificate), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_d__GetSignersCertificate(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_Sesscode && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_xsd__int(soap, "Sesscode", &a->Sesscode, "xsd:int"))
				{	soap_flag_Sesscode--;
					continue;
				}
			if (soap_flag_SignatureId && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "SignatureId", &a->SignatureId, "xsd:string"))
				{	soap_flag_SignatureId--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_Sesscode > 0))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct d__GetSignersCertificate *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_d__GetSignersCertificate, 0, sizeof(struct d__GetSignersCertificate), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_d__GetSignersCertificateResponse(struct soap *soap, const struct d__GetSignersCertificateResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_xsd__string(soap, &a->Status);
	soap_serialize_xsd__string(soap, &a->CertificateData);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_d__GetSignersCertificateResponse(struct soap *soap, struct d__GetSignersCertificateResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_xsd__string(soap, &a->Status);
	soap_default_xsd__string(soap, &a->CertificateData);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_d__GetSignersCertificateResponse(struct soap *soap, const struct d__GetSignersCertificateResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_d__GetSignersCertificateResponse);
	if (soap_out_d__GetSignersCertificateResponse(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_d__GetSignersCertificateResponse(struct soap *soap, const char *tag, int id, const struct d__GetSignersCertificateResponse *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_d__GetSignersCertificateResponse), type);
	if (a->Status)
		soap_element_result(soap, "Status");
	soap_out_xsd__string(soap, "Status", -1, &a->Status, "");
	soap_out_xsd__string(soap, "CertificateData", -1, &a->CertificateData, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct d__GetSignersCertificateResponse * SOAP_FMAC4 soap_get_d__GetSignersCertificateResponse(struct soap *soap, struct d__GetSignersCertificateResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_d__GetSignersCertificateResponse(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct d__GetSignersCertificateResponse * SOAP_FMAC4 soap_in_d__GetSignersCertificateResponse(struct soap *soap, const char *tag, struct d__GetSignersCertificateResponse *a, const char *type)
{
	short soap_flag_Status = 1, soap_flag_CertificateData = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct d__GetSignersCertificateResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_d__GetSignersCertificateResponse, sizeof(struct d__GetSignersCertificateResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_d__GetSignersCertificateResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_Status && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "Status", &a->Status, "xsd:string"))
				{	soap_flag_Status--;
					continue;
				}
			if (soap_flag_CertificateData && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "CertificateData", &a->CertificateData, "xsd:string"))
				{	soap_flag_CertificateData--;
					continue;
				}
			soap_check_result(soap, "Status");
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct d__GetSignersCertificateResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_d__GetSignersCertificateResponse, 0, sizeof(struct d__GetSignersCertificateResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_d__GetDataFile(struct soap *soap, const struct d__GetDataFile *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_xsd__string(soap, &a->DataFileId);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_d__GetDataFile(struct soap *soap, struct d__GetDataFile *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_xsd__int(soap, &a->Sesscode);
	soap_default_xsd__string(soap, &a->DataFileId);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_d__GetDataFile(struct soap *soap, const struct d__GetDataFile *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_d__GetDataFile);
	if (soap_out_d__GetDataFile(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_d__GetDataFile(struct soap *soap, const char *tag, int id, const struct d__GetDataFile *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_d__GetDataFile), type);
	soap_out_xsd__int(soap, "Sesscode", -1, &a->Sesscode, "");
	soap_out_xsd__string(soap, "DataFileId", -1, &a->DataFileId, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct d__GetDataFile * SOAP_FMAC4 soap_get_d__GetDataFile(struct soap *soap, struct d__GetDataFile *p, const char *tag, const char *type)
{
	if ((p = soap_in_d__GetDataFile(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct d__GetDataFile * SOAP_FMAC4 soap_in_d__GetDataFile(struct soap *soap, const char *tag, struct d__GetDataFile *a, const char *type)
{
	short soap_flag_Sesscode = 1, soap_flag_DataFileId = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct d__GetDataFile *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_d__GetDataFile, sizeof(struct d__GetDataFile), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_d__GetDataFile(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_Sesscode && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_xsd__int(soap, "Sesscode", &a->Sesscode, "xsd:int"))
				{	soap_flag_Sesscode--;
					continue;
				}
			if (soap_flag_DataFileId && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "DataFileId", &a->DataFileId, "xsd:string"))
				{	soap_flag_DataFileId--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_Sesscode > 0))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct d__GetDataFile *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_d__GetDataFile, 0, sizeof(struct d__GetDataFile), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_d__GetDataFileResponse(struct soap *soap, const struct d__GetDataFileResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_xsd__string(soap, &a->Status);
	soap_serialize_PointerTod__DataFileData(soap, &a->DataFileData);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_d__GetDataFileResponse(struct soap *soap, struct d__GetDataFileResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_xsd__string(soap, &a->Status);
	a->DataFileData = NULL;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_d__GetDataFileResponse(struct soap *soap, const struct d__GetDataFileResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_d__GetDataFileResponse);
	if (soap_out_d__GetDataFileResponse(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_d__GetDataFileResponse(struct soap *soap, const char *tag, int id, const struct d__GetDataFileResponse *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_d__GetDataFileResponse), type);
	if (a->Status)
		soap_element_result(soap, "Status");
	soap_out_xsd__string(soap, "Status", -1, &a->Status, "");
	soap_out_PointerTod__DataFileData(soap, "DataFileData", -1, &a->DataFileData, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct d__GetDataFileResponse * SOAP_FMAC4 soap_get_d__GetDataFileResponse(struct soap *soap, struct d__GetDataFileResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_d__GetDataFileResponse(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct d__GetDataFileResponse * SOAP_FMAC4 soap_in_d__GetDataFileResponse(struct soap *soap, const char *tag, struct d__GetDataFileResponse *a, const char *type)
{
	short soap_flag_Status = 1, soap_flag_DataFileData = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct d__GetDataFileResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_d__GetDataFileResponse, sizeof(struct d__GetDataFileResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_d__GetDataFileResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_Status && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "Status", &a->Status, "xsd:string"))
				{	soap_flag_Status--;
					continue;
				}
			if (soap_flag_DataFileData && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTod__DataFileData(soap, "DataFileData", &a->DataFileData, "d:DataFileData"))
				{	soap_flag_DataFileData--;
					continue;
				}
			soap_check_result(soap, "Status");
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct d__GetDataFileResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_d__GetDataFileResponse, 0, sizeof(struct d__GetDataFileResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_d__GetSignedDocInfo(struct soap *soap, const struct d__GetSignedDocInfo *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_d__GetSignedDocInfo(struct soap *soap, struct d__GetSignedDocInfo *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_xsd__int(soap, &a->Sesscode);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_d__GetSignedDocInfo(struct soap *soap, const struct d__GetSignedDocInfo *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_d__GetSignedDocInfo);
	if (soap_out_d__GetSignedDocInfo(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_d__GetSignedDocInfo(struct soap *soap, const char *tag, int id, const struct d__GetSignedDocInfo *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_d__GetSignedDocInfo), type);
	soap_out_xsd__int(soap, "Sesscode", -1, &a->Sesscode, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct d__GetSignedDocInfo * SOAP_FMAC4 soap_get_d__GetSignedDocInfo(struct soap *soap, struct d__GetSignedDocInfo *p, const char *tag, const char *type)
{
	if ((p = soap_in_d__GetSignedDocInfo(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct d__GetSignedDocInfo * SOAP_FMAC4 soap_in_d__GetSignedDocInfo(struct soap *soap, const char *tag, struct d__GetSignedDocInfo *a, const char *type)
{
	short soap_flag_Sesscode = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct d__GetSignedDocInfo *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_d__GetSignedDocInfo, sizeof(struct d__GetSignedDocInfo), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_d__GetSignedDocInfo(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_Sesscode && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_xsd__int(soap, "Sesscode", &a->Sesscode, "xsd:int"))
				{	soap_flag_Sesscode--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_Sesscode > 0))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct d__GetSignedDocInfo *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_d__GetSignedDocInfo, 0, sizeof(struct d__GetSignedDocInfo), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_d__GetSignedDocInfoResponse(struct soap *soap, const struct d__GetSignedDocInfoResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_xsd__string(soap, &a->Status);
	soap_serialize_PointerTod__SignedDocInfo(soap, &a->SignedDocInfo);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_d__GetSignedDocInfoResponse(struct soap *soap, struct d__GetSignedDocInfoResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_xsd__string(soap, &a->Status);
	a->SignedDocInfo = NULL;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_d__GetSignedDocInfoResponse(struct soap *soap, const struct d__GetSignedDocInfoResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_d__GetSignedDocInfoResponse);
	if (soap_out_d__GetSignedDocInfoResponse(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_d__GetSignedDocInfoResponse(struct soap *soap, const char *tag, int id, const struct d__GetSignedDocInfoResponse *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_d__GetSignedDocInfoResponse), type);
	if (a->Status)
		soap_element_result(soap, "Status");
	soap_out_xsd__string(soap, "Status", -1, &a->Status, "");
	soap_out_PointerTod__SignedDocInfo(soap, "SignedDocInfo", -1, &a->SignedDocInfo, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct d__GetSignedDocInfoResponse * SOAP_FMAC4 soap_get_d__GetSignedDocInfoResponse(struct soap *soap, struct d__GetSignedDocInfoResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_d__GetSignedDocInfoResponse(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct d__GetSignedDocInfoResponse * SOAP_FMAC4 soap_in_d__GetSignedDocInfoResponse(struct soap *soap, const char *tag, struct d__GetSignedDocInfoResponse *a, const char *type)
{
	short soap_flag_Status = 1, soap_flag_SignedDocInfo = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct d__GetSignedDocInfoResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_d__GetSignedDocInfoResponse, sizeof(struct d__GetSignedDocInfoResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_d__GetSignedDocInfoResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_Status && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "Status", &a->Status, "xsd:string"))
				{	soap_flag_Status--;
					continue;
				}
			if (soap_flag_SignedDocInfo && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTod__SignedDocInfo(soap, "SignedDocInfo", &a->SignedDocInfo, "d:SignedDocInfo"))
				{	soap_flag_SignedDocInfo--;
					continue;
				}
			soap_check_result(soap, "Status");
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct d__GetSignedDocInfoResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_d__GetSignedDocInfoResponse, 0, sizeof(struct d__GetSignedDocInfoResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_d__GetSignedDoc(struct soap *soap, const struct d__GetSignedDoc *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_d__GetSignedDoc(struct soap *soap, struct d__GetSignedDoc *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_xsd__int(soap, &a->Sesscode);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_d__GetSignedDoc(struct soap *soap, const struct d__GetSignedDoc *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_d__GetSignedDoc);
	if (soap_out_d__GetSignedDoc(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_d__GetSignedDoc(struct soap *soap, const char *tag, int id, const struct d__GetSignedDoc *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_d__GetSignedDoc), type);
	soap_out_xsd__int(soap, "Sesscode", -1, &a->Sesscode, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct d__GetSignedDoc * SOAP_FMAC4 soap_get_d__GetSignedDoc(struct soap *soap, struct d__GetSignedDoc *p, const char *tag, const char *type)
{
	if ((p = soap_in_d__GetSignedDoc(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct d__GetSignedDoc * SOAP_FMAC4 soap_in_d__GetSignedDoc(struct soap *soap, const char *tag, struct d__GetSignedDoc *a, const char *type)
{
	short soap_flag_Sesscode = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct d__GetSignedDoc *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_d__GetSignedDoc, sizeof(struct d__GetSignedDoc), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_d__GetSignedDoc(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_Sesscode && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_xsd__int(soap, "Sesscode", &a->Sesscode, "xsd:int"))
				{	soap_flag_Sesscode--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_Sesscode > 0))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct d__GetSignedDoc *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_d__GetSignedDoc, 0, sizeof(struct d__GetSignedDoc), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_d__GetSignedDocResponse(struct soap *soap, const struct d__GetSignedDocResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_xsd__string(soap, &a->Status);
	soap_serialize_xsd__string(soap, &a->SignedDocData);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_d__GetSignedDocResponse(struct soap *soap, struct d__GetSignedDocResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_xsd__string(soap, &a->Status);
	soap_default_xsd__string(soap, &a->SignedDocData);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_d__GetSignedDocResponse(struct soap *soap, const struct d__GetSignedDocResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_d__GetSignedDocResponse);
	if (soap_out_d__GetSignedDocResponse(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_d__GetSignedDocResponse(struct soap *soap, const char *tag, int id, const struct d__GetSignedDocResponse *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_d__GetSignedDocResponse), type);
	if (a->Status)
		soap_element_result(soap, "Status");
	soap_out_xsd__string(soap, "Status", -1, &a->Status, "");
	soap_out_xsd__string(soap, "SignedDocData", -1, &a->SignedDocData, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct d__GetSignedDocResponse * SOAP_FMAC4 soap_get_d__GetSignedDocResponse(struct soap *soap, struct d__GetSignedDocResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_d__GetSignedDocResponse(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct d__GetSignedDocResponse * SOAP_FMAC4 soap_in_d__GetSignedDocResponse(struct soap *soap, const char *tag, struct d__GetSignedDocResponse *a, const char *type)
{
	short soap_flag_Status = 1, soap_flag_SignedDocData = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct d__GetSignedDocResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_d__GetSignedDocResponse, sizeof(struct d__GetSignedDocResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_d__GetSignedDocResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_Status && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "Status", &a->Status, "xsd:string"))
				{	soap_flag_Status--;
					continue;
				}
			if (soap_flag_SignedDocData && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "SignedDocData", &a->SignedDocData, "xsd:string"))
				{	soap_flag_SignedDocData--;
					continue;
				}
			soap_check_result(soap, "Status");
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct d__GetSignedDocResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_d__GetSignedDocResponse, 0, sizeof(struct d__GetSignedDocResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_d__RemoveDataFile(struct soap *soap, const struct d__RemoveDataFile *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_xsd__string(soap, &a->DataFileId);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_d__RemoveDataFile(struct soap *soap, struct d__RemoveDataFile *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_xsd__int(soap, &a->Sesscode);
	soap_default_xsd__string(soap, &a->DataFileId);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_d__RemoveDataFile(struct soap *soap, const struct d__RemoveDataFile *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_d__RemoveDataFile);
	if (soap_out_d__RemoveDataFile(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_d__RemoveDataFile(struct soap *soap, const char *tag, int id, const struct d__RemoveDataFile *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_d__RemoveDataFile), type);
	soap_out_xsd__int(soap, "Sesscode", -1, &a->Sesscode, "");
	soap_out_xsd__string(soap, "DataFileId", -1, &a->DataFileId, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct d__RemoveDataFile * SOAP_FMAC4 soap_get_d__RemoveDataFile(struct soap *soap, struct d__RemoveDataFile *p, const char *tag, const char *type)
{
	if ((p = soap_in_d__RemoveDataFile(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct d__RemoveDataFile * SOAP_FMAC4 soap_in_d__RemoveDataFile(struct soap *soap, const char *tag, struct d__RemoveDataFile *a, const char *type)
{
	short soap_flag_Sesscode = 1, soap_flag_DataFileId = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct d__RemoveDataFile *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_d__RemoveDataFile, sizeof(struct d__RemoveDataFile), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_d__RemoveDataFile(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_Sesscode && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_xsd__int(soap, "Sesscode", &a->Sesscode, "xsd:int"))
				{	soap_flag_Sesscode--;
					continue;
				}
			if (soap_flag_DataFileId && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "DataFileId", &a->DataFileId, "xsd:string"))
				{	soap_flag_DataFileId--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_Sesscode > 0))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct d__RemoveDataFile *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_d__RemoveDataFile, 0, sizeof(struct d__RemoveDataFile), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_d__RemoveDataFileResponse(struct soap *soap, const struct d__RemoveDataFileResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_xsd__string(soap, &a->Status);
	soap_serialize_PointerTod__SignedDocInfo(soap, &a->SignedDocInfo);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_d__RemoveDataFileResponse(struct soap *soap, struct d__RemoveDataFileResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_xsd__string(soap, &a->Status);
	a->SignedDocInfo = NULL;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_d__RemoveDataFileResponse(struct soap *soap, const struct d__RemoveDataFileResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_d__RemoveDataFileResponse);
	if (soap_out_d__RemoveDataFileResponse(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_d__RemoveDataFileResponse(struct soap *soap, const char *tag, int id, const struct d__RemoveDataFileResponse *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_d__RemoveDataFileResponse), type);
	if (a->Status)
		soap_element_result(soap, "Status");
	soap_out_xsd__string(soap, "Status", -1, &a->Status, "");
	soap_out_PointerTod__SignedDocInfo(soap, "SignedDocInfo", -1, &a->SignedDocInfo, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct d__RemoveDataFileResponse * SOAP_FMAC4 soap_get_d__RemoveDataFileResponse(struct soap *soap, struct d__RemoveDataFileResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_d__RemoveDataFileResponse(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct d__RemoveDataFileResponse * SOAP_FMAC4 soap_in_d__RemoveDataFileResponse(struct soap *soap, const char *tag, struct d__RemoveDataFileResponse *a, const char *type)
{
	short soap_flag_Status = 1, soap_flag_SignedDocInfo = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct d__RemoveDataFileResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_d__RemoveDataFileResponse, sizeof(struct d__RemoveDataFileResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_d__RemoveDataFileResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_Status && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "Status", &a->Status, "xsd:string"))
				{	soap_flag_Status--;
					continue;
				}
			if (soap_flag_SignedDocInfo && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTod__SignedDocInfo(soap, "SignedDocInfo", &a->SignedDocInfo, "d:SignedDocInfo"))
				{	soap_flag_SignedDocInfo--;
					continue;
				}
			soap_check_result(soap, "Status");
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct d__RemoveDataFileResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_d__RemoveDataFileResponse, 0, sizeof(struct d__RemoveDataFileResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_d__AddDataFile(struct soap *soap, const struct d__AddDataFile *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_xsd__string(soap, &a->FileName);
	soap_serialize_xsd__string(soap, &a->MimeType);
	soap_serialize_xsd__string(soap, &a->ContentType);
	soap_serialize_xsd__string(soap, &a->DigestType);
	soap_serialize_xsd__string(soap, &a->DigestValue);
	soap_serialize_xsd__string(soap, &a->Content);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_d__AddDataFile(struct soap *soap, struct d__AddDataFile *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_xsd__int(soap, &a->Sesscode);
	soap_default_xsd__string(soap, &a->FileName);
	soap_default_xsd__string(soap, &a->MimeType);
	soap_default_xsd__string(soap, &a->ContentType);
	soap_default_xsd__int(soap, &a->Size);
	soap_default_xsd__string(soap, &a->DigestType);
	soap_default_xsd__string(soap, &a->DigestValue);
	soap_default_xsd__string(soap, &a->Content);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_d__AddDataFile(struct soap *soap, const struct d__AddDataFile *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_d__AddDataFile);
	if (soap_out_d__AddDataFile(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_d__AddDataFile(struct soap *soap, const char *tag, int id, const struct d__AddDataFile *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_d__AddDataFile), type);
	soap_out_xsd__int(soap, "Sesscode", -1, &a->Sesscode, "");
	soap_out_xsd__string(soap, "FileName", -1, &a->FileName, "");
	soap_out_xsd__string(soap, "MimeType", -1, &a->MimeType, "");
	soap_out_xsd__string(soap, "ContentType", -1, &a->ContentType, "");
	soap_out_xsd__int(soap, "Size", -1, &a->Size, "");
	soap_out_xsd__string(soap, "DigestType", -1, &a->DigestType, "");
	soap_out_xsd__string(soap, "DigestValue", -1, &a->DigestValue, "");
	soap_out_xsd__string(soap, "Content", -1, &a->Content, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct d__AddDataFile * SOAP_FMAC4 soap_get_d__AddDataFile(struct soap *soap, struct d__AddDataFile *p, const char *tag, const char *type)
{
	if ((p = soap_in_d__AddDataFile(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct d__AddDataFile * SOAP_FMAC4 soap_in_d__AddDataFile(struct soap *soap, const char *tag, struct d__AddDataFile *a, const char *type)
{
	short soap_flag_Sesscode = 1, soap_flag_FileName = 1, soap_flag_MimeType = 1, soap_flag_ContentType = 1, soap_flag_Size = 1, soap_flag_DigestType = 1, soap_flag_DigestValue = 1, soap_flag_Content = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct d__AddDataFile *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_d__AddDataFile, sizeof(struct d__AddDataFile), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_d__AddDataFile(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_Sesscode && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_xsd__int(soap, "Sesscode", &a->Sesscode, "xsd:int"))
				{	soap_flag_Sesscode--;
					continue;
				}
			if (soap_flag_FileName && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "FileName", &a->FileName, "xsd:string"))
				{	soap_flag_FileName--;
					continue;
				}
			if (soap_flag_MimeType && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "MimeType", &a->MimeType, "xsd:string"))
				{	soap_flag_MimeType--;
					continue;
				}
			if (soap_flag_ContentType && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "ContentType", &a->ContentType, "xsd:string"))
				{	soap_flag_ContentType--;
					continue;
				}
			if (soap_flag_Size && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_xsd__int(soap, "Size", &a->Size, "xsd:int"))
				{	soap_flag_Size--;
					continue;
				}
			if (soap_flag_DigestType && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "DigestType", &a->DigestType, "xsd:string"))
				{	soap_flag_DigestType--;
					continue;
				}
			if (soap_flag_DigestValue && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "DigestValue", &a->DigestValue, "xsd:string"))
				{	soap_flag_DigestValue--;
					continue;
				}
			if (soap_flag_Content && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "Content", &a->Content, "xsd:string"))
				{	soap_flag_Content--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_Sesscode > 0 || soap_flag_Size > 0))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct d__AddDataFile *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_d__AddDataFile, 0, sizeof(struct d__AddDataFile), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_d__AddDataFileResponse(struct soap *soap, const struct d__AddDataFileResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_xsd__string(soap, &a->Status);
	soap_serialize_PointerTod__SignedDocInfo(soap, &a->SignedDocInfo);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_d__AddDataFileResponse(struct soap *soap, struct d__AddDataFileResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_xsd__string(soap, &a->Status);
	a->SignedDocInfo = NULL;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_d__AddDataFileResponse(struct soap *soap, const struct d__AddDataFileResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_d__AddDataFileResponse);
	if (soap_out_d__AddDataFileResponse(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_d__AddDataFileResponse(struct soap *soap, const char *tag, int id, const struct d__AddDataFileResponse *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_d__AddDataFileResponse), type);
	if (a->Status)
		soap_element_result(soap, "Status");
	soap_out_xsd__string(soap, "Status", -1, &a->Status, "");
	soap_out_PointerTod__SignedDocInfo(soap, "SignedDocInfo", -1, &a->SignedDocInfo, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct d__AddDataFileResponse * SOAP_FMAC4 soap_get_d__AddDataFileResponse(struct soap *soap, struct d__AddDataFileResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_d__AddDataFileResponse(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct d__AddDataFileResponse * SOAP_FMAC4 soap_in_d__AddDataFileResponse(struct soap *soap, const char *tag, struct d__AddDataFileResponse *a, const char *type)
{
	short soap_flag_Status = 1, soap_flag_SignedDocInfo = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct d__AddDataFileResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_d__AddDataFileResponse, sizeof(struct d__AddDataFileResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_d__AddDataFileResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_Status && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "Status", &a->Status, "xsd:string"))
				{	soap_flag_Status--;
					continue;
				}
			if (soap_flag_SignedDocInfo && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTod__SignedDocInfo(soap, "SignedDocInfo", &a->SignedDocInfo, "d:SignedDocInfo"))
				{	soap_flag_SignedDocInfo--;
					continue;
				}
			soap_check_result(soap, "Status");
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct d__AddDataFileResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_d__AddDataFileResponse, 0, sizeof(struct d__AddDataFileResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_d__CreateSignedDoc(struct soap *soap, const struct d__CreateSignedDoc *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_xsd__string(soap, &a->Format);
	soap_serialize_xsd__string(soap, &a->Version);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_d__CreateSignedDoc(struct soap *soap, struct d__CreateSignedDoc *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_xsd__int(soap, &a->Sesscode);
	soap_default_xsd__string(soap, &a->Format);
	soap_default_xsd__string(soap, &a->Version);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_d__CreateSignedDoc(struct soap *soap, const struct d__CreateSignedDoc *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_d__CreateSignedDoc);
	if (soap_out_d__CreateSignedDoc(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_d__CreateSignedDoc(struct soap *soap, const char *tag, int id, const struct d__CreateSignedDoc *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_d__CreateSignedDoc), type);
	soap_out_xsd__int(soap, "Sesscode", -1, &a->Sesscode, "");
	soap_out_xsd__string(soap, "Format", -1, &a->Format, "");
	soap_out_xsd__string(soap, "Version", -1, &a->Version, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct d__CreateSignedDoc * SOAP_FMAC4 soap_get_d__CreateSignedDoc(struct soap *soap, struct d__CreateSignedDoc *p, const char *tag, const char *type)
{
	if ((p = soap_in_d__CreateSignedDoc(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct d__CreateSignedDoc * SOAP_FMAC4 soap_in_d__CreateSignedDoc(struct soap *soap, const char *tag, struct d__CreateSignedDoc *a, const char *type)
{
	short soap_flag_Sesscode = 1, soap_flag_Format = 1, soap_flag_Version = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct d__CreateSignedDoc *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_d__CreateSignedDoc, sizeof(struct d__CreateSignedDoc), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_d__CreateSignedDoc(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_Sesscode && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_xsd__int(soap, "Sesscode", &a->Sesscode, "xsd:int"))
				{	soap_flag_Sesscode--;
					continue;
				}
			if (soap_flag_Format && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "Format", &a->Format, "xsd:string"))
				{	soap_flag_Format--;
					continue;
				}
			if (soap_flag_Version && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "Version", &a->Version, "xsd:string"))
				{	soap_flag_Version--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_Sesscode > 0))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct d__CreateSignedDoc *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_d__CreateSignedDoc, 0, sizeof(struct d__CreateSignedDoc), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_d__CreateSignedDocResponse(struct soap *soap, const struct d__CreateSignedDocResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_xsd__string(soap, &a->Status);
	soap_serialize_PointerTod__SignedDocInfo(soap, &a->SignedDocInfo);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_d__CreateSignedDocResponse(struct soap *soap, struct d__CreateSignedDocResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_xsd__string(soap, &a->Status);
	a->SignedDocInfo = NULL;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_d__CreateSignedDocResponse(struct soap *soap, const struct d__CreateSignedDocResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_d__CreateSignedDocResponse);
	if (soap_out_d__CreateSignedDocResponse(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_d__CreateSignedDocResponse(struct soap *soap, const char *tag, int id, const struct d__CreateSignedDocResponse *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_d__CreateSignedDocResponse), type);
	if (a->Status)
		soap_element_result(soap, "Status");
	soap_out_xsd__string(soap, "Status", -1, &a->Status, "");
	soap_out_PointerTod__SignedDocInfo(soap, "SignedDocInfo", -1, &a->SignedDocInfo, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct d__CreateSignedDocResponse * SOAP_FMAC4 soap_get_d__CreateSignedDocResponse(struct soap *soap, struct d__CreateSignedDocResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_d__CreateSignedDocResponse(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct d__CreateSignedDocResponse * SOAP_FMAC4 soap_in_d__CreateSignedDocResponse(struct soap *soap, const char *tag, struct d__CreateSignedDocResponse *a, const char *type)
{
	short soap_flag_Status = 1, soap_flag_SignedDocInfo = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct d__CreateSignedDocResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_d__CreateSignedDocResponse, sizeof(struct d__CreateSignedDocResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_d__CreateSignedDocResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_Status && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "Status", &a->Status, "xsd:string"))
				{	soap_flag_Status--;
					continue;
				}
			if (soap_flag_SignedDocInfo && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTod__SignedDocInfo(soap, "SignedDocInfo", &a->SignedDocInfo, "d:SignedDocInfo"))
				{	soap_flag_SignedDocInfo--;
					continue;
				}
			soap_check_result(soap, "Status");
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct d__CreateSignedDocResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_d__CreateSignedDocResponse, 0, sizeof(struct d__CreateSignedDocResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_d__CloseSession(struct soap *soap, const struct d__CloseSession *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_d__CloseSession(struct soap *soap, struct d__CloseSession *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_xsd__int(soap, &a->Sesscode);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_d__CloseSession(struct soap *soap, const struct d__CloseSession *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_d__CloseSession);
	if (soap_out_d__CloseSession(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_d__CloseSession(struct soap *soap, const char *tag, int id, const struct d__CloseSession *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_d__CloseSession), type);
	soap_out_xsd__int(soap, "Sesscode", -1, &a->Sesscode, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct d__CloseSession * SOAP_FMAC4 soap_get_d__CloseSession(struct soap *soap, struct d__CloseSession *p, const char *tag, const char *type)
{
	if ((p = soap_in_d__CloseSession(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct d__CloseSession * SOAP_FMAC4 soap_in_d__CloseSession(struct soap *soap, const char *tag, struct d__CloseSession *a, const char *type)
{
	short soap_flag_Sesscode = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct d__CloseSession *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_d__CloseSession, sizeof(struct d__CloseSession), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_d__CloseSession(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_Sesscode && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_xsd__int(soap, "Sesscode", &a->Sesscode, "xsd:int"))
				{	soap_flag_Sesscode--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_Sesscode > 0))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct d__CloseSession *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_d__CloseSession, 0, sizeof(struct d__CloseSession), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_d__CloseSessionResponse(struct soap *soap, const struct d__CloseSessionResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_xsd__string(soap, &a->Status);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_d__CloseSessionResponse(struct soap *soap, struct d__CloseSessionResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_xsd__string(soap, &a->Status);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_d__CloseSessionResponse(struct soap *soap, const struct d__CloseSessionResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_d__CloseSessionResponse);
	if (soap_out_d__CloseSessionResponse(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_d__CloseSessionResponse(struct soap *soap, const char *tag, int id, const struct d__CloseSessionResponse *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_d__CloseSessionResponse), type);
	if (a->Status)
		soap_element_result(soap, "Status");
	soap_out_xsd__string(soap, "Status", -1, &a->Status, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct d__CloseSessionResponse * SOAP_FMAC4 soap_get_d__CloseSessionResponse(struct soap *soap, struct d__CloseSessionResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_d__CloseSessionResponse(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct d__CloseSessionResponse * SOAP_FMAC4 soap_in_d__CloseSessionResponse(struct soap *soap, const char *tag, struct d__CloseSessionResponse *a, const char *type)
{
	short soap_flag_Status = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct d__CloseSessionResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_d__CloseSessionResponse, sizeof(struct d__CloseSessionResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_d__CloseSessionResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_Status && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "Status", &a->Status, "xsd:string"))
				{	soap_flag_Status--;
					continue;
				}
			soap_check_result(soap, "Status");
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct d__CloseSessionResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_d__CloseSessionResponse, 0, sizeof(struct d__CloseSessionResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_d__StartSession(struct soap *soap, const struct d__StartSession *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_xsd__string(soap, &a->SigningProfile);
	soap_serialize_xsd__string(soap, &a->SigDocXML);
	soap_serialize_PointerTod__DataFileData(soap, &a->datafile);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_d__StartSession(struct soap *soap, struct d__StartSession *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_xsd__string(soap, &a->SigningProfile);
	soap_default_xsd__string(soap, &a->SigDocXML);
	soap_default_xsd__boolean(soap, &a->bHoldSession);
	a->datafile = NULL;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_d__StartSession(struct soap *soap, const struct d__StartSession *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_d__StartSession);
	if (soap_out_d__StartSession(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_d__StartSession(struct soap *soap, const char *tag, int id, const struct d__StartSession *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_d__StartSession), type);
	soap_out_xsd__string(soap, "SigningProfile", -1, &a->SigningProfile, "");
	soap_out_xsd__string(soap, "SigDocXML", -1, &a->SigDocXML, "");
	soap_out_xsd__boolean(soap, "bHoldSession", -1, &a->bHoldSession, "");
	soap_out_PointerTod__DataFileData(soap, "datafile", -1, &a->datafile, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct d__StartSession * SOAP_FMAC4 soap_get_d__StartSession(struct soap *soap, struct d__StartSession *p, const char *tag, const char *type)
{
	if ((p = soap_in_d__StartSession(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct d__StartSession * SOAP_FMAC4 soap_in_d__StartSession(struct soap *soap, const char *tag, struct d__StartSession *a, const char *type)
{
	short soap_flag_SigningProfile = 1, soap_flag_SigDocXML = 1, soap_flag_bHoldSession = 1, soap_flag_datafile = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct d__StartSession *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_d__StartSession, sizeof(struct d__StartSession), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_d__StartSession(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_SigningProfile && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "SigningProfile", &a->SigningProfile, "xsd:string"))
				{	soap_flag_SigningProfile--;
					continue;
				}
			if (soap_flag_SigDocXML && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "SigDocXML", &a->SigDocXML, "xsd:string"))
				{	soap_flag_SigDocXML--;
					continue;
				}
			if (soap_flag_bHoldSession && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_xsd__boolean(soap, "bHoldSession", &a->bHoldSession, "xsd:boolean"))
				{	soap_flag_bHoldSession--;
					continue;
				}
			if (soap_flag_datafile && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTod__DataFileData(soap, "datafile", &a->datafile, "d:DataFileData"))
				{	soap_flag_datafile--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_bHoldSession > 0))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct d__StartSession *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_d__StartSession, 0, sizeof(struct d__StartSession), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_d__StartSessionResponse(struct soap *soap, const struct d__StartSessionResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_xsd__string(soap, &a->Status);
	soap_serialize_PointerTod__SignedDocInfo(soap, &a->SignedDocInfo);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_d__StartSessionResponse(struct soap *soap, struct d__StartSessionResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_xsd__string(soap, &a->Status);
	soap_default_xsd__int(soap, &a->Sesscode);
	a->SignedDocInfo = NULL;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_d__StartSessionResponse(struct soap *soap, const struct d__StartSessionResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_d__StartSessionResponse);
	if (soap_out_d__StartSessionResponse(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_d__StartSessionResponse(struct soap *soap, const char *tag, int id, const struct d__StartSessionResponse *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_d__StartSessionResponse), type);
	if (a->Status)
		soap_element_result(soap, "Status");
	soap_out_xsd__string(soap, "Status", -1, &a->Status, "");
	soap_out_xsd__int(soap, "Sesscode", -1, &a->Sesscode, "");
	soap_out_PointerTod__SignedDocInfo(soap, "SignedDocInfo", -1, &a->SignedDocInfo, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct d__StartSessionResponse * SOAP_FMAC4 soap_get_d__StartSessionResponse(struct soap *soap, struct d__StartSessionResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_d__StartSessionResponse(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct d__StartSessionResponse * SOAP_FMAC4 soap_in_d__StartSessionResponse(struct soap *soap, const char *tag, struct d__StartSessionResponse *a, const char *type)
{
	short soap_flag_Status = 1, soap_flag_Sesscode = 1, soap_flag_SignedDocInfo = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct d__StartSessionResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_d__StartSessionResponse, sizeof(struct d__StartSessionResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_d__StartSessionResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_Status && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "Status", &a->Status, "xsd:string"))
				{	soap_flag_Status--;
					continue;
				}
			if (soap_flag_Sesscode && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_xsd__int(soap, "Sesscode", &a->Sesscode, "xsd:int"))
				{	soap_flag_Sesscode--;
					continue;
				}
			if (soap_flag_SignedDocInfo && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTod__SignedDocInfo(soap, "SignedDocInfo", &a->SignedDocInfo, "d:SignedDocInfo"))
				{	soap_flag_SignedDocInfo--;
					continue;
				}
			soap_check_result(soap, "Status");
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_Sesscode > 0))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct d__StartSessionResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_d__StartSessionResponse, 0, sizeof(struct d__StartSessionResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_d__DataFileData(struct soap *soap, const struct d__DataFileData *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_xsd__string(soap, &a->Id);
	soap_serialize_xsd__string(soap, &a->Filename);
	soap_serialize_xsd__string(soap, &a->MimeType);
	soap_serialize_xsd__string(soap, &a->ContentType);
	soap_serialize_xsd__string(soap, &a->DigestType);
	soap_serialize_xsd__string(soap, &a->DigestValue);
	if (a->__ptrAttributes)
	{	int i;
		for (i = 0; i < a->__sizeOfAttributes; i++)
		{
			soap_embedded(soap, a->__ptrAttributes + i, SOAP_TYPE_d__DataFileAttribute);
			soap_serialize_d__DataFileAttribute(soap, a->__ptrAttributes + i);
		}
	}
	soap_serialize_xsd__string(soap, &a->DfData);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_d__DataFileData(struct soap *soap, struct d__DataFileData *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_xsd__string(soap, &a->Id);
	soap_default_xsd__string(soap, &a->Filename);
	soap_default_xsd__string(soap, &a->MimeType);
	soap_default_xsd__string(soap, &a->ContentType);
	soap_default_xsd__string(soap, &a->DigestType);
	soap_default_xsd__string(soap, &a->DigestValue);
	soap_default_xsd__int(soap, &a->Size);
	a->__sizeOfAttributes = 0;
	a->__ptrAttributes = NULL;
	soap_default_xsd__string(soap, &a->DfData);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_d__DataFileData(struct soap *soap, const struct d__DataFileData *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_d__DataFileData);
	if (soap_out_d__DataFileData(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_d__DataFileData(struct soap *soap, const char *tag, int id, const struct d__DataFileData *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_d__DataFileData), type);
	soap_out_xsd__string(soap, "Id", -1, &a->Id, "");
	soap_out_xsd__string(soap, "Filename", -1, &a->Filename, "");
	soap_out_xsd__string(soap, "MimeType", -1, &a->MimeType, "");
	soap_out_xsd__string(soap, "ContentType", -1, &a->ContentType, "");
	soap_out_xsd__string(soap, "DigestType", -1, &a->DigestType, "");
	soap_out_xsd__string(soap, "DigestValue", -1, &a->DigestValue, "");
	soap_out_xsd__int(soap, "Size", -1, &a->Size, "");
	if (a->__ptrAttributes)
	{	int i;
		for (i = 0; i < a->__sizeOfAttributes; i++)
			soap_out_d__DataFileAttribute(soap, "Attributes", -1, a->__ptrAttributes + i, "");
	}
	soap_out_xsd__string(soap, "DfData", -1, &a->DfData, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct d__DataFileData * SOAP_FMAC4 soap_get_d__DataFileData(struct soap *soap, struct d__DataFileData *p, const char *tag, const char *type)
{
	if ((p = soap_in_d__DataFileData(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct d__DataFileData * SOAP_FMAC4 soap_in_d__DataFileData(struct soap *soap, const char *tag, struct d__DataFileData *a, const char *type)
{
	short soap_flag_Id = 1, soap_flag_Filename = 1, soap_flag_MimeType = 1, soap_flag_ContentType = 1, soap_flag_DigestType = 1, soap_flag_DigestValue = 1, soap_flag_Size = 1, soap_flag___ptrAttributes = 1, soap_flag_DfData = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct d__DataFileData *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_d__DataFileData, sizeof(struct d__DataFileData), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_d__DataFileData(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_Id && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "Id", &a->Id, "xsd:string"))
				{	soap_flag_Id--;
					continue;
				}
			if (soap_flag_Filename && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "Filename", &a->Filename, "xsd:string"))
				{	soap_flag_Filename--;
					continue;
				}
			if (soap_flag_MimeType && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "MimeType", &a->MimeType, "xsd:string"))
				{	soap_flag_MimeType--;
					continue;
				}
			if (soap_flag_ContentType && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "ContentType", &a->ContentType, "xsd:string"))
				{	soap_flag_ContentType--;
					continue;
				}
			if (soap_flag_DigestType && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "DigestType", &a->DigestType, "xsd:string"))
				{	soap_flag_DigestType--;
					continue;
				}
			if (soap_flag_DigestValue && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "DigestValue", &a->DigestValue, "xsd:string"))
				{	soap_flag_DigestValue--;
					continue;
				}
			if (soap_flag_Size && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_xsd__int(soap, "Size", &a->Size, "xsd:int"))
				{	soap_flag_Size--;
					continue;
				}
			if (soap_flag___ptrAttributes && soap->error == SOAP_TAG_MISMATCH)
			{	struct d__DataFileAttribute *p;
				soap_new_block(soap);
				for (a->__sizeOfAttributes = 0; !soap_element_begin_in(soap, "Attributes", 1, NULL); a->__sizeOfAttributes++)
				{	p = (struct d__DataFileAttribute *)soap_push_block(soap, sizeof(struct d__DataFileAttribute));
					soap_default_d__DataFileAttribute(soap, p);
					soap_revert(soap);
					if (!soap_in_d__DataFileAttribute(soap, "Attributes", p, "d:DataFileAttribute"))
						break;
					soap_flag___ptrAttributes = 0;
				}
				a->__ptrAttributes = (struct d__DataFileAttribute *)soap_save_block(soap, NULL, 1);
				if (!soap_flag___ptrAttributes && soap->error == SOAP_TAG_MISMATCH)
					continue;
			}
			if (soap_flag_DfData && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "DfData", &a->DfData, "xsd:string"))
				{	soap_flag_DfData--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_Size > 0))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct d__DataFileData *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_d__DataFileData, 0, sizeof(struct d__DataFileData), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_d__SignedDocInfo(struct soap *soap, const struct d__SignedDocInfo *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_xsd__string(soap, &a->Format);
	soap_serialize_xsd__string(soap, &a->Version);
	if (a->__ptrDataFileInfo)
	{	int i;
		for (i = 0; i < a->__sizeOfDataFileInfos; i++)
		{
			soap_embedded(soap, a->__ptrDataFileInfo + i, SOAP_TYPE_d__DataFileInfo);
			soap_serialize_d__DataFileInfo(soap, a->__ptrDataFileInfo + i);
		}
	}
	if (a->__ptrSignatureInfo)
	{	int i;
		for (i = 0; i < a->__sizeOfSignatureInfos; i++)
		{
			soap_embedded(soap, a->__ptrSignatureInfo + i, SOAP_TYPE_d__SignatureInfo);
			soap_serialize_d__SignatureInfo(soap, a->__ptrSignatureInfo + i);
		}
	}
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_d__SignedDocInfo(struct soap *soap, struct d__SignedDocInfo *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_xsd__string(soap, &a->Format);
	soap_default_xsd__string(soap, &a->Version);
	a->__sizeOfDataFileInfos = 0;
	a->__ptrDataFileInfo = NULL;
	a->__sizeOfSignatureInfos = 0;
	a->__ptrSignatureInfo = NULL;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_d__SignedDocInfo(struct soap *soap, const struct d__SignedDocInfo *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_d__SignedDocInfo);
	if (soap_out_d__SignedDocInfo(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_d__SignedDocInfo(struct soap *soap, const char *tag, int id, const struct d__SignedDocInfo *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_d__SignedDocInfo), type);
	soap_out_xsd__string(soap, "Format", -1, &a->Format, "");
	soap_out_xsd__string(soap, "Version", -1, &a->Version, "");
	if (a->__ptrDataFileInfo)
	{	int i;
		for (i = 0; i < a->__sizeOfDataFileInfos; i++)
			soap_out_d__DataFileInfo(soap, "DataFileInfo", -1, a->__ptrDataFileInfo + i, "");
	}
	if (a->__ptrSignatureInfo)
	{	int i;
		for (i = 0; i < a->__sizeOfSignatureInfos; i++)
			soap_out_d__SignatureInfo(soap, "SignatureInfo", -1, a->__ptrSignatureInfo + i, "");
	}
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct d__SignedDocInfo * SOAP_FMAC4 soap_get_d__SignedDocInfo(struct soap *soap, struct d__SignedDocInfo *p, const char *tag, const char *type)
{
	if ((p = soap_in_d__SignedDocInfo(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct d__SignedDocInfo * SOAP_FMAC4 soap_in_d__SignedDocInfo(struct soap *soap, const char *tag, struct d__SignedDocInfo *a, const char *type)
{
	short soap_flag_Format = 1, soap_flag_Version = 1, soap_flag___ptrDataFileInfo = 1, soap_flag___ptrSignatureInfo = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct d__SignedDocInfo *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_d__SignedDocInfo, sizeof(struct d__SignedDocInfo), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_d__SignedDocInfo(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_Format && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "Format", &a->Format, "xsd:string"))
				{	soap_flag_Format--;
					continue;
				}
			if (soap_flag_Version && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "Version", &a->Version, "xsd:string"))
				{	soap_flag_Version--;
					continue;
				}
			if (soap_flag___ptrDataFileInfo && soap->error == SOAP_TAG_MISMATCH)
			{	struct d__DataFileInfo *p;
				soap_new_block(soap);
				for (a->__sizeOfDataFileInfos = 0; !soap_element_begin_in(soap, "DataFileInfo", 1, NULL); a->__sizeOfDataFileInfos++)
				{	p = (struct d__DataFileInfo *)soap_push_block(soap, sizeof(struct d__DataFileInfo));
					soap_default_d__DataFileInfo(soap, p);
					soap_revert(soap);
					if (!soap_in_d__DataFileInfo(soap, "DataFileInfo", p, "d:DataFileInfo"))
						break;
					soap_flag___ptrDataFileInfo = 0;
				}
				a->__ptrDataFileInfo = (struct d__DataFileInfo *)soap_save_block(soap, NULL, 1);
				if (!soap_flag___ptrDataFileInfo && soap->error == SOAP_TAG_MISMATCH)
					continue;
			}
			if (soap_flag___ptrSignatureInfo && soap->error == SOAP_TAG_MISMATCH)
			{	struct d__SignatureInfo *p;
				soap_new_block(soap);
				for (a->__sizeOfSignatureInfos = 0; !soap_element_begin_in(soap, "SignatureInfo", 1, NULL); a->__sizeOfSignatureInfos++)
				{	p = (struct d__SignatureInfo *)soap_push_block(soap, sizeof(struct d__SignatureInfo));
					soap_default_d__SignatureInfo(soap, p);
					soap_revert(soap);
					if (!soap_in_d__SignatureInfo(soap, "SignatureInfo", p, "d:SignatureInfo"))
						break;
					soap_flag___ptrSignatureInfo = 0;
				}
				a->__ptrSignatureInfo = (struct d__SignatureInfo *)soap_save_block(soap, NULL, 1);
				if (!soap_flag___ptrSignatureInfo && soap->error == SOAP_TAG_MISMATCH)
					continue;
			}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct d__SignedDocInfo *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_d__SignedDocInfo, 0, sizeof(struct d__SignedDocInfo), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_d__SignatureInfo(struct soap *soap, const struct d__SignatureInfo *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_xsd__string(soap, &a->Id);
	soap_serialize_xsd__string(soap, &a->Status);
	soap_serialize_PointerTod__Error(soap, &a->Error);
	soap_serialize_xsd__dateTime(soap, &a->SigningTime);
	if (a->__ptrSignerRole)
	{	int i;
		for (i = 0; i < a->__sizeRoles; i++)
		{
			soap_embedded(soap, a->__ptrSignerRole + i, SOAP_TYPE_d__SignerRole);
			soap_serialize_d__SignerRole(soap, a->__ptrSignerRole + i);
		}
	}
	soap_serialize_PointerTod__SignatureProductionPlace(soap, &a->SignatureProductionPlace);
	soap_serialize_PointerTod__SignerInfo(soap, &a->Signer);
	soap_serialize_PointerTod__ConfirmationInfo(soap, &a->Confirmation);
	if (a->__ptrTimestamps)
	{	int i;
		for (i = 0; i < a->__sizeTimestamps; i++)
		{
			soap_embedded(soap, a->__ptrTimestamps + i, SOAP_TYPE_d__TstInfo);
			soap_serialize_d__TstInfo(soap, a->__ptrTimestamps + i);
		}
	}
	soap_serialize_PointerTod__CRLInfo(soap, &a->CRLInfo);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_d__SignatureInfo(struct soap *soap, struct d__SignatureInfo *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_xsd__string(soap, &a->Id);
	soap_default_xsd__string(soap, &a->Status);
	a->Error = NULL;
	soap_default_xsd__dateTime(soap, &a->SigningTime);
	a->__sizeRoles = 0;
	a->__ptrSignerRole = NULL;
	a->SignatureProductionPlace = NULL;
	a->Signer = NULL;
	a->Confirmation = NULL;
	a->__sizeTimestamps = 0;
	a->__ptrTimestamps = NULL;
	a->CRLInfo = NULL;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_d__SignatureInfo(struct soap *soap, const struct d__SignatureInfo *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_d__SignatureInfo);
	if (soap_out_d__SignatureInfo(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_d__SignatureInfo(struct soap *soap, const char *tag, int id, const struct d__SignatureInfo *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_d__SignatureInfo), type);
	soap_out_xsd__string(soap, "Id", -1, &a->Id, "");
	soap_out_xsd__string(soap, "Status", -1, &a->Status, "");
	soap_out_PointerTod__Error(soap, "Error", -1, &a->Error, "");
	soap_out_xsd__dateTime(soap, "SigningTime", -1, &a->SigningTime, "");
	if (a->__ptrSignerRole)
	{	int i;
		for (i = 0; i < a->__sizeRoles; i++)
			soap_out_d__SignerRole(soap, "SignerRole", -1, a->__ptrSignerRole + i, "");
	}
	soap_out_PointerTod__SignatureProductionPlace(soap, "SignatureProductionPlace", -1, &a->SignatureProductionPlace, "");
	soap_out_PointerTod__SignerInfo(soap, "Signer", -1, &a->Signer, "");
	soap_out_PointerTod__ConfirmationInfo(soap, "Confirmation", -1, &a->Confirmation, "");
	if (a->__ptrTimestamps)
	{	int i;
		for (i = 0; i < a->__sizeTimestamps; i++)
			soap_out_d__TstInfo(soap, "Timestamps", -1, a->__ptrTimestamps + i, "");
	}
	soap_out_PointerTod__CRLInfo(soap, "CRLInfo", -1, &a->CRLInfo, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct d__SignatureInfo * SOAP_FMAC4 soap_get_d__SignatureInfo(struct soap *soap, struct d__SignatureInfo *p, const char *tag, const char *type)
{
	if ((p = soap_in_d__SignatureInfo(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct d__SignatureInfo * SOAP_FMAC4 soap_in_d__SignatureInfo(struct soap *soap, const char *tag, struct d__SignatureInfo *a, const char *type)
{
	short soap_flag_Id = 1, soap_flag_Status = 1, soap_flag_Error = 1, soap_flag_SigningTime = 1, soap_flag___ptrSignerRole = 1, soap_flag_SignatureProductionPlace = 1, soap_flag_Signer = 1, soap_flag_Confirmation = 1, soap_flag___ptrTimestamps = 1, soap_flag_CRLInfo = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct d__SignatureInfo *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_d__SignatureInfo, sizeof(struct d__SignatureInfo), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_d__SignatureInfo(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_Id && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "Id", &a->Id, "xsd:string"))
				{	soap_flag_Id--;
					continue;
				}
			if (soap_flag_Status && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "Status", &a->Status, "xsd:string"))
				{	soap_flag_Status--;
					continue;
				}
			if (soap_flag_Error && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTod__Error(soap, "Error", &a->Error, "d:Error"))
				{	soap_flag_Error--;
					continue;
				}
			if (soap_flag_SigningTime && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__dateTime(soap, "SigningTime", &a->SigningTime, "xsd:dateTime"))
				{	soap_flag_SigningTime--;
					continue;
				}
			if (soap_flag___ptrSignerRole && soap->error == SOAP_TAG_MISMATCH)
			{	struct d__SignerRole *p;
				soap_new_block(soap);
				for (a->__sizeRoles = 0; !soap_element_begin_in(soap, "SignerRole", 1, NULL); a->__sizeRoles++)
				{	p = (struct d__SignerRole *)soap_push_block(soap, sizeof(struct d__SignerRole));
					soap_default_d__SignerRole(soap, p);
					soap_revert(soap);
					if (!soap_in_d__SignerRole(soap, "SignerRole", p, "d:SignerRole"))
						break;
					soap_flag___ptrSignerRole = 0;
				}
				a->__ptrSignerRole = (struct d__SignerRole *)soap_save_block(soap, NULL, 1);
				if (!soap_flag___ptrSignerRole && soap->error == SOAP_TAG_MISMATCH)
					continue;
			}
			if (soap_flag_SignatureProductionPlace && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTod__SignatureProductionPlace(soap, "SignatureProductionPlace", &a->SignatureProductionPlace, "d:SignatureProductionPlace"))
				{	soap_flag_SignatureProductionPlace--;
					continue;
				}
			if (soap_flag_Signer && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTod__SignerInfo(soap, "Signer", &a->Signer, "d:SignerInfo"))
				{	soap_flag_Signer--;
					continue;
				}
			if (soap_flag_Confirmation && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTod__ConfirmationInfo(soap, "Confirmation", &a->Confirmation, "d:ConfirmationInfo"))
				{	soap_flag_Confirmation--;
					continue;
				}
			if (soap_flag___ptrTimestamps && soap->error == SOAP_TAG_MISMATCH)
			{	struct d__TstInfo *p;
				soap_new_block(soap);
				for (a->__sizeTimestamps = 0; !soap_element_begin_in(soap, "Timestamps", 1, NULL); a->__sizeTimestamps++)
				{	p = (struct d__TstInfo *)soap_push_block(soap, sizeof(struct d__TstInfo));
					soap_default_d__TstInfo(soap, p);
					soap_revert(soap);
					if (!soap_in_d__TstInfo(soap, "Timestamps", p, "d:TstInfo"))
						break;
					soap_flag___ptrTimestamps = 0;
				}
				a->__ptrTimestamps = (struct d__TstInfo *)soap_save_block(soap, NULL, 1);
				if (!soap_flag___ptrTimestamps && soap->error == SOAP_TAG_MISMATCH)
					continue;
			}
			if (soap_flag_CRLInfo && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTod__CRLInfo(soap, "CRLInfo", &a->CRLInfo, "d:CRLInfo"))
				{	soap_flag_CRLInfo--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct d__SignatureInfo *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_d__SignatureInfo, 0, sizeof(struct d__SignatureInfo), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_d__Error(struct soap *soap, const struct d__Error *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_xsd__string(soap, &a->Category);
	soap_serialize_xsd__string(soap, &a->Description);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_d__Error(struct soap *soap, struct d__Error *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_xsd__int(soap, &a->Code);
	soap_default_xsd__string(soap, &a->Category);
	soap_default_xsd__string(soap, &a->Description);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_d__Error(struct soap *soap, const struct d__Error *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_d__Error);
	if (soap_out_d__Error(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_d__Error(struct soap *soap, const char *tag, int id, const struct d__Error *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_d__Error), type);
	soap_out_xsd__int(soap, "Code", -1, &a->Code, "");
	soap_out_xsd__string(soap, "Category", -1, &a->Category, "");
	soap_out_xsd__string(soap, "Description", -1, &a->Description, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct d__Error * SOAP_FMAC4 soap_get_d__Error(struct soap *soap, struct d__Error *p, const char *tag, const char *type)
{
	if ((p = soap_in_d__Error(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct d__Error * SOAP_FMAC4 soap_in_d__Error(struct soap *soap, const char *tag, struct d__Error *a, const char *type)
{
	short soap_flag_Code = 1, soap_flag_Category = 1, soap_flag_Description = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct d__Error *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_d__Error, sizeof(struct d__Error), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_d__Error(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_Code && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_xsd__int(soap, "Code", &a->Code, "xsd:int"))
				{	soap_flag_Code--;
					continue;
				}
			if (soap_flag_Category && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "Category", &a->Category, "xsd:string"))
				{	soap_flag_Category--;
					continue;
				}
			if (soap_flag_Description && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "Description", &a->Description, "xsd:string"))
				{	soap_flag_Description--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_Code > 0))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct d__Error *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_d__Error, 0, sizeof(struct d__Error), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_d__CRLInfo(struct soap *soap, const struct d__CRLInfo *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_xsd__string(soap, &a->Issuer);
	soap_serialize_xsd__dateTime(soap, &a->LastUpdate);
	soap_serialize_xsd__dateTime(soap, &a->NextUpdate);
	if (a->__ptrRevocations)
	{	int i;
		for (i = 0; i < a->__sizeOfRevocations; i++)
		{
			soap_embedded(soap, a->__ptrRevocations + i, SOAP_TYPE_d__RevokedInfo);
			soap_serialize_d__RevokedInfo(soap, a->__ptrRevocations + i);
		}
	}
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_d__CRLInfo(struct soap *soap, struct d__CRLInfo *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_xsd__string(soap, &a->Issuer);
	soap_default_xsd__dateTime(soap, &a->LastUpdate);
	soap_default_xsd__dateTime(soap, &a->NextUpdate);
	a->__sizeOfRevocations = 0;
	a->__ptrRevocations = NULL;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_d__CRLInfo(struct soap *soap, const struct d__CRLInfo *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_d__CRLInfo);
	if (soap_out_d__CRLInfo(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_d__CRLInfo(struct soap *soap, const char *tag, int id, const struct d__CRLInfo *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_d__CRLInfo), type);
	soap_out_xsd__string(soap, "Issuer", -1, &a->Issuer, "");
	soap_out_xsd__dateTime(soap, "LastUpdate", -1, &a->LastUpdate, "");
	soap_out_xsd__dateTime(soap, "NextUpdate", -1, &a->NextUpdate, "");
	if (a->__ptrRevocations)
	{	int i;
		for (i = 0; i < a->__sizeOfRevocations; i++)
			soap_out_d__RevokedInfo(soap, "Revocations", -1, a->__ptrRevocations + i, "");
	}
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct d__CRLInfo * SOAP_FMAC4 soap_get_d__CRLInfo(struct soap *soap, struct d__CRLInfo *p, const char *tag, const char *type)
{
	if ((p = soap_in_d__CRLInfo(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct d__CRLInfo * SOAP_FMAC4 soap_in_d__CRLInfo(struct soap *soap, const char *tag, struct d__CRLInfo *a, const char *type)
{
	short soap_flag_Issuer = 1, soap_flag_LastUpdate = 1, soap_flag_NextUpdate = 1, soap_flag___ptrRevocations = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct d__CRLInfo *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_d__CRLInfo, sizeof(struct d__CRLInfo), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_d__CRLInfo(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_Issuer && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "Issuer", &a->Issuer, "xsd:string"))
				{	soap_flag_Issuer--;
					continue;
				}
			if (soap_flag_LastUpdate && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__dateTime(soap, "LastUpdate", &a->LastUpdate, "xsd:dateTime"))
				{	soap_flag_LastUpdate--;
					continue;
				}
			if (soap_flag_NextUpdate && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__dateTime(soap, "NextUpdate", &a->NextUpdate, "xsd:dateTime"))
				{	soap_flag_NextUpdate--;
					continue;
				}
			if (soap_flag___ptrRevocations && soap->error == SOAP_TAG_MISMATCH)
			{	struct d__RevokedInfo *p;
				soap_new_block(soap);
				for (a->__sizeOfRevocations = 0; !soap_element_begin_in(soap, "Revocations", 1, NULL); a->__sizeOfRevocations++)
				{	p = (struct d__RevokedInfo *)soap_push_block(soap, sizeof(struct d__RevokedInfo));
					soap_default_d__RevokedInfo(soap, p);
					soap_revert(soap);
					if (!soap_in_d__RevokedInfo(soap, "Revocations", p, "d:RevokedInfo"))
						break;
					soap_flag___ptrRevocations = 0;
				}
				a->__ptrRevocations = (struct d__RevokedInfo *)soap_save_block(soap, NULL, 1);
				if (!soap_flag___ptrRevocations && soap->error == SOAP_TAG_MISMATCH)
					continue;
			}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct d__CRLInfo *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_d__CRLInfo, 0, sizeof(struct d__CRLInfo), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_d__RevokedInfo(struct soap *soap, const struct d__RevokedInfo *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_xsd__string(soap, &a->SerialNumber);
	soap_serialize_xsd__dateTime(soap, &a->RevocationDate);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_d__RevokedInfo(struct soap *soap, struct d__RevokedInfo *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_xsd__positiveInteger(soap, &a->Sequence);
	soap_default_xsd__string(soap, &a->SerialNumber);
	soap_default_xsd__dateTime(soap, &a->RevocationDate);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_d__RevokedInfo(struct soap *soap, const struct d__RevokedInfo *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_d__RevokedInfo);
	if (soap_out_d__RevokedInfo(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_d__RevokedInfo(struct soap *soap, const char *tag, int id, const struct d__RevokedInfo *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_d__RevokedInfo), type);
	soap_out_xsd__positiveInteger(soap, "Sequence", -1, &a->Sequence, "");
	soap_out_xsd__string(soap, "SerialNumber", -1, &a->SerialNumber, "");
	soap_out_xsd__dateTime(soap, "RevocationDate", -1, &a->RevocationDate, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct d__RevokedInfo * SOAP_FMAC4 soap_get_d__RevokedInfo(struct soap *soap, struct d__RevokedInfo *p, const char *tag, const char *type)
{
	if ((p = soap_in_d__RevokedInfo(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct d__RevokedInfo * SOAP_FMAC4 soap_in_d__RevokedInfo(struct soap *soap, const char *tag, struct d__RevokedInfo *a, const char *type)
{
	short soap_flag_Sequence = 1, soap_flag_SerialNumber = 1, soap_flag_RevocationDate = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct d__RevokedInfo *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_d__RevokedInfo, sizeof(struct d__RevokedInfo), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_d__RevokedInfo(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_Sequence && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_xsd__positiveInteger(soap, "Sequence", &a->Sequence, "xsd:positiveInteger"))
				{	soap_flag_Sequence--;
					continue;
				}
			if (soap_flag_SerialNumber && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "SerialNumber", &a->SerialNumber, "xsd:string"))
				{	soap_flag_SerialNumber--;
					continue;
				}
			if (soap_flag_RevocationDate && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__dateTime(soap, "RevocationDate", &a->RevocationDate, "xsd:dateTime"))
				{	soap_flag_RevocationDate--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_Sequence > 0))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct d__RevokedInfo *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_d__RevokedInfo, 0, sizeof(struct d__RevokedInfo), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_d__TstInfo(struct soap *soap, const struct d__TstInfo *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_xsd__string(soap, &a->Id);
	soap_serialize_xsd__string(soap, &a->Type);
	soap_serialize_xsd__string(soap, &a->SerialNumber);
	soap_serialize_xsd__dateTime(soap, &a->CreationTime);
	soap_serialize_xsd__string(soap, &a->Policy);
	soap_serialize_xsd__string(soap, &a->ErrorBound);
	soap_serialize_xsd__string(soap, &a->TSA);
	soap_serialize_PointerTod__CertificateInfo(soap, &a->Certificate);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_d__TstInfo(struct soap *soap, struct d__TstInfo *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_xsd__string(soap, &a->Id);
	soap_default_xsd__string(soap, &a->Type);
	soap_default_xsd__string(soap, &a->SerialNumber);
	soap_default_xsd__dateTime(soap, &a->CreationTime);
	soap_default_xsd__string(soap, &a->Policy);
	soap_default_xsd__string(soap, &a->ErrorBound);
	soap_default_xsd__boolean(soap, &a->Ordered);
	soap_default_xsd__string(soap, &a->TSA);
	a->Certificate = NULL;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_d__TstInfo(struct soap *soap, const struct d__TstInfo *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_d__TstInfo);
	if (soap_out_d__TstInfo(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_d__TstInfo(struct soap *soap, const char *tag, int id, const struct d__TstInfo *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_d__TstInfo), type);
	soap_out_xsd__string(soap, "Id", -1, &a->Id, "");
	soap_out_xsd__string(soap, "Type", -1, &a->Type, "");
	soap_out_xsd__string(soap, "SerialNumber", -1, &a->SerialNumber, "");
	soap_out_xsd__dateTime(soap, "CreationTime", -1, &a->CreationTime, "");
	soap_out_xsd__string(soap, "Policy", -1, &a->Policy, "");
	soap_out_xsd__string(soap, "ErrorBound", -1, &a->ErrorBound, "");
	soap_out_xsd__boolean(soap, "Ordered", -1, &a->Ordered, "");
	soap_out_xsd__string(soap, "TSA", -1, &a->TSA, "");
	soap_out_PointerTod__CertificateInfo(soap, "Certificate", -1, &a->Certificate, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct d__TstInfo * SOAP_FMAC4 soap_get_d__TstInfo(struct soap *soap, struct d__TstInfo *p, const char *tag, const char *type)
{
	if ((p = soap_in_d__TstInfo(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct d__TstInfo * SOAP_FMAC4 soap_in_d__TstInfo(struct soap *soap, const char *tag, struct d__TstInfo *a, const char *type)
{
	short soap_flag_Id = 1, soap_flag_Type = 1, soap_flag_SerialNumber = 1, soap_flag_CreationTime = 1, soap_flag_Policy = 1, soap_flag_ErrorBound = 1, soap_flag_Ordered = 1, soap_flag_TSA = 1, soap_flag_Certificate = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct d__TstInfo *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_d__TstInfo, sizeof(struct d__TstInfo), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_d__TstInfo(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_Id && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "Id", &a->Id, "xsd:string"))
				{	soap_flag_Id--;
					continue;
				}
			if (soap_flag_Type && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "Type", &a->Type, "xsd:string"))
				{	soap_flag_Type--;
					continue;
				}
			if (soap_flag_SerialNumber && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "SerialNumber", &a->SerialNumber, "xsd:string"))
				{	soap_flag_SerialNumber--;
					continue;
				}
			if (soap_flag_CreationTime && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__dateTime(soap, "CreationTime", &a->CreationTime, "xsd:dateTime"))
				{	soap_flag_CreationTime--;
					continue;
				}
			if (soap_flag_Policy && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "Policy", &a->Policy, "xsd:string"))
				{	soap_flag_Policy--;
					continue;
				}
			if (soap_flag_ErrorBound && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "ErrorBound", &a->ErrorBound, "xsd:string"))
				{	soap_flag_ErrorBound--;
					continue;
				}
			if (soap_flag_Ordered && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_xsd__boolean(soap, "Ordered", &a->Ordered, "xsd:boolean"))
				{	soap_flag_Ordered--;
					continue;
				}
			if (soap_flag_TSA && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "TSA", &a->TSA, "xsd:string"))
				{	soap_flag_TSA--;
					continue;
				}
			if (soap_flag_Certificate && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTod__CertificateInfo(soap, "Certificate", &a->Certificate, "d:CertificateInfo"))
				{	soap_flag_Certificate--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_Ordered > 0))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct d__TstInfo *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_d__TstInfo, 0, sizeof(struct d__TstInfo), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_d__ConfirmationInfo(struct soap *soap, const struct d__ConfirmationInfo *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_xsd__string(soap, &a->ResponderID);
	soap_serialize_xsd__string(soap, &a->ProducedAt);
	soap_serialize_PointerTod__CertificateInfo(soap, &a->ResponderCertificate);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_d__ConfirmationInfo(struct soap *soap, struct d__ConfirmationInfo *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_xsd__string(soap, &a->ResponderID);
	soap_default_xsd__string(soap, &a->ProducedAt);
	a->ResponderCertificate = NULL;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_d__ConfirmationInfo(struct soap *soap, const struct d__ConfirmationInfo *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_d__ConfirmationInfo);
	if (soap_out_d__ConfirmationInfo(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_d__ConfirmationInfo(struct soap *soap, const char *tag, int id, const struct d__ConfirmationInfo *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_d__ConfirmationInfo), type);
	soap_out_xsd__string(soap, "ResponderID", -1, &a->ResponderID, "");
	soap_out_xsd__string(soap, "ProducedAt", -1, &a->ProducedAt, "");
	soap_out_PointerTod__CertificateInfo(soap, "ResponderCertificate", -1, &a->ResponderCertificate, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct d__ConfirmationInfo * SOAP_FMAC4 soap_get_d__ConfirmationInfo(struct soap *soap, struct d__ConfirmationInfo *p, const char *tag, const char *type)
{
	if ((p = soap_in_d__ConfirmationInfo(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct d__ConfirmationInfo * SOAP_FMAC4 soap_in_d__ConfirmationInfo(struct soap *soap, const char *tag, struct d__ConfirmationInfo *a, const char *type)
{
	short soap_flag_ResponderID = 1, soap_flag_ProducedAt = 1, soap_flag_ResponderCertificate = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct d__ConfirmationInfo *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_d__ConfirmationInfo, sizeof(struct d__ConfirmationInfo), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_d__ConfirmationInfo(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_ResponderID && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "ResponderID", &a->ResponderID, "xsd:string"))
				{	soap_flag_ResponderID--;
					continue;
				}
			if (soap_flag_ProducedAt && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "ProducedAt", &a->ProducedAt, "xsd:string"))
				{	soap_flag_ProducedAt--;
					continue;
				}
			if (soap_flag_ResponderCertificate && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTod__CertificateInfo(soap, "ResponderCertificate", &a->ResponderCertificate, "d:CertificateInfo"))
				{	soap_flag_ResponderCertificate--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct d__ConfirmationInfo *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_d__ConfirmationInfo, 0, sizeof(struct d__ConfirmationInfo), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_d__SignerInfo(struct soap *soap, const struct d__SignerInfo *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_xsd__string(soap, &a->CommonName);
	soap_serialize_xsd__string(soap, &a->IDCode);
	soap_serialize_PointerTod__CertificateInfo(soap, &a->Certificate);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_d__SignerInfo(struct soap *soap, struct d__SignerInfo *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_xsd__string(soap, &a->CommonName);
	soap_default_xsd__string(soap, &a->IDCode);
	a->Certificate = NULL;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_d__SignerInfo(struct soap *soap, const struct d__SignerInfo *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_d__SignerInfo);
	if (soap_out_d__SignerInfo(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_d__SignerInfo(struct soap *soap, const char *tag, int id, const struct d__SignerInfo *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_d__SignerInfo), type);
	soap_out_xsd__string(soap, "CommonName", -1, &a->CommonName, "");
	soap_out_xsd__string(soap, "IDCode", -1, &a->IDCode, "");
	soap_out_PointerTod__CertificateInfo(soap, "Certificate", -1, &a->Certificate, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct d__SignerInfo * SOAP_FMAC4 soap_get_d__SignerInfo(struct soap *soap, struct d__SignerInfo *p, const char *tag, const char *type)
{
	if ((p = soap_in_d__SignerInfo(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct d__SignerInfo * SOAP_FMAC4 soap_in_d__SignerInfo(struct soap *soap, const char *tag, struct d__SignerInfo *a, const char *type)
{
	short soap_flag_CommonName = 1, soap_flag_IDCode = 1, soap_flag_Certificate = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct d__SignerInfo *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_d__SignerInfo, sizeof(struct d__SignerInfo), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_d__SignerInfo(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_CommonName && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "CommonName", &a->CommonName, "xsd:string"))
				{	soap_flag_CommonName--;
					continue;
				}
			if (soap_flag_IDCode && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "IDCode", &a->IDCode, "xsd:string"))
				{	soap_flag_IDCode--;
					continue;
				}
			if (soap_flag_Certificate && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTod__CertificateInfo(soap, "Certificate", &a->Certificate, "d:CertificateInfo"))
				{	soap_flag_Certificate--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct d__SignerInfo *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_d__SignerInfo, 0, sizeof(struct d__SignerInfo), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_d__CertificateInfo(struct soap *soap, const struct d__CertificateInfo *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_xsd__string(soap, &a->Issuer);
	soap_serialize_xsd__string(soap, &a->Subject);
	soap_serialize_xsd__dateTime(soap, &a->ValidFrom);
	soap_serialize_xsd__dateTime(soap, &a->ValidTo);
	soap_serialize_xsd__string(soap, &a->IssuerSerial);
	if (a->__ptrPolicies)
	{	int i;
		for (i = 0; i < a->__sizePolicies; i++)
		{
			soap_embedded(soap, a->__ptrPolicies + i, SOAP_TYPE_d__CertificatePolicy);
			soap_serialize_d__CertificatePolicy(soap, a->__ptrPolicies + i);
		}
	}
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_d__CertificateInfo(struct soap *soap, struct d__CertificateInfo *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_xsd__string(soap, &a->Issuer);
	soap_default_xsd__string(soap, &a->Subject);
	soap_default_xsd__dateTime(soap, &a->ValidFrom);
	soap_default_xsd__dateTime(soap, &a->ValidTo);
	soap_default_xsd__string(soap, &a->IssuerSerial);
	a->__sizePolicies = 0;
	a->__ptrPolicies = NULL;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_d__CertificateInfo(struct soap *soap, const struct d__CertificateInfo *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_d__CertificateInfo);
	if (soap_out_d__CertificateInfo(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_d__CertificateInfo(struct soap *soap, const char *tag, int id, const struct d__CertificateInfo *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_d__CertificateInfo), type);
	soap_out_xsd__string(soap, "Issuer", -1, &a->Issuer, "");
	soap_out_xsd__string(soap, "Subject", -1, &a->Subject, "");
	soap_out_xsd__dateTime(soap, "ValidFrom", -1, &a->ValidFrom, "");
	soap_out_xsd__dateTime(soap, "ValidTo", -1, &a->ValidTo, "");
	soap_out_xsd__string(soap, "IssuerSerial", -1, &a->IssuerSerial, "");
	if (a->__ptrPolicies)
	{	int i;
		for (i = 0; i < a->__sizePolicies; i++)
			soap_out_d__CertificatePolicy(soap, "Policies", -1, a->__ptrPolicies + i, "");
	}
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct d__CertificateInfo * SOAP_FMAC4 soap_get_d__CertificateInfo(struct soap *soap, struct d__CertificateInfo *p, const char *tag, const char *type)
{
	if ((p = soap_in_d__CertificateInfo(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct d__CertificateInfo * SOAP_FMAC4 soap_in_d__CertificateInfo(struct soap *soap, const char *tag, struct d__CertificateInfo *a, const char *type)
{
	short soap_flag_Issuer = 1, soap_flag_Subject = 1, soap_flag_ValidFrom = 1, soap_flag_ValidTo = 1, soap_flag_IssuerSerial = 1, soap_flag___ptrPolicies = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct d__CertificateInfo *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_d__CertificateInfo, sizeof(struct d__CertificateInfo), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_d__CertificateInfo(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_Issuer && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "Issuer", &a->Issuer, "xsd:string"))
				{	soap_flag_Issuer--;
					continue;
				}
			if (soap_flag_Subject && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "Subject", &a->Subject, "xsd:string"))
				{	soap_flag_Subject--;
					continue;
				}
			if (soap_flag_ValidFrom && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__dateTime(soap, "ValidFrom", &a->ValidFrom, "xsd:dateTime"))
				{	soap_flag_ValidFrom--;
					continue;
				}
			if (soap_flag_ValidTo && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__dateTime(soap, "ValidTo", &a->ValidTo, "xsd:dateTime"))
				{	soap_flag_ValidTo--;
					continue;
				}
			if (soap_flag_IssuerSerial && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "IssuerSerial", &a->IssuerSerial, "xsd:string"))
				{	soap_flag_IssuerSerial--;
					continue;
				}
			if (soap_flag___ptrPolicies && soap->error == SOAP_TAG_MISMATCH)
			{	struct d__CertificatePolicy *p;
				soap_new_block(soap);
				for (a->__sizePolicies = 0; !soap_element_begin_in(soap, "Policies", 1, NULL); a->__sizePolicies++)
				{	p = (struct d__CertificatePolicy *)soap_push_block(soap, sizeof(struct d__CertificatePolicy));
					soap_default_d__CertificatePolicy(soap, p);
					soap_revert(soap);
					if (!soap_in_d__CertificatePolicy(soap, "Policies", p, "d:CertificatePolicy"))
						break;
					soap_flag___ptrPolicies = 0;
				}
				a->__ptrPolicies = (struct d__CertificatePolicy *)soap_save_block(soap, NULL, 1);
				if (!soap_flag___ptrPolicies && soap->error == SOAP_TAG_MISMATCH)
					continue;
			}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct d__CertificateInfo *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_d__CertificateInfo, 0, sizeof(struct d__CertificateInfo), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_d__CertificatePolicy(struct soap *soap, const struct d__CertificatePolicy *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_xsd__string(soap, &a->OID);
	soap_serialize_xsd__string(soap, &a->URL);
	soap_serialize_xsd__string(soap, &a->Description);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_d__CertificatePolicy(struct soap *soap, struct d__CertificatePolicy *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_xsd__string(soap, &a->OID);
	soap_default_xsd__string(soap, &a->URL);
	soap_default_xsd__string(soap, &a->Description);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_d__CertificatePolicy(struct soap *soap, const struct d__CertificatePolicy *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_d__CertificatePolicy);
	if (soap_out_d__CertificatePolicy(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_d__CertificatePolicy(struct soap *soap, const char *tag, int id, const struct d__CertificatePolicy *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_d__CertificatePolicy), type);
	soap_out_xsd__string(soap, "OID", -1, &a->OID, "");
	soap_out_xsd__string(soap, "URL", -1, &a->URL, "");
	soap_out_xsd__string(soap, "Description", -1, &a->Description, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct d__CertificatePolicy * SOAP_FMAC4 soap_get_d__CertificatePolicy(struct soap *soap, struct d__CertificatePolicy *p, const char *tag, const char *type)
{
	if ((p = soap_in_d__CertificatePolicy(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct d__CertificatePolicy * SOAP_FMAC4 soap_in_d__CertificatePolicy(struct soap *soap, const char *tag, struct d__CertificatePolicy *a, const char *type)
{
	short soap_flag_OID = 1, soap_flag_URL = 1, soap_flag_Description = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct d__CertificatePolicy *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_d__CertificatePolicy, sizeof(struct d__CertificatePolicy), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_d__CertificatePolicy(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_OID && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "OID", &a->OID, "xsd:string"))
				{	soap_flag_OID--;
					continue;
				}
			if (soap_flag_URL && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "URL", &a->URL, "xsd:string"))
				{	soap_flag_URL--;
					continue;
				}
			if (soap_flag_Description && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "Description", &a->Description, "xsd:string"))
				{	soap_flag_Description--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct d__CertificatePolicy *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_d__CertificatePolicy, 0, sizeof(struct d__CertificatePolicy), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_d__SignatureProductionPlace(struct soap *soap, const struct d__SignatureProductionPlace *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_xsd__string(soap, &a->City);
	soap_serialize_xsd__string(soap, &a->StateOrProvince);
	soap_serialize_xsd__string(soap, &a->PostalCode);
	soap_serialize_xsd__string(soap, &a->CountryName);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_d__SignatureProductionPlace(struct soap *soap, struct d__SignatureProductionPlace *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_xsd__string(soap, &a->City);
	soap_default_xsd__string(soap, &a->StateOrProvince);
	soap_default_xsd__string(soap, &a->PostalCode);
	soap_default_xsd__string(soap, &a->CountryName);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_d__SignatureProductionPlace(struct soap *soap, const struct d__SignatureProductionPlace *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_d__SignatureProductionPlace);
	if (soap_out_d__SignatureProductionPlace(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_d__SignatureProductionPlace(struct soap *soap, const char *tag, int id, const struct d__SignatureProductionPlace *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_d__SignatureProductionPlace), type);
	soap_out_xsd__string(soap, "City", -1, &a->City, "");
	soap_out_xsd__string(soap, "StateOrProvince", -1, &a->StateOrProvince, "");
	soap_out_xsd__string(soap, "PostalCode", -1, &a->PostalCode, "");
	soap_out_xsd__string(soap, "CountryName", -1, &a->CountryName, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct d__SignatureProductionPlace * SOAP_FMAC4 soap_get_d__SignatureProductionPlace(struct soap *soap, struct d__SignatureProductionPlace *p, const char *tag, const char *type)
{
	if ((p = soap_in_d__SignatureProductionPlace(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct d__SignatureProductionPlace * SOAP_FMAC4 soap_in_d__SignatureProductionPlace(struct soap *soap, const char *tag, struct d__SignatureProductionPlace *a, const char *type)
{
	short soap_flag_City = 1, soap_flag_StateOrProvince = 1, soap_flag_PostalCode = 1, soap_flag_CountryName = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct d__SignatureProductionPlace *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_d__SignatureProductionPlace, sizeof(struct d__SignatureProductionPlace), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_d__SignatureProductionPlace(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_City && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "City", &a->City, "xsd:string"))
				{	soap_flag_City--;
					continue;
				}
			if (soap_flag_StateOrProvince && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "StateOrProvince", &a->StateOrProvince, "xsd:string"))
				{	soap_flag_StateOrProvince--;
					continue;
				}
			if (soap_flag_PostalCode && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "PostalCode", &a->PostalCode, "xsd:string"))
				{	soap_flag_PostalCode--;
					continue;
				}
			if (soap_flag_CountryName && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "CountryName", &a->CountryName, "xsd:string"))
				{	soap_flag_CountryName--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct d__SignatureProductionPlace *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_d__SignatureProductionPlace, 0, sizeof(struct d__SignatureProductionPlace), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_d__SignerRole(struct soap *soap, const struct d__SignerRole *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_xsd__string(soap, &a->Role);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_d__SignerRole(struct soap *soap, struct d__SignerRole *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_xsd__int(soap, &a->Certified);
	soap_default_xsd__string(soap, &a->Role);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_d__SignerRole(struct soap *soap, const struct d__SignerRole *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_d__SignerRole);
	if (soap_out_d__SignerRole(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_d__SignerRole(struct soap *soap, const char *tag, int id, const struct d__SignerRole *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_d__SignerRole), type);
	soap_out_xsd__int(soap, "Certified", -1, &a->Certified, "");
	soap_out_xsd__string(soap, "Role", -1, &a->Role, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct d__SignerRole * SOAP_FMAC4 soap_get_d__SignerRole(struct soap *soap, struct d__SignerRole *p, const char *tag, const char *type)
{
	if ((p = soap_in_d__SignerRole(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct d__SignerRole * SOAP_FMAC4 soap_in_d__SignerRole(struct soap *soap, const char *tag, struct d__SignerRole *a, const char *type)
{
	short soap_flag_Certified = 1, soap_flag_Role = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct d__SignerRole *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_d__SignerRole, sizeof(struct d__SignerRole), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_d__SignerRole(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_Certified && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_xsd__int(soap, "Certified", &a->Certified, "xsd:int"))
				{	soap_flag_Certified--;
					continue;
				}
			if (soap_flag_Role && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "Role", &a->Role, "xsd:string"))
				{	soap_flag_Role--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_Certified > 0))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct d__SignerRole *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_d__SignerRole, 0, sizeof(struct d__SignerRole), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_d__DataFileInfo(struct soap *soap, const struct d__DataFileInfo *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_xsd__string(soap, &a->Id);
	soap_serialize_xsd__string(soap, &a->Filename);
	soap_serialize_xsd__string(soap, &a->MimeType);
	soap_serialize_xsd__string(soap, &a->ContentType);
	soap_serialize_xsd__string(soap, &a->DigestType);
	soap_serialize_xsd__string(soap, &a->DigestValue);
	if (a->__ptrAttributes)
	{	int i;
		for (i = 0; i < a->__sizeOfAttributes; i++)
		{
			soap_embedded(soap, a->__ptrAttributes + i, SOAP_TYPE_d__DataFileAttribute);
			soap_serialize_d__DataFileAttribute(soap, a->__ptrAttributes + i);
		}
	}
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_d__DataFileInfo(struct soap *soap, struct d__DataFileInfo *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_xsd__string(soap, &a->Id);
	soap_default_xsd__string(soap, &a->Filename);
	soap_default_xsd__string(soap, &a->MimeType);
	soap_default_xsd__string(soap, &a->ContentType);
	soap_default_xsd__int(soap, &a->Size);
	soap_default_xsd__string(soap, &a->DigestType);
	soap_default_xsd__string(soap, &a->DigestValue);
	a->__sizeOfAttributes = 0;
	a->__ptrAttributes = NULL;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_d__DataFileInfo(struct soap *soap, const struct d__DataFileInfo *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_d__DataFileInfo);
	if (soap_out_d__DataFileInfo(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_d__DataFileInfo(struct soap *soap, const char *tag, int id, const struct d__DataFileInfo *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_d__DataFileInfo), type);
	soap_out_xsd__string(soap, "Id", -1, &a->Id, "");
	soap_out_xsd__string(soap, "Filename", -1, &a->Filename, "");
	soap_out_xsd__string(soap, "MimeType", -1, &a->MimeType, "");
	soap_out_xsd__string(soap, "ContentType", -1, &a->ContentType, "");
	soap_out_xsd__int(soap, "Size", -1, &a->Size, "");
	soap_out_xsd__string(soap, "DigestType", -1, &a->DigestType, "");
	soap_out_xsd__string(soap, "DigestValue", -1, &a->DigestValue, "");
	if (a->__ptrAttributes)
	{	int i;
		for (i = 0; i < a->__sizeOfAttributes; i++)
			soap_out_d__DataFileAttribute(soap, "Attributes", -1, a->__ptrAttributes + i, "");
	}
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct d__DataFileInfo * SOAP_FMAC4 soap_get_d__DataFileInfo(struct soap *soap, struct d__DataFileInfo *p, const char *tag, const char *type)
{
	if ((p = soap_in_d__DataFileInfo(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct d__DataFileInfo * SOAP_FMAC4 soap_in_d__DataFileInfo(struct soap *soap, const char *tag, struct d__DataFileInfo *a, const char *type)
{
	short soap_flag_Id = 1, soap_flag_Filename = 1, soap_flag_MimeType = 1, soap_flag_ContentType = 1, soap_flag_Size = 1, soap_flag_DigestType = 1, soap_flag_DigestValue = 1, soap_flag___ptrAttributes = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct d__DataFileInfo *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_d__DataFileInfo, sizeof(struct d__DataFileInfo), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_d__DataFileInfo(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_Id && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "Id", &a->Id, "xsd:string"))
				{	soap_flag_Id--;
					continue;
				}
			if (soap_flag_Filename && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "Filename", &a->Filename, "xsd:string"))
				{	soap_flag_Filename--;
					continue;
				}
			if (soap_flag_MimeType && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "MimeType", &a->MimeType, "xsd:string"))
				{	soap_flag_MimeType--;
					continue;
				}
			if (soap_flag_ContentType && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "ContentType", &a->ContentType, "xsd:string"))
				{	soap_flag_ContentType--;
					continue;
				}
			if (soap_flag_Size && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_xsd__int(soap, "Size", &a->Size, "xsd:int"))
				{	soap_flag_Size--;
					continue;
				}
			if (soap_flag_DigestType && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "DigestType", &a->DigestType, "xsd:string"))
				{	soap_flag_DigestType--;
					continue;
				}
			if (soap_flag_DigestValue && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "DigestValue", &a->DigestValue, "xsd:string"))
				{	soap_flag_DigestValue--;
					continue;
				}
			if (soap_flag___ptrAttributes && soap->error == SOAP_TAG_MISMATCH)
			{	struct d__DataFileAttribute *p;
				soap_new_block(soap);
				for (a->__sizeOfAttributes = 0; !soap_element_begin_in(soap, "Attributes", 1, NULL); a->__sizeOfAttributes++)
				{	p = (struct d__DataFileAttribute *)soap_push_block(soap, sizeof(struct d__DataFileAttribute));
					soap_default_d__DataFileAttribute(soap, p);
					soap_revert(soap);
					if (!soap_in_d__DataFileAttribute(soap, "Attributes", p, "d:DataFileAttribute"))
						break;
					soap_flag___ptrAttributes = 0;
				}
				a->__ptrAttributes = (struct d__DataFileAttribute *)soap_save_block(soap, NULL, 1);
				if (!soap_flag___ptrAttributes && soap->error == SOAP_TAG_MISMATCH)
					continue;
			}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_Size > 0))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct d__DataFileInfo *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_d__DataFileInfo, 0, sizeof(struct d__DataFileInfo), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_d__DataFileAttribute(struct soap *soap, const struct d__DataFileAttribute *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_xsd__string(soap, &a->Name);
	soap_serialize_xsd__string(soap, &a->Value);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_d__DataFileAttribute(struct soap *soap, struct d__DataFileAttribute *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_xsd__string(soap, &a->Name);
	soap_default_xsd__string(soap, &a->Value);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_d__DataFileAttribute(struct soap *soap, const struct d__DataFileAttribute *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_d__DataFileAttribute);
	if (soap_out_d__DataFileAttribute(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_d__DataFileAttribute(struct soap *soap, const char *tag, int id, const struct d__DataFileAttribute *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_d__DataFileAttribute), type);
	soap_out_xsd__string(soap, "Name", -1, &a->Name, "");
	soap_out_xsd__string(soap, "Value", -1, &a->Value, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct d__DataFileAttribute * SOAP_FMAC4 soap_get_d__DataFileAttribute(struct soap *soap, struct d__DataFileAttribute *p, const char *tag, const char *type)
{
	if ((p = soap_in_d__DataFileAttribute(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct d__DataFileAttribute * SOAP_FMAC4 soap_in_d__DataFileAttribute(struct soap *soap, const char *tag, struct d__DataFileAttribute *a, const char *type)
{
	short soap_flag_Name = 1, soap_flag_Value = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct d__DataFileAttribute *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_d__DataFileAttribute, sizeof(struct d__DataFileAttribute), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_d__DataFileAttribute(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_Name && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "Name", &a->Name, "xsd:string"))
				{	soap_flag_Name--;
					continue;
				}
			if (soap_flag_Value && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "Value", &a->Value, "xsd:string"))
				{	soap_flag_Value--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct d__DataFileAttribute *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_d__DataFileAttribute, 0, sizeof(struct d__DataFileAttribute), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_xsd__hexBinary(struct soap *soap, struct xsd__hexBinary const*a)
{
	if (a->__ptr)
		soap_array_reference(soap, a, (struct soap_array*)&a->__ptr, 1, SOAP_TYPE_xsd__hexBinary);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_xsd__hexBinary(struct soap *soap, struct xsd__hexBinary *a)
{
	a->__size = 0;
	a->__ptr = NULL;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_xsd__hexBinary(struct soap *soap, const struct xsd__hexBinary *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, (struct soap_array*)&a->__ptr, 1, tag, SOAP_TYPE_xsd__hexBinary);
	if (soap_out_xsd__hexBinary(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_xsd__hexBinary(struct soap *soap, const char *tag, int id, const struct xsd__hexBinary *a, const char *type)
{
	id = soap_element_id(soap, tag, id, a, (struct soap_array*)&a->__ptr, 1, type, SOAP_TYPE_xsd__hexBinary);
	if (id < 0)
		return soap->error;
	soap_element_begin_out(soap, tag, id, type);
	soap_puthex(soap, a->__ptr, a->__size);
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct xsd__hexBinary * SOAP_FMAC4 soap_get_xsd__hexBinary(struct soap *soap, struct xsd__hexBinary *p, const char *tag, const char *type)
{
	if ((p = soap_in_xsd__hexBinary(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct xsd__hexBinary * SOAP_FMAC4 soap_in_xsd__hexBinary(struct soap *soap, const char *tag, struct xsd__hexBinary *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type) && soap_match_tag(soap, soap->type, ":hexBinary"))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (struct xsd__hexBinary *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_xsd__hexBinary, sizeof(struct xsd__hexBinary), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_xsd__hexBinary(soap, a);
	if (soap->body && !*soap->href)
	{
		a->__ptr = soap_gethex(soap, &a->__size);
		if ((!a->__ptr && soap->error) || soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct xsd__hexBinary *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_xsd__hexBinary, 0, sizeof(struct xsd__hexBinary), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

#ifndef WITH_NOGLOBAL

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerToSOAP_ENV__Reason(struct soap *soap, struct SOAP_ENV__Reason *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_SOAP_ENV__Reason))
		soap_serialize_SOAP_ENV__Reason(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerToSOAP_ENV__Reason(struct soap *soap, struct SOAP_ENV__Reason *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerToSOAP_ENV__Reason);
	if (soap_out_PointerToSOAP_ENV__Reason(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerToSOAP_ENV__Reason(struct soap *soap, const char *tag, int id, struct SOAP_ENV__Reason *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_SOAP_ENV__Reason);
	if (id < 0)
		return soap->error;
	return soap_out_SOAP_ENV__Reason(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct SOAP_ENV__Reason ** SOAP_FMAC4 soap_get_PointerToSOAP_ENV__Reason(struct soap *soap, struct SOAP_ENV__Reason **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerToSOAP_ENV__Reason(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct SOAP_ENV__Reason ** SOAP_FMAC4 soap_in_PointerToSOAP_ENV__Reason(struct soap *soap, const char *tag, struct SOAP_ENV__Reason **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct SOAP_ENV__Reason **)soap_malloc(soap, sizeof(struct SOAP_ENV__Reason *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_SOAP_ENV__Reason(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct SOAP_ENV__Reason **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_SOAP_ENV__Reason, sizeof(struct SOAP_ENV__Reason), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

#endif

#ifndef WITH_NOGLOBAL

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerToSOAP_ENV__Detail(struct soap *soap, struct SOAP_ENV__Detail *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_SOAP_ENV__Detail))
		soap_serialize_SOAP_ENV__Detail(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerToSOAP_ENV__Detail(struct soap *soap, struct SOAP_ENV__Detail *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerToSOAP_ENV__Detail);
	if (soap_out_PointerToSOAP_ENV__Detail(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerToSOAP_ENV__Detail(struct soap *soap, const char *tag, int id, struct SOAP_ENV__Detail *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_SOAP_ENV__Detail);
	if (id < 0)
		return soap->error;
	return soap_out_SOAP_ENV__Detail(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct SOAP_ENV__Detail ** SOAP_FMAC4 soap_get_PointerToSOAP_ENV__Detail(struct soap *soap, struct SOAP_ENV__Detail **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerToSOAP_ENV__Detail(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct SOAP_ENV__Detail ** SOAP_FMAC4 soap_in_PointerToSOAP_ENV__Detail(struct soap *soap, const char *tag, struct SOAP_ENV__Detail **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct SOAP_ENV__Detail **)soap_malloc(soap, sizeof(struct SOAP_ENV__Detail *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_SOAP_ENV__Detail(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct SOAP_ENV__Detail **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_SOAP_ENV__Detail, sizeof(struct SOAP_ENV__Detail), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

#endif

#ifndef WITH_NOGLOBAL

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerToSOAP_ENV__Code(struct soap *soap, struct SOAP_ENV__Code *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_SOAP_ENV__Code))
		soap_serialize_SOAP_ENV__Code(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerToSOAP_ENV__Code(struct soap *soap, struct SOAP_ENV__Code *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerToSOAP_ENV__Code);
	if (soap_out_PointerToSOAP_ENV__Code(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerToSOAP_ENV__Code(struct soap *soap, const char *tag, int id, struct SOAP_ENV__Code *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_SOAP_ENV__Code);
	if (id < 0)
		return soap->error;
	return soap_out_SOAP_ENV__Code(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct SOAP_ENV__Code ** SOAP_FMAC4 soap_get_PointerToSOAP_ENV__Code(struct soap *soap, struct SOAP_ENV__Code **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerToSOAP_ENV__Code(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct SOAP_ENV__Code ** SOAP_FMAC4 soap_in_PointerToSOAP_ENV__Code(struct soap *soap, const char *tag, struct SOAP_ENV__Code **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct SOAP_ENV__Code **)soap_malloc(soap, sizeof(struct SOAP_ENV__Code *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_SOAP_ENV__Code(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct SOAP_ENV__Code **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_SOAP_ENV__Code, sizeof(struct SOAP_ENV__Code), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

#endif

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTomss_DummyResp(struct soap *soap, struct mss_DummyResp *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_mss_DummyResp))
		soap_serialize_mss_DummyResp(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTomss_DummyResp(struct soap *soap, struct mss_DummyResp *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTomss_DummyResp);
	if (soap_out_PointerTomss_DummyResp(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTomss_DummyResp(struct soap *soap, const char *tag, int id, struct mss_DummyResp *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_mss_DummyResp);
	if (id < 0)
		return soap->error;
	return soap_out_mss_DummyResp(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct mss_DummyResp ** SOAP_FMAC4 soap_get_PointerTomss_DummyResp(struct soap *soap, struct mss_DummyResp **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTomss_DummyResp(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct mss_DummyResp ** SOAP_FMAC4 soap_in_PointerTomss_DummyResp(struct soap *soap, const char *tag, struct mss_DummyResp **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct mss_DummyResp **)soap_malloc(soap, sizeof(struct mss_DummyResp *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_mss_DummyResp(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct mss_DummyResp **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_mss_DummyResp, sizeof(struct mss_DummyResp), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTod__GetMobileCreateSignatureStatusResponse(struct soap *soap, struct d__GetMobileCreateSignatureStatusResponse *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_d__GetMobileCreateSignatureStatusResponse))
		soap_serialize_d__GetMobileCreateSignatureStatusResponse(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTod__GetMobileCreateSignatureStatusResponse(struct soap *soap, struct d__GetMobileCreateSignatureStatusResponse *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTod__GetMobileCreateSignatureStatusResponse);
	if (soap_out_PointerTod__GetMobileCreateSignatureStatusResponse(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTod__GetMobileCreateSignatureStatusResponse(struct soap *soap, const char *tag, int id, struct d__GetMobileCreateSignatureStatusResponse *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_d__GetMobileCreateSignatureStatusResponse);
	if (id < 0)
		return soap->error;
	return soap_out_d__GetMobileCreateSignatureStatusResponse(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct d__GetMobileCreateSignatureStatusResponse ** SOAP_FMAC4 soap_get_PointerTod__GetMobileCreateSignatureStatusResponse(struct soap *soap, struct d__GetMobileCreateSignatureStatusResponse **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTod__GetMobileCreateSignatureStatusResponse(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct d__GetMobileCreateSignatureStatusResponse ** SOAP_FMAC4 soap_in_PointerTod__GetMobileCreateSignatureStatusResponse(struct soap *soap, const char *tag, struct d__GetMobileCreateSignatureStatusResponse **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct d__GetMobileCreateSignatureStatusResponse **)soap_malloc(soap, sizeof(struct d__GetMobileCreateSignatureStatusResponse *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_d__GetMobileCreateSignatureStatusResponse(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct d__GetMobileCreateSignatureStatusResponse **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_d__GetMobileCreateSignatureStatusResponse, sizeof(struct d__GetMobileCreateSignatureStatusResponse), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTod__MobileCreateSignatureResponse(struct soap *soap, struct d__MobileCreateSignatureResponse *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_d__MobileCreateSignatureResponse))
		soap_serialize_d__MobileCreateSignatureResponse(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTod__MobileCreateSignatureResponse(struct soap *soap, struct d__MobileCreateSignatureResponse *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTod__MobileCreateSignatureResponse);
	if (soap_out_PointerTod__MobileCreateSignatureResponse(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTod__MobileCreateSignatureResponse(struct soap *soap, const char *tag, int id, struct d__MobileCreateSignatureResponse *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_d__MobileCreateSignatureResponse);
	if (id < 0)
		return soap->error;
	return soap_out_d__MobileCreateSignatureResponse(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct d__MobileCreateSignatureResponse ** SOAP_FMAC4 soap_get_PointerTod__MobileCreateSignatureResponse(struct soap *soap, struct d__MobileCreateSignatureResponse **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTod__MobileCreateSignatureResponse(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct d__MobileCreateSignatureResponse ** SOAP_FMAC4 soap_in_PointerTod__MobileCreateSignatureResponse(struct soap *soap, const char *tag, struct d__MobileCreateSignatureResponse **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct d__MobileCreateSignatureResponse **)soap_malloc(soap, sizeof(struct d__MobileCreateSignatureResponse *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_d__MobileCreateSignatureResponse(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct d__MobileCreateSignatureResponse **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_d__MobileCreateSignatureResponse, sizeof(struct d__MobileCreateSignatureResponse), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTod__DataFileDigestList(struct soap *soap, struct d__DataFileDigestList *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_d__DataFileDigestList))
		soap_serialize_d__DataFileDigestList(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTod__DataFileDigestList(struct soap *soap, struct d__DataFileDigestList *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTod__DataFileDigestList);
	if (soap_out_PointerTod__DataFileDigestList(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTod__DataFileDigestList(struct soap *soap, const char *tag, int id, struct d__DataFileDigestList *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_d__DataFileDigestList);
	if (id < 0)
		return soap->error;
	return soap_out_d__DataFileDigestList(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct d__DataFileDigestList ** SOAP_FMAC4 soap_get_PointerTod__DataFileDigestList(struct soap *soap, struct d__DataFileDigestList **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTod__DataFileDigestList(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct d__DataFileDigestList ** SOAP_FMAC4 soap_in_PointerTod__DataFileDigestList(struct soap *soap, const char *tag, struct d__DataFileDigestList **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct d__DataFileDigestList **)soap_malloc(soap, sizeof(struct d__DataFileDigestList *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_d__DataFileDigestList(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct d__DataFileDigestList **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_d__DataFileDigestList, sizeof(struct d__DataFileDigestList), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTod__DataFileDigest(struct soap *soap, struct d__DataFileDigest *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_d__DataFileDigest))
		soap_serialize_d__DataFileDigest(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTod__DataFileDigest(struct soap *soap, struct d__DataFileDigest *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTod__DataFileDigest);
	if (soap_out_PointerTod__DataFileDigest(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTod__DataFileDigest(struct soap *soap, const char *tag, int id, struct d__DataFileDigest *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_d__DataFileDigest);
	if (id < 0)
		return soap->error;
	return soap_out_d__DataFileDigest(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct d__DataFileDigest ** SOAP_FMAC4 soap_get_PointerTod__DataFileDigest(struct soap *soap, struct d__DataFileDigest **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTod__DataFileDigest(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct d__DataFileDigest ** SOAP_FMAC4 soap_in_PointerTod__DataFileDigest(struct soap *soap, const char *tag, struct d__DataFileDigest **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct d__DataFileDigest **)soap_malloc(soap, sizeof(struct d__DataFileDigest *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_d__DataFileDigest(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct d__DataFileDigest **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_d__DataFileDigest, sizeof(struct d__DataFileDigest), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTod__GetMobileAuthenticateStatusResponse(struct soap *soap, struct d__GetMobileAuthenticateStatusResponse *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_d__GetMobileAuthenticateStatusResponse))
		soap_serialize_d__GetMobileAuthenticateStatusResponse(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTod__GetMobileAuthenticateStatusResponse(struct soap *soap, struct d__GetMobileAuthenticateStatusResponse *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTod__GetMobileAuthenticateStatusResponse);
	if (soap_out_PointerTod__GetMobileAuthenticateStatusResponse(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTod__GetMobileAuthenticateStatusResponse(struct soap *soap, const char *tag, int id, struct d__GetMobileAuthenticateStatusResponse *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_d__GetMobileAuthenticateStatusResponse);
	if (id < 0)
		return soap->error;
	return soap_out_d__GetMobileAuthenticateStatusResponse(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct d__GetMobileAuthenticateStatusResponse ** SOAP_FMAC4 soap_get_PointerTod__GetMobileAuthenticateStatusResponse(struct soap *soap, struct d__GetMobileAuthenticateStatusResponse **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTod__GetMobileAuthenticateStatusResponse(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct d__GetMobileAuthenticateStatusResponse ** SOAP_FMAC4 soap_in_PointerTod__GetMobileAuthenticateStatusResponse(struct soap *soap, const char *tag, struct d__GetMobileAuthenticateStatusResponse **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct d__GetMobileAuthenticateStatusResponse **)soap_malloc(soap, sizeof(struct d__GetMobileAuthenticateStatusResponse *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_d__GetMobileAuthenticateStatusResponse(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct d__GetMobileAuthenticateStatusResponse **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_d__GetMobileAuthenticateStatusResponse, sizeof(struct d__GetMobileAuthenticateStatusResponse), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTod__MobileAuthenticateResponse(struct soap *soap, struct d__MobileAuthenticateResponse *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_d__MobileAuthenticateResponse))
		soap_serialize_d__MobileAuthenticateResponse(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTod__MobileAuthenticateResponse(struct soap *soap, struct d__MobileAuthenticateResponse *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTod__MobileAuthenticateResponse);
	if (soap_out_PointerTod__MobileAuthenticateResponse(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTod__MobileAuthenticateResponse(struct soap *soap, const char *tag, int id, struct d__MobileAuthenticateResponse *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_d__MobileAuthenticateResponse);
	if (id < 0)
		return soap->error;
	return soap_out_d__MobileAuthenticateResponse(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct d__MobileAuthenticateResponse ** SOAP_FMAC4 soap_get_PointerTod__MobileAuthenticateResponse(struct soap *soap, struct d__MobileAuthenticateResponse **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTod__MobileAuthenticateResponse(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct d__MobileAuthenticateResponse ** SOAP_FMAC4 soap_in_PointerTod__MobileAuthenticateResponse(struct soap *soap, const char *tag, struct d__MobileAuthenticateResponse **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct d__MobileAuthenticateResponse **)soap_malloc(soap, sizeof(struct d__MobileAuthenticateResponse *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_d__MobileAuthenticateResponse(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct d__MobileAuthenticateResponse **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_d__MobileAuthenticateResponse, sizeof(struct d__MobileAuthenticateResponse), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTod__GetStatusInfoResponse(struct soap *soap, struct d__GetStatusInfoResponse *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_d__GetStatusInfoResponse))
		soap_serialize_d__GetStatusInfoResponse(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTod__GetStatusInfoResponse(struct soap *soap, struct d__GetStatusInfoResponse *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTod__GetStatusInfoResponse);
	if (soap_out_PointerTod__GetStatusInfoResponse(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTod__GetStatusInfoResponse(struct soap *soap, const char *tag, int id, struct d__GetStatusInfoResponse *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_d__GetStatusInfoResponse);
	if (id < 0)
		return soap->error;
	return soap_out_d__GetStatusInfoResponse(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct d__GetStatusInfoResponse ** SOAP_FMAC4 soap_get_PointerTod__GetStatusInfoResponse(struct soap *soap, struct d__GetStatusInfoResponse **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTod__GetStatusInfoResponse(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct d__GetStatusInfoResponse ** SOAP_FMAC4 soap_in_PointerTod__GetStatusInfoResponse(struct soap *soap, const char *tag, struct d__GetStatusInfoResponse **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct d__GetStatusInfoResponse **)soap_malloc(soap, sizeof(struct d__GetStatusInfoResponse *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_d__GetStatusInfoResponse(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct d__GetStatusInfoResponse **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_d__GetStatusInfoResponse, sizeof(struct d__GetStatusInfoResponse), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTod__MobileSignResponse(struct soap *soap, struct d__MobileSignResponse *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_d__MobileSignResponse))
		soap_serialize_d__MobileSignResponse(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTod__MobileSignResponse(struct soap *soap, struct d__MobileSignResponse *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTod__MobileSignResponse);
	if (soap_out_PointerTod__MobileSignResponse(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTod__MobileSignResponse(struct soap *soap, const char *tag, int id, struct d__MobileSignResponse *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_d__MobileSignResponse);
	if (id < 0)
		return soap->error;
	return soap_out_d__MobileSignResponse(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct d__MobileSignResponse ** SOAP_FMAC4 soap_get_PointerTod__MobileSignResponse(struct soap *soap, struct d__MobileSignResponse **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTod__MobileSignResponse(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct d__MobileSignResponse ** SOAP_FMAC4 soap_in_PointerTod__MobileSignResponse(struct soap *soap, const char *tag, struct d__MobileSignResponse **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct d__MobileSignResponse **)soap_malloc(soap, sizeof(struct d__MobileSignResponse *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_d__MobileSignResponse(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct d__MobileSignResponse **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_d__MobileSignResponse, sizeof(struct d__MobileSignResponse), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTod__GetVersionResponse(struct soap *soap, struct d__GetVersionResponse *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_d__GetVersionResponse))
		soap_serialize_d__GetVersionResponse(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTod__GetVersionResponse(struct soap *soap, struct d__GetVersionResponse *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTod__GetVersionResponse);
	if (soap_out_PointerTod__GetVersionResponse(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTod__GetVersionResponse(struct soap *soap, const char *tag, int id, struct d__GetVersionResponse *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_d__GetVersionResponse);
	if (id < 0)
		return soap->error;
	return soap_out_d__GetVersionResponse(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct d__GetVersionResponse ** SOAP_FMAC4 soap_get_PointerTod__GetVersionResponse(struct soap *soap, struct d__GetVersionResponse **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTod__GetVersionResponse(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct d__GetVersionResponse ** SOAP_FMAC4 soap_in_PointerTod__GetVersionResponse(struct soap *soap, const char *tag, struct d__GetVersionResponse **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct d__GetVersionResponse **)soap_malloc(soap, sizeof(struct d__GetVersionResponse *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_d__GetVersionResponse(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct d__GetVersionResponse **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_d__GetVersionResponse, sizeof(struct d__GetVersionResponse), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTod__RemoveSignatureResponse(struct soap *soap, struct d__RemoveSignatureResponse *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_d__RemoveSignatureResponse))
		soap_serialize_d__RemoveSignatureResponse(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTod__RemoveSignatureResponse(struct soap *soap, struct d__RemoveSignatureResponse *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTod__RemoveSignatureResponse);
	if (soap_out_PointerTod__RemoveSignatureResponse(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTod__RemoveSignatureResponse(struct soap *soap, const char *tag, int id, struct d__RemoveSignatureResponse *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_d__RemoveSignatureResponse);
	if (id < 0)
		return soap->error;
	return soap_out_d__RemoveSignatureResponse(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct d__RemoveSignatureResponse ** SOAP_FMAC4 soap_get_PointerTod__RemoveSignatureResponse(struct soap *soap, struct d__RemoveSignatureResponse **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTod__RemoveSignatureResponse(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct d__RemoveSignatureResponse ** SOAP_FMAC4 soap_in_PointerTod__RemoveSignatureResponse(struct soap *soap, const char *tag, struct d__RemoveSignatureResponse **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct d__RemoveSignatureResponse **)soap_malloc(soap, sizeof(struct d__RemoveSignatureResponse *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_d__RemoveSignatureResponse(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct d__RemoveSignatureResponse **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_d__RemoveSignatureResponse, sizeof(struct d__RemoveSignatureResponse), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTod__FinalizeSignatureResponse(struct soap *soap, struct d__FinalizeSignatureResponse *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_d__FinalizeSignatureResponse))
		soap_serialize_d__FinalizeSignatureResponse(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTod__FinalizeSignatureResponse(struct soap *soap, struct d__FinalizeSignatureResponse *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTod__FinalizeSignatureResponse);
	if (soap_out_PointerTod__FinalizeSignatureResponse(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTod__FinalizeSignatureResponse(struct soap *soap, const char *tag, int id, struct d__FinalizeSignatureResponse *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_d__FinalizeSignatureResponse);
	if (id < 0)
		return soap->error;
	return soap_out_d__FinalizeSignatureResponse(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct d__FinalizeSignatureResponse ** SOAP_FMAC4 soap_get_PointerTod__FinalizeSignatureResponse(struct soap *soap, struct d__FinalizeSignatureResponse **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTod__FinalizeSignatureResponse(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct d__FinalizeSignatureResponse ** SOAP_FMAC4 soap_in_PointerTod__FinalizeSignatureResponse(struct soap *soap, const char *tag, struct d__FinalizeSignatureResponse **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct d__FinalizeSignatureResponse **)soap_malloc(soap, sizeof(struct d__FinalizeSignatureResponse *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_d__FinalizeSignatureResponse(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct d__FinalizeSignatureResponse **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_d__FinalizeSignatureResponse, sizeof(struct d__FinalizeSignatureResponse), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTod__PrepareSignatureResponse(struct soap *soap, struct d__PrepareSignatureResponse *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_d__PrepareSignatureResponse))
		soap_serialize_d__PrepareSignatureResponse(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTod__PrepareSignatureResponse(struct soap *soap, struct d__PrepareSignatureResponse *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTod__PrepareSignatureResponse);
	if (soap_out_PointerTod__PrepareSignatureResponse(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTod__PrepareSignatureResponse(struct soap *soap, const char *tag, int id, struct d__PrepareSignatureResponse *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_d__PrepareSignatureResponse);
	if (id < 0)
		return soap->error;
	return soap_out_d__PrepareSignatureResponse(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct d__PrepareSignatureResponse ** SOAP_FMAC4 soap_get_PointerTod__PrepareSignatureResponse(struct soap *soap, struct d__PrepareSignatureResponse **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTod__PrepareSignatureResponse(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct d__PrepareSignatureResponse ** SOAP_FMAC4 soap_in_PointerTod__PrepareSignatureResponse(struct soap *soap, const char *tag, struct d__PrepareSignatureResponse **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct d__PrepareSignatureResponse **)soap_malloc(soap, sizeof(struct d__PrepareSignatureResponse *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_d__PrepareSignatureResponse(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct d__PrepareSignatureResponse **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_d__PrepareSignatureResponse, sizeof(struct d__PrepareSignatureResponse), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTod__GetSignatureModulesResponse(struct soap *soap, struct d__GetSignatureModulesResponse *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_d__GetSignatureModulesResponse))
		soap_serialize_d__GetSignatureModulesResponse(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTod__GetSignatureModulesResponse(struct soap *soap, struct d__GetSignatureModulesResponse *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTod__GetSignatureModulesResponse);
	if (soap_out_PointerTod__GetSignatureModulesResponse(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTod__GetSignatureModulesResponse(struct soap *soap, const char *tag, int id, struct d__GetSignatureModulesResponse *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_d__GetSignatureModulesResponse);
	if (id < 0)
		return soap->error;
	return soap_out_d__GetSignatureModulesResponse(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct d__GetSignatureModulesResponse ** SOAP_FMAC4 soap_get_PointerTod__GetSignatureModulesResponse(struct soap *soap, struct d__GetSignatureModulesResponse **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTod__GetSignatureModulesResponse(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct d__GetSignatureModulesResponse ** SOAP_FMAC4 soap_in_PointerTod__GetSignatureModulesResponse(struct soap *soap, const char *tag, struct d__GetSignatureModulesResponse **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct d__GetSignatureModulesResponse **)soap_malloc(soap, sizeof(struct d__GetSignatureModulesResponse *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_d__GetSignatureModulesResponse(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct d__GetSignatureModulesResponse **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_d__GetSignatureModulesResponse, sizeof(struct d__GetSignatureModulesResponse), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTod__SignatureModulesArray(struct soap *soap, struct d__SignatureModulesArray *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_d__SignatureModulesArray))
		soap_serialize_d__SignatureModulesArray(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTod__SignatureModulesArray(struct soap *soap, struct d__SignatureModulesArray *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTod__SignatureModulesArray);
	if (soap_out_PointerTod__SignatureModulesArray(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTod__SignatureModulesArray(struct soap *soap, const char *tag, int id, struct d__SignatureModulesArray *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_d__SignatureModulesArray);
	if (id < 0)
		return soap->error;
	return soap_out_d__SignatureModulesArray(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct d__SignatureModulesArray ** SOAP_FMAC4 soap_get_PointerTod__SignatureModulesArray(struct soap *soap, struct d__SignatureModulesArray **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTod__SignatureModulesArray(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct d__SignatureModulesArray ** SOAP_FMAC4 soap_in_PointerTod__SignatureModulesArray(struct soap *soap, const char *tag, struct d__SignatureModulesArray **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct d__SignatureModulesArray **)soap_malloc(soap, sizeof(struct d__SignatureModulesArray *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_d__SignatureModulesArray(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct d__SignatureModulesArray **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_d__SignatureModulesArray, sizeof(struct d__SignatureModulesArray), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTod__SignatureModule(struct soap *soap, struct d__SignatureModule *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_d__SignatureModule))
		soap_serialize_d__SignatureModule(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTod__SignatureModule(struct soap *soap, struct d__SignatureModule *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTod__SignatureModule);
	if (soap_out_PointerTod__SignatureModule(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTod__SignatureModule(struct soap *soap, const char *tag, int id, struct d__SignatureModule *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_d__SignatureModule);
	if (id < 0)
		return soap->error;
	return soap_out_d__SignatureModule(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct d__SignatureModule ** SOAP_FMAC4 soap_get_PointerTod__SignatureModule(struct soap *soap, struct d__SignatureModule **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTod__SignatureModule(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct d__SignatureModule ** SOAP_FMAC4 soap_in_PointerTod__SignatureModule(struct soap *soap, const char *tag, struct d__SignatureModule **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct d__SignatureModule **)soap_malloc(soap, sizeof(struct d__SignatureModule *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_d__SignatureModule(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct d__SignatureModule **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_d__SignatureModule, sizeof(struct d__SignatureModule), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTod__GetCRLResponse(struct soap *soap, struct d__GetCRLResponse *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_d__GetCRLResponse))
		soap_serialize_d__GetCRLResponse(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTod__GetCRLResponse(struct soap *soap, struct d__GetCRLResponse *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTod__GetCRLResponse);
	if (soap_out_PointerTod__GetCRLResponse(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTod__GetCRLResponse(struct soap *soap, const char *tag, int id, struct d__GetCRLResponse *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_d__GetCRLResponse);
	if (id < 0)
		return soap->error;
	return soap_out_d__GetCRLResponse(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct d__GetCRLResponse ** SOAP_FMAC4 soap_get_PointerTod__GetCRLResponse(struct soap *soap, struct d__GetCRLResponse **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTod__GetCRLResponse(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct d__GetCRLResponse ** SOAP_FMAC4 soap_in_PointerTod__GetCRLResponse(struct soap *soap, const char *tag, struct d__GetCRLResponse **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct d__GetCRLResponse **)soap_malloc(soap, sizeof(struct d__GetCRLResponse *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_d__GetCRLResponse(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct d__GetCRLResponse **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_d__GetCRLResponse, sizeof(struct d__GetCRLResponse), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTod__GetTimestampResponse(struct soap *soap, struct d__GetTimestampResponse *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_d__GetTimestampResponse))
		soap_serialize_d__GetTimestampResponse(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTod__GetTimestampResponse(struct soap *soap, struct d__GetTimestampResponse *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTod__GetTimestampResponse);
	if (soap_out_PointerTod__GetTimestampResponse(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTod__GetTimestampResponse(struct soap *soap, const char *tag, int id, struct d__GetTimestampResponse *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_d__GetTimestampResponse);
	if (id < 0)
		return soap->error;
	return soap_out_d__GetTimestampResponse(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct d__GetTimestampResponse ** SOAP_FMAC4 soap_get_PointerTod__GetTimestampResponse(struct soap *soap, struct d__GetTimestampResponse **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTod__GetTimestampResponse(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct d__GetTimestampResponse ** SOAP_FMAC4 soap_in_PointerTod__GetTimestampResponse(struct soap *soap, const char *tag, struct d__GetTimestampResponse **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct d__GetTimestampResponse **)soap_malloc(soap, sizeof(struct d__GetTimestampResponse *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_d__GetTimestampResponse(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct d__GetTimestampResponse **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_d__GetTimestampResponse, sizeof(struct d__GetTimestampResponse), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTod__GetTSACertificateResponse(struct soap *soap, struct d__GetTSACertificateResponse *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_d__GetTSACertificateResponse))
		soap_serialize_d__GetTSACertificateResponse(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTod__GetTSACertificateResponse(struct soap *soap, struct d__GetTSACertificateResponse *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTod__GetTSACertificateResponse);
	if (soap_out_PointerTod__GetTSACertificateResponse(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTod__GetTSACertificateResponse(struct soap *soap, const char *tag, int id, struct d__GetTSACertificateResponse *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_d__GetTSACertificateResponse);
	if (id < 0)
		return soap->error;
	return soap_out_d__GetTSACertificateResponse(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct d__GetTSACertificateResponse ** SOAP_FMAC4 soap_get_PointerTod__GetTSACertificateResponse(struct soap *soap, struct d__GetTSACertificateResponse **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTod__GetTSACertificateResponse(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct d__GetTSACertificateResponse ** SOAP_FMAC4 soap_in_PointerTod__GetTSACertificateResponse(struct soap *soap, const char *tag, struct d__GetTSACertificateResponse **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct d__GetTSACertificateResponse **)soap_malloc(soap, sizeof(struct d__GetTSACertificateResponse *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_d__GetTSACertificateResponse(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct d__GetTSACertificateResponse **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_d__GetTSACertificateResponse, sizeof(struct d__GetTSACertificateResponse), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTod__GetNotaryResponse(struct soap *soap, struct d__GetNotaryResponse *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_d__GetNotaryResponse))
		soap_serialize_d__GetNotaryResponse(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTod__GetNotaryResponse(struct soap *soap, struct d__GetNotaryResponse *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTod__GetNotaryResponse);
	if (soap_out_PointerTod__GetNotaryResponse(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTod__GetNotaryResponse(struct soap *soap, const char *tag, int id, struct d__GetNotaryResponse *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_d__GetNotaryResponse);
	if (id < 0)
		return soap->error;
	return soap_out_d__GetNotaryResponse(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct d__GetNotaryResponse ** SOAP_FMAC4 soap_get_PointerTod__GetNotaryResponse(struct soap *soap, struct d__GetNotaryResponse **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTod__GetNotaryResponse(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct d__GetNotaryResponse ** SOAP_FMAC4 soap_in_PointerTod__GetNotaryResponse(struct soap *soap, const char *tag, struct d__GetNotaryResponse **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct d__GetNotaryResponse **)soap_malloc(soap, sizeof(struct d__GetNotaryResponse *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_d__GetNotaryResponse(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct d__GetNotaryResponse **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_d__GetNotaryResponse, sizeof(struct d__GetNotaryResponse), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTod__GetNotarysCertificateResponse(struct soap *soap, struct d__GetNotarysCertificateResponse *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_d__GetNotarysCertificateResponse))
		soap_serialize_d__GetNotarysCertificateResponse(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTod__GetNotarysCertificateResponse(struct soap *soap, struct d__GetNotarysCertificateResponse *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTod__GetNotarysCertificateResponse);
	if (soap_out_PointerTod__GetNotarysCertificateResponse(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTod__GetNotarysCertificateResponse(struct soap *soap, const char *tag, int id, struct d__GetNotarysCertificateResponse *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_d__GetNotarysCertificateResponse);
	if (id < 0)
		return soap->error;
	return soap_out_d__GetNotarysCertificateResponse(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct d__GetNotarysCertificateResponse ** SOAP_FMAC4 soap_get_PointerTod__GetNotarysCertificateResponse(struct soap *soap, struct d__GetNotarysCertificateResponse **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTod__GetNotarysCertificateResponse(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct d__GetNotarysCertificateResponse ** SOAP_FMAC4 soap_in_PointerTod__GetNotarysCertificateResponse(struct soap *soap, const char *tag, struct d__GetNotarysCertificateResponse **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct d__GetNotarysCertificateResponse **)soap_malloc(soap, sizeof(struct d__GetNotarysCertificateResponse *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_d__GetNotarysCertificateResponse(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct d__GetNotarysCertificateResponse **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_d__GetNotarysCertificateResponse, sizeof(struct d__GetNotarysCertificateResponse), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTod__GetSignersCertificateResponse(struct soap *soap, struct d__GetSignersCertificateResponse *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_d__GetSignersCertificateResponse))
		soap_serialize_d__GetSignersCertificateResponse(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTod__GetSignersCertificateResponse(struct soap *soap, struct d__GetSignersCertificateResponse *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTod__GetSignersCertificateResponse);
	if (soap_out_PointerTod__GetSignersCertificateResponse(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTod__GetSignersCertificateResponse(struct soap *soap, const char *tag, int id, struct d__GetSignersCertificateResponse *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_d__GetSignersCertificateResponse);
	if (id < 0)
		return soap->error;
	return soap_out_d__GetSignersCertificateResponse(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct d__GetSignersCertificateResponse ** SOAP_FMAC4 soap_get_PointerTod__GetSignersCertificateResponse(struct soap *soap, struct d__GetSignersCertificateResponse **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTod__GetSignersCertificateResponse(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct d__GetSignersCertificateResponse ** SOAP_FMAC4 soap_in_PointerTod__GetSignersCertificateResponse(struct soap *soap, const char *tag, struct d__GetSignersCertificateResponse **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct d__GetSignersCertificateResponse **)soap_malloc(soap, sizeof(struct d__GetSignersCertificateResponse *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_d__GetSignersCertificateResponse(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct d__GetSignersCertificateResponse **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_d__GetSignersCertificateResponse, sizeof(struct d__GetSignersCertificateResponse), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTod__GetDataFileResponse(struct soap *soap, struct d__GetDataFileResponse *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_d__GetDataFileResponse))
		soap_serialize_d__GetDataFileResponse(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTod__GetDataFileResponse(struct soap *soap, struct d__GetDataFileResponse *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTod__GetDataFileResponse);
	if (soap_out_PointerTod__GetDataFileResponse(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTod__GetDataFileResponse(struct soap *soap, const char *tag, int id, struct d__GetDataFileResponse *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_d__GetDataFileResponse);
	if (id < 0)
		return soap->error;
	return soap_out_d__GetDataFileResponse(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct d__GetDataFileResponse ** SOAP_FMAC4 soap_get_PointerTod__GetDataFileResponse(struct soap *soap, struct d__GetDataFileResponse **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTod__GetDataFileResponse(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct d__GetDataFileResponse ** SOAP_FMAC4 soap_in_PointerTod__GetDataFileResponse(struct soap *soap, const char *tag, struct d__GetDataFileResponse **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct d__GetDataFileResponse **)soap_malloc(soap, sizeof(struct d__GetDataFileResponse *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_d__GetDataFileResponse(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct d__GetDataFileResponse **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_d__GetDataFileResponse, sizeof(struct d__GetDataFileResponse), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTod__GetSignedDocInfoResponse(struct soap *soap, struct d__GetSignedDocInfoResponse *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_d__GetSignedDocInfoResponse))
		soap_serialize_d__GetSignedDocInfoResponse(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTod__GetSignedDocInfoResponse(struct soap *soap, struct d__GetSignedDocInfoResponse *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTod__GetSignedDocInfoResponse);
	if (soap_out_PointerTod__GetSignedDocInfoResponse(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTod__GetSignedDocInfoResponse(struct soap *soap, const char *tag, int id, struct d__GetSignedDocInfoResponse *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_d__GetSignedDocInfoResponse);
	if (id < 0)
		return soap->error;
	return soap_out_d__GetSignedDocInfoResponse(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct d__GetSignedDocInfoResponse ** SOAP_FMAC4 soap_get_PointerTod__GetSignedDocInfoResponse(struct soap *soap, struct d__GetSignedDocInfoResponse **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTod__GetSignedDocInfoResponse(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct d__GetSignedDocInfoResponse ** SOAP_FMAC4 soap_in_PointerTod__GetSignedDocInfoResponse(struct soap *soap, const char *tag, struct d__GetSignedDocInfoResponse **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct d__GetSignedDocInfoResponse **)soap_malloc(soap, sizeof(struct d__GetSignedDocInfoResponse *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_d__GetSignedDocInfoResponse(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct d__GetSignedDocInfoResponse **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_d__GetSignedDocInfoResponse, sizeof(struct d__GetSignedDocInfoResponse), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTod__GetSignedDocResponse(struct soap *soap, struct d__GetSignedDocResponse *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_d__GetSignedDocResponse))
		soap_serialize_d__GetSignedDocResponse(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTod__GetSignedDocResponse(struct soap *soap, struct d__GetSignedDocResponse *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTod__GetSignedDocResponse);
	if (soap_out_PointerTod__GetSignedDocResponse(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTod__GetSignedDocResponse(struct soap *soap, const char *tag, int id, struct d__GetSignedDocResponse *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_d__GetSignedDocResponse);
	if (id < 0)
		return soap->error;
	return soap_out_d__GetSignedDocResponse(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct d__GetSignedDocResponse ** SOAP_FMAC4 soap_get_PointerTod__GetSignedDocResponse(struct soap *soap, struct d__GetSignedDocResponse **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTod__GetSignedDocResponse(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct d__GetSignedDocResponse ** SOAP_FMAC4 soap_in_PointerTod__GetSignedDocResponse(struct soap *soap, const char *tag, struct d__GetSignedDocResponse **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct d__GetSignedDocResponse **)soap_malloc(soap, sizeof(struct d__GetSignedDocResponse *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_d__GetSignedDocResponse(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct d__GetSignedDocResponse **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_d__GetSignedDocResponse, sizeof(struct d__GetSignedDocResponse), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTod__RemoveDataFileResponse(struct soap *soap, struct d__RemoveDataFileResponse *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_d__RemoveDataFileResponse))
		soap_serialize_d__RemoveDataFileResponse(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTod__RemoveDataFileResponse(struct soap *soap, struct d__RemoveDataFileResponse *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTod__RemoveDataFileResponse);
	if (soap_out_PointerTod__RemoveDataFileResponse(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTod__RemoveDataFileResponse(struct soap *soap, const char *tag, int id, struct d__RemoveDataFileResponse *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_d__RemoveDataFileResponse);
	if (id < 0)
		return soap->error;
	return soap_out_d__RemoveDataFileResponse(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct d__RemoveDataFileResponse ** SOAP_FMAC4 soap_get_PointerTod__RemoveDataFileResponse(struct soap *soap, struct d__RemoveDataFileResponse **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTod__RemoveDataFileResponse(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct d__RemoveDataFileResponse ** SOAP_FMAC4 soap_in_PointerTod__RemoveDataFileResponse(struct soap *soap, const char *tag, struct d__RemoveDataFileResponse **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct d__RemoveDataFileResponse **)soap_malloc(soap, sizeof(struct d__RemoveDataFileResponse *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_d__RemoveDataFileResponse(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct d__RemoveDataFileResponse **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_d__RemoveDataFileResponse, sizeof(struct d__RemoveDataFileResponse), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTod__AddDataFileResponse(struct soap *soap, struct d__AddDataFileResponse *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_d__AddDataFileResponse))
		soap_serialize_d__AddDataFileResponse(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTod__AddDataFileResponse(struct soap *soap, struct d__AddDataFileResponse *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTod__AddDataFileResponse);
	if (soap_out_PointerTod__AddDataFileResponse(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTod__AddDataFileResponse(struct soap *soap, const char *tag, int id, struct d__AddDataFileResponse *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_d__AddDataFileResponse);
	if (id < 0)
		return soap->error;
	return soap_out_d__AddDataFileResponse(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct d__AddDataFileResponse ** SOAP_FMAC4 soap_get_PointerTod__AddDataFileResponse(struct soap *soap, struct d__AddDataFileResponse **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTod__AddDataFileResponse(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct d__AddDataFileResponse ** SOAP_FMAC4 soap_in_PointerTod__AddDataFileResponse(struct soap *soap, const char *tag, struct d__AddDataFileResponse **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct d__AddDataFileResponse **)soap_malloc(soap, sizeof(struct d__AddDataFileResponse *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_d__AddDataFileResponse(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct d__AddDataFileResponse **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_d__AddDataFileResponse, sizeof(struct d__AddDataFileResponse), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTod__CreateSignedDocResponse(struct soap *soap, struct d__CreateSignedDocResponse *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_d__CreateSignedDocResponse))
		soap_serialize_d__CreateSignedDocResponse(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTod__CreateSignedDocResponse(struct soap *soap, struct d__CreateSignedDocResponse *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTod__CreateSignedDocResponse);
	if (soap_out_PointerTod__CreateSignedDocResponse(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTod__CreateSignedDocResponse(struct soap *soap, const char *tag, int id, struct d__CreateSignedDocResponse *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_d__CreateSignedDocResponse);
	if (id < 0)
		return soap->error;
	return soap_out_d__CreateSignedDocResponse(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct d__CreateSignedDocResponse ** SOAP_FMAC4 soap_get_PointerTod__CreateSignedDocResponse(struct soap *soap, struct d__CreateSignedDocResponse **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTod__CreateSignedDocResponse(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct d__CreateSignedDocResponse ** SOAP_FMAC4 soap_in_PointerTod__CreateSignedDocResponse(struct soap *soap, const char *tag, struct d__CreateSignedDocResponse **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct d__CreateSignedDocResponse **)soap_malloc(soap, sizeof(struct d__CreateSignedDocResponse *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_d__CreateSignedDocResponse(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct d__CreateSignedDocResponse **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_d__CreateSignedDocResponse, sizeof(struct d__CreateSignedDocResponse), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTod__CloseSessionResponse(struct soap *soap, struct d__CloseSessionResponse *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_d__CloseSessionResponse))
		soap_serialize_d__CloseSessionResponse(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTod__CloseSessionResponse(struct soap *soap, struct d__CloseSessionResponse *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTod__CloseSessionResponse);
	if (soap_out_PointerTod__CloseSessionResponse(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTod__CloseSessionResponse(struct soap *soap, const char *tag, int id, struct d__CloseSessionResponse *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_d__CloseSessionResponse);
	if (id < 0)
		return soap->error;
	return soap_out_d__CloseSessionResponse(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct d__CloseSessionResponse ** SOAP_FMAC4 soap_get_PointerTod__CloseSessionResponse(struct soap *soap, struct d__CloseSessionResponse **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTod__CloseSessionResponse(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct d__CloseSessionResponse ** SOAP_FMAC4 soap_in_PointerTod__CloseSessionResponse(struct soap *soap, const char *tag, struct d__CloseSessionResponse **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct d__CloseSessionResponse **)soap_malloc(soap, sizeof(struct d__CloseSessionResponse *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_d__CloseSessionResponse(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct d__CloseSessionResponse **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_d__CloseSessionResponse, sizeof(struct d__CloseSessionResponse), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTod__StartSessionResponse(struct soap *soap, struct d__StartSessionResponse *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_d__StartSessionResponse))
		soap_serialize_d__StartSessionResponse(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTod__StartSessionResponse(struct soap *soap, struct d__StartSessionResponse *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTod__StartSessionResponse);
	if (soap_out_PointerTod__StartSessionResponse(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTod__StartSessionResponse(struct soap *soap, const char *tag, int id, struct d__StartSessionResponse *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_d__StartSessionResponse);
	if (id < 0)
		return soap->error;
	return soap_out_d__StartSessionResponse(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct d__StartSessionResponse ** SOAP_FMAC4 soap_get_PointerTod__StartSessionResponse(struct soap *soap, struct d__StartSessionResponse **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTod__StartSessionResponse(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct d__StartSessionResponse ** SOAP_FMAC4 soap_in_PointerTod__StartSessionResponse(struct soap *soap, const char *tag, struct d__StartSessionResponse **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct d__StartSessionResponse **)soap_malloc(soap, sizeof(struct d__StartSessionResponse *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_d__StartSessionResponse(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct d__StartSessionResponse **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_d__StartSessionResponse, sizeof(struct d__StartSessionResponse), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTod__DataFileData(struct soap *soap, struct d__DataFileData *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_d__DataFileData))
		soap_serialize_d__DataFileData(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTod__DataFileData(struct soap *soap, struct d__DataFileData *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTod__DataFileData);
	if (soap_out_PointerTod__DataFileData(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTod__DataFileData(struct soap *soap, const char *tag, int id, struct d__DataFileData *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_d__DataFileData);
	if (id < 0)
		return soap->error;
	return soap_out_d__DataFileData(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct d__DataFileData ** SOAP_FMAC4 soap_get_PointerTod__DataFileData(struct soap *soap, struct d__DataFileData **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTod__DataFileData(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct d__DataFileData ** SOAP_FMAC4 soap_in_PointerTod__DataFileData(struct soap *soap, const char *tag, struct d__DataFileData **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct d__DataFileData **)soap_malloc(soap, sizeof(struct d__DataFileData *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_d__DataFileData(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct d__DataFileData **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_d__DataFileData, sizeof(struct d__DataFileData), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTod__SignedDocInfo(struct soap *soap, struct d__SignedDocInfo *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_d__SignedDocInfo))
		soap_serialize_d__SignedDocInfo(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTod__SignedDocInfo(struct soap *soap, struct d__SignedDocInfo *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTod__SignedDocInfo);
	if (soap_out_PointerTod__SignedDocInfo(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTod__SignedDocInfo(struct soap *soap, const char *tag, int id, struct d__SignedDocInfo *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_d__SignedDocInfo);
	if (id < 0)
		return soap->error;
	return soap_out_d__SignedDocInfo(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct d__SignedDocInfo ** SOAP_FMAC4 soap_get_PointerTod__SignedDocInfo(struct soap *soap, struct d__SignedDocInfo **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTod__SignedDocInfo(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct d__SignedDocInfo ** SOAP_FMAC4 soap_in_PointerTod__SignedDocInfo(struct soap *soap, const char *tag, struct d__SignedDocInfo **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct d__SignedDocInfo **)soap_malloc(soap, sizeof(struct d__SignedDocInfo *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_d__SignedDocInfo(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct d__SignedDocInfo **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_d__SignedDocInfo, sizeof(struct d__SignedDocInfo), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTod__SignatureInfo(struct soap *soap, struct d__SignatureInfo *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_d__SignatureInfo))
		soap_serialize_d__SignatureInfo(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTod__SignatureInfo(struct soap *soap, struct d__SignatureInfo *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTod__SignatureInfo);
	if (soap_out_PointerTod__SignatureInfo(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTod__SignatureInfo(struct soap *soap, const char *tag, int id, struct d__SignatureInfo *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_d__SignatureInfo);
	if (id < 0)
		return soap->error;
	return soap_out_d__SignatureInfo(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct d__SignatureInfo ** SOAP_FMAC4 soap_get_PointerTod__SignatureInfo(struct soap *soap, struct d__SignatureInfo **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTod__SignatureInfo(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct d__SignatureInfo ** SOAP_FMAC4 soap_in_PointerTod__SignatureInfo(struct soap *soap, const char *tag, struct d__SignatureInfo **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct d__SignatureInfo **)soap_malloc(soap, sizeof(struct d__SignatureInfo *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_d__SignatureInfo(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct d__SignatureInfo **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_d__SignatureInfo, sizeof(struct d__SignatureInfo), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTod__DataFileInfo(struct soap *soap, struct d__DataFileInfo *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_d__DataFileInfo))
		soap_serialize_d__DataFileInfo(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTod__DataFileInfo(struct soap *soap, struct d__DataFileInfo *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTod__DataFileInfo);
	if (soap_out_PointerTod__DataFileInfo(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTod__DataFileInfo(struct soap *soap, const char *tag, int id, struct d__DataFileInfo *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_d__DataFileInfo);
	if (id < 0)
		return soap->error;
	return soap_out_d__DataFileInfo(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct d__DataFileInfo ** SOAP_FMAC4 soap_get_PointerTod__DataFileInfo(struct soap *soap, struct d__DataFileInfo **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTod__DataFileInfo(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct d__DataFileInfo ** SOAP_FMAC4 soap_in_PointerTod__DataFileInfo(struct soap *soap, const char *tag, struct d__DataFileInfo **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct d__DataFileInfo **)soap_malloc(soap, sizeof(struct d__DataFileInfo *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_d__DataFileInfo(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct d__DataFileInfo **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_d__DataFileInfo, sizeof(struct d__DataFileInfo), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTod__CRLInfo(struct soap *soap, struct d__CRLInfo *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_d__CRLInfo))
		soap_serialize_d__CRLInfo(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTod__CRLInfo(struct soap *soap, struct d__CRLInfo *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTod__CRLInfo);
	if (soap_out_PointerTod__CRLInfo(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTod__CRLInfo(struct soap *soap, const char *tag, int id, struct d__CRLInfo *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_d__CRLInfo);
	if (id < 0)
		return soap->error;
	return soap_out_d__CRLInfo(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct d__CRLInfo ** SOAP_FMAC4 soap_get_PointerTod__CRLInfo(struct soap *soap, struct d__CRLInfo **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTod__CRLInfo(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct d__CRLInfo ** SOAP_FMAC4 soap_in_PointerTod__CRLInfo(struct soap *soap, const char *tag, struct d__CRLInfo **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct d__CRLInfo **)soap_malloc(soap, sizeof(struct d__CRLInfo *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_d__CRLInfo(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct d__CRLInfo **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_d__CRLInfo, sizeof(struct d__CRLInfo), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTod__TstInfo(struct soap *soap, struct d__TstInfo *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_d__TstInfo))
		soap_serialize_d__TstInfo(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTod__TstInfo(struct soap *soap, struct d__TstInfo *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTod__TstInfo);
	if (soap_out_PointerTod__TstInfo(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTod__TstInfo(struct soap *soap, const char *tag, int id, struct d__TstInfo *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_d__TstInfo);
	if (id < 0)
		return soap->error;
	return soap_out_d__TstInfo(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct d__TstInfo ** SOAP_FMAC4 soap_get_PointerTod__TstInfo(struct soap *soap, struct d__TstInfo **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTod__TstInfo(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct d__TstInfo ** SOAP_FMAC4 soap_in_PointerTod__TstInfo(struct soap *soap, const char *tag, struct d__TstInfo **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct d__TstInfo **)soap_malloc(soap, sizeof(struct d__TstInfo *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_d__TstInfo(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct d__TstInfo **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_d__TstInfo, sizeof(struct d__TstInfo), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTod__ConfirmationInfo(struct soap *soap, struct d__ConfirmationInfo *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_d__ConfirmationInfo))
		soap_serialize_d__ConfirmationInfo(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTod__ConfirmationInfo(struct soap *soap, struct d__ConfirmationInfo *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTod__ConfirmationInfo);
	if (soap_out_PointerTod__ConfirmationInfo(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTod__ConfirmationInfo(struct soap *soap, const char *tag, int id, struct d__ConfirmationInfo *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_d__ConfirmationInfo);
	if (id < 0)
		return soap->error;
	return soap_out_d__ConfirmationInfo(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct d__ConfirmationInfo ** SOAP_FMAC4 soap_get_PointerTod__ConfirmationInfo(struct soap *soap, struct d__ConfirmationInfo **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTod__ConfirmationInfo(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct d__ConfirmationInfo ** SOAP_FMAC4 soap_in_PointerTod__ConfirmationInfo(struct soap *soap, const char *tag, struct d__ConfirmationInfo **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct d__ConfirmationInfo **)soap_malloc(soap, sizeof(struct d__ConfirmationInfo *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_d__ConfirmationInfo(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct d__ConfirmationInfo **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_d__ConfirmationInfo, sizeof(struct d__ConfirmationInfo), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTod__SignerInfo(struct soap *soap, struct d__SignerInfo *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_d__SignerInfo))
		soap_serialize_d__SignerInfo(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTod__SignerInfo(struct soap *soap, struct d__SignerInfo *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTod__SignerInfo);
	if (soap_out_PointerTod__SignerInfo(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTod__SignerInfo(struct soap *soap, const char *tag, int id, struct d__SignerInfo *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_d__SignerInfo);
	if (id < 0)
		return soap->error;
	return soap_out_d__SignerInfo(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct d__SignerInfo ** SOAP_FMAC4 soap_get_PointerTod__SignerInfo(struct soap *soap, struct d__SignerInfo **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTod__SignerInfo(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct d__SignerInfo ** SOAP_FMAC4 soap_in_PointerTod__SignerInfo(struct soap *soap, const char *tag, struct d__SignerInfo **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct d__SignerInfo **)soap_malloc(soap, sizeof(struct d__SignerInfo *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_d__SignerInfo(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct d__SignerInfo **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_d__SignerInfo, sizeof(struct d__SignerInfo), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTod__SignatureProductionPlace(struct soap *soap, struct d__SignatureProductionPlace *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_d__SignatureProductionPlace))
		soap_serialize_d__SignatureProductionPlace(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTod__SignatureProductionPlace(struct soap *soap, struct d__SignatureProductionPlace *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTod__SignatureProductionPlace);
	if (soap_out_PointerTod__SignatureProductionPlace(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTod__SignatureProductionPlace(struct soap *soap, const char *tag, int id, struct d__SignatureProductionPlace *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_d__SignatureProductionPlace);
	if (id < 0)
		return soap->error;
	return soap_out_d__SignatureProductionPlace(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct d__SignatureProductionPlace ** SOAP_FMAC4 soap_get_PointerTod__SignatureProductionPlace(struct soap *soap, struct d__SignatureProductionPlace **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTod__SignatureProductionPlace(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct d__SignatureProductionPlace ** SOAP_FMAC4 soap_in_PointerTod__SignatureProductionPlace(struct soap *soap, const char *tag, struct d__SignatureProductionPlace **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct d__SignatureProductionPlace **)soap_malloc(soap, sizeof(struct d__SignatureProductionPlace *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_d__SignatureProductionPlace(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct d__SignatureProductionPlace **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_d__SignatureProductionPlace, sizeof(struct d__SignatureProductionPlace), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTod__SignerRole(struct soap *soap, struct d__SignerRole *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_d__SignerRole))
		soap_serialize_d__SignerRole(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTod__SignerRole(struct soap *soap, struct d__SignerRole *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTod__SignerRole);
	if (soap_out_PointerTod__SignerRole(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTod__SignerRole(struct soap *soap, const char *tag, int id, struct d__SignerRole *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_d__SignerRole);
	if (id < 0)
		return soap->error;
	return soap_out_d__SignerRole(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct d__SignerRole ** SOAP_FMAC4 soap_get_PointerTod__SignerRole(struct soap *soap, struct d__SignerRole **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTod__SignerRole(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct d__SignerRole ** SOAP_FMAC4 soap_in_PointerTod__SignerRole(struct soap *soap, const char *tag, struct d__SignerRole **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct d__SignerRole **)soap_malloc(soap, sizeof(struct d__SignerRole *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_d__SignerRole(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct d__SignerRole **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_d__SignerRole, sizeof(struct d__SignerRole), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTod__Error(struct soap *soap, struct d__Error *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_d__Error))
		soap_serialize_d__Error(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTod__Error(struct soap *soap, struct d__Error *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTod__Error);
	if (soap_out_PointerTod__Error(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTod__Error(struct soap *soap, const char *tag, int id, struct d__Error *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_d__Error);
	if (id < 0)
		return soap->error;
	return soap_out_d__Error(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct d__Error ** SOAP_FMAC4 soap_get_PointerTod__Error(struct soap *soap, struct d__Error **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTod__Error(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct d__Error ** SOAP_FMAC4 soap_in_PointerTod__Error(struct soap *soap, const char *tag, struct d__Error **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct d__Error **)soap_malloc(soap, sizeof(struct d__Error *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_d__Error(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct d__Error **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_d__Error, sizeof(struct d__Error), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTod__RevokedInfo(struct soap *soap, struct d__RevokedInfo *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_d__RevokedInfo))
		soap_serialize_d__RevokedInfo(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTod__RevokedInfo(struct soap *soap, struct d__RevokedInfo *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTod__RevokedInfo);
	if (soap_out_PointerTod__RevokedInfo(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTod__RevokedInfo(struct soap *soap, const char *tag, int id, struct d__RevokedInfo *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_d__RevokedInfo);
	if (id < 0)
		return soap->error;
	return soap_out_d__RevokedInfo(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct d__RevokedInfo ** SOAP_FMAC4 soap_get_PointerTod__RevokedInfo(struct soap *soap, struct d__RevokedInfo **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTod__RevokedInfo(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct d__RevokedInfo ** SOAP_FMAC4 soap_in_PointerTod__RevokedInfo(struct soap *soap, const char *tag, struct d__RevokedInfo **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct d__RevokedInfo **)soap_malloc(soap, sizeof(struct d__RevokedInfo *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_d__RevokedInfo(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct d__RevokedInfo **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_d__RevokedInfo, sizeof(struct d__RevokedInfo), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTod__CertificateInfo(struct soap *soap, struct d__CertificateInfo *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_d__CertificateInfo))
		soap_serialize_d__CertificateInfo(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTod__CertificateInfo(struct soap *soap, struct d__CertificateInfo *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTod__CertificateInfo);
	if (soap_out_PointerTod__CertificateInfo(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTod__CertificateInfo(struct soap *soap, const char *tag, int id, struct d__CertificateInfo *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_d__CertificateInfo);
	if (id < 0)
		return soap->error;
	return soap_out_d__CertificateInfo(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct d__CertificateInfo ** SOAP_FMAC4 soap_get_PointerTod__CertificateInfo(struct soap *soap, struct d__CertificateInfo **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTod__CertificateInfo(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct d__CertificateInfo ** SOAP_FMAC4 soap_in_PointerTod__CertificateInfo(struct soap *soap, const char *tag, struct d__CertificateInfo **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct d__CertificateInfo **)soap_malloc(soap, sizeof(struct d__CertificateInfo *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_d__CertificateInfo(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct d__CertificateInfo **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_d__CertificateInfo, sizeof(struct d__CertificateInfo), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTod__CertificatePolicy(struct soap *soap, struct d__CertificatePolicy *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_d__CertificatePolicy))
		soap_serialize_d__CertificatePolicy(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTod__CertificatePolicy(struct soap *soap, struct d__CertificatePolicy *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTod__CertificatePolicy);
	if (soap_out_PointerTod__CertificatePolicy(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTod__CertificatePolicy(struct soap *soap, const char *tag, int id, struct d__CertificatePolicy *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_d__CertificatePolicy);
	if (id < 0)
		return soap->error;
	return soap_out_d__CertificatePolicy(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct d__CertificatePolicy ** SOAP_FMAC4 soap_get_PointerTod__CertificatePolicy(struct soap *soap, struct d__CertificatePolicy **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTod__CertificatePolicy(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct d__CertificatePolicy ** SOAP_FMAC4 soap_in_PointerTod__CertificatePolicy(struct soap *soap, const char *tag, struct d__CertificatePolicy **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct d__CertificatePolicy **)soap_malloc(soap, sizeof(struct d__CertificatePolicy *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_d__CertificatePolicy(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct d__CertificatePolicy **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_d__CertificatePolicy, sizeof(struct d__CertificatePolicy), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTod__DataFileAttribute(struct soap *soap, struct d__DataFileAttribute *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_d__DataFileAttribute))
		soap_serialize_d__DataFileAttribute(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTod__DataFileAttribute(struct soap *soap, struct d__DataFileAttribute *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTod__DataFileAttribute);
	if (soap_out_PointerTod__DataFileAttribute(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTod__DataFileAttribute(struct soap *soap, const char *tag, int id, struct d__DataFileAttribute *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_d__DataFileAttribute);
	if (id < 0)
		return soap->error;
	return soap_out_d__DataFileAttribute(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct d__DataFileAttribute ** SOAP_FMAC4 soap_get_PointerTod__DataFileAttribute(struct soap *soap, struct d__DataFileAttribute **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTod__DataFileAttribute(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct d__DataFileAttribute ** SOAP_FMAC4 soap_in_PointerTod__DataFileAttribute(struct soap *soap, const char *tag, struct d__DataFileAttribute **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct d__DataFileAttribute **)soap_malloc(soap, sizeof(struct d__DataFileAttribute *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_d__DataFileAttribute(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct d__DataFileAttribute **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_d__DataFileAttribute, sizeof(struct d__DataFileAttribute), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTounsignedByte(struct soap *soap, unsigned char *const*a)
{
	soap_reference(soap, *a, SOAP_TYPE_unsignedByte);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTounsignedByte(struct soap *soap, unsigned char *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTounsignedByte);
	if (soap_out_PointerTounsignedByte(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTounsignedByte(struct soap *soap, const char *tag, int id, unsigned char *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_unsignedByte);
	if (id < 0)
		return soap->error;
	return soap_out_unsignedByte(soap, tag, id, *a, type);
}

SOAP_FMAC3 unsigned char ** SOAP_FMAC4 soap_get_PointerTounsignedByte(struct soap *soap, unsigned char **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTounsignedByte(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 unsigned char ** SOAP_FMAC4 soap_in_PointerTounsignedByte(struct soap *soap, const char *tag, unsigned char **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (unsigned char **)soap_malloc(soap, sizeof(unsigned char *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_unsignedByte(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (unsigned char **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_unsignedByte, sizeof(unsigned char), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_xsd__dateTime(struct soap *soap, char **a)
{	soap_default_string(soap, a);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_xsd__dateTime(struct soap *soap, char *const*a)
{	soap_serialize_string(soap, a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_xsd__dateTime(struct soap *soap, char *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_xsd__dateTime);
	if (soap_out_xsd__dateTime(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_xsd__dateTime(struct soap *soap, const char *tag, int id, char *const*a, const char *type)
{
	return soap_outstring(soap, tag, id, a, type, SOAP_TYPE_xsd__dateTime);
}

SOAP_FMAC3 char ** SOAP_FMAC4 soap_get_xsd__dateTime(struct soap *soap, char **p, const char *tag, const char *type)
{
	if ((p = soap_in_xsd__dateTime(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 char * * SOAP_FMAC4 soap_in_xsd__dateTime(struct soap *soap, const char *tag, char **a, const char *type)
{
	return soap_instring(soap, tag, a, type, SOAP_TYPE_xsd__dateTime, 1, -1, -1);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_xsd__anyURI(struct soap *soap, char **a)
{	soap_default_string(soap, a);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_xsd__anyURI(struct soap *soap, char *const*a)
{	soap_serialize_string(soap, a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_xsd__anyURI(struct soap *soap, char *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_xsd__anyURI);
	if (soap_out_xsd__anyURI(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_xsd__anyURI(struct soap *soap, const char *tag, int id, char *const*a, const char *type)
{
	return soap_outstring(soap, tag, id, a, type, SOAP_TYPE_xsd__anyURI);
}

SOAP_FMAC3 char ** SOAP_FMAC4 soap_get_xsd__anyURI(struct soap *soap, char **p, const char *tag, const char *type)
{
	if ((p = soap_in_xsd__anyURI(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 char * * SOAP_FMAC4 soap_in_xsd__anyURI(struct soap *soap, const char *tag, char **a, const char *type)
{
	return soap_instring(soap, tag, a, type, SOAP_TYPE_xsd__anyURI, 1, -1, -1);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_xsd__string(struct soap *soap, char **a)
{	soap_default_string(soap, a);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_xsd__string(struct soap *soap, char *const*a)
{	soap_serialize_string(soap, a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_xsd__string(struct soap *soap, char *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_xsd__string);
	if (soap_out_xsd__string(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_xsd__string(struct soap *soap, const char *tag, int id, char *const*a, const char *type)
{
	return soap_outstring(soap, tag, id, a, type, SOAP_TYPE_xsd__string);
}

SOAP_FMAC3 char ** SOAP_FMAC4 soap_get_xsd__string(struct soap *soap, char **p, const char *tag, const char *type)
{
	if ((p = soap_in_xsd__string(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 char * * SOAP_FMAC4 soap_in_xsd__string(struct soap *soap, const char *tag, char **a, const char *type)
{
	return soap_instring(soap, tag, a, type, SOAP_TYPE_xsd__string, 1, -1, -1);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__QName(struct soap *soap, char **a)
{	soap_default_string(soap, a);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__QName(struct soap *soap, char *const*a)
{	soap_serialize_string(soap, a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__QName(struct soap *soap, char *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__QName);
	if (soap_out__QName(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__QName(struct soap *soap, const char *tag, int id, char *const*a, const char *type)
{
	return soap_outstring(soap, tag, id, a, type, SOAP_TYPE__QName);
}

SOAP_FMAC3 char ** SOAP_FMAC4 soap_get__QName(struct soap *soap, char **p, const char *tag, const char *type)
{
	if ((p = soap_in__QName(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 char * * SOAP_FMAC4 soap_in__QName(struct soap *soap, const char *tag, char **a, const char *type)
{
	return soap_instring(soap, tag, a, type, SOAP_TYPE__QName, 2, -1, -1);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_string(struct soap *soap, char **a)
{	(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_string
	*a = SOAP_DEFAULT_string;
#else
	*a = (char *)0;
#endif
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_string(struct soap *soap, char *const*a)
{
	soap_reference(soap, *a, SOAP_TYPE_string);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_string(struct soap *soap, char *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_string);
	if (soap_out_string(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_string(struct soap *soap, const char *tag, int id, char *const*a, const char *type)
{
	return soap_outstring(soap, tag, id, a, type, SOAP_TYPE_string);
}

SOAP_FMAC3 char ** SOAP_FMAC4 soap_get_string(struct soap *soap, char **p, const char *tag, const char *type)
{
	if ((p = soap_in_string(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 char * * SOAP_FMAC4 soap_in_string(struct soap *soap, const char *tag, char **a, const char *type)
{
	return soap_instring(soap, tag, a, type, SOAP_TYPE_string, 1, -1, -1);
}

#ifdef __cplusplus
}
#endif

/* End of ddsC.c */
