/*
 * Note: this file originally auto-generated by mib2c using
 *       version : 12088 $ of $ 
 *
 * $Id:$
 */
/*
 * standard Net-SNMP includes 
 */
#include <net-snmp/net-snmp-config.h>
#include <net-snmp/net-snmp-includes.h>
#include <net-snmp/agent/net-snmp-agent-includes.h>

/*
 * include our parent header 
 */
#include "dessertSysifTable.h"


/** @defgroup data_get data_get: Routines to get data
 *
 * TODO:230:M: Implement dessertSysifTable get routines.
 * TODO:240:M: Implement dessertSysifTable mapping routines (if any).
 *
 * These routine are used to get the value for individual objects. The
 * row context is passed, along with a pointer to the memory where the
 * value should be copied.
 *
 * @{
 */
/**********************************************************************
 **********************************************************************
 ***
 *** Table dessertSysifTable
 ***
 **********************************************************************
 **********************************************************************/
/*
 * DESSERT-MIB::dessertSysifTable is subid 7 of dessertObjects.
 * Its status is Current.
 * OID: .1.3.6.1.4.1.18898.0.19.10.1.1.7, length: 12
 */

/*
 * ---------------------------------------------------------------------
 * * TODO:200:r: Implement dessertSysifTable data context functions.
 */


/**
 * set mib index(es)
 *
 * @param tbl_idx mib index structure
 * @param sysifIndex_val
 *
 * @retval MFD_SUCCESS     : success.
 * @retval MFD_ERROR       : other error.
 *
 * @remark
 *  This convenience function is useful for setting all the MIB index
 *  components with a single function call. It is assume that the C values
 *  have already been mapped from their native/rawformat to the MIB format.
 */
int
dessertSysifTable_indexes_set_tbl_idx(dessertSysifTable_mib_index *
                                      tbl_idx, long sysifIndex_val)
{
    DEBUGMSGTL(("verbose:dessertSysifTable:dessertSysifTable_indexes_set_tbl_idx", "called\n"));

    /*
     * sysifIndex(1)///()//L/a/w/e/r/d/h 
     */
    tbl_idx->sysifIndex = sysifIndex_val;


    return MFD_SUCCESS;
}                               /* dessertSysifTable_indexes_set_tbl_idx */

/**
 * @internal
 * set row context indexes
 *
 * @param reqreq_ctx the row context that needs updated indexes
 *
 * @retval MFD_SUCCESS     : success.
 * @retval MFD_ERROR       : other error.
 *
 * @remark
 *  This function sets the mib indexs, then updates the oid indexs
 *  from the mib index.
 */
int
dessertSysifTable_indexes_set(dessertSysifTable_rowreq_ctx * rowreq_ctx,
                              long sysifIndex_val)
{
    DEBUGMSGTL(("verbose:dessertSysifTable:dessertSysifTable_indexes_set",
                "called\n"));

    if (MFD_SUCCESS !=
        dessertSysifTable_indexes_set_tbl_idx(&rowreq_ctx->tbl_idx,
                                              sysifIndex_val))
        return MFD_ERROR;

    /*
     * convert mib index to oid index
     */
    rowreq_ctx->oid_idx.len = sizeof(rowreq_ctx->oid_tmp) / sizeof(oid);
    if (0 != dessertSysifTable_index_to_oid(&rowreq_ctx->oid_idx,
                                            &rowreq_ctx->tbl_idx)) {
        return MFD_ERROR;
    }

    return MFD_SUCCESS;
}                               /* dessertSysifTable_indexes_set */


/*---------------------------------------------------------------------
 * DESSERT-MIB::dessertSysifEntry.sysifName
 * sysifName is subid 2 of dessertSysifEntry.
 * Its status is Current, and its access level is ReadOnly.
 * OID: .1.3.6.1.4.1.18898.0.19.10.1.1.7.1.2
 * Description:
name of interface
 *
 * Attributes:
 *   accessible 1     isscalar 0     enums  0      hasdefval 0
 *   readable   1     iscolumn 1     ranges 1      hashint   1
 *   settable   0
 *   hint: 255a
 *
 * Ranges:  0 - 255;
 *
 * Its syntax is DisplayString (based on perltype OCTETSTR)
 * The net-snmp type is ASN_OCTET_STR. The C type decl is char (char)
 * This data type requires a length.  (Max 255)
 */
/**
 * Extract the current value of the sysifName data.
 *
 * Set a value using the data context for the row.
 *
 * @param rowreq_ctx
 *        Pointer to the row request context.
 * @param sysifName_val_ptr_ptr
 *        Pointer to storage for a char variable
 * @param sysifName_val_ptr_len_ptr
 *        Pointer to a size_t. On entry, it will contain the size (in bytes)
 *        pointed to by sysifName.
 *        On exit, this value should contain the data size (in bytes).
 *
 * @retval MFD_SUCCESS         : success
 * @retval MFD_SKIP            : skip this node (no value for now)
 * @retval MFD_ERROR           : Any other error
*
 * @note If you need more than (*sysifName_val_ptr_len_ptr) bytes of memory,
 *       allocate it using malloc() and update sysifName_val_ptr_ptr.
 *       <b>DO NOT</b> free the previous pointer.
 *       The MFD helper will release the memory you allocate.
 *
 * @remark If you call this function yourself, you are responsible
 *         for checking if the pointer changed, and freeing any
 *         previously allocated memory. (Not necessary if you pass
 *         in a pointer to static memory, obviously.)
 */
int
sysifName_get(dessertSysifTable_rowreq_ctx * rowreq_ctx,
              char **sysifName_val_ptr_ptr,
              size_t *sysifName_val_ptr_len_ptr)
{
   /** we should have a non-NULL pointer and enough storage */
    netsnmp_assert((NULL != sysifName_val_ptr_ptr)
                   && (NULL != *sysifName_val_ptr_ptr));
    netsnmp_assert(NULL != sysifName_val_ptr_len_ptr);


    DEBUGMSGTL(("verbose:dessertSysifTable:sysifName_get", "called\n"));

    netsnmp_assert(NULL != rowreq_ctx);

    /*
     * TODO:231:o: |-> Extract the current value of the sysifName data.
     * copy (* sysifName_val_ptr_ptr ) data and (* sysifName_val_ptr_len_ptr ) from rowreq_ctx->data
     */
    /*
     * make sure there is enough space for sysifName data
     */
    if ((NULL == (*sysifName_val_ptr_ptr)) ||
        ((*sysifName_val_ptr_len_ptr) <
         (rowreq_ctx->data.sysifName_len *
          sizeof(rowreq_ctx->data.sysifName[0])))) {
        /*
         * allocate space for sysifName data
         */
        (*sysifName_val_ptr_ptr) =
            malloc(rowreq_ctx->data.sysifName_len *
                   sizeof(rowreq_ctx->data.sysifName[0]));
        if (NULL == (*sysifName_val_ptr_ptr)) {
            snmp_log(LOG_ERR, "could not allocate memory\n");
            return MFD_ERROR;
        }
    }
    (*sysifName_val_ptr_len_ptr) =
        rowreq_ctx->data.sysifName_len *
        sizeof(rowreq_ctx->data.sysifName[0]);
    memcpy((*sysifName_val_ptr_ptr), rowreq_ctx->data.sysifName,
           rowreq_ctx->data.sysifName_len *
           sizeof(rowreq_ctx->data.sysifName[0]));

    return MFD_SUCCESS;
}                               /* sysifName_get */

/*---------------------------------------------------------------------
 * DESSERT-MIB::dessertSysifEntry.sysifMacAddress
 * sysifMacAddress is subid 3 of dessertSysifEntry.
 * Its status is Current, and its access level is ReadOnly.
 * OID: .1.3.6.1.4.1.18898.0.19.10.1.1.7.1.3
 * Description:
hardware address of interface
 *
 * Attributes:
 *   accessible 1     isscalar 0     enums  0      hasdefval 0
 *   readable   1     iscolumn 1     ranges 1      hashint   1
 *   settable   0
 *   hint: 1x:
 *
 * Ranges:  6;
 *
 * Its syntax is MacAddress (based on perltype OCTETSTR)
 * The net-snmp type is ASN_OCTET_STR. The C type decl is char (char)
 * This data type requires a length.  (Max 6)
 */
/**
 * Extract the current value of the sysifMacAddress data.
 *
 * Set a value using the data context for the row.
 *
 * @param rowreq_ctx
 *        Pointer to the row request context.
 * @param sysifMacAddress_val_ptr_ptr
 *        Pointer to storage for a char variable
 * @param sysifMacAddress_val_ptr_len_ptr
 *        Pointer to a size_t. On entry, it will contain the size (in bytes)
 *        pointed to by sysifMacAddress.
 *        On exit, this value should contain the data size (in bytes).
 *
 * @retval MFD_SUCCESS         : success
 * @retval MFD_SKIP            : skip this node (no value for now)
 * @retval MFD_ERROR           : Any other error
*
 * @note If you need more than (*sysifMacAddress_val_ptr_len_ptr) bytes of memory,
 *       allocate it using malloc() and update sysifMacAddress_val_ptr_ptr.
 *       <b>DO NOT</b> free the previous pointer.
 *       The MFD helper will release the memory you allocate.
 *
 * @remark If you call this function yourself, you are responsible
 *         for checking if the pointer changed, and freeing any
 *         previously allocated memory. (Not necessary if you pass
 *         in a pointer to static memory, obviously.)
 */
int
sysifMacAddress_get(dessertSysifTable_rowreq_ctx * rowreq_ctx,
                    char **sysifMacAddress_val_ptr_ptr,
                    size_t *sysifMacAddress_val_ptr_len_ptr)
{
   /** we should have a non-NULL pointer and enough storage */
    netsnmp_assert((NULL != sysifMacAddress_val_ptr_ptr)
                   && (NULL != *sysifMacAddress_val_ptr_ptr));
    netsnmp_assert(NULL != sysifMacAddress_val_ptr_len_ptr);


    DEBUGMSGTL(("verbose:dessertSysifTable:sysifMacAddress_get",
                "called\n"));

    netsnmp_assert(NULL != rowreq_ctx);

    /*
     * TODO:231:o: |-> Extract the current value of the sysifMacAddress data.
     * copy (* sysifMacAddress_val_ptr_ptr ) data and (* sysifMacAddress_val_ptr_len_ptr ) from rowreq_ctx->data
     */
    /*
     * make sure there is enough space for sysifMacAddress data
     */
    if ((NULL == (*sysifMacAddress_val_ptr_ptr)) ||
        ((*sysifMacAddress_val_ptr_len_ptr) <
         (rowreq_ctx->data.sysifMacAddress_len *
          sizeof(rowreq_ctx->data.sysifMacAddress[0])))) {
        /*
         * allocate space for sysifMacAddress data
         */
        (*sysifMacAddress_val_ptr_ptr) =
            malloc(rowreq_ctx->data.sysifMacAddress_len *
                   sizeof(rowreq_ctx->data.sysifMacAddress[0]));
        if (NULL == (*sysifMacAddress_val_ptr_ptr)) {
            snmp_log(LOG_ERR, "could not allocate memory\n");
            return MFD_ERROR;
        }
    }
    (*sysifMacAddress_val_ptr_len_ptr) =
        rowreq_ctx->data.sysifMacAddress_len *
        sizeof(rowreq_ctx->data.sysifMacAddress[0]);
    memcpy((*sysifMacAddress_val_ptr_ptr),
           rowreq_ctx->data.sysifMacAddress,
           rowreq_ctx->data.sysifMacAddress_len *
           sizeof(rowreq_ctx->data.sysifMacAddress[0]));

    return MFD_SUCCESS;
}                               /* sysifMacAddress_get */

/*---------------------------------------------------------------------
 * DESSERT-MIB::dessertSysifEntry.sysifInPkts
 * sysifInPkts is subid 4 of dessertSysifEntry.
 * Its status is Current, and its access level is ReadOnly.
 * OID: .1.3.6.1.4.1.18898.0.19.10.1.1.7.1.4
 * Description:
packet counter in
 *
 * Attributes:
 *   accessible 1     isscalar 0     enums  0      hasdefval 0
 *   readable   1     iscolumn 1     ranges 0      hashint   0
 *   settable   0
 *
 *
 * Its syntax is COUNTER64 (based on perltype COUNTER64)
 * The net-snmp type is ASN_COUNTER64. The C type decl is U64 (U64)
 */
/**
 * Extract the current value of the sysifInPkts data.
 *
 * Set a value using the data context for the row.
 *
 * @param rowreq_ctx
 *        Pointer to the row request context.
 * @param sysifInPkts_val_ptr
 *        Pointer to storage for a U64 variable
 *
 * @retval MFD_SUCCESS         : success
 * @retval MFD_SKIP            : skip this node (no value for now)
 * @retval MFD_ERROR           : Any other error
 */
int
sysifInPkts_get(dessertSysifTable_rowreq_ctx * rowreq_ctx,
                U64 * sysifInPkts_val_ptr)
{
   /** we should have a non-NULL pointer */
    netsnmp_assert(NULL != sysifInPkts_val_ptr);

    /*
     * TODO:231:o: |-> copy sysifInPkts data.
     * get (* sysifInPkts_val_ptr ).low and (* sysifInPkts_val_ptr ).high from rowreq_ctx->data
     */
    (*sysifInPkts_val_ptr).high = rowreq_ctx->data.sysifInPkts.high;
    (*sysifInPkts_val_ptr).low = rowreq_ctx->data.sysifInPkts.low;


    return MFD_SUCCESS;
}                               /* sysifInPkts_get */

/*---------------------------------------------------------------------
 * DESSERT-MIB::dessertSysifEntry.sysifOutPkts
 * sysifOutPkts is subid 5 of dessertSysifEntry.
 * Its status is Current, and its access level is ReadOnly.
 * OID: .1.3.6.1.4.1.18898.0.19.10.1.1.7.1.5
 * Description:
packet counter out
 *
 * Attributes:
 *   accessible 1     isscalar 0     enums  0      hasdefval 0
 *   readable   1     iscolumn 1     ranges 0      hashint   0
 *   settable   0
 *
 *
 * Its syntax is COUNTER64 (based on perltype COUNTER64)
 * The net-snmp type is ASN_COUNTER64. The C type decl is U64 (U64)
 */
/**
 * Extract the current value of the sysifOutPkts data.
 *
 * Set a value using the data context for the row.
 *
 * @param rowreq_ctx
 *        Pointer to the row request context.
 * @param sysifOutPkts_val_ptr
 *        Pointer to storage for a U64 variable
 *
 * @retval MFD_SUCCESS         : success
 * @retval MFD_SKIP            : skip this node (no value for now)
 * @retval MFD_ERROR           : Any other error
 */
int
sysifOutPkts_get(dessertSysifTable_rowreq_ctx * rowreq_ctx,
                 U64 * sysifOutPkts_val_ptr)
{
   /** we should have a non-NULL pointer */
    netsnmp_assert(NULL != sysifOutPkts_val_ptr);

    /*
     * TODO:231:o: |-> copy sysifOutPkts data.
     * get (* sysifOutPkts_val_ptr ).low and (* sysifOutPkts_val_ptr ).high from rowreq_ctx->data
     */
    (*sysifOutPkts_val_ptr).high = rowreq_ctx->data.sysifOutPkts.high;
    (*sysifOutPkts_val_ptr).low = rowreq_ctx->data.sysifOutPkts.low;


    return MFD_SUCCESS;
}                               /* sysifOutPkts_get */

/*---------------------------------------------------------------------
 * DESSERT-MIB::dessertSysifEntry.sysifInOctets
 * sysifInOctets is subid 6 of dessertSysifEntry.
 * Its status is Current, and its access level is ReadOnly.
 * OID: .1.3.6.1.4.1.18898.0.19.10.1.1.7.1.6
 * Description:
octet counter in
 *
 * Attributes:
 *   accessible 1     isscalar 0     enums  0      hasdefval 0
 *   readable   1     iscolumn 1     ranges 0      hashint   0
 *   settable   0
 *
 *
 * Its syntax is COUNTER64 (based on perltype COUNTER64)
 * The net-snmp type is ASN_COUNTER64. The C type decl is U64 (U64)
 */
/**
 * Extract the current value of the sysifInOctets data.
 *
 * Set a value using the data context for the row.
 *
 * @param rowreq_ctx
 *        Pointer to the row request context.
 * @param sysifInOctets_val_ptr
 *        Pointer to storage for a U64 variable
 *
 * @retval MFD_SUCCESS         : success
 * @retval MFD_SKIP            : skip this node (no value for now)
 * @retval MFD_ERROR           : Any other error
 */
int
sysifInOctets_get(dessertSysifTable_rowreq_ctx * rowreq_ctx,
                  U64 * sysifInOctets_val_ptr)
{
   /** we should have a non-NULL pointer */
    netsnmp_assert(NULL != sysifInOctets_val_ptr);

    /*
     * TODO:231:o: |-> copy sysifInOctets data.
     * get (* sysifInOctets_val_ptr ).low and (* sysifInOctets_val_ptr ).high from rowreq_ctx->data
     */
    (*sysifInOctets_val_ptr).high = rowreq_ctx->data.sysifInOctets.high;
    (*sysifInOctets_val_ptr).low = rowreq_ctx->data.sysifInOctets.low;


    return MFD_SUCCESS;
}                               /* sysifInOctets_get */

/*---------------------------------------------------------------------
 * DESSERT-MIB::dessertSysifEntry.sysifOutOctets
 * sysifOutOctets is subid 7 of dessertSysifEntry.
 * Its status is Current, and its access level is ReadOnly.
 * OID: .1.3.6.1.4.1.18898.0.19.10.1.1.7.1.7
 * Description:
octet counter out
 *
 * Attributes:
 *   accessible 1     isscalar 0     enums  0      hasdefval 0
 *   readable   1     iscolumn 1     ranges 0      hashint   0
 *   settable   0
 *
 *
 * Its syntax is COUNTER64 (based on perltype COUNTER64)
 * The net-snmp type is ASN_COUNTER64. The C type decl is U64 (U64)
 */
/**
 * Extract the current value of the sysifOutOctets data.
 *
 * Set a value using the data context for the row.
 *
 * @param rowreq_ctx
 *        Pointer to the row request context.
 * @param sysifOutOctets_val_ptr
 *        Pointer to storage for a U64 variable
 *
 * @retval MFD_SUCCESS         : success
 * @retval MFD_SKIP            : skip this node (no value for now)
 * @retval MFD_ERROR           : Any other error
 */
int
sysifOutOctets_get(dessertSysifTable_rowreq_ctx * rowreq_ctx,
                   U64 * sysifOutOctets_val_ptr)
{
   /** we should have a non-NULL pointer */
    netsnmp_assert(NULL != sysifOutOctets_val_ptr);

    /*
     * TODO:231:o: |-> copy sysifOutOctets data.
     * get (* sysifOutOctets_val_ptr ).low and (* sysifOutOctets_val_ptr ).high from rowreq_ctx->data
     */
    (*sysifOutOctets_val_ptr).high = rowreq_ctx->data.sysifOutOctets.high;
    (*sysifOutOctets_val_ptr).low = rowreq_ctx->data.sysifOutOctets.low;


    return MFD_SUCCESS;
}                               /* sysifOutOctets_get */



/** @} */
