/*
 * Copyright 2012-2013 Canonical Ltd.
 *
 * This file is part of lomiri-dialer-app.
 *
 * lomiri-dialer-app is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; version 3.
 *
 * lomiri-dialer-app is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

import QtQuick 2.3
import QtQuick.Layouts 1.1
import Lomiri.Components 1.3
import Lomiri.Components.ListItems 1.3 as ListItems

Item {
    id: keypad

    readonly property int keysWidth: Math.min(units.gu(11), (keypad.width  / (keys.columns + 1)))
    readonly property int keysHeight: Math.min(units.gu(8), (keypad.height / (keys.rows + 1)))
    property double labelPixelSize: keypad.height > units.dp(160) ? units.dp(30) : units.dp(20)
    property bool showVoicemail: false
    property alias spacing: keys.columnSpacing

    signal keyPressed(int keycode, string keychar, string keyText)
    signal keyPressAndHold(int keycode, string keychar)

    function keyTextfromKeyCode(keyCode) {
        for (var i = 0; i < keys.children.length; i++)
        {
            var item = keys.children[i]
            if (item.keycode === keyCode) {
                return item.sublabel
            }
        }
        return ""
    }

    GridLayout {
        id: keys

        rows: 4
        columns: 3
        anchors.fill: parent

        KeypadButton {
            objectName: "buttonOne"
            shapeWidth: keysWidth
            shapeHeight: keysHeight
            label: i18n.tr("1")
            keycode: Qt.Key_1
            onPressed: keypad.keyPressed(keycode, "1", "1")
            onPressAndHold: keypad.keyPressAndHold(keycode, "1")
            iconSource: showVoicemail ? "voicemail" : ""
            labelFont.pixelSize: keypad.labelPixelSize

            // Layout
            Layout.fillHeight: true
            Layout.fillWidth: true
        }

        KeypadButton {
            objectName: "buttonTwo"
            shapeWidth: keysWidth
           shapeHeight: keysHeight
            label: i18n.tr("2")
            sublabel: i18n.tr("ABC")
            keycode: Qt.Key_2
            onPressed: keypad.keyPressed(keycode, "2", sublabel)
            onPressAndHold: keypad.keyPressAndHold(keycode, "2")
            labelFont.pixelSize: keypad.labelPixelSize

            // Layout
            Layout.fillHeight: true
            Layout.fillWidth: true
        }

        KeypadButton {
            objectName: "buttonThree"
            shapeWidth: keysWidth
            shapeHeight: keysHeight
            label: i18n.tr("3")
            sublabel: i18n.tr("DEF")
            keycode: Qt.Key_3
            onPressed: keypad.keyPressed(keycode, "3", sublabel)
            onPressAndHold: keypad.keyPressAndHold(keycode, "3")
            labelFont.pixelSize: keypad.labelPixelSize

            // Layout
            Layout.fillHeight: true
            Layout.fillWidth: true
        }

        KeypadButton {
            objectName: "buttonFour"
            shapeWidth: keysWidth
            shapeHeight: keysHeight
            label: i18n.tr("4")
            sublabel: i18n.tr("GHI")
            keycode: Qt.Key_4
            onPressed: keypad.keyPressed(keycode, "4", sublabel)
            onPressAndHold: keypad.keyPressAndHold(keycode, "4")
            labelFont.pixelSize: keypad.labelPixelSize

            // Layout
            Layout.fillHeight: true
            Layout.fillWidth: true
        }

        KeypadButton {
            objectName: "buttonFive"
            shapeWidth: keysWidth
            shapeHeight: keysHeight
            label: i18n.tr("5")
            sublabel: i18n.tr("JKL")
            keycode: Qt.Key_5
            onPressed: keypad.keyPressed(keycode, "5", sublabel)
            onPressAndHold: keypad.keyPressAndHold(keycode, "5")
            labelFont.pixelSize: keypad.labelPixelSize

            // Layout
            Layout.fillHeight: true
            Layout.fillWidth: true
        }

        KeypadButton {
            objectName: "buttonSix"
            shapeWidth: keysWidth
            shapeHeight: keysHeight
            label: i18n.tr("6")
            sublabel: i18n.tr("MNO")
            keycode: Qt.Key_6
            onPressed: keypad.keyPressed(keycode, "6", sublabel)
            onPressAndHold: keypad.keyPressAndHold(keycode, "6")
            labelFont.pixelSize: keypad.labelPixelSize

            // Layout
            Layout.fillHeight: true
            Layout.fillWidth: true
        }

        KeypadButton {
            objectName: "buttonSeven"
            shapeWidth: keysWidth
            shapeHeight: keysHeight
            label: i18n.tr("7")
            sublabel: i18n.tr("PQRS")
            keycode: Qt.Key_7
            onPressed: keypad.keyPressed(keycode, "7", sublabel)
            onPressAndHold: keypad.keyPressAndHold(keycode, "7")
            labelFont.pixelSize: keypad.labelPixelSize

            // Layout
            Layout.fillHeight: true
            Layout.fillWidth: true
        }

        KeypadButton {
            objectName: "buttonEight"
            shapeWidth: keysWidth
            shapeHeight: keysHeight
            label: i18n.tr("8")
            sublabel: i18n.tr("TUV")
            keycode: Qt.Key_8
            onPressed: keypad.keyPressed(keycode, "8", sublabel)
            onPressAndHold: keypad.keyPressAndHold(keycode, "8")
            labelFont.pixelSize: keypad.labelPixelSize

            // Layout
            Layout.fillHeight: true
            Layout.fillWidth: true
        }

        KeypadButton {
            objectName: "buttonNine"
            shapeWidth: keysWidth
            shapeHeight: keysHeight
            label: i18n.tr("9")
            sublabel: i18n.tr("WXYZ")
            keycode: Qt.Key_9
            onPressed: keypad.keyPressed(keycode, "9", sublabel)
            onPressAndHold: keypad.keyPressAndHold(keycode, "9")
            labelFont.pixelSize: keypad.labelPixelSize

            // Layout
            Layout.fillHeight: true
            Layout.fillWidth: true
        }

        KeypadButton {
            objectName: "buttonAsterisk"
            shapeWidth: keysWidth
            shapeHeight: keysHeight
            isCorner: true
            corner: Qt.BottomLeftCorner
            label: i18n.tr("*")
            keycode: Qt.Key_Asterisk
            onPressed: keypad.keyPressed(keycode, "*","*")
            onPressAndHold: keypad.keyPressAndHold(keycode, "*")
            labelFont.pixelSize: keypad.labelPixelSize

            // Layout
            Layout.fillHeight: true
            Layout.fillWidth: true
        }

        KeypadButton {
            objectName: "buttonZero"
            shapeWidth: keysWidth
            shapeHeight: keysHeight
            label: i18n.tr("0")
            sublabel: i18n.tr("+")
            sublabelSize: "medium"
            keycode: Qt.Key_0
            onPressed: keypad.keyPressed(keycode, "0", "0")
            onPressAndHold: keypad.keyPressAndHold(keycode, "0")
            labelFont.pixelSize: keypad.labelPixelSize

            // Layout
            Layout.fillHeight: true
            Layout.fillWidth: true
        }

        KeypadButton {
            objectName: "buttonHash"
            shapeWidth: keysWidth
            shapeHeight: keysHeight
            isCorner: true
            corner: Qt.BottomRightCorner
            label: i18n.tr("#")
            keycode: Qt.Key_ssharp
            onPressed: keypad.keyPressed(keycode, "#", "#")
            onPressAndHold: keypad.keyPressAndHold(keycode, "#")
            labelFont.pixelSize: keypad.labelPixelSize

            // Layout
            Layout.fillHeight: true
            Layout.fillWidth: true
        }
    }
}
