package tests::UIPolyListWidgetTest;

use strict;

use base qw/ Lire::Test::TestCase /;

use Lire::Config::TypeSpec;
use Lire::Test::CursesUIDriver;
use Lire::UI::PolyListWidget;
use Curses::UI;

sub set_up {
    my $self = $_[0];
    $self->SUPER::set_up();

    $self->{'driver'} = new Lire::Test::CursesUIDriver();
    $self->{'driver'}->setup_curses_ui();

    $self->{'ui'} = new Curses::UI();
    $self->{'driver'}->set_curses_ui( $self->{'ui'} );
    $self->{'window'} = $self->{'ui'}->add( 'window', 'Window' );

    my $spec = new Lire::Config::ListSpec( 'name' => 'poly' );
    $spec->add( new Lire::Config::StringSpec( 'name' => 'string',
                                              'summary' => 'String' ) );
    $spec->add( new Lire::Config::BooleanSpec( 'name' => 'boolean',
                                               'summary' => 'Bool' ) );
    $self->{'poly_value'} = $spec->instance();

    return;
}

sub tear_down {
    my $self = $_[0];
    $self->SUPER::tear_down();

    $self->{'driver'}->teardown_curses_ui();

    return;
}

sub test_new {
    my $self = $_[0];

    my $value = $self->{'poly_value'};
    my $widget = $self->{'window'}->add( 'list_widget', 'Lire::UI::ListWidget',
                                         'value' => $value );
    $self->assert_isa( 'Lire::UI::PolyListWidget', $widget );

    my $popup = $widget->getobj( 'type_widget' );
    $self->assert_isa( 'Curses::UI::Popupmenu', $popup );

    $self->assert_deep_equals( [ $value->spec()->get( 'boolean' ),
                                 $value->spec()->get( 'string' ) ],
                               $popup->{'-values'} );

    $self->assert_deep_equals( { $value->spec()->get( 'boolean' ) => 'Bool',
                                 $value->spec()->get( 'string' ) => 'String' },
                               $popup->{'-labels'} );
}

sub test_new_value {
    my $self = $_[0];

    my $widget = $self->{'window'}->add( 'list_widget', 'Lire::UI::ListWidget',
                                         'value' => $self->{'poly_value'} );
    my $popup = $widget->getobj( 'type_widget' );

    $self->assert_null( $widget->new_value(), 'new_value() != undef' );

    $popup->{'-selected'} = 0;
    my $value = $widget->new_value();
    $self->assert_isa( 'Lire::Config::Scalar', $value );
    $self->assert_str_equals( $self->{'poly_value'}->spec()->get( 'boolean' ),
                              $value->spec() );

    $popup->{'-selected'} = 1;
    $value = $widget->new_value();
    $self->assert_str_equals( $self->{'poly_value'}->spec()->get( 'string' ),
                              $value->spec() );
}

1;
