/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.stripes.util;

import java.lang.reflect.Array;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CollectionUtil {
    public static boolean contains(Object[] arr, Object item) {
        if (arr == null) {
            return false;
        }
        for (int i = 0; i < arr.length; ++i) {
            if (item == null && arr[i] == null) {
                return true;
            }
            if (item == null || !item.equals(arr[i])) continue;
            return true;
        }
        return false;
    }

    public static boolean empty(String[] arr) {
        if (arr == null || arr.length == 0) {
            return true;
        }
        for (String s : arr) {
            if (s == null || "".equals(s)) continue;
            return false;
        }
        return true;
    }

    public static boolean applies(String[] events, String event) {
        boolean isPositive;
        if (events == null || events.length == 0) {
            return true;
        }
        boolean bl = isPositive = events[0].charAt(0) != '!';
        if (isPositive) {
            return CollectionUtil.contains(events, event);
        }
        return !CollectionUtil.contains(events, "!" + event);
    }

    public static Object[] asObjectArray(Object in) {
        if (in == null || !in.getClass().isArray()) {
            throw new IllegalArgumentException("Parameter to asObjectArray must be a non-null array.");
        }
        if (in instanceof Object[]) {
            return (Object[])in;
        }
        int length = Array.getLength(in);
        Object[] out = new Object[length];
        for (int i = 0; i < length; ++i) {
            out[i] = Array.get(in, i);
        }
        return out;
    }

    public static List<Object> asList(Object in) {
        if (in == null || !in.getClass().isArray()) {
            throw new IllegalArgumentException("Parameter to asObjectArray must be a non-null array.");
        }
        int length = Array.getLength(in);
        LinkedList<Object> list = new LinkedList<Object>();
        for (int i = 0; i < length; ++i) {
            list.add(i, Array.get(in, i));
        }
        return list;
    }

    public static <T> List<T> asList(Iterable<T> in) {
        if (in instanceof List) {
            return (List)in;
        }
        LinkedList<T> list = new LinkedList<T>();
        for (T item : in) {
            list.add(item);
        }
        return list;
    }
}

