/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.stripes.mock;

import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MockHttpSession
implements HttpSession {
    private long creationTime = System.currentTimeMillis();
    private String sessionId = String.valueOf(new Random().nextLong());
    private ServletContext context;
    private Map<String, Object> attributes = new HashMap<String, Object>();

    public MockHttpSession(ServletContext context) {
        this.context = context;
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public String getId() {
        return this.sessionId;
    }

    public long getLastAccessedTime() {
        return System.currentTimeMillis();
    }

    public ServletContext getServletContext() {
        return this.context;
    }

    public void setServletContext(ServletContext context) {
        this.context = context;
    }

    public void setMaxInactiveInterval(int i) {
    }

    public int getMaxInactiveInterval() {
        return Integer.MAX_VALUE;
    }

    public HttpSessionContext getSessionContext() {
        return null;
    }

    public Object getAttribute(String key) {
        return this.attributes.get(key);
    }

    public Object getValue(String key) {
        return this.getAttribute(key);
    }

    public Enumeration<String> getAttributeNames() {
        return Collections.enumeration(this.attributes.keySet());
    }

    public String[] getValueNames() {
        return this.attributes.keySet().toArray(new String[this.attributes.size()]);
    }

    public void setAttribute(String key, Object value) {
        this.attributes.put(key, value);
    }

    public void putValue(String key, Object value) {
        this.setAttribute(key, value);
    }

    public void removeAttribute(String key) {
        this.attributes.remove(key);
    }

    public void removeValue(String key) {
        this.removeAttribute(key);
    }

    public void invalidate() {
        this.attributes.clear();
    }

    public boolean isNew() {
        return false;
    }
}

