///////
   //    AccessibilityCheck.cc
   //    AccessibilityCheck Class definitions
   //
   //    Class for Html statements
   //
   //    Copyright (c) 1999-2004 Comune di Prato - Prato - Italy
   //    Author: Gabriele Bartolini - Prato - Italy <angusgb@users.sourceforge.net>
   //
   //    For copyright details, see the file COPYING in your distribution
   //    or the GNU General Public License version 2 or later 
   //    <http://www.gnu.org/copyleft/gpl.html>
   //
   //    $Id: AccessibilityCheck.cc,v 1.1 2004-03-30 11:07:35 angusgb Exp $
   //
   //    G.Bartolini
   //    started: 29.03.2004
///////

#ifdef HAVE_CONFIG_H
#include "htconfig.h"
#endif /* HAVE_CONFIG_H */

#include "AccessibilityCheck.h"

   // Static variables initialization
      int AccessibilityCheck::debug = 0;
      unsigned int AccessibilityCheck::last_id = 0;

///////
   //    Construction
///////

AccessibilityCheck::AccessibilityCheck()
	: IDCheck(0), IDUrl(0), TagPosition(0), AttrPosition(0), Code(0)
{
}

///////
   //    Destruction
///////

AccessibilityCheck::~AccessibilityCheck ()
{
}

///////
   //    Reset the schedule content
///////

void AccessibilityCheck::Reset()
{
   IDCheck = 0;
   IDUrl = 0;
   TagPosition = 0;
   AttrPosition = 0;
   Code = 0;
}


///////
   //    Output AccessibilityCheck object
///////

ostream& operator<<(ostream& output, const AccessibilityCheck& s)

{
   output << s.IDCheck << " / " << s.IDUrl << " / " << s.TagPosition
      << " / " << s.AttrPosition;
   
   if (s.debug < 3) return output;
   
   // Only if debug level is greater than 2
   
   output << " (Code : " << s.Code << ")";
   
   return output;
}
