#include "rename.h"
#include "iconload.h"
#include "inputdir.h"
#include "filesdata.h"
#include "dirsdata.h"
#include "timestamp.h"
#include <kapplication.h>
#include <kaboutdata.h>
#include <kcmdlineargs.h>
#include <KDE/KLocale>



filesData f;
dirsData g;
bool InitiatedRename=FALSE;
bool noProfiles;

static const char description[] =
    I18N_NOOP("A batch renaming tool for KDE");

static const char version[] = "1.1-beta7";

int main(int argc, char **argv){
	bool noProfiles=false;
	QString askDir;
	int askResult=2;
	iconload dialogsIcons;
	inpDir * inp=0;
	KAboutData about("gwenrename", 0, ki18n("GwenRename"), version, ki18n(description),
										KAboutData::License_GPL, ki18n("(C) 2003 - 2009 Spiros Georgaras"), KLocalizedString(), 0, "sng@hellug.gr");
	about.addAuthor( ki18n("Spiros Georgaras"), KLocalizedString(), "sng@hellug.gr" );
	KCmdLineArgs::init(argc, argv, &about);

	KCmdLineOptions options;
	options.add("disableProfiles", ki18n( "Disable profiles" ));
	options.add("+file(s)", ki18n( "File(s) to be renamed, or" ));
	options.add("+folders", ki18n( "Folders to be renamed, or" ));
	options.add("+folder", ki18n( "Location of files to rename" ));
	KCmdLineArgs::addCmdLineOptions(options);
	KApplication app;

	//gwenrename *widget = new gwenrename;




		
	// Load icons for dialogs
	QStringList picture("48x48/apps/gwenrename.png");
	dialogsIcons.loadIcon(picture,0);
	picture=QStringList("16x16/places/folder.png");
	picture+="gwenrename/icons/hicolor/16x16/actions/folder.png";
	dialogsIcons.loadIcon(picture,1);
	picture=QStringList("16x16/actions/locationbar_erase.png");
	picture+="gwenrename/icons/hicolor/16x16/actions/locationbar_erase.png";
	dialogsIcons.loadIcon(picture,2);
	picture=QStringList("16x16/actions/dialog-ok.png");
	picture+="16x16/actions/dialog-ok-apply.png";
	picture+="16x16/actions/ok.png";
	picture+="16x16/actions/apply.png";
	picture+="gwenrename/icons/hicolor/16x16/actions/button_ok.png";
	dialogsIcons.loadIcon(picture,3);
	picture=QStringList("16x16/actions/dialog-cancel.png");
	picture+="16x16/actions/no.png";
	picture+="16x16/actions/remove.png";
	picture+="gwenrename/icons/hicolor/16x16/actions/button_cancel.png";
	dialogsIcons.loadIcon(picture,4);
	picture=QStringList("16x16/actions/filefind.png");
	picture+="gwenrename/icons/hicolor/16x16/actions/filefind.png";
	dialogsIcons.loadIcon(picture,5);
	// khelpcenter is for all help buttons
	picture=QStringList("16x16/apps/khelpcenter.png");
	picture+="16x16/actions/help.png";
	picture+="gwenrename/icons/hicolor/16x16/actions/khelpcenter.png";
	dialogsIcons.loadIcon(picture,6);
	if(argc<2){
		inp=new inpDir(0, &dialogsIcons);
// 		inp->pix->setPixmap(dialogsIcons.Icon(0)); old impl
// 		inp->btOpen->setPixmap(dialogsIcons.Icon(1)); old impl
// 		inp->eraseLocBar->setPixmap(dialogsIcons.Icon(2)); old impl
// 		inp->buttonOk->setIconSet(QIconSet(dialogsIcons.Icon(3))); old impl
// 		inp->buttonCancel->setIconSet(QIconSet(dialogsIcons.Icon(4))); old impl
// 		inp->buttonHelp->setIconSet(QIconSet(dialogsIcons.Icon(6))); old impl
		if(inp->exec()){
// 			askDir=inp->dir->currentText(); old impl
			askDir=inp->selectedFolder();
			askResult=1;
			delete inp;
		}else{
			delete inp;
			return 0;
		}
	}
		
	KCmdLineArgs *args = KCmdLineArgs::parsedArgs();
	if(askResult==2){ // This means we haven't showed the dir selection dialog
		if(args->isSet("disableProfiles"))
			noProfiles=TRUE;
		if(args->count()==0){
			inp=new inpDir(0, &dialogsIcons);
// 			inp->pix->setPixmap(dialogsIcons.Icon(0)); old impl
// 			inp->btOpen->setPixmap(dialogsIcons.Icon(1)); old impl
// 			inp->eraseLocBar->setPixmap(dialogsIcons.Icon(2)); old impl
// 			inp->buttonOk->setIconSet(QIconSet(dialogsIcons.Icon(3))); old impl
// 			inp->buttonCancel->setIconSet(QIconSet(dialogsIcons.Icon(4))); old impl
// 			inp->buttonHelp->setIconSet(QIconSet(dialogsIcons.Icon(6))); old impl
			if(inp->exec()){
// 				askDir=inp->dir->currentText(); old impl
				askDir=inp->selectedFolder();
				askResult=1;
				delete inp;
			}else{
				delete inp;
				return 0;
			}
		}
		
		if(askResult==2){ // This means we haven't showed the dir selection dialog
			if(f.setItems(args->count())==-1){
				KMessageBox::error(0,i18n("Memory allocation error\n\nThe program could not allocate memory needed for its execution. Close some applications and try again"),0);
				return 0;
			}
			if(args->count()==1){
				QString tmp=args->url(0).path();
//				qWarning("tmp = %s", tmp.toLocal8Bit().constData());
				if(tmp.endsWith("/"))
					tmp=tmp.left(tmp.length()-1);
				QFileInfo fInfo(tmp);
				if(fInfo.isDir()){
					
				if(!fInfo.isWritable()){
					QString m;
					m=QString(i18n("Directory '%1' can not be renamed\nYou don't have write permission to this directory")).arg( tmp );
					KMessageBox::error(0,m,QString::null,KMessageBox::AllowLink);
					args->clear();
					return 0;
				}
					
					initaskMode *askMode=new initaskMode(0, &dialogsIcons,tmp);
// 					askMode->Message->setText(QString(i18n("<p>The folder <b>%1</b> is the only parameter passed to <b>GwenRename</b>.<br><br>Do you want to rename this folder, or the files contained in it?</p>")).arg(tmp)); old impl
// 					askMode->pix->setPixmap(dialogsIcons.Icon(0)); old impl
// 					askMode->renameDir->setIconSet(QIconSet(dialogsIcons.Icon(1))); old impl
// 					askMode->renameFiles->setIconSet(QIconSet(dialogsIcons.Icon(5))); old impl
// 					askMode->buttonCancel->setIconSet(QIconSet(dialogsIcons.Icon(4))); old impl
					if(askMode->exec()){
						askResult=askMode->Result();
						askDir=tmp;
					}else{
						delete askMode;
						args->clear();
						return 0;
					}
					delete askMode;
				}
			}
		}
	}
	
	

	
	
	
	if(askResult==2){ // Files of folders passed normally
		for(int i=0;i<args->count();i++){
			if(args->url(i).path().endsWith("/")){
				QString tmp=args->url(i).path();
				f.files[i].setFile(tmp.left(tmp.length()-1));
			}else
				f.files[i].setFile(args->url(i).path());
		}
		if(!f.canRename()){
			for(int y=0;y<f.numOfFiles;y++){
				if(!f.files[y].exists()){
					QString m;
					m=QString(i18n("File '%1' does not exist\nPlease check your selection and try again")).arg( f.files[y].filePath() );
					KMessageBox::error(0,m,QString::null,KMessageBox::AllowLink);
					args->clear();
					return 0;
				}
				if(!f.files[y].isWritable()){
					QString m;
					m=QString(i18n("File '%1' can not be renamed\nYou don't have write permission to this file")).arg( f.files[y].filePath() );
					KMessageBox::error(0,m,QString::null,KMessageBox::AllowLink);
					args->clear();
					return 0;
				}
			}
		}
		f.getType();
		if(f.Type==0){
				KMessageBox::error(0,i18n("Invalid file type selected\nYou can rename normal files or directories"),0);
				args->clear();
				return 0;
		}else if(f.Type==-1){
				KMessageBox::error(0,i18n("Invalid selection\nYou can not mix files and directories in the same renaming function"),0);
				args->clear();
				return 0;
		}
		if(!f.samePath()){
			KMessageBox::error(0,i18n("Invalid selection\nThe files must be in the same directory"),0);
			args->clear();
			return 0;
		}
		if(f.Type==2){
				for(int i=0;i<f.items();i++){
// 					if((f.files[i].filePath()==f.files[i].dirPath()+"/.") || (f.files[i].filePath()==f.files[i].dirPath()+"/..")){ old impl
					if((f.files[i].filePath()==f.files[i].absolutePath()+"/.") || (f.files[i].filePath()==f.files[i].absolutePath()+"/..")){
					KMessageBox::error(0,i18n("Invalid selection\nYou can't rename the current or parent directory"),0);
					args->clear();
					return 0;
					}
				}
		}
	}
	
	// FIX ME!!!
	// if a folder is selected/givven we must check if we have write permission on it
	// even if the user selectes to rename the files contained in it
	
	
	
	
	args->clear();
	QString spec="*";
// 	int iSpec; old impl
	QDir::Filters iSpec;
	if(f.Type==1){
			iSpec=QDir::Files | QDir::NoSymLinks;
	}else if(f.Type==2){
			iSpec=QDir::Dirs | QDir::NoSymLinks;
	}else{
			iSpec=QDir::Readable | QDir::Writable | QDir::NoSymLinks;
	}
	iSpec=QDir::Dirs | QDir::Files;
	if(askResult==2){
// 		g.setPath(f.files[0].dirPath(),spec,iSpec); old impl
		g.setPath(f.files[0].absolutePath(),spec,iSpec);
		if(g.setLink(&f)==-1){
				KMessageBox::error(0,i18n("Memory allocation error\n\nThe program could not allocate memory needed for its execution. Close some applications and try again"),0);
				return 0;
		}
	}else{
		g.setPath(askDir,spec,iSpec);
		if(g.numOfFiles<=0){
			KMessageBox::error(0,QString(i18n("<p>Folder <b>%1</b> is empty!!!</p>").arg(askDir)),0);
			return 0;
		}
		if(f.reSetItems(g.numOfFiles)==-1){
			KMessageBox::error(0,i18n("Memory allocation error\n\nThe program could not allocate memory needed for its execution. Close some applications and try again"),0);
			return 0;
		}
		if(g.setFilesInDir(false)==-1){
				KMessageBox::error(0,i18n("Memory allocation error\n\nThe program could not allocate memory needed for its execution. Close some applications and try again"),0);
				return 0;
		}
	}
	GwenRename *dialog = new GwenRename(0,&about);
	dialog->show();
	return app.exec();
}
