// Code generated by smithy-go-codegen DO NOT EDIT.

package lakeformation

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/lakeformation/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Retrieve the current list of resources and principals that are opt in to
// enforce Lake Formation permissions.
func (c *Client) ListLakeFormationOptIns(ctx context.Context, params *ListLakeFormationOptInsInput, optFns ...func(*Options)) (*ListLakeFormationOptInsOutput, error) {
	if params == nil {
		params = &ListLakeFormationOptInsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListLakeFormationOptIns", params, optFns, c.addOperationListLakeFormationOptInsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListLakeFormationOptInsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListLakeFormationOptInsInput struct {

	// The maximum number of results to return.
	MaxResults *int32

	// A continuation token, if this is not the first call to retrieve this list.
	NextToken *string

	// The Lake Formation principal. Supported principals are IAM users or IAM roles.
	Principal *types.DataLakePrincipal

	// A structure for the resource.
	Resource *types.Resource

	noSmithyDocumentSerde
}

type ListLakeFormationOptInsOutput struct {

	// A list of principal-resource pairs that have Lake Formation permissins enforced.
	LakeFormationOptInsInfoList []types.LakeFormationOptInsInfo

	// A continuation token, if this is not the first call to retrieve this list.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListLakeFormationOptInsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpListLakeFormationOptIns{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpListLakeFormationOptIns{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListLakeFormationOptIns"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addOpListLakeFormationOptInsValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListLakeFormationOptIns(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	return nil
}

// ListLakeFormationOptInsPaginatorOptions is the paginator options for
// ListLakeFormationOptIns
type ListLakeFormationOptInsPaginatorOptions struct {
	// The maximum number of results to return.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListLakeFormationOptInsPaginator is a paginator for ListLakeFormationOptIns
type ListLakeFormationOptInsPaginator struct {
	options   ListLakeFormationOptInsPaginatorOptions
	client    ListLakeFormationOptInsAPIClient
	params    *ListLakeFormationOptInsInput
	nextToken *string
	firstPage bool
}

// NewListLakeFormationOptInsPaginator returns a new
// ListLakeFormationOptInsPaginator
func NewListLakeFormationOptInsPaginator(client ListLakeFormationOptInsAPIClient, params *ListLakeFormationOptInsInput, optFns ...func(*ListLakeFormationOptInsPaginatorOptions)) *ListLakeFormationOptInsPaginator {
	if params == nil {
		params = &ListLakeFormationOptInsInput{}
	}

	options := ListLakeFormationOptInsPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListLakeFormationOptInsPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListLakeFormationOptInsPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListLakeFormationOptIns page.
func (p *ListLakeFormationOptInsPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListLakeFormationOptInsOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListLakeFormationOptIns(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListLakeFormationOptInsAPIClient is a client that implements the
// ListLakeFormationOptIns operation.
type ListLakeFormationOptInsAPIClient interface {
	ListLakeFormationOptIns(context.Context, *ListLakeFormationOptInsInput, ...func(*Options)) (*ListLakeFormationOptInsOutput, error)
}

var _ ListLakeFormationOptInsAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListLakeFormationOptIns(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListLakeFormationOptIns",
	}
}
