// Code generated by smithy-go-codegen DO NOT EDIT.

package glacier

import (
	"context"
	"fmt"
	"github.com/aws/aws-sdk-go-v2/service/glacier/types"
	smithy "github.com/aws/smithy-go"
	"github.com/aws/smithy-go/middleware"
)

type validateOpAbortMultipartUpload struct {
}

func (*validateOpAbortMultipartUpload) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpAbortMultipartUpload) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*AbortMultipartUploadInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpAbortMultipartUploadInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpAbortVaultLock struct {
}

func (*validateOpAbortVaultLock) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpAbortVaultLock) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*AbortVaultLockInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpAbortVaultLockInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpAddTagsToVault struct {
}

func (*validateOpAddTagsToVault) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpAddTagsToVault) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*AddTagsToVaultInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpAddTagsToVaultInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpCompleteMultipartUpload struct {
}

func (*validateOpCompleteMultipartUpload) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpCompleteMultipartUpload) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*CompleteMultipartUploadInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpCompleteMultipartUploadInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpCompleteVaultLock struct {
}

func (*validateOpCompleteVaultLock) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpCompleteVaultLock) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*CompleteVaultLockInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpCompleteVaultLockInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpCreateVault struct {
}

func (*validateOpCreateVault) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpCreateVault) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*CreateVaultInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpCreateVaultInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDeleteArchive struct {
}

func (*validateOpDeleteArchive) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDeleteArchive) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DeleteArchiveInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDeleteArchiveInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDeleteVaultAccessPolicy struct {
}

func (*validateOpDeleteVaultAccessPolicy) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDeleteVaultAccessPolicy) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DeleteVaultAccessPolicyInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDeleteVaultAccessPolicyInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDeleteVault struct {
}

func (*validateOpDeleteVault) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDeleteVault) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DeleteVaultInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDeleteVaultInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDeleteVaultNotifications struct {
}

func (*validateOpDeleteVaultNotifications) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDeleteVaultNotifications) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DeleteVaultNotificationsInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDeleteVaultNotificationsInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDescribeJob struct {
}

func (*validateOpDescribeJob) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDescribeJob) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DescribeJobInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDescribeJobInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDescribeVault struct {
}

func (*validateOpDescribeVault) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDescribeVault) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DescribeVaultInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDescribeVaultInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpGetDataRetrievalPolicy struct {
}

func (*validateOpGetDataRetrievalPolicy) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpGetDataRetrievalPolicy) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*GetDataRetrievalPolicyInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpGetDataRetrievalPolicyInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpGetJobOutput struct {
}

func (*validateOpGetJobOutput) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpGetJobOutput) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*GetJobOutputInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpGetJobOutputInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpGetVaultAccessPolicy struct {
}

func (*validateOpGetVaultAccessPolicy) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpGetVaultAccessPolicy) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*GetVaultAccessPolicyInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpGetVaultAccessPolicyInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpGetVaultLock struct {
}

func (*validateOpGetVaultLock) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpGetVaultLock) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*GetVaultLockInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpGetVaultLockInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpGetVaultNotifications struct {
}

func (*validateOpGetVaultNotifications) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpGetVaultNotifications) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*GetVaultNotificationsInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpGetVaultNotificationsInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpInitiateJob struct {
}

func (*validateOpInitiateJob) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpInitiateJob) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*InitiateJobInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpInitiateJobInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpInitiateMultipartUpload struct {
}

func (*validateOpInitiateMultipartUpload) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpInitiateMultipartUpload) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*InitiateMultipartUploadInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpInitiateMultipartUploadInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpInitiateVaultLock struct {
}

func (*validateOpInitiateVaultLock) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpInitiateVaultLock) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*InitiateVaultLockInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpInitiateVaultLockInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpListJobs struct {
}

func (*validateOpListJobs) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpListJobs) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*ListJobsInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpListJobsInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpListMultipartUploads struct {
}

func (*validateOpListMultipartUploads) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpListMultipartUploads) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*ListMultipartUploadsInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpListMultipartUploadsInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpListParts struct {
}

func (*validateOpListParts) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpListParts) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*ListPartsInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpListPartsInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpListProvisionedCapacity struct {
}

func (*validateOpListProvisionedCapacity) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpListProvisionedCapacity) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*ListProvisionedCapacityInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpListProvisionedCapacityInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpListTagsForVault struct {
}

func (*validateOpListTagsForVault) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpListTagsForVault) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*ListTagsForVaultInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpListTagsForVaultInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpListVaults struct {
}

func (*validateOpListVaults) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpListVaults) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*ListVaultsInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpListVaultsInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpPurchaseProvisionedCapacity struct {
}

func (*validateOpPurchaseProvisionedCapacity) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpPurchaseProvisionedCapacity) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*PurchaseProvisionedCapacityInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpPurchaseProvisionedCapacityInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpRemoveTagsFromVault struct {
}

func (*validateOpRemoveTagsFromVault) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpRemoveTagsFromVault) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*RemoveTagsFromVaultInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpRemoveTagsFromVaultInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpSetDataRetrievalPolicy struct {
}

func (*validateOpSetDataRetrievalPolicy) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpSetDataRetrievalPolicy) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*SetDataRetrievalPolicyInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpSetDataRetrievalPolicyInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpSetVaultAccessPolicy struct {
}

func (*validateOpSetVaultAccessPolicy) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpSetVaultAccessPolicy) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*SetVaultAccessPolicyInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpSetVaultAccessPolicyInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpSetVaultNotifications struct {
}

func (*validateOpSetVaultNotifications) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpSetVaultNotifications) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*SetVaultNotificationsInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpSetVaultNotificationsInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpUploadArchive struct {
}

func (*validateOpUploadArchive) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpUploadArchive) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*UploadArchiveInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpUploadArchiveInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpUploadMultipartPart struct {
}

func (*validateOpUploadMultipartPart) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpUploadMultipartPart) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*UploadMultipartPartInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpUploadMultipartPartInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

func addOpAbortMultipartUploadValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpAbortMultipartUpload{}, middleware.After)
}

func addOpAbortVaultLockValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpAbortVaultLock{}, middleware.After)
}

func addOpAddTagsToVaultValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpAddTagsToVault{}, middleware.After)
}

func addOpCompleteMultipartUploadValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpCompleteMultipartUpload{}, middleware.After)
}

func addOpCompleteVaultLockValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpCompleteVaultLock{}, middleware.After)
}

func addOpCreateVaultValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpCreateVault{}, middleware.After)
}

func addOpDeleteArchiveValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDeleteArchive{}, middleware.After)
}

func addOpDeleteVaultAccessPolicyValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDeleteVaultAccessPolicy{}, middleware.After)
}

func addOpDeleteVaultValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDeleteVault{}, middleware.After)
}

func addOpDeleteVaultNotificationsValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDeleteVaultNotifications{}, middleware.After)
}

func addOpDescribeJobValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDescribeJob{}, middleware.After)
}

func addOpDescribeVaultValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDescribeVault{}, middleware.After)
}

func addOpGetDataRetrievalPolicyValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpGetDataRetrievalPolicy{}, middleware.After)
}

func addOpGetJobOutputValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpGetJobOutput{}, middleware.After)
}

func addOpGetVaultAccessPolicyValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpGetVaultAccessPolicy{}, middleware.After)
}

func addOpGetVaultLockValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpGetVaultLock{}, middleware.After)
}

func addOpGetVaultNotificationsValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpGetVaultNotifications{}, middleware.After)
}

func addOpInitiateJobValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpInitiateJob{}, middleware.After)
}

func addOpInitiateMultipartUploadValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpInitiateMultipartUpload{}, middleware.After)
}

func addOpInitiateVaultLockValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpInitiateVaultLock{}, middleware.After)
}

func addOpListJobsValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpListJobs{}, middleware.After)
}

func addOpListMultipartUploadsValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpListMultipartUploads{}, middleware.After)
}

func addOpListPartsValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpListParts{}, middleware.After)
}

func addOpListProvisionedCapacityValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpListProvisionedCapacity{}, middleware.After)
}

func addOpListTagsForVaultValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpListTagsForVault{}, middleware.After)
}

func addOpListVaultsValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpListVaults{}, middleware.After)
}

func addOpPurchaseProvisionedCapacityValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpPurchaseProvisionedCapacity{}, middleware.After)
}

func addOpRemoveTagsFromVaultValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpRemoveTagsFromVault{}, middleware.After)
}

func addOpSetDataRetrievalPolicyValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpSetDataRetrievalPolicy{}, middleware.After)
}

func addOpSetVaultAccessPolicyValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpSetVaultAccessPolicy{}, middleware.After)
}

func addOpSetVaultNotificationsValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpSetVaultNotifications{}, middleware.After)
}

func addOpUploadArchiveValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpUploadArchive{}, middleware.After)
}

func addOpUploadMultipartPartValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpUploadMultipartPart{}, middleware.After)
}

func validateAccessControlPolicyList(v []types.Grant) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "AccessControlPolicyList"}
	for i := range v {
		if err := validateGrant(&v[i]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%d]", i), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateGrant(v *types.Grant) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "Grant"}
	if v.Grantee != nil {
		if err := validateGrantee(v.Grantee); err != nil {
			invalidParams.AddNested("Grantee", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateGrantee(v *types.Grantee) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "Grantee"}
	if len(v.Type) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("Type"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateJobParameters(v *types.JobParameters) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "JobParameters"}
	if v.OutputLocation != nil {
		if err := validateOutputLocation(v.OutputLocation); err != nil {
			invalidParams.AddNested("OutputLocation", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOutputLocation(v *types.OutputLocation) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "OutputLocation"}
	if v.S3 != nil {
		if err := validateS3Location(v.S3); err != nil {
			invalidParams.AddNested("S3", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateS3Location(v *types.S3Location) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "S3Location"}
	if v.AccessControlList != nil {
		if err := validateAccessControlPolicyList(v.AccessControlList); err != nil {
			invalidParams.AddNested("AccessControlList", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpAbortMultipartUploadInput(v *AbortMultipartUploadInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "AbortMultipartUploadInput"}
	if v.AccountId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("AccountId"))
	}
	if v.VaultName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("VaultName"))
	}
	if v.UploadId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("UploadId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpAbortVaultLockInput(v *AbortVaultLockInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "AbortVaultLockInput"}
	if v.AccountId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("AccountId"))
	}
	if v.VaultName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("VaultName"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpAddTagsToVaultInput(v *AddTagsToVaultInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "AddTagsToVaultInput"}
	if v.AccountId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("AccountId"))
	}
	if v.VaultName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("VaultName"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpCompleteMultipartUploadInput(v *CompleteMultipartUploadInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "CompleteMultipartUploadInput"}
	if v.AccountId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("AccountId"))
	}
	if v.VaultName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("VaultName"))
	}
	if v.UploadId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("UploadId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpCompleteVaultLockInput(v *CompleteVaultLockInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "CompleteVaultLockInput"}
	if v.AccountId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("AccountId"))
	}
	if v.VaultName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("VaultName"))
	}
	if v.LockId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("LockId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpCreateVaultInput(v *CreateVaultInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "CreateVaultInput"}
	if v.AccountId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("AccountId"))
	}
	if v.VaultName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("VaultName"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDeleteArchiveInput(v *DeleteArchiveInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DeleteArchiveInput"}
	if v.AccountId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("AccountId"))
	}
	if v.VaultName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("VaultName"))
	}
	if v.ArchiveId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ArchiveId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDeleteVaultAccessPolicyInput(v *DeleteVaultAccessPolicyInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DeleteVaultAccessPolicyInput"}
	if v.AccountId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("AccountId"))
	}
	if v.VaultName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("VaultName"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDeleteVaultInput(v *DeleteVaultInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DeleteVaultInput"}
	if v.AccountId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("AccountId"))
	}
	if v.VaultName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("VaultName"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDeleteVaultNotificationsInput(v *DeleteVaultNotificationsInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DeleteVaultNotificationsInput"}
	if v.AccountId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("AccountId"))
	}
	if v.VaultName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("VaultName"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDescribeJobInput(v *DescribeJobInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DescribeJobInput"}
	if v.AccountId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("AccountId"))
	}
	if v.VaultName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("VaultName"))
	}
	if v.JobId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("JobId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDescribeVaultInput(v *DescribeVaultInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DescribeVaultInput"}
	if v.AccountId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("AccountId"))
	}
	if v.VaultName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("VaultName"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpGetDataRetrievalPolicyInput(v *GetDataRetrievalPolicyInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "GetDataRetrievalPolicyInput"}
	if v.AccountId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("AccountId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpGetJobOutputInput(v *GetJobOutputInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "GetJobOutputInput"}
	if v.AccountId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("AccountId"))
	}
	if v.VaultName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("VaultName"))
	}
	if v.JobId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("JobId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpGetVaultAccessPolicyInput(v *GetVaultAccessPolicyInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "GetVaultAccessPolicyInput"}
	if v.AccountId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("AccountId"))
	}
	if v.VaultName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("VaultName"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpGetVaultLockInput(v *GetVaultLockInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "GetVaultLockInput"}
	if v.AccountId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("AccountId"))
	}
	if v.VaultName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("VaultName"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpGetVaultNotificationsInput(v *GetVaultNotificationsInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "GetVaultNotificationsInput"}
	if v.AccountId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("AccountId"))
	}
	if v.VaultName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("VaultName"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpInitiateJobInput(v *InitiateJobInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "InitiateJobInput"}
	if v.AccountId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("AccountId"))
	}
	if v.VaultName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("VaultName"))
	}
	if v.JobParameters != nil {
		if err := validateJobParameters(v.JobParameters); err != nil {
			invalidParams.AddNested("JobParameters", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpInitiateMultipartUploadInput(v *InitiateMultipartUploadInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "InitiateMultipartUploadInput"}
	if v.AccountId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("AccountId"))
	}
	if v.VaultName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("VaultName"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpInitiateVaultLockInput(v *InitiateVaultLockInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "InitiateVaultLockInput"}
	if v.AccountId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("AccountId"))
	}
	if v.VaultName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("VaultName"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpListJobsInput(v *ListJobsInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ListJobsInput"}
	if v.AccountId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("AccountId"))
	}
	if v.VaultName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("VaultName"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpListMultipartUploadsInput(v *ListMultipartUploadsInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ListMultipartUploadsInput"}
	if v.AccountId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("AccountId"))
	}
	if v.VaultName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("VaultName"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpListPartsInput(v *ListPartsInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ListPartsInput"}
	if v.AccountId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("AccountId"))
	}
	if v.VaultName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("VaultName"))
	}
	if v.UploadId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("UploadId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpListProvisionedCapacityInput(v *ListProvisionedCapacityInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ListProvisionedCapacityInput"}
	if v.AccountId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("AccountId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpListTagsForVaultInput(v *ListTagsForVaultInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ListTagsForVaultInput"}
	if v.AccountId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("AccountId"))
	}
	if v.VaultName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("VaultName"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpListVaultsInput(v *ListVaultsInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ListVaultsInput"}
	if v.AccountId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("AccountId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpPurchaseProvisionedCapacityInput(v *PurchaseProvisionedCapacityInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "PurchaseProvisionedCapacityInput"}
	if v.AccountId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("AccountId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpRemoveTagsFromVaultInput(v *RemoveTagsFromVaultInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "RemoveTagsFromVaultInput"}
	if v.AccountId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("AccountId"))
	}
	if v.VaultName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("VaultName"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpSetDataRetrievalPolicyInput(v *SetDataRetrievalPolicyInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "SetDataRetrievalPolicyInput"}
	if v.AccountId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("AccountId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpSetVaultAccessPolicyInput(v *SetVaultAccessPolicyInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "SetVaultAccessPolicyInput"}
	if v.AccountId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("AccountId"))
	}
	if v.VaultName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("VaultName"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpSetVaultNotificationsInput(v *SetVaultNotificationsInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "SetVaultNotificationsInput"}
	if v.AccountId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("AccountId"))
	}
	if v.VaultName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("VaultName"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpUploadArchiveInput(v *UploadArchiveInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "UploadArchiveInput"}
	if v.VaultName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("VaultName"))
	}
	if v.AccountId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("AccountId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpUploadMultipartPartInput(v *UploadMultipartPartInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "UploadMultipartPartInput"}
	if v.AccountId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("AccountId"))
	}
	if v.VaultName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("VaultName"))
	}
	if v.UploadId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("UploadId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}
