with Ada.Text_IO;
with Ada.Long_Long_Float_Text_IO;
with GNAT.Float_Control;
with Interfaces.C;
with System;
with OCI.Thick.Gen_OCINumber;
with OCI.Thick.Number_Functions;

procedure FNum is
   use Ada.Text_IO;
   use Interfaces;

   subtype LLF is Long_Long_Float;

   F : LLF := 1.0;

   procedure Test (F : LLF);

   procedure Test (F : LLF) is
      use OCI.Thick;

      function To_Number is new Gen_OCINumber.Float_To_Number_Better (LLF);
      function To_Float is new Gen_OCINumber.Num_To_Float_Better (LLF);

      N : constant OCINumber := To_Number (F);
      FN : constant LLF := To_Float (N);
   begin
      Ada.Long_Long_Float_Text_IO.Put (F, Aft => 20);
      Put (' ' & Number_Functions.To_String (N));
      Put (' ' & Number_Functions.To_String (Number_Functions.Ln (N)));
      Ada.Long_Long_Float_Text_IO.Put (FN, Aft => 20);

      if F /= FN then
         Put (" /=");
      end if;

      New_Line;
   end Test;

begin
   Put_Line ("Long Float" & Long_Float'Size'Img);
   Put_Line ("Long Long Float" & Long_Long_Float'Size'Img);
   Put_Line ("double" & C.double'Size'Img);
   Put_Line ("long double" & C.long_double'Size'Img);

   for J in 1 .. 20 loop
      Test (F);
      F := F + (10.0 ** (-J)) * LLF (J rem 10);
   end loop;
end FNum;
