/* Common hooks for Texas Instruments MSP430.
   Copyright (C) 2014-2015 Free Software Foundation, Inc.

   This file is part of GCC.

   GCC is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3, or (at your option)
   any later version.

   GCC is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with GCC; see the file COPYING3.  If not see
   <http://www.gnu.org/licenses/>.  */

#include "config.h"
#include "system.h"
#include "coretypes.h"
#include "diagnostic-core.h"
#include "tm.h"
#include "common/common-target.h"
#include "common/common-target-def.h"
#include "opts.h"
#include "flags.h"

/* Handle -mcpu= and -mmcu= here.  We want to ensure that only one
   of these two options - the last specified on the command line -
   is passed on to the msp430 backend.  */

static bool
msp430_handle_option (struct gcc_options *opts ATTRIBUTE_UNUSED,
		      struct gcc_options *opts_set ATTRIBUTE_UNUSED,
		      const struct cl_decoded_option *decoded,
		      location_t loc ATTRIBUTE_UNUSED)
{
  switch (decoded->opt_index)
    {
    case OPT_mcpu_:
      if (strcasecmp (decoded->arg, "msp430x") == 0
	  || strcasecmp (decoded->arg, "msp430xv2") == 0
	  || strcasecmp (decoded->arg, "430x") == 0
	  || strcasecmp (decoded->arg, "430xv2") == 0)
	{
	  target_cpu = "msp430x";
	  target_mcu = NULL;
	}
      else if (strcasecmp (decoded->arg, "msp430") == 0
	       || strcasecmp (decoded->arg, "430") == 0)
	{
	  target_cpu = "msp430";
	  target_mcu = NULL;
	}
      else
	{
	  error ("unrecognised argument of -mcpu: %s", decoded->arg);
	  return false;
	}
      break;

    case OPT_mmcu_:
      /* For backwards compatibility we recognise two generic MCU
	 430X names.  However we want to be able to generate special C
	 preprocessor defines for them, which is why we set target_mcu
	 to NULL.  */
      if (strcasecmp (decoded->arg, "msp430") == 0)
	{
	  target_cpu = "msp430";
	  target_mcu = NULL;
	}
      else if (strcasecmp (decoded->arg, "msp430x") == 0
	       || strcasecmp (decoded->arg, "msp430xv2") == 0)
	{
	  target_cpu = "msp430x";
	  target_mcu = NULL;
	}
      else
	target_cpu = NULL;
      break;
    }
      
  return true;
}

#undef  TARGET_HANDLE_OPTION
#define TARGET_HANDLE_OPTION			msp430_handle_option

struct gcc_targetm_common targetm_common = TARGETM_COMMON_INITIALIZER;
