/*	Copyright  2001 The Regents of the University of California.
*	All Rights Reserved.
*	Permission to use, copy, modify, and distribute this software and its
*	documentation for educational, research and non-profit purposes, without
*	fee, and without a written agreement is hereby granted, provided that the
*	above copyright notice, this paragraph and the following three paragraphs
*	appear in all copies.
*	Permission to incorporate this software into commercial products may
*	be obtained by contacting the University of California: 
*	Bill Hoskins
*	Office of Technology Licensing
*	2150 Shattuck Avenue #150
* 	Berkeley, CA 94720-1620
*	(510) 643-7201
*	bhoskins@uclink2.berkeley.edu
*	
*
*	This software program and documentation are copyrighted by The Regents
*	of the University of California. The software program and documentation
*	are supplied "as is", without any accompanying services from
*	The Regents. The Regents does not warrant that the operation of the program
*	will be uninterrupted or error-free. The end-user understands that the
*	program was developed for research purposes and is advised not to rely
*	exclusively on the program for any reason.
*	IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY
*	FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES, INCLUDING
*	LOST PROFITS, ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION,
*	EVEN IF THE UNIVERSITY OF CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY
*	OF SUCH DAMAGE. THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY
*	WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY
*	AND FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE PROVIDED HEREUNDER IS
*	ON AN "AS IS" BASIS, AND THE UNIVERSITY OF CALIFORNIA HAS NO
*	OBLIGATIONS TO PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.
*	This software is based on Mark Fullmer's flow-tools 
*	http://www.splintered.net/sw/flow-tools/
*	$Id: route_lookup.c,v 1.2 2001/10/17 23:32:24 robert Exp $
*/
#include "route_lookup.h"
#include "ftlib.h"
#include "fmt.h"
view_t *view;
bgp_route_t *route;
bgp_local_t *local_bgp;
trace_t *default_trace;
prefix_t *sprefix;
radix_node_t *search_node ;
bgp_route_head_t *route_head;


static int INIT = 0;  

void load_file (char* rib_file)
{

  extern view_t *view;
  extern bgp_local_t *local_bgp;
  extern trace_t *default_trace;
      
  /* load mrtd rib from disk */
  if (!INIT && rib_file != NULL) {
    
    /* mrtd startup stuff */
    default_trace = New_Trace2("route_lookup");;
    set_trace (default_trace, TRACE_PREPEND_STRING, "route_lookup", 0);
    //set_trace (default_trace, TRACE_MAX_ERRORS, DEFAULT_MAX_ERRORS, 0);
    set_trace (default_trace, TRACE_FLAGS, TR_DEFAULT_FLAGS, 0);
    

    //fterr_info(stderr, "firing up mrtd dependencies\n");
    init_trace("route_lookup", 1);
    init_mrt(default_trace);
    init_BGP(default_trace);
    init_rib(default_trace);
    //fterr_info(stderr, "finished firing up mrtd dependencies\n");

    /*  initialize mrt bgp view 0 */
    local_bgp = init_bgp_local(0, 0);
    view = BGP->views[0];
    view->local_bgp = local_bgp;
    BITX_SET (&local_bgp->view_mask, 0);

    /* load bgp table dump from disk into memory */
    //(stderr, "loading mrt rib file from disk: %s\n", rib_file);
    if(!load_rib_from_disk(rib_file)){
      fterr_errx(1,"failed to load mrt rib file: %s\n", rib_file);
    }

    /* open view  */
    //fterr_info("opening bgp view\n 0");
    view = BGP->views[0];
    /*
      pthread_mutex_lock (&view->local_bgp->peers_mutex_lock);
      LL_Iterate (view->local_bgp->ll_bgp_peers, peer) {
      BITX_SET (&peer->view_mask, view->viewno);
      }
      pthread_mutex_unlock (&view->local_bgp->peers_mutex_lock);
    */
    view_open (view);
    //fprintf(stderr, "opened bgp view:||%d\n",
    //    view->radix_tree->num_active_node);
    INIT = 1;

  }
}

char*  lookup_aspath(u_int32 prefix, u_int8 mask_bitlen)
{

  prefix_t *sprefix;
  extern radix_node_t *search_node ;
  extern bgp_route_head_t *route_head;
  char* tmp = NULL;
  
  SWAPINT32 (prefix); 
            sprefix = New_Prefix(AF_INET, &prefix, mask_bitlen);
	    search_node = radix_search_best (view->radix_tree, sprefix);
	    
	    /* route lookup succeeded */
	    if (search_node != NULL ) { 
	      assert (search_node->data);
	      route_head = RADIX_DATA_GET (search_node, bgp_route_head_t);
	      route = route_head->active;
	      assert(route->attr);
	      if (route->attr->aspath){
		tmp = strdup(aspath_toa(route->attr->aspath));
	      }
	    }
	   
            Delete(sprefix);
	    return tmp;
}

char* lookup_community(u_int32 prefix, u_int8 mask_bitlen)
{

  prefix_t *sprefix;
  extern radix_node_t *search_node ;
  extern bgp_route_head_t *route_head;
  char* tmp = NULL;
  //char addr[32], mask[32];
  
  SWAPINT32 (prefix); 
  
  sprefix = New_Prefix(AF_INET, &prefix, mask_bitlen);
  search_node = radix_search_best (view->radix_tree, sprefix);
  
  if (search_node != NULL ) { 
    assert (search_node->data);
    route_head = RADIX_DATA_GET (search_node, bgp_route_head_t);
    route = route_head->active;
    assert(route->attr);
    if  (route->attr->community)
      tmp = strdup(community_toa(route->attr->community));
  }
  Delete(sprefix);
  return tmp;
}
