//
// Copyright (C) 2013~2015 by CSSlayer
// wengxt@gmail.com
//
// This library is free software; you can redistribute it and/or modify
// it under the terms of the GNU Lesser General Public License as
// published by the Free Software Foundation; either version 2.1 of the
// License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; see the file COPYING. If not,
// see <http://www.gnu.org/licenses/>.
//

#ifndef _FCITX_UTILS_KEYNAMETABLE_COMPAT_H_
#define _FCITX_UTILS_KEYNAMETABLE_COMPAT_H_

#include <fcitx-utils/keysym.h>

static const struct KeyNameListCompat {
    const char *name;
    FcitxKeySym sym;
} keyNameListCompat[] = {
    {"ACCESSXENABLE", FcitxKey_AccessX_Enable},
    {"ACCESSXFEEDBACKENABLE", FcitxKey_AccessX_Feedback_Enable},
    {"ARABICHEH", FcitxKey_Arabic_heh},
    {"ARABICSWITCH", FcitxKey_Arabic_switch},
    {"AUDIBLEBELLENABLE", FcitxKey_AudibleBell_Enable},
    {"BACKSPACE", FcitxKey_BackSpace},
    {"BEGIN", FcitxKey_Begin},
    {"BLANK", FcitxKey_blank},
    {"BOTLEFTSUMMATION", FcitxKey_botleftsummation},
    {"BOTRIGHTSUMMATION", FcitxKey_botrightsummation},
    {"BOTVERTSUMMATIONCONNECTOR", FcitxKey_botvertsummationconnector},
    {"BOUNCEKEYSENABLE", FcitxKey_BounceKeys_Enable},
    {"BRAILLEDOT1", FcitxKey_braille_dot_1},
    {"BRAILLEDOT10", FcitxKey_braille_dot_10},
    {"BRAILLEDOT2", FcitxKey_braille_dot_2},
    {"BRAILLEDOT3", FcitxKey_braille_dot_3},
    {"BRAILLEDOT4", FcitxKey_braille_dot_4},
    {"BRAILLEDOT5", FcitxKey_braille_dot_5},
    {"BRAILLEDOT6", FcitxKey_braille_dot_6},
    {"BRAILLEDOT7", FcitxKey_braille_dot_7},
    {"BRAILLEDOT8", FcitxKey_braille_dot_8},
    {"BRAILLEDOT9", FcitxKey_braille_dot_9},
    {"BREAK", FcitxKey_Break},
    {"CANCEL", FcitxKey_Cancel},
    {"CAPSLOCK", FcitxKey_Caps_Lock},
    {"CLEAR", FcitxKey_Clear},
    {"CODEINPUT", FcitxKey_Codeinput},
    {"CURSOR", FcitxKey_cursor},
    {"DELETE", FcitxKey_Delete},
    {"DOWN", FcitxKey_Down},
    {"EISUSHIFT", FcitxKey_Eisu_Shift},
    {"EISUTOGGLE", FcitxKey_Eisu_toggle},
    {"END", FcitxKey_End},
    {"ENTER", FcitxKey_Return},
    {"ESCAPE", FcitxKey_Escape},
    {"EXECUTE", FcitxKey_Execute},
    {"F1", FcitxKey_F1},
    {"F10", FcitxKey_F10},
    {"F11", FcitxKey_F11},
    {"F12", FcitxKey_F12},
    {"F13", FcitxKey_F13},
    {"F14", FcitxKey_F14},
    {"F15", FcitxKey_F15},
    {"F16", FcitxKey_F16},
    {"F17", FcitxKey_F17},
    {"F18", FcitxKey_F18},
    {"F19", FcitxKey_F19},
    {"F2", FcitxKey_F2},
    {"F20", FcitxKey_F20},
    {"F21", FcitxKey_F21},
    {"F22", FcitxKey_F22},
    {"F23", FcitxKey_F23},
    {"F24", FcitxKey_F24},
    {"F25", FcitxKey_F25},
    {"F26", FcitxKey_F26},
    {"F27", FcitxKey_F27},
    {"F28", FcitxKey_F28},
    {"F29", FcitxKey_F29},
    {"F3", FcitxKey_F3},
    {"F30", FcitxKey_F30},
    {"F31", FcitxKey_F31},
    {"F32", FcitxKey_F32},
    {"F33", FcitxKey_F33},
    {"F34", FcitxKey_F34},
    {"F35", FcitxKey_F35},
    {"F4", FcitxKey_F4},
    {"F5", FcitxKey_F5},
    {"F6", FcitxKey_F6},
    {"F7", FcitxKey_F7},
    {"F8", FcitxKey_F8},
    {"F9", FcitxKey_F9},
    {"FIND", FcitxKey_Find},
    {"FIRSTVIRTUALSCREEN", FcitxKey_First_Virtual_Screen},
    {"GREEKIOTADIAERESIS", FcitxKey_Greek_IOTAdiaeresis},
    {"GREEKSWITCH", FcitxKey_Greek_switch},
    {"HANGUL", FcitxKey_Hangul},
    {"HANGULA", FcitxKey_Hangul_A},
    {"HANGULAE", FcitxKey_Hangul_AE},
    {"HANGULARAEA", FcitxKey_Hangul_AraeA},
    {"HANGULARAEAE", FcitxKey_Hangul_AraeAE},
    {"HANGULBANJA", FcitxKey_Hangul_Banja},
    {"HANGULCIEUC", FcitxKey_Hangul_Cieuc},
    {"HANGULCODEINPUT", FcitxKey_Hangul_Codeinput},
    {"HANGULDIKEUD", FcitxKey_Hangul_Dikeud},
    {"HANGULE", FcitxKey_Hangul_E},
    {"HANGULEND", FcitxKey_Hangul_End},
    {"HANGULEO", FcitxKey_Hangul_EO},
    {"HANGULEU", FcitxKey_Hangul_EU},
    {"HANGULHANJA", FcitxKey_Hangul_Hanja},
    {"HANGULHIEUH", FcitxKey_Hangul_Hieuh},
    {"HANGULI", FcitxKey_Hangul_I},
    {"HANGULIEUNG", FcitxKey_Hangul_Ieung},
    {"HANGULJAMO", FcitxKey_Hangul_Jamo},
    {"HANGULJCIEUC", FcitxKey_Hangul_J_Cieuc},
    {"HANGULJDIKEUD", FcitxKey_Hangul_J_Dikeud},
    {"HANGULJEONJA", FcitxKey_Hangul_Jeonja},
    {"HANGULJHIEUH", FcitxKey_Hangul_J_Hieuh},
    {"HANGULJIEUJ", FcitxKey_Hangul_Jieuj},
    {"HANGULJIEUNG", FcitxKey_Hangul_J_Ieung},
    {"HANGULJJIEUJ", FcitxKey_Hangul_J_Jieuj},
    {"HANGULJKHIEUQ", FcitxKey_Hangul_J_Khieuq},
    {"HANGULJKIYEOG", FcitxKey_Hangul_J_Kiyeog},
    {"HANGULJKIYEOGSIOS", FcitxKey_Hangul_J_KiyeogSios},
    {"HANGULJKKOGJIDALRINIEUNG", FcitxKey_Hangul_J_KkogjiDalrinIeung},
    {"HANGULJMIEUM", FcitxKey_Hangul_J_Mieum},
    {"HANGULJNIEUN", FcitxKey_Hangul_J_Nieun},
    {"HANGULJNIEUNHIEUH", FcitxKey_Hangul_J_NieunHieuh},
    {"HANGULJNIEUNJIEUJ", FcitxKey_Hangul_J_NieunJieuj},
    {"HANGULJPANSIOS", FcitxKey_Hangul_J_PanSios},
    {"HANGULJPHIEUF", FcitxKey_Hangul_J_Phieuf},
    {"HANGULJPIEUB", FcitxKey_Hangul_J_Pieub},
    {"HANGULJPIEUBSIOS", FcitxKey_Hangul_J_PieubSios},
    {"HANGULJRIEUL", FcitxKey_Hangul_J_Rieul},
    {"HANGULJRIEULHIEUH", FcitxKey_Hangul_J_RieulHieuh},
    {"HANGULJRIEULKIYEOG", FcitxKey_Hangul_J_RieulKiyeog},
    {"HANGULJRIEULMIEUM", FcitxKey_Hangul_J_RieulMieum},
    {"HANGULJRIEULPHIEUF", FcitxKey_Hangul_J_RieulPhieuf},
    {"HANGULJRIEULPIEUB", FcitxKey_Hangul_J_RieulPieub},
    {"HANGULJRIEULSIOS", FcitxKey_Hangul_J_RieulSios},
    {"HANGULJRIEULTIEUT", FcitxKey_Hangul_J_RieulTieut},
    {"HANGULJSIOS", FcitxKey_Hangul_J_Sios},
    {"HANGULJSSANGKIYEOG", FcitxKey_Hangul_J_SsangKiyeog},
    {"HANGULJSSANGSIOS", FcitxKey_Hangul_J_SsangSios},
    {"HANGULJTIEUT", FcitxKey_Hangul_J_Tieut},
    {"HANGULJYEORINHIEUH", FcitxKey_Hangul_J_YeorinHieuh},
    {"HANGULKHIEUQ", FcitxKey_Hangul_Khieuq},
    {"HANGULKIYEOG", FcitxKey_Hangul_Kiyeog},
    {"HANGULKIYEOGSIOS", FcitxKey_Hangul_KiyeogSios},
    {"HANGULKKOGJIDALRINIEUNG", FcitxKey_Hangul_KkogjiDalrinIeung},
    {"HANGULMIEUM", FcitxKey_Hangul_Mieum},
    {"HANGULMULTIPLECANDIDATE", FcitxKey_Hangul_MultipleCandidate},
    {"HANGULNIEUN", FcitxKey_Hangul_Nieun},
    {"HANGULNIEUNHIEUH", FcitxKey_Hangul_NieunHieuh},
    {"HANGULNIEUNJIEUJ", FcitxKey_Hangul_NieunJieuj},
    {"HANGULO", FcitxKey_Hangul_O},
    {"HANGULOE", FcitxKey_Hangul_OE},
    {"HANGULPANSIOS", FcitxKey_Hangul_PanSios},
    {"HANGULPHIEUF", FcitxKey_Hangul_Phieuf},
    {"HANGULPIEUB", FcitxKey_Hangul_Pieub},
    {"HANGULPIEUBSIOS", FcitxKey_Hangul_PieubSios},
    {"HANGULPOSTHANJA", FcitxKey_Hangul_PostHanja},
    {"HANGULPREHANJA", FcitxKey_Hangul_PreHanja},
    {"HANGULPREVIOUSCANDIDATE", FcitxKey_Hangul_PreviousCandidate},
    {"HANGULRIEUL", FcitxKey_Hangul_Rieul},
    {"HANGULRIEULHIEUH", FcitxKey_Hangul_RieulHieuh},
    {"HANGULRIEULKIYEOG", FcitxKey_Hangul_RieulKiyeog},
    {"HANGULRIEULMIEUM", FcitxKey_Hangul_RieulMieum},
    {"HANGULRIEULPHIEUF", FcitxKey_Hangul_RieulPhieuf},
    {"HANGULRIEULPIEUB", FcitxKey_Hangul_RieulPieub},
    {"HANGULRIEULSIOS", FcitxKey_Hangul_RieulSios},
    {"HANGULRIEULTIEUT", FcitxKey_Hangul_RieulTieut},
    {"HANGULRIEULYEORINHIEUH", FcitxKey_Hangul_RieulYeorinHieuh},
    {"HANGULROMAJA", FcitxKey_Hangul_Romaja},
    {"HANGULSINGLECANDIDATE", FcitxKey_Hangul_SingleCandidate},
    {"HANGULSIOS", FcitxKey_Hangul_Sios},
    {"HANGULSPECIAL", FcitxKey_Hangul_Special},
    {"HANGULSSANGDIKEUD", FcitxKey_Hangul_SsangDikeud},
    {"HANGULSSANGJIEUJ", FcitxKey_Hangul_SsangJieuj},
    {"HANGULSSANGKIYEOG", FcitxKey_Hangul_SsangKiyeog},
    {"HANGULSSANGPIEUB", FcitxKey_Hangul_SsangPieub},
    {"HANGULSSANGSIOS", FcitxKey_Hangul_SsangSios},
    {"HANGULSTART", FcitxKey_Hangul_Start},
    {"HANGULSUNKYEONGEUMMIEUM", FcitxKey_Hangul_SunkyeongeumMieum},
    {"HANGULSUNKYEONGEUMPHIEUF", FcitxKey_Hangul_SunkyeongeumPhieuf},
    {"HANGULSUNKYEONGEUMPIEUB", FcitxKey_Hangul_SunkyeongeumPieub},
    {"HANGULSWITCH", FcitxKey_Hangul_switch},
    {"HANGULTIEUT", FcitxKey_Hangul_Tieut},
    {"HANGULU", FcitxKey_Hangul_U},
    {"HANGULWA", FcitxKey_Hangul_WA},
    {"HANGULWAE", FcitxKey_Hangul_WAE},
    {"HANGULWE", FcitxKey_Hangul_WE},
    {"HANGULWEO", FcitxKey_Hangul_WEO},
    {"HANGULWI", FcitxKey_Hangul_WI},
    {"HANGULYA", FcitxKey_Hangul_YA},
    {"HANGULYAE", FcitxKey_Hangul_YAE},
    {"HANGULYE", FcitxKey_Hangul_YE},
    {"HANGULYEO", FcitxKey_Hangul_YEO},
    {"HANGULYEORINHIEUH", FcitxKey_Hangul_YeorinHieuh},
    {"HANGULYI", FcitxKey_Hangul_YI},
    {"HANGULYO", FcitxKey_Hangul_YO},
    {"HANGULYU", FcitxKey_Hangul_YU},
    {"HANKAKU", FcitxKey_Hankaku},
    {"HEBREWBETH", FcitxKey_hebrew_beth},
    {"HEBREWDALETH", FcitxKey_hebrew_daleth},
    {"HEBREWFINALZADI", FcitxKey_hebrew_finalzadi},
    {"HEBREWGIMMEL", FcitxKey_hebrew_gimmel},
    {"HEBREWHET", FcitxKey_hebrew_het},
    {"HEBREWKUF", FcitxKey_hebrew_kuf},
    {"HEBREWSAMEKH", FcitxKey_hebrew_samekh},
    {"HEBREWSWITCH", FcitxKey_Hebrew_switch},
    {"HEBREWTAF", FcitxKey_hebrew_taf},
    {"HEBREWTETH", FcitxKey_hebrew_teth},
    {"HEBREWZADI", FcitxKey_hebrew_zadi},
    {"HEBREWZAYIN", FcitxKey_hebrew_zayin},
    {"HELP", FcitxKey_Help},
    {"HENKAN", FcitxKey_Henkan},
    {"HENKANMODE", FcitxKey_Henkan_Mode},
    {"HEXAGRAM", FcitxKey_hexagram},
    {"HIRAGANA", FcitxKey_Hiragana},
    {"HIRAGANAKATAKANA", FcitxKey_Hiragana_Katakana},
    {"HOME", FcitxKey_Home},
    {"INSERT", FcitxKey_Insert},
    {"KANAHU", FcitxKey_kana_HU},
    {"KANALOCK", FcitxKey_Kana_Lock},
    {"KANAMIDDLEDOT", FcitxKey_kana_middledot},
    {"KANASHIFT", FcitxKey_Kana_Shift},
    {"KANASWITCH", FcitxKey_kana_switch},
    {"KANATI", FcitxKey_kana_TI},
    {"KANATU", FcitxKey_kana_TU},
    {"KANJI", FcitxKey_Kanji},
    {"KANJIBANGOU", FcitxKey_Kanji_Bangou},
    {"KAPPA", FcitxKey_kappa},
    {"KATAKANA", FcitxKey_Katakana},
    {"KP0", FcitxKey_KP_0},
    {"KP1", FcitxKey_KP_1},
    {"KP2", FcitxKey_KP_2},
    {"KP3", FcitxKey_KP_3},
    {"KP4", FcitxKey_KP_4},
    {"KP5", FcitxKey_KP_5},
    {"KP6", FcitxKey_KP_6},
    {"KP7", FcitxKey_KP_7},
    {"KP8", FcitxKey_KP_8},
    {"KP9", FcitxKey_KP_9},
    {"KPADD", FcitxKey_KP_Add},
    {"KPBEGIN", FcitxKey_KP_Begin},
    {"KPDECIMAL", FcitxKey_KP_Decimal},
    {"KPDELETE", FcitxKey_KP_Delete},
    {"KPDIVIDE", FcitxKey_KP_Divide},
    {"KPDOWN", FcitxKey_KP_Down},
    {"KPEND", FcitxKey_KP_End},
    {"KPENTER", FcitxKey_KP_Enter},
    {"KPEQUAL", FcitxKey_KP_Equal},
    {"KPF1", FcitxKey_KP_F1},
    {"KPF2", FcitxKey_KP_F2},
    {"KPF3", FcitxKey_KP_F3},
    {"KPF4", FcitxKey_KP_F4},
    {"KPHOME", FcitxKey_KP_Home},
    {"KPINSERT", FcitxKey_KP_Insert},
    {"KPLEFT", FcitxKey_KP_Left},
    {"KPMULTIPLY", FcitxKey_KP_Multiply},
    {"KPPGDOWN", FcitxKey_KP_Page_Down},
    {"KPPGUP", FcitxKey_KP_Page_Up},
    {"KPRIGHT", FcitxKey_KP_Right},
    {"KPSEPARATOR", FcitxKey_KP_Separator},
    {"KPSPACE", FcitxKey_KP_Space},
    {"KPSUBTRACT", FcitxKey_KP_Subtract},
    {"KPTAB", FcitxKey_KP_Tab},
    {"KPUP", FcitxKey_KP_Up},
    {"L1", FcitxKey_L1},
    {"L10", FcitxKey_L10},
    {"L2", FcitxKey_L2},
    {"L3", FcitxKey_L3},
    {"L4", FcitxKey_L4},
    {"L5", FcitxKey_L5},
    {"L6", FcitxKey_L6},
    {"L7", FcitxKey_L7},
    {"L8", FcitxKey_L8},
    {"L9", FcitxKey_L9},
    {"LALT", FcitxKey_Alt_L},
    {"LASTVIRTUALSCREEN", FcitxKey_Last_Virtual_Screen},
    {"LCTRL", FcitxKey_Control_L},
    {"LEFT", FcitxKey_Left},
    {"LHYPER", FcitxKey_Hyper_L},
    {"LINEFEED", FcitxKey_Linefeed},
    {"LMETA", FcitxKey_Meta_L},
    {"LSHIFT", FcitxKey_Shift_L},
    {"LSUPER", FcitxKey_Super_L},
    {"MAEKOHO", FcitxKey_Mae_Koho},
    {"MARKER", FcitxKey_marker},
    {"MASSYO", FcitxKey_Massyo},
    {"MENU", FcitxKey_Menu},
    {"MODESWITCH", FcitxKey_Mode_switch},
    {"MOUSEKEYSACCELENABLE", FcitxKey_MouseKeys_Accel_Enable},
    {"MOUSEKEYSENABLE", FcitxKey_MouseKeys_Enable},
    {"MUHENKAN", FcitxKey_Muhenkan},
    {"MULTIKEY", FcitxKey_Multi_key},
    {"MULTIPLECANDIDATE", FcitxKey_MultipleCandidate},
    {"NEXTVIRTUALSCREEN", FcitxKey_Next_Virtual_Screen},
    {"NUMLOCK", FcitxKey_Num_Lock},
    {"OVERLAY1ENABLE", FcitxKey_Overlay1_Enable},
    {"OVERLAY2ENABLE", FcitxKey_Overlay2_Enable},
    {"PAUSE", FcitxKey_Pause},
    {"PGDN", FcitxKey_Page_Down},
    {"PGUP", FcitxKey_Page_Up},
    {"PREVIOUSCANDIDATE", FcitxKey_PreviousCandidate},
    {"PREVVIRTUALSCREEN", FcitxKey_Prev_Virtual_Screen},
    {"PRINT", FcitxKey_Print},
    {"R1", FcitxKey_R1},
    {"R10", FcitxKey_R10},
    {"R11", FcitxKey_R11},
    {"R12", FcitxKey_R12},
    {"R13", FcitxKey_R13},
    {"R14", FcitxKey_R14},
    {"R15", FcitxKey_R15},
    {"R2", FcitxKey_R2},
    {"R3", FcitxKey_R3},
    {"R4", FcitxKey_R4},
    {"R5", FcitxKey_R5},
    {"R6", FcitxKey_R6},
    {"R7", FcitxKey_R7},
    {"R8", FcitxKey_R8},
    {"R9", FcitxKey_R9},
    {"RALT", FcitxKey_Alt_R},
    {"RCTRL", FcitxKey_Control_R},
    {"REDO", FcitxKey_Redo},
    {"REPEATKEYSENABLE", FcitxKey_RepeatKeys_Enable},
    {"RHYPER", FcitxKey_Hyper_R},
    {"RIGHT", FcitxKey_Right},
    {"RIGHTMIDDLESUMMATION", FcitxKey_rightmiddlesummation},
    {"RMETA", FcitxKey_Meta_R},
    {"ROMAJI", FcitxKey_Romaji},
    {"RSHIFT", FcitxKey_Shift_R},
    {"RSUPER", FcitxKey_Super_R},
    {"SCRIPTSWITCH", FcitxKey_script_switch},
    {"SCROLLLOCK", FcitxKey_Scroll_Lock},
    {"SELECT", FcitxKey_Select},
    {"SERBIANDZE", FcitxKey_Serbian_dze},
    {"SERBIANJE", FcitxKey_Serbian_je},
    {"SERBIANLJE", FcitxKey_Serbian_lje},
    {"SERBIANNJE", FcitxKey_Serbian_nje},
    {"SHIFTLOCK", FcitxKey_Shift_Lock},
    {"SINGLECANDIDATE", FcitxKey_SingleCandidate},
    {"SLOWKEYSENABLE", FcitxKey_SlowKeys_Enable},
    {"SPACE", FcitxKey_space},
    {"STICKYKEYSENABLE", FcitxKey_StickyKeys_Enable},
    {"SYSREQ", FcitxKey_Sys_Req},
    {"TAB", FcitxKey_Tab},
    {"TERMINATESERVER", FcitxKey_Terminate_Server},
    {"THAIMAIHANAKATMAITHO", FcitxKey_Thai_maihanakat_maitho},
    {"TOPLEFTSUMMATION", FcitxKey_topleftsummation},
    {"TOPRIGHTSUMMATION", FcitxKey_toprightsummation},
    {"TOPVERTSUMMATIONCONNECTOR", FcitxKey_topvertsummationconnector},
    {"TOUROKU", FcitxKey_Touroku},
    {"TRADEMARKINCIRCLE", FcitxKey_trademarkincircle},
    {"UKRANIANI", FcitxKey_Ukranian_i},
    {"UKRANIANJE", FcitxKey_Ukranian_je},
    {"UKRANIANYI", FcitxKey_Ukranian_yi},
    {"UNDO", FcitxKey_Undo},
    {"UP", FcitxKey_Up},
    {"ZENKAKU", FcitxKey_Zenkaku},
    {"ZENKAKUHANKAKU", FcitxKey_Zenkaku_Hankaku},
    {"ZENKOHO", FcitxKey_Zen_Koho},
};

#endif
