/*
 * $Id: sig_video.h,v 1.15 2012-03-06 14:46:50 siflkres Exp $
 *
 * Video signal (only the video component of the VGA cable).
 *
 * Copyright (C) 2007-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#ifndef __SIG_VIDEO_H_INCLUDED
#define __SIG_VIDEO_H_INCLUDED

#include <inttypes.h>

#include "sig_gen.h"

struct sig_video_funcs {
	void (*out)(void *s,
			uint8_t r, uint8_t g, uint8_t b);
	void (*vert_retrace)(void *s);
	void (*hor_retrace)(void *s);
	void (*no_sync)(void *s);
};

struct sig_video {
	enum sig_gen_type type;
	struct {
		const struct sig_video_funcs *f;
		void *s;
	} member[20];
	unsigned int member_count;
};

struct sig_video_merge {
	struct sig_video *s0;
	struct sig_video *s1;
};

extern void
sig_video_vert_retrace(struct sig_video *b, void *s);
extern void
sig_video_hor_retrace(struct sig_video *b, void *s);
extern void
sig_video_out(struct sig_video *v, void *s, uint8_t r, uint8_t g, uint8_t b);
extern void
sig_video_no_sync(struct sig_video *b, void *s);

extern void
sig_video_connect(struct sig_video *b, void *s, 
	const struct sig_video_funcs *f);

extern struct sig_video_merge *
sig_video_merge(struct sig_video *s0, struct sig_video *s1);
extern void
sig_video_split(struct sig_video_merge *m);

extern struct sig_video *
sig_video_create(const char *name);
extern void
sig_video_destroy(struct sig_video *sig);

extern void
sig_video_suspend(struct sig_video *b, FILE *fSig);
extern void
sig_video_resume(struct sig_video *b, FILE *fSig);

#endif /* __SIG_VIDEO_H_INCLUDED */
