# *****************************************************************************
# *									      *
# *		ESTIC Makefile for SVR4 / X Window System		      *
# *									      *
# * (C) 1995-97  Ullrich von Bassewitz					      *
# *		 Wacholderweg 14					      *
# *		 D-70597 Stuttgart					      *
# * EMail:	 uz@ibb.schwaben.com					      *
# *									      *
# *****************************************************************************



# $Id$
#
# $Log$
#
#



# ------------------------------------------------------------------------------
# Definitions

# Names of executables
AS = gas
AR = ar
LD = ld
CC = gcc

LIB	= ../spunk/spunk.a
INCDIR	= ../spunk

# Flags for the GNU C compiler
CFLAGS	= -DSVR4 -O2 -Wall -I$(INCDIR) -x c++ -fno-implicit-templates -DEXPLICIT_TEMPLATES

# ------------------------------------------------------------------------------
# Implicit rules

.cc.o:
	$(CC) $(CFLAGS) -c $<

# ------------------------------------------------------------------------------
# All OBJ files

OBJS =		callwin.o	\
		chargwin.o	\
		cliwin.o	\
		devstate.o	\
		estic.o		\
		icac.o		\
		icalias.o	\
		icbaseed.o	\
		iccli.o		\
		icconfig.o	\
		iccom.o		\
		iccprint.o	\
		iccron.o	\
		iccti.o		\
		icdevs.o	\
		icdiag.o	\
		icdlog.o	\
		icei.o		\
		icerror.o	\
		icfile.o	\
		icident.o	\
		icintcon.o	\
		iclog.o		\
		icmsgwin.o	\
		icshort.o	\
		icver.o		\
		imon.o		\
		istecmsg.o

ACOBJ =		../areacode/areacode.o

# ------------------------------------------------------------------------------
#

ifeq (.depend,$(wildcard .depend))
all:	xestic
include .depend
else
all:	depend
endif


xestic: $(LIB) $(OBJS)
	$(CC) -o xestic $(OBJS) $(ACOBJ) $(LIB) -lg++ -lc -lX11 -lnsl -lsocket -L /usr/ucblib -lucb


# ------------------------------------------------------------------------------
# Create a dependency file

depend dep:
	@echo "Creating dependency information"
	$(CC) -I$(INCDIR) -DSVR4 -MM *.cc > .depend

# ------------------------------------------------------------------------------
# Strin the executable

strip:
	strip xestic

# ------------------------------------------------------------------------------
# clean up

clean:
	-rm *.bak *~

zap:	clean
	-rm *.o
	-rm .depend

