/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.xfire.picocontainer;

import java.net.URL;
import java.util.Map;
import javax.xml.namespace.QName;
import org.codehaus.xfire.picocontainer.util.PicoFactory;
import org.codehaus.xfire.service.Service;
import org.codehaus.xfire.service.binding.BindingProvider;
import org.codehaus.xfire.service.binding.ObjectServiceFactory;
import org.codehaus.xfire.service.invoker.FactoryInvoker;
import org.codehaus.xfire.service.invoker.RequestScopePolicy;
import org.codehaus.xfire.service.invoker.ScopePolicy;
import org.codehaus.xfire.transport.TransportManager;
import org.picocontainer.PicoContainer;
import org.picocontainer.defaults.ObjectReference;
import org.picocontainer.defaults.SimpleReference;

public class PicoObjectServiceFactory
extends ObjectServiceFactory {
    private final ObjectReference picoReference;
    private final ScopePolicy scope;

    public PicoObjectServiceFactory(PicoContainer pico) {
        this(PicoObjectServiceFactory.enref(pico));
    }

    public PicoObjectServiceFactory(ObjectReference picoReference) {
        this(PicoObjectServiceFactory.getDefaultScope(), picoReference);
    }

    public PicoObjectServiceFactory(ScopePolicy scope, ObjectReference picoReference) {
        this.scope = scope;
        this.picoReference = picoReference;
    }

    public PicoObjectServiceFactory(PicoContainer pico, TransportManager transportManager, BindingProvider provider) {
        this(PicoObjectServiceFactory.enref(pico), transportManager, provider);
    }

    public PicoObjectServiceFactory(ObjectReference picoReference, TransportManager transportManager, BindingProvider provider) {
        this(PicoObjectServiceFactory.getDefaultScope(), picoReference, transportManager, provider);
    }

    public PicoObjectServiceFactory(ScopePolicy scope, ObjectReference picoReference, TransportManager transportManager, BindingProvider provider) {
        super(transportManager, provider);
        this.scope = scope;
        this.picoReference = picoReference;
    }

    public Service create(Class clazz, String name, String namespace, Map properties) {
        return this.prepare(super.create(clazz, name, namespace, properties));
    }

    public Service create(Class clazz, Map properties) {
        return this.prepare(super.create(clazz, properties));
    }

    public Service create(Class clazz, QName name, URL wsdlUrl, Map properties) {
        return this.prepare(super.create(clazz, name, wsdlUrl, properties));
    }

    public Service create(Class clazz) {
        return this.prepare(super.create(clazz));
    }

    protected Service prepare(Service endpoint) {
        endpoint.setInvoker(new FactoryInvoker(new PicoFactory(this.picoReference, endpoint.getServiceInfo().getServiceClass()), this.scope));
        return endpoint;
    }

    private static ObjectReference enref(PicoContainer pico) {
        SimpleReference result = new SimpleReference();
        result.set((Object)pico);
        return result;
    }

    public static ScopePolicy getDefaultScope() {
        return RequestScopePolicy.instance();
    }
}

