/****************************************************************************
 *    lib/c/Scanner.l - This file is part of coala							*
 *																			*
 *    Copyright (C) 2009  Torsten Grote										*
 *																			*
 *    This program is free software; you can redistribute it and/or modify	*
 *    it under the terms of the GNU General Public License as published by	*
 *    the Free Software Foundation; either version 3 of the License, or		*
 *    (at your option) any later version.									*
 *																			*
 *    This program is distributed in the hope that it will be useful,		*
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of		*
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the			*
 *    GNU General Public License for more details.							*
 *																			*
 *    You should have received a copy of the GNU General Public License		*
 *    along with this program; if not, see http://www.gnu.org/licenses		*
 ****************************************************************************/

%{
#include <stdio.h>
#include "Parser.h"
%}

%option yylineno nounput noyywrap c++ prefix="c"

%s ltl

MOD		mod
IDENTIFIER	  [a-z][a-zA-Z0-9_]*
NEG_IDENTI	\-[a-z][a-zA-Z0-9_]*
NUMBER		[0-9]+
VARIABLE	[A-Z][a-zA-Z0-9_]*
COMMENT		\%.*\n
NOT		not
ACT		<action>
FLU		<fluent>
CAUS	<caused>
IF		<if>
AFTER	<after>
TRUE	<true>
FALSE	<false>
DEF		<default>
INERT	<inertial>
CAUSES	<causes>
ALWAYS	<always>
MAY		<may\ cause>
NONEXE	<nonexecutable>
WHERE	<where>
OC_AT	<occurs\ at>
HO_AT	<holds\ at>
HOLDS	<holds>
OCCURS	<occurs>
NECES	<necessarily>
AT		<at>

%%
[\t\n ]+		// ignore white space.
"LTL:"			{ BEGIN(ltl); return Parser::LTL; }
<ltl>"X"		{ return Parser::X; }
<ltl>"F"		{ return Parser::F; }
<ltl>"G"		{ return Parser::G; }
<ltl>"U"		{ return Parser::U; }
<ltl>"R"		{ return Parser::R; }
{NOT}			{ return Parser::NOT; }
{ACT}			{ return Parser::ACT; }
{FLU}			{ return Parser::FLU; }
{CAUS}			{ return Parser::CAUS; }
{IF}			{ return Parser::IF; }
{AFTER}			{ return Parser::AFTER; }
{TRUE}			{ return Parser::TRUE; }
{FALSE}			{ return Parser::FALSE; }
{DEF}			{ return Parser::DEF; }
{INERT}			{ return Parser::INERT; }
{CAUSES}		{ return Parser::CAUSES; }
{ALWAYS}		{ return Parser::ALWAYS; }
{MAY}			{ return Parser::MAY; }
{NONEXE}		{ return Parser::NONEXE; }
{WHERE}			{ return Parser::WHERE; }
{OC_AT}			{ return Parser::OC_AT; }
{HO_AT}			{ return Parser::HO_AT; }
{OCCURS}		{ return Parser::OCCURS; }
{HOLDS}			{ return Parser::HOLDS; }
{NECES}			{ return Parser::NECES; }
{AT}			{ return Parser::AT; }
{MOD}			{ return Parser::MOD; }
{IDENTIFIER}	{ return Parser::IDENTIFIER; }
{NEG_IDENTI}	{ return Parser::NEG_IDENTI; }
{NUMBER}		{ return Parser::NUMBER; }
{VARIABLE}		{ return Parser::VARIABLE; }
","				{ return Parser::COMMA; }
";"				{ return Parser::SEMIC; }
":"				{ return Parser::COLON; }
".."			{ return Parser::DDOT; }
"."				{ BEGIN(0); return Parser::DOT; }
"("				{ return Parser::LBRAC; }
")"				{ return Parser::RBRAC; }
"=="			{ return Parser::EQ; }
"!="			{ return Parser::NEQ; }
"<"				{ return Parser::LT; }
">"				{ return Parser::GT; }
"<="			{ return Parser::LE; }
">="			{ return Parser::GE; }
"+"				{ return Parser::PLUS; }
"-"				{ return Parser::MINUS; }
"*"				{ return Parser::TIMES; }
"/"				{ return Parser::DIV; }
"&"				{ return Parser::AND; }
"?"				{ return Parser::OR; }
"^"				{ return Parser::XOR; }
"!"				{ return Parser::LTLNOT; }
"|"				{ return Parser::LTLOR; }
"->"			{ return Parser::IMPL; }
"<->"			{ return Parser::EQUIV; }
{COMMENT}		{ /* comment */ }
<<EOF>>         { yyterminate(); }
.				{ cerr << "\n\nError: Unknown keyword '"+string(yytext)+"' found at line "<<lineno()<<".\n";
				  exit(2);
				}
%%
