/*
//
//  Copyright 1997-2012 Torsten Rohlfing
//
//  Copyright 2004-2010 SRI International
//
//  This file is part of the Computational Morphometry Toolkit.
//
//  http://www.nitrc.org/projects/cmtk/
//
//  The Computational Morphometry Toolkit is free software: you can
//  redistribute it and/or modify it under the terms of the GNU General Public
//  License as published by the Free Software Foundation, either version 3 of
//  the License, or (at your option) any later version.
//
//  The Computational Morphometry Toolkit is distributed in the hope that it
//  will be useful, but WITHOUT ANY WARRANTY; without even the implied
//  warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License along
//  with the Computational Morphometry Toolkit.  If not, see
//  <http://www.gnu.org/licenses/>.
//
//  $Revision: 4276 $
//
//  $LastChangedDate: 2012-04-29 12:52:17 -0700 (Sun, 29 Apr 2012) $
//
//  $LastChangedBy: torsten_at_home $
//
*/

#ifndef __cmtkQRDecomposition_h_included_
#define __cmtkQRDecomposition_h_included_

#include <cmtkconfig.h>

#include <Base/cmtkMatrix.h>
#include <Base/cmtkFixedSquareMatrix.h>

#include "Numerics/ap.h"

namespace
cmtk
{

/** \addtogroup Base */
//@{

/** Compute the QRDecomposition of a matrix
 */  
template<class TFloat>
class QRDecomposition
{
public:
  /// This class.
  typedef QRDecomposition<TFloat> Self;

  /// Matrix type
  typedef Matrix2D<TFloat> MatrixType;

  /// Constructor: compute QR decomposition of given matrix.
  QRDecomposition( const typename Self::MatrixType& matrix );

  /// Constructor: compute QR decomposition of given matrix.
  template<size_t NDIM> QRDecomposition( const FixedSquareMatrix<NDIM,TFloat>& matrix );

  /// Get the Q factor 
  typename Self::MatrixType& GetQ();
  
  /// Get the R factor 
  typename Self::MatrixType& GetR(); 

private:
  /// Number of rows in the input matrix
  size_t m_Rows; 

  /// Number of columns in the input matrix
  size_t m_Cols;

  /// Alglib compact QR representation
  ap::real_2d_array m_CompactQR;

  /// Alglib tau array (generated by rmatrixqr, needed to compute Q)
  ap::real_1d_array m_Tau;

  /// Q matrix.
  typename Self::MatrixType::SmartPtr m_Q;
  
  /// R matrix.
  typename Self::MatrixType::SmartPtr m_R;
};

//@}

} // namespace cmtk

#include "cmtkQRDecomposition.txx"

#endif // #ifndef __cmtkQRDecomposition_h_included_
