include(manual.h)dnl
HEADER(poncho_package_analyze)

SECTION(NAME)

BOLD(poncho_package_analyze) - command-line utility for analyzing Python script for library and interpreter dependencies

SECTION(SYNOPSIS)

CODE(poncho_package_analyze [options] PARAM(python-script ...)  PARAM(json-output-file))

SECTION(DESCRIPTION)

BOLD(poncho_package_analyze) is a simple command line utility for analyzing Python scripts for the necessary external dependencies. It generates an output file that can be used with python_package_create to build a self-contained Conda environment for the Python application.

The CODE(python-script ...) argument is the path(s) to the Python script(s) to be analyzed. The CODE(json-output-file) argument is the path to the output JSON file that will be generated by the command. Specifying - for either will use stdin/stdout instead of a file.

SECTION(OPTIONS)

OPTIONS_BEGIN
OPTION_FLAG(h,help) Show this help message
OPTION_FLAG_LONG(toplevel) Only include imports at the top level of the script.
OPTION_ARG_LONG(function,PARAM(fn)) Only include imports in the given function.
OPTION_ARG_LONG(pkg-mapping,PARAM(import=name)) Specify that the module imported as PARAM(import) in the code is provided by the pip/conda package PARAM(name).
OPTION_ARG_LONG(extra-pkg,pkg) Also include the pip/conda package PARAM(pkg), even if it does not appear in the sources. May be useful for scripts that execute other (possibly non-Python) components that must also be included.
OPTIONS_END

SECTION(EXIT)

On success, returns zero. On failure, returns non-zero.

SECTION(EXAMPLE)
An example Python script CODE(example.py) contains the following code:

LONGCODE_BEGIN
import os
import sys
import pickle

import antigravity
import matplotlib


if __name__ == "__main__":
    print("example")
LONGCODE_END

To analyze the CODE(example.py) script for its dependencies and generate the output JSON dependencies file CODE(dependencies.json), run the following command:

CODE($ poncho_package_analyze example.py dependencies.json)

Once the command completes, the CODE(dependencies.json) file within the current working directory will contain a Conda environment specification
(suitable to use with CODE(conda env create)).

Note that system-level modules are considered part of the Python package installed into the Conda environment.
Additionally, imports not managed by Pip or Conda are not allowed.
This includes other modules within the CWD or in user-written packages.


SECTION(COPYRIGHT)

COPYRIGHT_BOILERPLATE

FOOTER

