# -*- coding: utf-8 -*-
# Balazar in the Rancid Skull Dungeon
# Copyright (C) 2008 Jean-Baptiste LAMY
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

import os, sys, time
import PIL, PIL.Image




nb_colors = 32

character = "balazar_gourdin"
#character = "balazar_gros_gourdin"
#character = "balazar_massue"
#character = "echassien"
#character = "divers"
#character = "font"
#character = "item"
#character = "coffre1"

i = 1
while i < len(sys.argv):
  if   sys.argv[i] == "--nb-colors"   : i += 1; nb_colors = int(sys.argv[i])
  elif sys.argv[i] == "--name"        : i += 1; character =     sys.argv[i]
  i += 1


sprites  = []
spritesd = {}

if   character == "font":
  s = u"0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZéèëêàâäôöîïùûüç+-_()%,.;:!?<>&'\"*\\/@"
  animation_nb_angles = [
    (char,  1, [0]) for char in s
    ]
else:
  animation_nb    = {}
  animation_angle = {}
  for file in os.listdir("/home/jiba/tmp/balazar3_sprites"):
    if file.startswith(character + "_") and file.endswith(".info"):
      angle, animation = file[len(character) + 1:-5].split("_", 1)
      if not animation_angle.has_key(animation): animation_angle[animation] = []
      animation_angle[animation].append(int(angle))
      animation_nb   [animation] = 1 + int(open(os.path.join("/home/jiba/tmp/balazar3_sprites", file)).read().strip().count("\n"))
      
  animation_nb_angles = [(animation, animation_nb[animation], animation_angle[animation]) for animation in animation_nb.keys()]
  
  for i in animation_nb_angles:
    print i
    

for animation, nb, angles in animation_nb_angles:
  if   animation == "/" : animation_f = "slash"
  elif animation == "\\": animation_f = "backslash"
  else:                   animation_f = animation
  for angle in angles:
    coords = []
    for line in open("/home/jiba/tmp/balazar3_sprites/%s_%s_%s.info" % (character, angle, animation_f)).read().split("\n"):
      if line: coords.append([int(word) for word in line.split()][:2])
      
    for i in range(nb):
      sprite = PIL.Image.open("/home/jiba/tmp/balazar3_sprites/%s_%s_%s_%s.png" % (character, angle, animation_f, i))
      sprite.angle     = angle
      sprite.animation = animation
      sprite.i         = i
      sprite.coords    = coords[i]
      spritesd[angle, animation, i] = sprite
      if   (animation == "mort"  ) and (i <  4): pass
      elif (animation == "couic" ) and (i == 0): pass
      elif (animation == "frappe") and (i == 0): pass
      else:
        sprites.append(sprite)

animations = set([animation for animation, nb, angles in animation_nb_angles])
if "frappe" in animations:
  for angle in [0, 90, 180, 270]:
    spritesd[angle, "frappe", 0] = spritesd[angle, "attente", 0]
if "couic" in animations:
  for angle in [0, 90, 180, 270]:
    spritesd[angle, "couic", 0] = spritesd[angle, "couic", 1]
if "mort" in animations:
  for angle in [0, 90, 180, 270]:
    for i in range(4):
      spritesd[angle, "mort", i] = spritesd[angle, "couic", i]

sprites.sort(lambda a, b: cmp(a.size[1], b.size[1]))

def do(task, max_width):
  x = 0
  width  = 0
  height = 0
  line      = [(0, 1000000, 0)]
  next_line = []
  for sprite in sprites:
    y0s = []
    for (x0, x1, y0) in line:
      if (x + sprite.size[0] > x0) and (x < x1):
        y0s.append(y0)
    y = max(y0s)
    next_line.append((x, x + sprite.size[0], y + sprite.size[1]))

    task(sprite, x, y)
    
    x    += sprite.size[0]
    width = max(width, x)
    
    if x > max_width:
      x         = 0
      line      = next_line
      next_line = []
      
  height = max([y0 for (x0, x1, y0) in line + next_line])
  return width, height

def do(task, max_width):
  x = 0
  y = 0
  h = 0
  width  = 0
  height = 0
  for sprite in sprites:
    h = max(h, sprite.size[1])
    task(sprite, x, y)
    
    x    += sprite.size[0]
    width = max(width, x)
    
    if x > max_width:
      x         = 0
      y        += h
      h         = 0
      
  height = y + h
  return width, height

l = []
for max_width in range(50, 3000, 1):
  width, height = do(lambda *args: None, max_width)
  l.append((width * height, width, height, max_width))
l.sort()
print l
size, width, height, max_width = l[0]

print l[0]
big = PIL.Image.new("RGBA", (width, height))

def task(sprite, x, y):
  sprite.x = x
  sprite.y = y
  big.paste(sprite, (x, y))
  
width, height = do(task, max_width)
print   width, height

#big.save("./balazar3/sprites/%s.png" % character)
sprite_rgba = "/home/jiba/tmp/balazar3_sprites/%s.png" % character
sprite_i    = "./balazar3/sprites/%s.png" % character
big.save(sprite_rgba)
cmd = """gimp --no-interface --batch "(python-fu-eval 1 \\\"print 12; image = pdb.gimp_file_load('%s', '%s'); pdb.gimp_convert_indexed(image, 0, 0, %s, 0, False, ''); drawable = pdb.gimp_image_active_drawable(image); pdb.file_png_save(image, drawable, '%s', '%s', 0, 9, 0, 0, 0, 0, 0); print 13\\\") (gimp-quit 0)" """ % (sprite_rgba, sprite_rgba, nb_colors, sprite_i, sprite_i)
print cmd
os.system(cmd)


# l = []
# for animation, nb, angles in animation_nb_angles:
#   for angle in angles:
#     if isinstance(animation, unicode): animation_ = animation.encode("utf8")
#     else:                              animation_ = animation
#     l.append("%s %s %s" % (animation_, angle, nb))
#     for i in range(nb):
#       sprite = spritesd[angle, animation, i]
#       l.append("%s %s %s %s %s %s" % (sprite.x, sprite.y, sprite.size[0], sprite.size[1], sprite.coords[0], sprite.coords[1]))

# open("./balazar3/sprites/%s_big.info" % character, "w").write("\n".join(l))


animation_nb = {}
coords       = {}
for animation, nb, angles in animation_nb_angles:
  animation_nb[animation] = nb
  for angle in angles:
    for i in range(nb):
      sprite = spritesd[angle, animation, i]
      coords[animation, angle, i] = (sprite.x, sprite.y, sprite.size[0], sprite.size[1], sprite.coords[0], sprite.coords[1])
      
open("./balazar3/sprites/%s.py" % character, "w").write((u"""# -*- coding: utf-8 -*-
animation_nb = %s
coords = %s
""" % (animation_nb, coords)).encode("utf8"))

