/*###############################################################################
# Linux Management Providers (LMP), IP provider package
# Copyright (C) 2007 Ilsoo Byun <widepis@etri.re.kr ,widepis@empal.com>
# 
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
# 
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
# 
# Modified by 2008 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr, guillaumebottex@gmail.com>
###############################################################################*/

#ifndef OPENDRIM_IP2GATEWAY_H_
#define OPENDRIM_IP2GATEWAY_H_

#include <Association.h>

// Direct Invocation includes, may have to be adjusted
/*
#include "cmpiCIM_RemoteServiceAccessPoint.h"
#include "CIM_RemoteServiceAccessPointAccess.h"
#include "cmpiCIM_EnabledLogicalElement.h"
#include "CIM_EnabledLogicalElementAccess.h"
*/

const static char* OpenDRIM_IP2Gateway_classnames[] = {"OpenDRIM_IP2Gateway"};
static string OpenDRIM_IP2Gateway_NAMESPACE = _NAMESPACE;
const static string Antecedent_role = "Antecedent";
const static char* Antecedent_classnames[] = {"OpenDRIM_Gateway"};
const static string Antecedent_NAMESPACE = _NAMESPACE;

const static string Dependent_role = "Dependent";
const static char* Dependent_classnames[] = {"OpenDRIM_IPProtocolEndpoint"};
const static string Dependent_NAMESPACE = _NAMESPACE;

class OpenDRIM_IP2Gateway {

public:
	
	Objectpath Antecedent;
	bool Antecedent_isNULL;
	
	Objectpath Dependent;
	bool Dependent_isNULL;
	
	bool IsDefault;
	bool IsDefault_isNULL;
	
	unsigned short OrderOfAccess;
	bool OrderOfAccess_isNULL;
	
	OpenDRIM_IP2Gateway() {
		Antecedent_isNULL = true;
		Dependent_isNULL = true;
		IsDefault_isNULL = true;
		OrderOfAccess_isNULL = true;
	}
	
	~OpenDRIM_IP2Gateway() {}
	
	string getKeys() const {
		return CF_toLowCase(".Antecedent=\"" + CF_quoteString(Antecedent.toString()) + "\""".Dependent=\"" + CF_quoteString(Dependent.toString()) + "\"");
	}

	int getAntecedent(Objectpath& value) const {
		if (Antecedent_isNULL==true)
			return NOT_FOUND;
		value = Antecedent;
		return OK;
	}
	
	int setAntecedent(const Objectpath& newValue) {
		Antecedent = newValue;
		Antecedent.setNamespace(Antecedent_NAMESPACE);
		Antecedent_isNULL = false;
		return OK;
	}

	int getDependent(Objectpath& value) const {
		if (Dependent_isNULL==true)
			return NOT_FOUND;
		value = Dependent;
		return OK;
	}
	
	int setDependent(const Objectpath& newValue) {
		Dependent = newValue;
		Dependent.setNamespace(Dependent_NAMESPACE);
		Dependent_isNULL = false;
		return OK;
	}

	int getIsDefault(bool& value) const {
		if (IsDefault_isNULL==true)
			return NOT_FOUND;
		value = IsDefault;
		return OK;
	}
	
	int setIsDefault(const bool& newValue) {
		IsDefault = newValue;
		IsDefault_isNULL = false;
		return OK;
	}

	int getOrderOfAccess(unsigned short& value) const {
		if (OrderOfAccess_isNULL==true)
			return NOT_FOUND;
		value = OrderOfAccess;
		return OK;
	}
	
	int setOrderOfAccess(const unsigned short& newValue) {
		OrderOfAccess = newValue;
		OrderOfAccess_isNULL = false;
		return OK;
	}

};

#endif /*OPENDRIM_IP2GATEWAY_H_*/
