/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.adapter;

import java.io.File;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.birt.core.data.ExpressionUtil;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.core.script.JavascriptEvalUtil;
import org.eclipse.birt.core.script.ScriptExpression;
import org.eclipse.birt.data.engine.api.IBaseDataSetDesign;
import org.eclipse.birt.data.engine.api.IBaseDataSourceDesign;
import org.eclipse.birt.data.engine.api.IBaseExpression;
import org.eclipse.birt.data.engine.api.IColumnDefinition;
import org.eclipse.birt.data.engine.api.IComputedColumn;
import org.eclipse.birt.data.engine.api.IDataScriptEngine;
import org.eclipse.birt.data.engine.api.IFilterDefinition;
import org.eclipse.birt.data.engine.api.IInputParameterBinding;
import org.eclipse.birt.data.engine.api.IOdaDataSetDesign;
import org.eclipse.birt.data.engine.api.IOdaDataSourceDesign;
import org.eclipse.birt.data.engine.api.IParameterDefinition;
import org.eclipse.birt.data.engine.api.IScriptDataSetDesign;
import org.eclipse.birt.data.engine.api.IScriptDataSourceDesign;
import org.eclipse.birt.data.engine.api.IScriptExpression;
import org.eclipse.birt.data.engine.api.aggregation.AggregationManager;
import org.eclipse.birt.data.engine.api.aggregation.IAggrFunction;
import org.eclipse.birt.data.engine.api.aggregation.IParameterDefn;
import org.eclipse.birt.data.engine.api.querydefn.BaseDataSetDesign;
import org.eclipse.birt.data.engine.api.querydefn.BaseDataSourceDesign;
import org.eclipse.birt.data.engine.api.querydefn.ColumnDefinition;
import org.eclipse.birt.data.engine.api.querydefn.ComputedColumn;
import org.eclipse.birt.data.engine.api.querydefn.ConditionalExpression;
import org.eclipse.birt.data.engine.api.querydefn.FilterDefinition;
import org.eclipse.birt.data.engine.api.querydefn.InputParameterBinding;
import org.eclipse.birt.data.engine.api.querydefn.OdaDataSetDesign;
import org.eclipse.birt.data.engine.api.querydefn.OdaDataSourceDesign;
import org.eclipse.birt.data.engine.api.querydefn.ParameterDefinition;
import org.eclipse.birt.data.engine.api.querydefn.ScriptDataSetDesign;
import org.eclipse.birt.data.engine.api.querydefn.ScriptDataSourceDesign;
import org.eclipse.birt.data.engine.api.script.IBaseDataSetEventHandler;
import org.eclipse.birt.data.engine.api.script.IBaseDataSourceEventHandler;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.report.data.adapter.api.DataAdapterUtil;
import org.eclipse.birt.report.data.adapter.api.DataRequestSession;
import org.eclipse.birt.report.engine.api.EngineException;
import org.eclipse.birt.report.engine.data.dte.DteDataEngine;
import org.eclipse.birt.report.engine.executor.ExecutionContext;
import org.eclipse.birt.report.engine.script.internal.DataSetScriptExecutor;
import org.eclipse.birt.report.engine.script.internal.DataSourceScriptExecutor;
import org.eclipse.birt.report.engine.script.internal.ScriptDataSetScriptExecutor;
import org.eclipse.birt.report.engine.script.internal.ScriptDataSourceScriptExecutor;
import org.eclipse.birt.report.model.api.AggregationArgumentHandle;
import org.eclipse.birt.report.model.api.ColumnHintHandle;
import org.eclipse.birt.report.model.api.ComputedColumnHandle;
import org.eclipse.birt.report.model.api.DataSetHandle;
import org.eclipse.birt.report.model.api.DataSetParameterHandle;
import org.eclipse.birt.report.model.api.DataSourceHandle;
import org.eclipse.birt.report.model.api.DerivedDataSetHandle;
import org.eclipse.birt.report.model.api.Expression;
import org.eclipse.birt.report.model.api.ExtendedPropertyHandle;
import org.eclipse.birt.report.model.api.FilterConditionHandle;
import org.eclipse.birt.report.model.api.JointDataSetHandle;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.OdaDataSetHandle;
import org.eclipse.birt.report.model.api.OdaDataSetParameterHandle;
import org.eclipse.birt.report.model.api.OdaDataSourceHandle;
import org.eclipse.birt.report.model.api.ParamBindingHandle;
import org.eclipse.birt.report.model.api.ParameterHandle;
import org.eclipse.birt.report.model.api.ReportElementHandle;
import org.eclipse.birt.report.model.api.ResultSetColumnHandle;
import org.eclipse.birt.report.model.api.ScalarParameterHandle;
import org.eclipse.birt.report.model.api.ScriptDataSetHandle;
import org.eclipse.birt.report.model.api.ScriptDataSourceHandle;
import org.eclipse.birt.report.model.api.metadata.IPropertyDefn;
import org.eclipse.datatools.connectivity.oda.util.ResourceIdentifiers;
import org.mozilla.javascript.Scriptable;

public class ModelDteApiAdapter {
    private ExecutionContext context;
    private Scriptable jsScope;
    private DataRequestSession dteSession;

    public static ModelDteApiAdapter getInstance() {
        return new ModelDteApiAdapter();
    }

    public IBaseDataSourceDesign createDataSourceDesign(DataSourceHandle dataSource, ExecutionContext context) throws EngineException {
        try {
            ModelDteApiAdapter tmpAdaptor = new ModelDteApiAdapter(context, null);
            return tmpAdaptor.createDataSourceDesign(dataSource);
        }
        catch (BirtException e) {
            throw new EngineException(e);
        }
    }

    public ModelDteApiAdapter() {
    }

    public ModelDteApiAdapter(ExecutionContext context, Scriptable jsScope) {
        this.context = context;
        this.jsScope = jsScope;
    }

    public ModelDteApiAdapter(ExecutionContext context) throws BirtException {
        this.context = context;
        this.jsScope = ((IDataScriptEngine)context.getScriptContext().getScriptEngine("javascript")).getJSScope(context.getScriptContext());
    }

    public IBaseDataSourceDesign createDataSourceDesign(DataSourceHandle dataSource) throws BirtException {
        BaseDataSourceDesign datasourceDesign = this.dteSession.getModelAdaptor().adaptDataSource(dataSource);
        DataSourceScriptExecutor eventHandler = null;
        if (dataSource instanceof OdaDataSourceHandle) {
            eventHandler = new DataSourceScriptExecutor(dataSource, this.context);
        } else if (dataSource instanceof ScriptDataSourceHandle) {
            eventHandler = new ScriptDataSourceScriptExecutor((ScriptDataSourceHandle)dataSource, this.context);
        }
        datasourceDesign.setEventHandler(eventHandler);
        return datasourceDesign;
    }

    public IBaseDataSetDesign appendRuntimeInfoToDataSet(DataSetHandle handle, BaseDataSetDesign dataSet) throws BirtException {
        if (dataSet instanceof OdaDataSetDesign) {
            return this.newOdaDataSet((OdaDataSetHandle)handle, (OdaDataSetDesign)dataSet, this.context);
        }
        if (dataSet instanceof ScriptDataSetDesign) {
            return this.newScriptDataSet((ScriptDataSetHandle)handle, (ScriptDataSetDesign)dataSet, this.context);
        }
        return this.newGeneralDataSet(handle, dataSet);
    }

    public void defineDataSet(DataSetHandle dataSet, DataRequestSession dteSession) throws BirtException {
        if (dataSet == null || dteSession == null) {
            return;
        }
        this.dteSession = dteSession;
        DataSourceHandle dataSource = dataSet.getDataSource();
        if (dataSource != null) {
            this.doDefineDataSource(dataSource);
        }
        this.doDefineDataSet(dataSet);
    }

    private void doDefineDataSource(DataSourceHandle dataSource) throws BirtException {
        this.dteSession.defineDataSource(this.createDataSourceDesign(dataSource));
    }

    private void doDefineDataSet(DataSetHandle dataSet) throws BirtException {
        if (dataSet instanceof JointDataSetHandle) {
            JointDataSetHandle jointDataSet = (JointDataSetHandle)dataSet;
            Iterator iter = jointDataSet.dataSetsIterator();
            while (iter.hasNext()) {
                DataSetHandle childDataSet = (DataSetHandle)iter.next();
                if (childDataSet == null) continue;
                DataSourceHandle childDataSource = childDataSet.getDataSource();
                if (childDataSource != null) {
                    this.doDefineDataSource(childDataSource);
                }
                this.doDefineDataSet(childDataSet);
            }
        } else if (dataSet instanceof DerivedDataSetHandle) {
            DerivedDataSetHandle handle = (DerivedDataSetHandle)dataSet;
            for (DataSetHandle childDataSet : handle.getInputDataSets()) {
                if (childDataSet == null) continue;
                DataSourceHandle childDataSource = childDataSet.getDataSource();
                if (childDataSource != null) {
                    this.doDefineDataSource(childDataSource);
                }
                this.doDefineDataSet(childDataSet);
            }
        }
        this.dteSession.defineDataSet(this.appendRuntimeInfoToDataSet(dataSet, this.dteSession.getModelAdaptor().adaptDataSet(dataSet)));
    }

    private IBaseDataSetDesign newGeneralDataSet(DataSetHandle handle, BaseDataSetDesign dteDataSet) throws BirtException {
        DataSetScriptExecutor eventHandler = new DataSetScriptExecutor(handle, this.context);
        dteDataSet.setEventHandler((IBaseDataSetEventHandler)eventHandler);
        return dteDataSet;
    }

    String evaluatePropertyBindingExpr(String expr) throws BirtException {
        Object result = JavascriptEvalUtil.evaluateScript(null, (Scriptable)this.jsScope, (String)expr, (String)ScriptExpression.defaultID, (int)0);
        return result == null ? null : result.toString();
    }

    IOdaDataSourceDesign newOdaDataSource(OdaDataSourceHandle source) throws BirtException {
        Iterator elmtIter;
        this.setResourceIDtoDataSourceHandle(source);
        OdaDataSourceDesign dteSource = new OdaDataSourceDesign(source.getQualifiedName());
        DataSourceScriptExecutor eventHandler = new DataSourceScriptExecutor((DataSourceHandle)source, this.context);
        dteSource.setEventHandler((IBaseDataSourceEventHandler)eventHandler);
        this.adaptBaseDataSource((DataSourceHandle)source, (BaseDataSourceDesign)dteSource);
        String driverName = source.getExtensionID();
        if (driverName == null || driverName.length() == 0) {
            throw new EngineException("Error.ExtentionIDMissingError", source.getName());
        }
        dteSource.setExtensionID(driverName);
        Map staticProps = this.getExtensionProperties((ReportElementHandle)source, source.getExtensionPropertyDefinitionList());
        if (staticProps != null && !staticProps.isEmpty()) {
            for (Map.Entry entry : staticProps.entrySet()) {
                String propName = (String)entry.getKey();
                assert (propName != null);
                Expression expr = source.getPropertyBindingExpression(propName);
                String bindingExpr = this.getExpressionValue(expr);
                String propValue = this.needPropertyBinding() && bindingExpr != null && bindingExpr.length() > 0 && this.context.getDataEngine() instanceof DteDataEngine ? this.evaluatePropertyBindingExpr(bindingExpr) : (String)entry.getValue();
                dteSource.addPublicProperty(propName, propValue);
            }
        }
        if ((elmtIter = source.privateDriverPropertiesIterator()) != null) {
            while (elmtIter.hasNext()) {
                ExtendedPropertyHandle modelProp = (ExtendedPropertyHandle)elmtIter.next();
                dteSource.addPrivateProperty(modelProp.getName(), modelProp.getValue());
            }
        }
        this.addPropertyConfigurationId(dteSource, source);
        return dteSource;
    }

    private String getExpressionValue(Expression expr) {
        if (expr == null) {
            return null;
        }
        if ("constant".equals(expr.getType())) {
            return JavascriptEvalUtil.transformToJsExpression((String)expr.getStringExpression());
        }
        return expr.getStringExpression();
    }

    private void setResourceIDtoDataSourceHandle(OdaDataSourceHandle source) {
        if (this.dteSession.getDataSessionContext().getAppContext() == null) {
            this.dteSession.getDataSessionContext().setAppContext(new HashMap());
        }
        if (!this.dteSession.getDataSessionContext().getAppContext().containsKey("org.eclipse.datatools.connectivity.oda.util_consumerResourceIds")) {
            this.dteSession.getDataSessionContext().getAppContext().put("org.eclipse.datatools.connectivity.oda.util_consumerResourceIds", ModelDteApiAdapter.createResourceIdentifiers(source.getModuleHandle()));
        }
    }

    private static ResourceIdentifiers createResourceIdentifiers(ModuleHandle handle) {
        if (handle == null) {
            return null;
        }
        try {
            ResourceIdentifiers identifiers = new ResourceIdentifiers();
            if (handle.getSystemId() != null) {
                identifiers.setDesignResourceBaseURI(handle.getSystemId().toURI());
            }
            if (handle.getResourceFolder() != null) {
                identifiers.setApplResourceBaseURI(new File(handle.getResourceFolder()).toURI());
            }
            return identifiers;
        }
        catch (URISyntaxException uRISyntaxException) {
            return null;
        }
    }

    private void addPropertyConfigurationId(OdaDataSourceDesign dteSource, OdaDataSourceHandle sourceHandle) throws BirtException {
        String configIdValue = String.valueOf(dteSource.getExtensionID()) + "_" + sourceHandle.getName();
        dteSource.addPublicProperty("OdaPropertyConfigId", configIdValue);
    }

    IScriptDataSourceDesign newScriptDataSource(ScriptDataSourceHandle source) throws BirtException {
        ScriptDataSourceDesign dteSource = new ScriptDataSourceDesign(source.getQualifiedName());
        ScriptDataSourceScriptExecutor eventHandler = new ScriptDataSourceScriptExecutor(source, this.context);
        dteSource.setEventHandler((IBaseDataSourceEventHandler)eventHandler);
        this.adaptBaseDataSource((DataSourceHandle)source, (BaseDataSourceDesign)dteSource);
        dteSource.setOpenScript(source.getOpen());
        dteSource.setCloseScript(source.getClose());
        return dteSource;
    }

    void adaptBaseDataSource(DataSourceHandle source, BaseDataSourceDesign dest) {
        dest.setBeforeOpenScript(source.getBeforeOpen());
        dest.setAfterOpenScript(source.getAfterOpen());
        dest.setBeforeCloseScript(source.getBeforeClose());
        dest.setAfterCloseScript(source.getAfterClose());
    }

    IOdaDataSetDesign newOdaDataSet(OdaDataSetHandle modelDataSet, OdaDataSetDesign dteDataSet, ExecutionContext context) throws BirtException {
        Map staticProps;
        DataSetScriptExecutor eventHandler = new DataSetScriptExecutor((DataSetHandle)modelDataSet, context);
        dteDataSet.setEventHandler((IBaseDataSetEventHandler)eventHandler);
        Expression expression = modelDataSet.getPropertyBindingExpression("queryText");
        String queryTextBinding = this.getExpressionValue(expression);
        if (this.needPropertyBinding() && queryTextBinding != null && queryTextBinding.length() > 0 && context.getDataEngine() instanceof DteDataEngine) {
            dteDataSet.setQueryText(this.evaluatePropertyBindingExpr(queryTextBinding));
        }
        if ((staticProps = this.getExtensionProperties((ReportElementHandle)modelDataSet, modelDataSet.getExtensionPropertyDefinitionList())) != null && !staticProps.isEmpty()) {
            for (String propName : staticProps.keySet()) {
                assert (propName != null);
                Expression expr = modelDataSet.getPropertyBindingExpression(propName);
                String bindingExpr = this.getExpressionValue(expr);
                if (!this.needPropertyBinding() || bindingExpr == null || bindingExpr.length() <= 0) continue;
                String propValue = this.evaluatePropertyBindingExpr(bindingExpr);
                dteDataSet.addPublicProperty(propName, propValue);
            }
        }
        return dteDataSet;
    }

    IScriptDataSetDesign newScriptDataSet(ScriptDataSetHandle modelDataSet, ScriptDataSetDesign dteDataSet, ExecutionContext context) throws BirtException {
        ScriptDataSetScriptExecutor eventHandler = new ScriptDataSetScriptExecutor(modelDataSet, context);
        dteDataSet.setEventHandler((IBaseDataSetEventHandler)eventHandler);
        return dteDataSet;
    }

    private Iterator populateParameter(DataSetHandle modelDataSet, BaseDataSetDesign dteDataSet) throws BirtException {
        HashMap<String, org.eclipse.birt.data.engine.api.querydefn.ScriptExpression> paramBindingCandidates = new HashMap<String, org.eclipse.birt.data.engine.api.querydefn.ScriptExpression>();
        Iterator elmtIter = modelDataSet.parametersIterator();
        if (elmtIter != null) {
            while (elmtIter.hasNext()) {
                DataSetParameterHandle modelParam = (DataSetParameterHandle)elmtIter.next();
                if (modelParam.isInput()) {
                    String defaultValueExpr = null;
                    if (modelParam instanceof OdaDataSetParameterHandle) {
                        String linkedReportParam = ((OdaDataSetParameterHandle)modelParam).getParamName();
                        if (linkedReportParam != null) {
                            ParameterHandle ph = modelDataSet.getModuleHandle().findParameter(linkedReportParam);
                            if (ph instanceof ScalarParameterHandle && ((ScalarParameterHandle)ph).getParamType().equals("multi-value")) {
                                throw new DataException("data.engine.LinkedReportParamAllowMultiValues", (Object[])new String[]{linkedReportParam, modelParam.getName()});
                            }
                            defaultValueExpr = ExpressionUtil.createJSParameterExpression((String)((OdaDataSetParameterHandle)modelParam).getParamName());
                        } else {
                            defaultValueExpr = this.getExpressionDefaultValue(modelParam);
                        }
                    } else {
                        defaultValueExpr = this.getExpressionDefaultValue(modelParam);
                    }
                    dteDataSet.addParameter(this.newParam(modelParam));
                    paramBindingCandidates.put(modelParam.getName(), new org.eclipse.birt.data.engine.api.querydefn.ScriptExpression(defaultValueExpr, DataAdapterUtil.modelDataTypeToCoreDataType((String)modelParam.getDataType())));
                    continue;
                }
                dteDataSet.addParameter(this.newParam(modelParam));
            }
        }
        if ((elmtIter = modelDataSet.paramBindingsIterator()) != null) {
            while (elmtIter.hasNext()) {
                ParamBindingHandle modelParamBinding = (ParamBindingHandle)elmtIter.next();
                paramBindingCandidates.put(modelParamBinding.getParamName(), new org.eclipse.birt.data.engine.api.querydefn.ScriptExpression(modelParamBinding.getExpression()));
            }
        }
        if (paramBindingCandidates.size() > 0) {
            elmtIter = paramBindingCandidates.keySet().iterator();
            while (elmtIter.hasNext()) {
                Object paramName = elmtIter.next();
                assert (paramName != null && paramName instanceof String);
                org.eclipse.birt.data.engine.api.querydefn.ScriptExpression expression = (org.eclipse.birt.data.engine.api.querydefn.ScriptExpression)paramBindingCandidates.get(paramName);
                dteDataSet.addInputParamBinding(this.newInputParamBinding((String)paramName, expression));
            }
        }
        return elmtIter;
    }

    private String getExpressionDefaultValue(DataSetParameterHandle modelParam) {
        if ("constant".equals(modelParam.getExpressionProperty("defaultValue").getType())) {
            return JavascriptEvalUtil.transformToJsExpression((String)modelParam.getDefaultValue());
        }
        return modelParam.getDefaultValue();
    }

    private void populateComputedColumn(DataSetHandle modelDataSet, BaseDataSetDesign dteDataSet) throws EngineException {
        Iterator elmtIter = modelDataSet.computedColumnsIterator();
        if (elmtIter != null) {
            while (elmtIter.hasNext()) {
                ComputedColumnHandle modelCmptdColumn = (ComputedColumnHandle)elmtIter.next();
                IComputedColumn dteCmptdColumn = this.newComputedColumn(modelCmptdColumn);
                dteDataSet.addComputedColumn(dteCmptdColumn);
            }
        }
    }

    private void populateFilter(DataSetHandle modelDataSet, BaseDataSetDesign dteDataSet) {
        Iterator elmtIter = modelDataSet.filtersIterator();
        if (elmtIter != null) {
            while (elmtIter.hasNext()) {
                FilterConditionHandle modelFilter = (FilterConditionHandle)elmtIter.next();
                IFilterDefinition dteFilter = this.newFilter(modelFilter);
                dteDataSet.addFilter(dteFilter);
            }
        }
    }

    IParameterDefinition newParam(DataSetParameterHandle modelParam) {
        ParameterDefinition dteParam = new ParameterDefinition();
        dteParam.setName(modelParam.getName());
        if (modelParam.getPosition() != null) {
            dteParam.setPosition(modelParam.getPosition().intValue());
        }
        if (modelParam.getNativeDataType() != null) {
            dteParam.setNativeType(modelParam.getNativeDataType().intValue());
        }
        if (modelParam instanceof OdaDataSetParameterHandle) {
            dteParam.setNativeName(((OdaDataSetParameterHandle)modelParam).getNativeName());
        }
        dteParam.setType(DataAdapterUtil.adaptModelDataType((String)modelParam.getDataType()));
        dteParam.setInputMode(modelParam.isInput());
        dteParam.setOutputMode(modelParam.isOutput());
        dteParam.setNullable(modelParam.allowNull());
        dteParam.setInputOptional(modelParam.isOptional());
        dteParam.setDefaultInputValue(modelParam.getDefaultValue());
        return dteParam;
    }

    IInputParameterBinding newInputParamBinding(ParamBindingHandle modelInputParamBndg) {
        return this.newInputParamBinding(modelInputParamBndg.getParamName(), new org.eclipse.birt.data.engine.api.querydefn.ScriptExpression(modelInputParamBndg.getExpression()));
    }

    private IInputParameterBinding newInputParamBinding(String paramName, org.eclipse.birt.data.engine.api.querydefn.ScriptExpression paramValueExpr) {
        if (paramValueExpr == null || paramValueExpr.getText() == null) {
            return null;
        }
        return new InputParameterBinding(paramName, (IBaseExpression)paramValueExpr);
    }

    IComputedColumn newComputedColumn(ComputedColumnHandle modelCmptdColumn) throws EngineException {
        if (modelCmptdColumn.getExpression() == null && modelCmptdColumn.getAggregateFunction() == null) {
            throw new EngineException("Error.MissingComputedColumnExpression", modelCmptdColumn.getName());
        }
        HashMap<String, org.eclipse.birt.data.engine.api.querydefn.ScriptExpression> argumentList = new HashMap<String, org.eclipse.birt.data.engine.api.querydefn.ScriptExpression>();
        Iterator argumentIter = modelCmptdColumn.argumentsIterator();
        while (argumentIter.hasNext()) {
            AggregationArgumentHandle handle = (AggregationArgumentHandle)argumentIter.next();
            argumentList.put(handle.getName(), new org.eclipse.birt.data.engine.api.querydefn.ScriptExpression(handle.getValue()));
        }
        ArrayList orderedArgument = new ArrayList();
        try {
            IParameterDefn[] parameters;
            IAggrFunction info;
            if (modelCmptdColumn.getAggregateFunction() != null && (info = AggregationManager.getInstance().getAggregation(modelCmptdColumn.getAggregateFunction())) != null && (parameters = info.getParameterDefn()) != null) {
                int i = 0;
                while (i < parameters.length) {
                    IParameterDefn pInfo = parameters[i];
                    if (argumentList.get(pInfo.getName()) != null) {
                        orderedArgument.add(argumentList.get(pInfo.getName()));
                    }
                    ++i;
                }
            }
        }
        catch (DataException e) {
            throw new EngineException(e.getLocalizedMessage(), e);
        }
        return new ComputedColumn(modelCmptdColumn.getName(), modelCmptdColumn.getExpression(), ModelDteApiAdapter.toDteDataType(modelCmptdColumn.getDataType()), modelCmptdColumn.getAggregateFunction(), (IScriptExpression)(modelCmptdColumn.getFilterExpression() == null ? null : new org.eclipse.birt.data.engine.api.querydefn.ScriptExpression(modelCmptdColumn.getFilterExpression())), orderedArgument);
    }

    IFilterDefinition newFilter(FilterConditionHandle modelFilter) {
        String filterExpr = modelFilter.getExpr();
        if (filterExpr == null || filterExpr.length() == 0) {
            return null;
        }
        String filterOpr = modelFilter.getOperator();
        if (filterOpr == null || filterOpr.length() == 0) {
            return new FilterDefinition((IBaseExpression)new org.eclipse.birt.data.engine.api.querydefn.ScriptExpression(filterExpr));
        }
        String column = filterExpr;
        int dteOpr = ModelDteApiAdapter.toDteFilterOperator(filterOpr);
        if (dteOpr == 22 || dteOpr == 23) {
            List operands = modelFilter.getValue1List();
            return new FilterDefinition((IBaseExpression)new ConditionalExpression(column, dteOpr, operands));
        }
        String operand1 = modelFilter.getValue1();
        String operand2 = modelFilter.getValue2();
        return new FilterDefinition((IBaseExpression)new ConditionalExpression(column, dteOpr, operand1, operand2));
    }

    private IColumnDefinition newColumnDefn(ResultSetColumnHandle modelColumn) {
        ColumnDefinition newColumn = new ColumnDefinition(modelColumn.getColumnName());
        if (modelColumn.getPosition() != null) {
            newColumn.setColumnPosition(modelColumn.getPosition().intValue());
        }
        if (modelColumn.getNativeDataType() != null) {
            newColumn.setNativeDataType(modelColumn.getNativeDataType().intValue());
        }
        newColumn.setDataType(ModelDteApiAdapter.toDteDataType(modelColumn.getDataType()));
        return newColumn;
    }

    private void updateColumnDefn(ColumnDefinition dteColumn, ColumnHintHandle modelColumnHint) {
        String searchConstant;
        assert (dteColumn.getColumnName().equals(modelColumnHint.getColumnName()));
        dteColumn.setAlias(modelColumnHint.getAlias());
        String exportConstant = modelColumnHint.getExport();
        if (exportConstant != null) {
            int exportHint = 1;
            if (exportConstant.equals("if-realized")) {
                exportHint = 2;
            } else if (exportConstant.equals("always")) {
                exportHint = 3;
            } else assert (exportConstant.equals("none"));
            dteColumn.setExportHint(exportHint);
        }
        if ((searchConstant = modelColumnHint.getSearching()) != null) {
            int searchHint = 3;
            if (searchConstant.equals("indexed")) {
                searchHint = 2;
            } else if (searchConstant.equals("any")) {
                searchHint = 1;
            } else assert (searchConstant.equals("none"));
            dteColumn.setSearchHint(searchHint);
        }
    }

    private IColumnDefinition newColumnDefn(ColumnHintHandle modelColumnHint) {
        ColumnDefinition newColumn = new ColumnDefinition(modelColumnHint.getColumnName());
        this.updateColumnDefn(newColumn, modelColumnHint);
        return newColumn;
    }

    /*
     * Unable to fully structure code
     */
    private ColumnDefinition findColumnDefn(List columnDefns, String columnName) {
        if (!ModelDteApiAdapter.$assertionsDisabled && columnName == null) {
            throw new AssertionError();
        }
        if (columnDefns == null) {
            return null;
        }
        iter = columnDefns.iterator();
        if (iter != null) ** GOTO lbl11
        return null;
lbl-1000:
        // 1 sources

        {
            column = (ColumnDefinition)iter.next();
            if (!columnName.equals(column.getColumnName())) continue;
            return column;
lbl11:
            // 2 sources

            ** while (iter.hasNext())
        }
lbl12:
        // 1 sources

        return null;
    }

    public static int toDteDataType(String modelDataType) {
        return DataAdapterUtil.adaptModelDataType((String)modelDataType);
    }

    public static int toDteFilterOperator(String modelOpr) {
        return DataAdapterUtil.adaptModelFilterOperator((String)modelOpr);
    }

    private Map getExtensionProperties(ReportElementHandle dataHandle, List driverPropList) {
        if (driverPropList == null || driverPropList.isEmpty()) {
            return null;
        }
        HashMap<String, String> properties = new HashMap<String, String>();
        for (IPropertyDefn modelExtProp : driverPropList) {
            String propName = modelExtProp.getName();
            assert (propName != null && propName.length() > 0);
            Object propValueObj = dataHandle.getProperty(modelExtProp.getName());
            String propValue = propValueObj == null ? null : propValueObj.toString();
            properties.put(propName, propValue);
        }
        return properties;
    }

    private boolean needPropertyBinding() {
        return this.context != null && this.jsScope != null;
    }
}

