/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.layout.pdf.font;

import com.lowagie.text.pdf.BaseFont;
import java.util.Collection;
import java.util.LinkedHashSet;
import org.eclipse.birt.report.engine.layout.pdf.font.CharSegment;
import org.eclipse.birt.report.engine.layout.pdf.font.CompositeFontConfig;
import org.eclipse.birt.report.engine.layout.pdf.font.FontMappingManager;

public class CompositeFont {
    CompositeFontConfig config;
    CompositeFont parent;
    String[] usedFonts;
    boolean fullIndexed;
    CharSegment[] specialCharacters;
    CharSegment[][] fontsIndex;
    BaseFont[] baseFonts;
    CharSegment[] fullIndex;

    public CompositeFont(FontMappingManager manager, CompositeFontConfig config, String[] sequence) {
        int i;
        FontMappingManager parentManager = manager.getParent();
        if (parentManager != null) {
            this.parent = parentManager.getCompositeFont(config.fontName);
        }
        this.config = config;
        this.specialCharacters = config.getSpecialCharacters();
        LinkedHashSet fonts = new LinkedHashSet();
        if (sequence != null) {
            i = 0;
            while (i < sequence.length) {
                Collection catalogFonts = config.getFontByCatalog(sequence[i]);
                if (catalogFonts != null) {
                    fonts.addAll(catalogFonts);
                }
                ++i;
            }
        }
        fonts.addAll(config.getAllFonts());
        this.usedFonts = fonts.toArray(new String[0]);
        this.fullIndexed = true;
        this.fontsIndex = new CharSegment[this.usedFonts.length][];
        i = 0;
        while (i < this.usedFonts.length) {
            this.fontsIndex[i] = config.getCharSegment(this.usedFonts[i]);
            if (this.fontsIndex[i] == null) {
                this.fullIndexed = false;
            }
            ++i;
        }
        if (this.fullIndexed) {
            this.fullIndex = CharSegment.merge(this.fontsIndex);
        } else {
            this.baseFonts = new BaseFont[this.usedFonts.length];
            i = 0;
            while (i < this.baseFonts.length) {
                this.baseFonts[i] = manager.createFont(this.usedFonts[i], 0);
                ++i;
            }
        }
    }

    public String getFontName() {
        return this.config.fontName;
    }

    public String getDefaultFont() {
        if (this.config.defaultFont != null) {
            return this.config.defaultFont;
        }
        if (this.parent != null) {
            return this.parent.getDefaultFont();
        }
        return null;
    }

    public String getUsedFont(char ch) {
        String usedFont = this.findUsedFont(ch);
        if (usedFont != null) {
            return usedFont;
        }
        return this.getDefaultFont();
    }

    protected String findUsedFont(char ch) {
        int index;
        if (this.specialCharacters != null && (index = CharSegment.search(this.specialCharacters, ch)) != -1) {
            return this.specialCharacters[index].name;
        }
        if (this.fullIndexed) {
            index = CharSegment.search(this.fullIndex, ch);
            if (index != -1) {
                return this.fullIndex[index].name;
            }
        } else {
            int i = 0;
            while (i < this.usedFonts.length) {
                if (this.fontsIndex[i] != null ? CharSegment.search(this.fontsIndex[i], ch) != -1 : this.baseFonts[i] != null && this.baseFonts[i].charExists((int)ch)) {
                    return this.usedFonts[i];
                }
                ++i;
            }
        }
        if (this.parent != null) {
            return this.parent.getUsedFont(ch);
        }
        return null;
    }
}

