/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.cuda.ide.remote.internal.wizard;

import com.nvidia.common.wizards.WizardContext;
import com.nvidia.cuda.ide.remote.internal.wizard.IDebugSessionType;
import com.nvidia.cuda.ide.remote.internal.wizard.IDebugWizardProperties;
import com.nvidia.cuda.ide.remote.internal.wizard.RemoteConnectDebugSession;
import com.nvidia.cuda.ide.remote.internal.wizard.RemoteRunDebugSession;
import com.nvidia.cuda.ide.remote.ui.launch.LaunchMode;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Widget;

public final class DebugWizardFirstPage
extends WizardPage
implements SelectionListener {
    private IDebugSessionType[] sessionTypes;
    private final WizardContext wizardContext;

    public DebugWizardFirstPage(WizardContext wizardContext) {
        super("Select debug type", "Select Debug Session Type", null);
        this.wizardContext = wizardContext;
        this.setDescription("Select debug session type");
    }

    public void createControl(Composite parent) {
        IDebugSessionType[] sessionTypes;
        Composite root = new Composite(parent, 2048);
        this.setControl((Control)root);
        RowLayout rl_defaultPage = new RowLayout(512);
        rl_defaultPage.fill = true;
        root.setLayout((Layout)rl_defaultPage);
        IDebugSessionType[] iDebugSessionTypeArray = sessionTypes = this.getSessionTypes();
        int n = sessionTypes.length;
        int n2 = 0;
        while (n2 < n) {
            IDebugSessionType type = iDebugSessionTypeArray[n2];
            Link link = new Link(root, 0);
            link.setText(String.format("<a>%s</a>", type.getName()));
            link.addSelectionListener((SelectionListener)this);
            link.setData((Object)type);
            Label text = new Label(root, 64);
            text.setText(type.getDescription());
            new Label(root, 0);
            ++n2;
        }
        this.setPageComplete(false);
    }

    private synchronized IDebugSessionType[] getSessionTypes() {
        if (this.sessionTypes == null) {
            LaunchMode mode = (LaunchMode)((Object)this.wizardContext.getProperty(IDebugWizardProperties.PROPERTY_LAUNCH_MODE));
            IDebugSessionType[] iDebugSessionTypeArray = this.sessionTypes = new IDebugSessionType[]{new RemoteRunDebugSession(mode), new RemoteConnectDebugSession()};
            int n = this.sessionTypes.length;
            int n2 = 0;
            while (n2 < n) {
                IDebugSessionType sessionType = iDebugSessionTypeArray[n2];
                sessionType.init(this.wizardContext);
                ++n2;
            }
        }
        return this.sessionTypes;
    }

    private void postOpenNextPage(final Widget widget) {
        widget.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                IWizardPage nextPage = DebugWizardFirstPage.this.getNextPage();
                if (nextPage == null) {
                    DebugWizardFirstPage.this.postOpenNextPage(widget);
                } else {
                    DebugWizardFirstPage.this.getContainer().showPage(nextPage);
                }
            }
        });
    }

    public void widgetDefaultSelected(SelectionEvent e) {
        this.widgetSelected(e);
    }

    public void widgetSelected(SelectionEvent e) {
        IDebugSessionType type = (IDebugSessionType)e.widget.getData();
        this.wizardContext.setProperty(IDebugWizardProperties.PROPERTY_DEBUG_SESSION_TYPE, (Object)type);
        this.postOpenNextPage(e.widget);
    }
}

