/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.expert;

import com.nvidia.viper.fs.IDevicesData;
import com.nvidia.viper.model.Metric;
import com.nvidia.viper.model.MetricCategory;
import java.util.Arrays;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

public class ExpertMetricContentProvider
implements ITreeContentProvider {
    private static final Object[] EMPTY_ARRAY = new Object[0];
    private String deviceDescriptor;
    private IDevicesData deviceData;

    public ExpertMetricContentProvider(IDevicesData deviceData) {
        this.deviceData = deviceData;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        if (newInput instanceof String) {
            this.deviceDescriptor = (String)newInput;
        }
    }

    public Object[] getElements(Object inputElement) {
        if (this.deviceDescriptor != null) {
            Object[] categories = this.deviceData.getMetricCategories(this.deviceDescriptor).toArray(new MetricCategory[0]);
            Arrays.sort(categories);
            return categories;
        }
        return EMPTY_ARRAY;
    }

    public Object getParent(Object element) {
        if (element instanceof MetricCategory) {
            return this.deviceDescriptor;
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        return element instanceof MetricCategory;
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof MetricCategory) {
            Object[] metrics = ((MetricCategory)parentElement).getAggregateMetrics().toArray(new Metric[0]);
            return metrics;
        }
        return EMPTY_ARRAY;
    }

    public void dispose() {
    }
}

