/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.pdf;

import edu.harvard.hul.ois.jhove.module.pdf.Ascii85FilterStream;
import edu.harvard.hul.ois.jhove.module.pdf.AsciiHexFilterStream;
import edu.harvard.hul.ois.jhove.module.pdf.Filter;
import edu.harvard.hul.ois.jhove.module.pdf.PdfException;
import edu.harvard.hul.ois.jhove.module.pdf.PdfFlateInputStream;
import edu.harvard.hul.ois.jhove.module.pdf.PdfMalformedException;
import edu.harvard.hul.ois.jhove.module.pdf.RunLengthFilterStream;
import edu.harvard.hul.ois.jhove.module.pdf.Token;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;

public class Stream
extends Token {
    private long _length = 0L;
    private long _offset = -1L;
    private int _bytesRead = 0;
    private Filter[] _filters = new Filter[0];
    private InputStream _inStream;
    private byte[] _sdata = null;

    public long getLength() {
        return this._length;
    }

    public void setLength(long l) {
        this._length = l;
    }

    public long getOffset() {
        return this._offset;
    }

    public void setOffset(long l) {
        this._offset = l;
    }

    public void setFilters(Filter[] filterArray) {
        this._filters = filterArray;
    }

    public void initRead(RandomAccessFile randomAccessFile) throws IOException, PdfException {
        int n;
        this._bytesRead = 0;
        randomAccessFile.seek(this._offset);
        if (this._sdata == null) {
            this._sdata = new byte[(int)this._length];
            int n2 = 0;
            while ((long)n2 < this._length && (n = randomAccessFile.read(this._sdata, n2, (int)(this._length - (long)n2))) > 0) {
                n2 += n;
            }
        }
        InputStream inputStream = new ByteArrayInputStream(this._sdata);
        for (n = 0; n < this._filters.length; ++n) {
            Filter filter = this._filters[n];
            String string = filter.getFilterName();
            Object var6_7 = null;
            if ("ASCIIHexDecode".equals(string) || "AHx".equals(string)) {
                inputStream = new AsciiHexFilterStream(inputStream);
                continue;
            }
            if ("ASCII85Decode".equals(string) || "A85".equals(string)) {
                inputStream = new Ascii85FilterStream(inputStream);
                continue;
            }
            if ("FlateDecode".equals(string) || "Fl".equals(string)) {
                inputStream = new PdfFlateInputStream(inputStream, filter.getDecodeParms());
                continue;
            }
            if (!"RunLengthDecode".equals(string) && !"RL".equals(string)) continue;
            inputStream = new RunLengthFilterStream(inputStream);
        }
        this._inStream = inputStream;
    }

    public int read() throws IOException {
        int n = this._inStream.read();
        if (n >= 0) {
            ++this._bytesRead;
        }
        return n;
    }

    public int read(byte[] byArray) throws IOException {
        int n = this._inStream.read(byArray);
        if (n > 0) {
            this._bytesRead += n;
        }
        return n;
    }

    public long skipBytes(long l) throws IOException {
        long l2 = this._inStream.skip(l);
        this._bytesRead = (int)((long)this._bytesRead + l2);
        return l2;
    }

    public int readAsciiInt() throws IOException, PdfException {
        int n;
        block2: {
            boolean bl = false;
            n = 0;
            while (true) {
                char c;
                if (Character.isDigit(c = (char)this.read())) {
                    bl = true;
                    n = n * 10 + (c - 48);
                    continue;
                }
                if (bl) break block2;
                if (!Character.isWhitespace(c)) break;
            }
            throw new PdfMalformedException("Malformed ASCII number in stream");
        }
        return n;
    }

    public boolean advanceTo(int n) throws IOException {
        if (n < this._bytesRead) {
            return false;
        }
        while (this._bytesRead < n && this.skipBytes(n - this._bytesRead) > 0L) {
        }
        return true;
    }
}

