/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module;

import edu.harvard.hul.ois.jhove.Agent;
import edu.harvard.hul.ois.jhove.AgentType;
import edu.harvard.hul.ois.jhove.Checksum;
import edu.harvard.hul.ois.jhove.ChecksumInputStream;
import edu.harvard.hul.ois.jhove.ChecksumType;
import edu.harvard.hul.ois.jhove.Checksummer;
import edu.harvard.hul.ois.jhove.Document;
import edu.harvard.hul.ois.jhove.DocumentType;
import edu.harvard.hul.ois.jhove.ErrorMessage;
import edu.harvard.hul.ois.jhove.ExternalSignature;
import edu.harvard.hul.ois.jhove.Identifier;
import edu.harvard.hul.ois.jhove.IdentifierType;
import edu.harvard.hul.ois.jhove.InfoMessage;
import edu.harvard.hul.ois.jhove.JhoveBase;
import edu.harvard.hul.ois.jhove.Message;
import edu.harvard.hul.ois.jhove.Module;
import edu.harvard.hul.ois.jhove.ModuleBase;
import edu.harvard.hul.ois.jhove.Property;
import edu.harvard.hul.ois.jhove.PropertyArity;
import edu.harvard.hul.ois.jhove.PropertyType;
import edu.harvard.hul.ois.jhove.RepInfo;
import edu.harvard.hul.ois.jhove.SignatureType;
import edu.harvard.hul.ois.jhove.SignatureUseType;
import edu.harvard.hul.ois.jhove.TextMDMetadata;
import edu.harvard.hul.ois.jhove.Utf8BlockMarker;
import edu.harvard.hul.ois.jhove.module.html.DTDMapper;
import edu.harvard.hul.ois.jhove.module.html.HtmlMetadata;
import edu.harvard.hul.ois.jhove.module.xml.XmlDeclHandler;
import edu.harvard.hul.ois.jhove.module.xml.XmlDeclStream;
import edu.harvard.hul.ois.jhove.module.xml.XmlLexicalHandler;
import edu.harvard.hul.ois.jhove.module.xml.XmlModuleHandler;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UTFDataFormatException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.XMLReaderFactory;

public class XmlModule
extends ModuleBase {
    private static final String NAME = "XML-hul";
    private static final String RELEASE = "1.4";
    private static final int[] DATE = new int[]{2007, 1, 8};
    private static final String[] FORMAT = new String[]{"XML", "XHTML"};
    private static final String COVERAGE = "XML 1.0";
    private static final String[] MIMETYPE = new String[]{"text/xml", "application/xml", "text/html"};
    private static final String WELLFORMED = "An XML file is well-formed if it meets the criteria defined in Section 2.1 of the XML specification (W3C Recommendation, 3rd edition, 2004-02-04)";
    private static final String VALIDITY = "An XML file is valid if well-formed, and the file has an associated DTD or XML Schema and the file meets the constraints defined by that DTD or Schema";
    private static final String REPINFO = "Additional representation information includes: version, endcoding, standalone flag, DTD or schema, namespaces, notations, character references, entities, processing instructions, and comments";
    private static final String NOTE = "This module determines well-formedness and validity using the SAX2-conforming parser specified by the invoking application";
    private static final String RIGHTS = "Copyright 2004-2007 by JSTOR and the President and Fellows of Harvard College. Released under the GNU Lesser General Public License.";
    protected Checksummer _ckSummer;
    protected ChecksumInputStream _cstream;
    protected DataInputStream _dstream;
    protected List _propList;
    protected Property _metadata;
    protected String _xhtmlDoctype;
    protected String _baseURL;
    protected boolean _sigWantsDecl;
    protected boolean _parseFromSig;
    protected boolean _withTextMD = false;
    protected TextMDMetadata _textMD;

    public XmlModule() {
        super(NAME, RELEASE, DATE, FORMAT, COVERAGE, MIMETYPE, WELLFORMED, VALIDITY, REPINFO, NOTE, RIGHTS, false);
        Agent agent = new Agent("Harvard University Library", AgentType.EDUCATIONAL);
        agent.setAddress("Office for Information Systems, 90 Mt. Auburn St., Cambridge, MA 02138");
        agent.setTelephone("+1 (617) 495-3724");
        agent.setEmail("jhove-support@hulmail.harvard.edu");
        this._vendor = agent;
        Document document = new Document("Extensible Markup Language (XML) 1.0 (Third Edition)", DocumentType.REPORT);
        agent = new Agent("Word Wide Web Consortium", AgentType.NONPROFIT);
        agent.setAddress("Massachusetts Institute of Technology, Computer Science and Artificial Intelligence Laboratory, 32 Vassar Street, Room 32-G515, Cambridge, MA 02139");
        agent.setTelephone("(617) 253-2613");
        agent.setFax("(617) 258-5999");
        agent.setWeb("http://www.w3.org/");
        document.setPublisher(agent);
        document.setDate("2004-02-04");
        document.setIdentifier(new Identifier("http://www.w3.org/TR/REC-xml", IdentifierType.URL));
        this._specification.add(document);
        document = new Document("SAX", DocumentType.WEB);
        document.setIdentifier(new Identifier("http://sax.sourceforge.net/", IdentifierType.URL));
        this._specification.add(document);
        ExternalSignature externalSignature = new ExternalSignature(".xml", SignatureType.EXTENSION, SignatureUseType.OPTIONAL);
        this._signature.add(externalSignature);
    }

    public void setXhtmlDoctype(String string) {
        this._xhtmlDoctype = string;
        if (this._textMD != null) {
            this._textMD.setMarkup_language(this._xhtmlDoctype);
        }
    }

    public void resetParams() throws Exception {
        this._baseURL = null;
        this._sigWantsDecl = false;
        this._parseFromSig = false;
    }

    public void param(String string) {
        if (string != null) {
            if ((string = string.toLowerCase()).indexOf(115) == 0) {
                this._sigWantsDecl = true;
                string = string.substring(1);
            }
            if (string.indexOf(98) == 0) {
                this._baseURL = string.substring(1);
            }
        }
    }

    public int parse(InputStream inputStream, RepInfo repInfo, int n) throws IOException {
        Object object;
        Object object2;
        Object object3;
        List<Property> list;
        Object object4;
        Object object5;
        Object object6;
        ArrayList<String> arrayList;
        Object object7;
        Object object8;
        Utf8BlockMarker utf8BlockMarker;
        Collection<Object> collection;
        Property property;
        Object object9;
        Object object10;
        Object object11;
        Object object12;
        String string;
        Object object1322;
        if (this._defaultParams != null) {
            this._withTextMD = false;
            for (Object object1322 : this._defaultParams) {
                if (!((String)object1322).toLowerCase().equals("withtextmd=true")) continue;
                this._withTextMD = true;
            }
        }
        boolean bl = true;
        this.initParse();
        repInfo.setFormat(this._format[0]);
        repInfo.setMimeType(this._mimeType[0]);
        repInfo.setModule((Module)this);
        if (this._textMD == null || n == 0) {
            this._textMD = new TextMDMetadata();
            this._xhtmlDoctype = null;
        }
        this._ckSummer = null;
        if (this._je != null && this._je.getChecksumFlag() && repInfo.getChecksum().size() == 0) {
            this._ckSummer = new Checksummer();
        }
        this._cstream = new ChecksumInputStream(inputStream, this._ckSummer);
        this._propList = new LinkedList();
        this._metadata = new Property("XMLMetadata", PropertyType.PROPERTY, PropertyArity.LIST, (Object)this._propList);
        object1322 = null;
        InputSource inputSource = null;
        XmlModuleHandler xmlModuleHandler = null;
        XmlLexicalHandler xmlLexicalHandler = new XmlLexicalHandler();
        XmlDeclHandler xmlDeclHandler = new XmlDeclHandler();
        XmlDeclStream xmlDeclStream = new XmlDeclStream((InputStream)this._cstream);
        try {
            inputSource = new InputSource(xmlDeclStream);
            if (this._baseURL != null) {
                inputSource.setSystemId(new File(this._baseURL).toURI().toURL().toString());
            }
            if ((string = this._je.getSaxClass()) == null) {
                object12 = SAXParserFactory.newInstance();
                ((SAXParserFactory)object12).setNamespaceAware(true);
                object1322 = ((SAXParserFactory)object12).newSAXParser().getXMLReader();
            } else {
                object1322 = XMLReaderFactory.createXMLReader(string);
            }
            xmlModuleHandler = new XmlModuleHandler();
            xmlModuleHandler.setXhtmlFlag(this._xhtmlDoctype != null);
            object1322.setContentHandler(xmlModuleHandler);
            object1322.setErrorHandler(xmlModuleHandler);
            object1322.setEntityResolver(xmlModuleHandler);
            object1322.setDTDHandler(xmlModuleHandler);
            try {
                object1322.setProperty("http://xml.org/sax/properties/lexical-handler", xmlLexicalHandler);
            }
            catch (SAXException sAXException) {
                repInfo.setMessage((Message)new InfoMessage("The XML implementation in use does not support the LexicalHandler interface. This may result in some properties not being reported."));
            }
            try {
                object1322.setProperty("http://xml.org/sax/properties/declaration-handler", xmlDeclHandler);
            }
            catch (SAXException sAXException) {
                repInfo.setMessage((Message)new InfoMessage("The XML implementation in use does not support the DeclHandler interface. This may result in some properties not being reported."));
            }
        }
        catch (Exception exception) {
            repInfo.setMessage((Message)new ErrorMessage(exception.getMessage()));
            repInfo.setWellFormed(false);
            return 0;
        }
        try {
            object1322.setFeature("http://xml.org/sax/features/validation", n != 0);
        }
        catch (SAXException sAXException) {
            if (n != 0) {
                repInfo.setMessage((Message)new InfoMessage("The SAX parser is not capable of validation."));
            }
            bl = false;
        }
        try {
            object1322.setFeature("http://xml.org/sax/features/namespaces", true);
        }
        catch (SAXException sAXException) {
            repInfo.setMessage((Message)new InfoMessage("The SAX parser does not support namespaces."));
        }
        if (n > 0) {
            try {
                object1322.setFeature("http://apache.org/xml/features/validation/schema", true);
            }
            catch (SAXException sAXException) {
                try {
                    object1322.setProperty("http://java.sun.com/xml/jaxp/properties/schemaLanguage", "http://www.w3.org/2001/XMLSchema");
                }
                catch (SAXException sAXException2) {
                    repInfo.setMessage((Message)new InfoMessage("The XML implementation in use does not support schema language identification.  This may result in documents specified by schemas being reported as invalid."));
                }
            }
        }
        try {
            object1322.parse(inputSource);
        }
        catch (FileNotFoundException fileNotFoundException) {
            repInfo.setMessage((Message)new ErrorMessage("File not found", fileNotFoundException.getMessage().toString()));
            repInfo.setWellFormed(false);
            return 0;
        }
        catch (UTFDataFormatException uTFDataFormatException) {
            if (xmlModuleHandler.getSigFlag() && !this._parseFromSig) {
                repInfo.setSigMatch(this._name);
            }
            repInfo.setMessage((Message)new ErrorMessage("Invalid character encoding"));
            repInfo.setWellFormed(false);
            return 0;
        }
        catch (IOException iOException) {
            if (xmlModuleHandler.getSigFlag() && !this._parseFromSig) {
                repInfo.setSigMatch(this._name);
            }
            repInfo.setMessage((Message)new ErrorMessage(iOException.getClass().getName() + ": " + iOException.getMessage().toString()));
            repInfo.setWellFormed(false);
            return 0;
        }
        catch (SAXParseException sAXParseException) {
            if (xmlModuleHandler.getSigFlag() && !this._parseFromSig) {
                repInfo.setSigMatch(this._name);
            }
            int n2 = sAXParseException.getLineNumber();
            int n3 = sAXParseException.getColumnNumber();
            repInfo.setMessage((Message)new ErrorMessage(sAXParseException.getMessage().toString(), "Line = " + n2 + ", Column = " + n3));
            repInfo.setWellFormed(false);
            return 0;
        }
        catch (SAXException sAXException) {
            if (xmlModuleHandler.getSigFlag()) {
                repInfo.setSigMatch(this._name);
            }
            if ((object12 = sAXException.getMessage()) == null) {
                Throwable throwable = sAXException.getCause();
                object12 = throwable != null ? "SAXException, cause = " + throwable.getClass().getName() : "Unspecified SAXException";
            }
            repInfo.setMessage((Message)new ErrorMessage((String)object12));
            repInfo.setWellFormed(false);
            return 0;
        }
        if (this._je.getAbort()) {
            return 0;
        }
        if (xmlModuleHandler.getSigFlag() && n == 0) {
            repInfo.setSigMatch(this._name);
        }
        string = xmlModuleHandler.getDTDURI();
        object12 = xmlModuleHandler.getSchemas();
        if (!object12.isEmpty()) {
            object11 = (String[])object12.get(0);
            if (XmlModule.isNotEmpty(object11[0])) {
                this._textMD.setMarkup_language(object11[0]);
            } else if (XmlModule.isNotEmpty(object11[1])) {
                this._textMD.setMarkup_language(object11[1]);
            }
        } else if (XmlModule.isNotEmpty(string)) {
            this._textMD.setMarkup_language(string);
        }
        if (n == 0) {
            if ((xmlModuleHandler.getDTDURI() != null || !object12.isEmpty()) && bl) {
                return 1;
            }
            repInfo.setValid(-1);
        }
        repInfo.setProperty(this._metadata);
        object11 = xmlModuleHandler.getHtmlMetadata();
        if (object11 != null) {
            repInfo.setProperty(((HtmlMetadata)object11).toProperty(this._withTextMD ? this._textMD : null));
        }
        this._propList.add(new Property("Parser", PropertyType.STRING, (Object)object1322.getClass().getName()));
        String string2 = null;
        if (this._xhtmlDoctype != null) {
            string2 = DTDMapper.getXHTMLVersion(this._xhtmlDoctype);
            this._textMD.setMarkup_language_version(string2);
        }
        if (string2 != null) {
            repInfo.setVersion(string2);
        } else {
            string2 = xmlDeclStream.getVersion();
            if (string2 != null) {
                repInfo.setVersion(string2);
            }
        }
        this._textMD.setMarkup_basis_version(string2);
        String string3 = xmlDeclStream.getEncoding();
        if (string3 == null) {
            string3 = "UTF-8";
        }
        this._propList.add(new Property("Encoding", PropertyType.STRING, (Object)string3));
        this._textMD.setCharset(string3);
        String string4 = this._textMD.getCharset();
        if (string4.indexOf("UTF") != -1) {
            this._textMD.setByte_order(this._bigEndian ? 0 : 1);
            this._textMD.setByte_size("8");
            this._textMD.setCharacter_size("variable");
        } else {
            this._textMD.setByte_order(this._bigEndian ? 0 : 1);
            this._textMD.setByte_size("8");
            this._textMD.setCharacter_size("1");
        }
        String string5 = xmlDeclStream.getKindOfLineEnd();
        if (string5 == null) {
            repInfo.setMessage((Message)new InfoMessage("Not able to determine type of end of line"));
            this._textMD.setLinebreak(-1);
        } else if (string5.equalsIgnoreCase("CR")) {
            this._textMD.setLinebreak(0);
        } else if (string5.equalsIgnoreCase("LF")) {
            this._textMD.setLinebreak(1);
        } else if (string5.equalsIgnoreCase("CRLF")) {
            this._textMD.setLinebreak(2);
        }
        String string6 = xmlDeclStream.getStandalone();
        if (string6 != null) {
            this._propList.add(new Property("Standalone", PropertyType.STRING, (Object)string6));
        }
        if (string != null) {
            this._propList.add(new Property("DTD_URI", PropertyType.STRING, (Object)string));
        }
        if (!object12.isEmpty()) {
            Property property2;
            object10 = new ArrayList(object12.size());
            object9 = object12.listIterator();
            while (object9.hasNext()) {
                property2 = (Property)object9.next();
                property = new Property[]{new Property("NamespaceURI", PropertyType.STRING, (Object)property2[0]), new Property("SchemaLocation", PropertyType.STRING, (Object)property2[1])};
                object10.add(new Property("Schema", PropertyType.PROPERTY, PropertyArity.ARRAY, (Object)property));
            }
            property2 = new Property("Schemas", PropertyType.PROPERTY, PropertyArity.LIST, object10);
            this._propList.add(property2);
        }
        object10 = xmlModuleHandler.getRoot();
        object9 = null;
        if (object10 != null) {
            int n4;
            this._propList.add(new Property("Root", PropertyType.STRING, object10));
            if ("html".equals(object10)) {
                repInfo.setFormat(this._format[1]);
            }
            if ((n4 = ((String)object10).indexOf(58)) != -1) {
                object9 = ((String)object10).substring(0, n4);
            }
        }
        if (object9 == null) {
            object9 = "";
        }
        Property property3 = null;
        property = null;
        Property property4 = null;
        Property property5 = null;
        Property property6 = null;
        Property property7 = null;
        Property property8 = null;
        Map map = xmlModuleHandler.getNamespaces();
        if (!map.isEmpty()) {
            collection = map.keySet();
            utf8BlockMarker = new ArrayList(collection.size());
            for (String listIterator2 : collection) {
                object8 = (String)map.get(listIterator2);
                Property[] propertyArray = new Property[]{new Property("Prefix", PropertyType.STRING, (Object)listIterator2), new Property("URI", PropertyType.STRING, object8)};
                object7 = new Property("Namespace", PropertyType.PROPERTY, PropertyArity.ARRAY, (Object)propertyArray);
                utf8BlockMarker.add(object7);
                if (!((String)object9).equalsIgnoreCase(listIterator2) || !XmlModule.isNotEmpty((String)object8)) continue;
                this._textMD.setMarkup_language((String)object8);
            }
            property3 = new Property("Namespaces", PropertyType.PROPERTY, PropertyArity.LIST, (Object)utf8BlockMarker);
        }
        if (!(collection = xmlDeclStream.getCharacterReferences()).isEmpty()) {
            utf8BlockMarker = new Utf8BlockMarker();
            arrayList = new ArrayList<String>(collection.size());
            ListIterator listIterator = collection.listIterator();
            while (listIterator.hasNext()) {
                object8 = (Integer)listIterator.next();
                int n2 = (Integer)object8;
                arrayList.add(XmlModule.intTo4DigitHex(n2));
                utf8BlockMarker.markBlock(n2);
            }
            property4 = new Property("CharacterReferences", PropertyType.STRING, PropertyArity.LIST, arrayList);
            property8 = utf8BlockMarker.getBlocksUsedProperty("UnicodeCharRefBlocks");
        }
        utf8BlockMarker = xmlLexicalHandler.getEntityNames();
        arrayList = xmlModuleHandler.getAttributeValues();
        LinkedList<Property> linkedList = new LinkedList<Property>();
        object8 = xmlModuleHandler.getUnparsedEntities();
        LinkedList<Object> linkedList2 = new LinkedList<Object>();
        if (!object8.isEmpty()) {
            object7 = object8.listIterator();
            while (object7.hasNext()) {
                object6 = (String[])object7.next();
                object5 = object6[0];
                if (!XmlModule.nameInCollection((String)object5, arrayList)) continue;
                linkedList2.add(object6[3]);
                object4 = new ArrayList<Property>(6);
                object4.add(new Property("Name", PropertyType.STRING, object5));
                object4.add(new Property("Type", PropertyType.STRING, (Object)"External unparsed"));
                object4.add(new Property("PublicID", PropertyType.STRING, object6[1]));
                object4.add(new Property("SystemID", PropertyType.STRING, object6[2]));
                object4.add(new Property("NotationName", PropertyType.STRING, object6[3]));
                linkedList.add(new Property("Entity", PropertyType.PROPERTY, PropertyArity.LIST, object4));
            }
        }
        if (!(object7 = xmlDeclHandler.getInternalEntityDeclarations()).isEmpty()) {
            object6 = object7.listIterator();
            while (object6.hasNext()) {
                object5 = (String[])object6.next();
                object4 = object5[0];
                if (!XmlModule.nameInCollection((String)object4, (Collection)utf8BlockMarker)) continue;
                list = new ArrayList<Property>(4);
                list.add(new Property("Name", PropertyType.STRING, object4));
                list.add(new Property("Type", PropertyType.STRING, (Object)"Internal"));
                list.add(new Property("Value", PropertyType.STRING, object5[1]));
                linkedList.add(new Property("Entity", PropertyType.PROPERTY, PropertyArity.LIST, list));
            }
        }
        if (!(object7 = xmlDeclHandler.getExternalEntityDeclarations()).isEmpty()) {
            object6 = object7.listIterator();
            while (object6.hasNext()) {
                object5 = (String[])object6.next();
                object4 = object5[0];
                if (!XmlModule.nameInCollection((String)object4, (Collection)utf8BlockMarker)) continue;
                list = new ArrayList<Property>(4);
                list.add(new Property("Name", PropertyType.STRING, object4));
                list.add(new Property("Type", PropertyType.STRING, (Object)"External parsed"));
                if (object5[1] != null) {
                    list.add(new Property("PublicID", PropertyType.STRING, object5[1]));
                }
                if (object5[2] != null) {
                    list.add(new Property("SystemID", PropertyType.STRING, object5[2]));
                }
                linkedList.add(new Property("Entity", PropertyType.PROPERTY, PropertyArity.LIST, list));
            }
        }
        if (!linkedList.isEmpty()) {
            property5 = new Property("Entities", PropertyType.PROPERTY, PropertyArity.LIST, linkedList);
        }
        object6 = xmlModuleHandler.getProcessingInstructions();
        object5 = new LinkedList();
        if (!object6.isEmpty()) {
            object4 = new ArrayList(object6.size());
            list = object6.listIterator();
            while (list.hasNext()) {
                object3 = (String[])list.next();
                object2 = new Property[2];
                object5.add(object2[0]);
                object2[0] = new Property("Target", PropertyType.STRING, (Object)object3[0]);
                object2[1] = new Property("Data", PropertyType.STRING, object3[1]);
                object4.add(new Property("ProcessingInstruction", PropertyType.PROPERTY, PropertyArity.ARRAY, object2));
            }
            property6 = new Property("ProcessingInstructions", PropertyType.PROPERTY, PropertyArity.LIST, object4);
        }
        if (!(object4 = xmlModuleHandler.getNotations()).isEmpty()) {
            list = new ArrayList(object4.size());
            object3 = object4.listIterator();
            object2 = new ArrayList(3);
            while (object3.hasNext()) {
                object = (String[])object3.next();
                String string7 = object[0];
                if (!XmlModule.nameInCollection(string7, (Collection)object5) && !XmlModule.nameInCollection(string7, linkedList2)) continue;
                object2.add(new Property("Name", PropertyType.STRING, (Object)string7));
                if (object[1] != null) {
                    object2.add(new Property("PublicID", PropertyType.STRING, (Object)object[1]));
                }
                if (object[2] != null) {
                    object2.add(new Property("SystemID", PropertyType.STRING, (Object)object[2]));
                }
                list.add(new Property("Notation", PropertyType.PROPERTY, PropertyArity.LIST, object2));
            }
            if (!list.isEmpty()) {
                property = new Property("Notations", PropertyType.PROPERTY, PropertyArity.LIST, list);
            }
        }
        if (property3 != null) {
            this._propList.add(property3);
        }
        if (property != null) {
            this._propList.add(property);
        }
        if (property4 != null) {
            this._propList.add(property4);
        }
        if (property8 != null) {
            this._propList.add(property8);
        }
        if (property5 != null) {
            this._propList.add(property5);
        }
        if (property6 != null) {
            this._propList.add(property6);
        }
        if (property7 != null) {
            this._propList.add(property7);
        }
        if (!(list = xmlLexicalHandler.getComments()).isEmpty()) {
            property7 = new Property("Comments", PropertyType.STRING, PropertyArity.LIST, list);
        }
        if (!xmlModuleHandler.isValid()) {
            repInfo.setValid(false);
        }
        if (repInfo.getWellFormed() == 1) {
            if (this._xhtmlDoctype != null) {
                repInfo.setMimeType(this._mimeType[2]);
            } else {
                repInfo.setMimeType(this._mimeType[0]);
            }
        }
        object3 = xmlModuleHandler.getMessages();
        object2 = object3.listIterator();
        while (object2.hasNext()) {
            repInfo.setMessage((Message)object2.next());
        }
        if (this._withTextMD) {
            this._textMD.setMarkup_basis(repInfo.getFormat());
            this._textMD.setMarkup_basis_version(repInfo.getVersion());
            object = new Property("TextMDMetadata", PropertyType.TEXTMDMETADATA, PropertyArity.SCALAR, (Object)this._textMD);
            this._propList.add(object);
        }
        if (this._ckSummer != null) {
            repInfo.setChecksum(new Checksum(this._ckSummer.getCRC32(), ChecksumType.CRC32));
            object = this._ckSummer.getMD5();
            if (object != null) {
                repInfo.setChecksum(new Checksum((String)object, ChecksumType.MD5));
            }
            if ((object = this._ckSummer.getSHA1()) != null) {
                repInfo.setChecksum(new Checksum((String)object, ChecksumType.SHA1));
            }
        }
        if (repInfo.getVersion() == null) {
            repInfo.setVersion("1.0");
            this._textMD.setMarkup_basis_version("1.0");
        }
        return 0;
    }

    public void checkSignatures(File file, InputStream inputStream, RepInfo repInfo) throws IOException {
        int n;
        this._parseFromSig = false;
        repInfo.setFormat(this._format[0]);
        repInfo.setMimeType(this._mimeType[0]);
        repInfo.setModule((Module)this);
        String string = "<?xml";
        int n2 = 0;
        JhoveBase jhoveBase = this.getBase();
        int n3 = jhoveBase.getSigBytes();
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        try {
            for (int i = 0; i < n3; ++i) {
                n = dataInputStream.readChar();
                if (n2 <= 2 && Character.isWhitespace((char)n)) continue;
                if (n != string.charAt(n2)) break;
                if (++n2 < string.length()) continue;
                repInfo.setSigMatch(this._name);
                return;
            }
        }
        catch (IOException iOException) {
            repInfo.setWellFormed(false);
            return;
        }
        if (this._sigWantsDecl) {
            repInfo.setWellFormed(false);
            return;
        }
        n = 1;
        this._parseFromSig = true;
        while (n != 0) {
            inputStream.close();
            inputStream = new FileInputStream(file);
            n = this.parse(inputStream, repInfo, n);
        }
        if (repInfo.getWellFormed() == 1) {
            repInfo.setSigMatch(this._name);
        }
    }

    protected void initParse() {
        super.initParse();
    }

    protected static boolean nameInCollection(String string, Collection collection) {
        for (String string2 : collection) {
            if (!string.equals(string2)) continue;
            return true;
        }
        return false;
    }

    protected static String intTo4DigitHex(int n) {
        StringBuffer stringBuffer = new StringBuffer(4);
        for (int i = 3; i >= 0; --i) {
            int n2 = n >> 4 * i & 0xF;
            if (n2 < 10) {
                stringBuffer.append((char)(48 + n2));
                continue;
            }
            stringBuffer.append((char)(65 + (n2 - 10)));
        }
        return stringBuffer.toString();
    }

    protected static boolean isNotEmpty(String string) {
        return string != null && string.length() != 0 && !"[None]".equals(string);
    }
}

