/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.gatk.utils.commandline;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Tags {
    private final List<String> positionalTags = new ArrayList<String>();
    private Map<String, String> keyValueTags = new HashMap<String, String>();

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (!(other instanceof Tags)) {
            return false;
        }
        Tags otherTags = (Tags)other;
        return this.positionalTags.equals(otherTags.positionalTags) && this.keyValueTags.equals(otherTags.keyValueTags);
    }

    public boolean isEmpty() {
        return this.positionalTags.isEmpty() && this.keyValueTags.isEmpty();
    }

    public List<String> getPositionalTags() {
        return Collections.unmodifiableList(this.positionalTags);
    }

    public String getValue(String key) {
        return this.keyValueTags.get(key);
    }

    public boolean containsKey(String key) {
        return this.keyValueTags.containsKey(key);
    }

    protected void addPositionalTag(String ... tags) {
        this.positionalTags.addAll(Arrays.asList(tags));
    }

    protected void addKeyValueTag(String key, String value) {
        this.keyValueTags.put(key, value);
    }
}

